/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class AdvancedGraphicsChip
extends GraphicsChip {
    protected int[] frameBuffer;
    protected int[] scaledBuffer;
    protected int[] transparentImage = new int[0];
    protected int[][] tileImage;
    protected boolean[] tileReadState;
    protected int[] tempPix;
    protected int windowSourceLine;

    public AdvancedGraphicsChip(Dmgcpu dmgcpu) {
        super(dmgcpu);
        this.colors = new int[]{-2131166984, -2136430424, -2142220208, Integer.MIN_VALUE};
        this.gbcMask = Integer.MIN_VALUE;
        this.transparentCutoff = this.cpu.gbcFeatures ? 32 : 4;
        this.tileImage = new int[this.tileCount * this.colorCount][];
        this.tileReadState = new boolean[this.tileCount];
        this.tempPix = new int[64];
        this.frameBuffer = new int[23040];
    }

    public final void addressWrite(int n, byte by) {
        int n2;
        if (this.videoRam[n] == by) {
            return;
        }
        if (n < 6144 && this.tileReadState[n2 = (n >> 4) + this.tileOffset]) {
            int n3 = this.tileImage.length - this.tileCount + n2;
            do {
                this.tileImage[n3] = null;
            } while ((n3 -= this.tileCount) >= 0);
            this.tileReadState[n2] = false;
        }
        this.videoRam[n] = by;
    }

    public final void invalidateAll(int n) {
        int n2 = n * this.tileCount * 4;
        int n3 = (n + 1) * this.tileCount * 4;
        for (int i = n2; i < n3; ++i) {
            this.tileImage[i] = null;
        }
    }

    protected final void drawSpritesForLine(int n) {
        int n2;
        if (!this.spritesEnabled) {
            return;
        }
        int n3 = this.doubledSprites ? n - 15 : n - 7;
        int n4 = n2 = this.spritePriorityEnabled ? 128 : 0;
        while (n2 >= 0) {
            int n5 = 159;
            while (n5 >= 0) {
                int n6;
                if (((n6 = 0xFF & this.cpu.oam[n5--]) & 0x80) == n2 || !this.spritePriorityEnabled) {
                    int n7 = 0xFF & this.cpu.oam[n5--];
                    int n8 = (0xFF & this.cpu.oam[n5--]) - 8;
                    int n9 = (0xFF & this.cpu.oam[n5--]) - 16;
                    int n10 = n - n9;
                    if (n8 >= 160 || n9 < n3 || n10 < 0) continue;
                    if (this.doubledSprites) {
                        n7 &= 0xFE;
                    }
                    int n11 = n6 >> 5 & 3;
                    if (this.cpu.gbcFeatures) {
                        n11 += 32 + ((n6 & 7) << 2);
                        n7 += 48 * (n6 & 8);
                    } else {
                        n11 += 4 + ((n6 & 0x10) >> 2);
                    }
                    if (n2 == 128) {
                        if (this.doubledSprites) {
                            if ((n11 & 2) != 0) {
                                this.drawPartBgSprite((n7 | 1) - (n10 >> 3), n8, n, n10 & 7, n11);
                                continue;
                            }
                            this.drawPartBgSprite((n7 & 0xFFFFFFFE) + (n10 >> 3), n8, n, n10 & 7, n11);
                            continue;
                        }
                        this.drawPartBgSprite(n7, n8, n, n10, n11);
                        continue;
                    }
                    if (this.doubledSprites) {
                        if ((n11 & 2) != 0) {
                            this.drawPartFgSprite((n7 | 1) - (n10 >> 3), n8, n, n10 & 7, n11);
                            continue;
                        }
                        this.drawPartFgSprite((n7 & 0xFFFFFFFE) + (n10 >> 3), n8, n, n10 & 7, n11);
                        continue;
                    }
                    this.drawPartFgSprite(n7, n8, n, n10, n11);
                    continue;
                }
                n5 -= 3;
            }
            n2 -= 128;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawBackgroundForLine(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl = false;
        int n8 = n + (this.cpu.registers[66] & 0xFF);
        int n9 = n8 & 7;
        int n10 = (this.cpu.registers[67] & 0xFF) >> 3;
        int n11 = (this.hiBgTileMapAddress ? 7168 : 6144) + ((n8 & 0xF8) << 2);
        for (n7 = -(this.cpu.registers[67] & 7); n7 < n2; ++n10, n7 += 8) {
            n6 = this.bgWindowDataSelect ? this.videoRamBanks[0][n11 + (n10 & 0x1F)] & 0xFF : 256 + this.videoRamBanks[0][n11 + (n10 & 0x1F)];
            n5 = 0;
            if (this.cpu.gbcFeatures) {
                n4 = this.videoRamBanks[1][n11 + (n10 & 0x1F)];
                if ((n4 & 0x80) != n3) {
                    bl = true;
                    continue;
                }
                n5 += (n4 & 7) << 2;
                n5 += n4 >> 5 & 3;
                n6 += 384 * (n4 >> 3 & 1);
            }
            this.drawPartCopy(n6, n7, n, n9, n5);
        }
        if (n2 < 160) {
            n5 = this.hiWinTileMapAddress ? 7168 : 6144;
            int n12 = this.windowSourceLine >> 3;
            int n13 = this.windowSourceLine & 7;
            n4 = n5 + n12 * 32;
            for (n7 = n2; n7 < 160; ++n4, n7 += 8) {
                n6 = this.bgWindowDataSelect ? this.videoRamBanks[0][n4] & 0xFF : 256 + this.videoRamBanks[0][n4];
                int n14 = 0;
                if (this.cpu.gbcFeatures) {
                    byte by = this.videoRamBanks[1][n4];
                    if ((by & 0x80) != n3) {
                        bl = true;
                        continue;
                    }
                    n14 += (by & 7) << 2;
                    n14 += by >> 5 & 3;
                    n6 += 384 * (by >> 3 & 1);
                }
                this.drawPartCopy(n6, n7, n, n13, n14);
            }
        }
        return bl;
    }

    public final void notifyScanline(int n) {
        int n2;
        if (this.skipping || n >= 144) {
            return;
        }
        if (n == 0) {
            this.windowSourceLine = 0;
        }
        if (this.winEnabled && (this.cpu.registers[74] & 0xFF) <= n) {
            n2 = (this.cpu.registers[75] & 0xFF) - 7;
            if (n2 > 160) {
                n2 = 160;
            }
        } else {
            n2 = 160;
        }
        boolean bl = this.drawBackgroundForLine(n, n2, 0);
        this.drawSpritesForLine(n);
        if (bl) {
            this.drawBackgroundForLine(n, n2, 128);
        }
        if (n2 < 160) {
            ++this.windowSourceLine;
        }
        if (n == 143) {
            this.updateFrameBufferImage();
        }
    }

    protected final void updateFrameBufferImage() {
        if (!this.lcdEnabled) {
            int[] nArray = this.scale ? this.scaledBuffer : this.frameBuffer;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = -1;
            }
            this.frameBufferImage = Image.createRGBImage((int[])nArray, (int)this.scaledWidth, (int)this.scaledHeight, (boolean)false);
            return;
        }
        if (this.scale) {
            if (MeBoy.scalingMode == 0) {
                int n = 163839 / this.scaledWidth;
                int n2 = 147455 / this.scaledHeight;
                int n3 = 0;
                int n4 = n2 >> 1;
                int n5 = 0;
                int n6 = this.scaledWidth;
                for (int i = 0; i < this.scaledHeight; ++i) {
                    int n7 = n >> 1;
                    int n8 = n3 * 160;
                    while (n5 < n6) {
                        this.scaledBuffer[n5++] = this.frameBuffer[n8];
                        n7 = (n7 & 0x3FF) + n;
                        n8 += n7 >> 10;
                    }
                    n4 = (n4 & 0x3FF) + n2;
                    n3 += n4 >> 10;
                    n6 += this.scaledWidth;
                }
            } else if (MeBoy.scalingMode == 1) {
                int n = 162815 / this.scaledWidth;
                int n9 = 147455 / this.scaledHeight;
                int n10 = 0;
                int n11 = n9 >> 1;
                int n12 = 0;
                int n13 = this.scaledWidth;
                for (int i = 0; i < this.scaledHeight; ++i) {
                    int n14 = n >> 1;
                    int n15 = n10 * 160;
                    while (n12 < n13) {
                        int n16 = n14 >> 7;
                        int n17 = 8 - n16;
                        this.scaledBuffer[n12++] = n17 * this.frameBuffer[n15] + n16 * this.frameBuffer[n15 + 1] >> 3;
                        n15 += (n14 += n) >> 10;
                        n14 &= 0x3FF;
                    }
                    n11 = (n11 & 0x3FF) + n9;
                    n10 += n11 >> 10;
                    n13 += this.scaledWidth;
                }
            } else if (MeBoy.scalingMode == 2) {
                int n = 163839 / this.scaledWidth;
                int n18 = 146431 / this.scaledHeight;
                int n19 = 0;
                int n20 = n18 >> 1;
                int n21 = 0;
                int n22 = this.scaledWidth;
                for (int i = 0; i < this.scaledHeight; ++i) {
                    int n23 = n >> 1;
                    int n24 = n19 * 160;
                    while (n21 < n22) {
                        int n25 = n20 >> 7;
                        int n26 = 8 - n25;
                        this.scaledBuffer[n21++] = n26 * this.frameBuffer[n24] + n25 * this.frameBuffer[n24 + 160] >> 3;
                        n24 += (n23 += n) >> 10;
                        n23 &= 0x3FF;
                    }
                    n19 += (n20 += n18) >> 10;
                    n20 &= 0x3FF;
                    n22 += this.scaledWidth;
                }
            } else if (MeBoy.scalingMode == 3) {
                int n = 162815 / this.scaledWidth;
                int n27 = 146431 / this.scaledHeight;
                int n28 = 0;
                int n29 = n27 >> 1;
                int n30 = 0;
                int n31 = this.scaledWidth;
                for (int i = 0; i < this.scaledHeight; ++i) {
                    int n32 = n29 >> 7;
                    int n33 = 8 - n32;
                    int n34 = n >> 1;
                    int n35 = n28 * 160;
                    while (n30 < n31) {
                        int n36 = n34 * n33 >> 10;
                        int n37 = n33 - n36;
                        int n38 = n34 * n32 >> 10;
                        int n39 = n32 - n38;
                        this.scaledBuffer[n30++] = n37 * this.frameBuffer[n35] + n36 * this.frameBuffer[n35 + 1] + n39 * this.frameBuffer[n35 + 160] + n38 * this.frameBuffer[n35 + 161] >> 3;
                        n35 += (n34 += n) >> 10;
                        n34 &= 0x3FF;
                    }
                    n28 += (n29 += n27) >> 10;
                    n29 &= 0x3FF;
                    n31 += this.scaledWidth;
                }
            }
            this.frameBufferImage = Image.createRGBImage((int[])this.scaledBuffer, (int)this.scaledWidth, (int)this.scaledHeight, (boolean)false);
        } else {
            this.frameBufferImage = Image.createRGBImage((int[])this.frameBuffer, (int)160, (int)144, (boolean)false);
        }
    }

    protected final int[] updateImage(int n, int n2) {
        int n3 = n + this.tileCount * n2;
        boolean bl = n >= 384;
        int n4 = bl ? n - 384 << 4 : n << 4;
        int n5 = n2 & 0xFC;
        byte[] byArray = bl ? this.videoRamBanks[1] : this.videoRamBanks[0];
        int[] nArray = this.cpu.gbcFeatures ? this.gbcPalette : this.gbPalette;
        boolean bl2 = n2 >= this.transparentCutoff;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        if ((n2 & 2) != 0) {
            n8 = -16;
            n6 = 56;
        }
        if ((n2 & 1) == 0) {
            n7 = -1;
            n6 += 7;
            n8 += 16;
        }
        int n9 = 8;
        while (--n9 >= 0) {
            int n10;
            if ((n10 = weaveLookup[byArray[n4++] & 0xFF] + (weaveLookup[byArray[n4++] & 0xFF] << 1)) != 0) {
                bl2 = false;
            }
            int n11 = 8;
            while (--n11 >= 0) {
                this.tempPix[n6] = nArray[n5 + (n10 & 3)];
                n6 += n7;
                n10 >>= 2;
            }
            n6 += n8;
        }
        if (bl2) {
            this.tileImage[n3] = this.transparentImage;
        } else {
            this.tileImage[n3] = this.tempPix;
            this.tempPix = new int[64];
        }
        this.tileReadState[n] = true;
        return this.tileImage[n3];
    }

    protected final void drawPartCopy(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n + this.tileCount * n5;
        int[] nArray = this.tileImage[n7];
        if (nArray == null) {
            nArray = this.updateImage(n, n5);
        }
        int n8 = n2 + n3 * 160;
        int n9 = n4 * 8;
        int n10 = n6 = n2 + 8 > 160 ? (n3 + 1) * 160 : n8 + 8;
        if (n2 < 0) {
            n8 -= n2;
            n9 -= n2;
        }
        while (n8 < n6) {
            this.frameBuffer[n8++] = nArray[n9++];
        }
    }

    protected final void drawPartFgSprite(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n + this.tileCount * n5;
        int[] nArray = this.tileImage[n7];
        if (nArray == null) {
            nArray = this.updateImage(n, n5);
        }
        if (nArray == this.transparentImage) {
            return;
        }
        int n8 = n2 + n3 * 160;
        int n9 = n4 * 8;
        int n10 = n6 = n2 + 8 > 160 ? (n3 + 1) * 160 : n8 + 8;
        if (n2 < 0) {
            n8 -= n2;
            n9 -= n2;
        }
        while (n8 < n6) {
            if (nArray[n9] < 0) {
                this.frameBuffer[n8] = nArray[n9];
            }
            ++n8;
            ++n9;
        }
    }

    protected final void drawPartBgSprite(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n + this.tileCount * n5;
        int[] nArray = this.tileImage[n7];
        if (nArray == null) {
            nArray = this.updateImage(n, n5);
        }
        if (nArray == this.transparentImage) {
            return;
        }
        int n8 = n2 + n3 * 160;
        int n9 = n4 * 8;
        int n10 = n6 = n2 + 8 > 160 ? (n3 + 1) * 160 : n8 + 8;
        if (n2 < 0) {
            n8 -= n2;
            n9 -= n2;
        }
        while (n8 < n6) {
            if (nArray[n9] < 0 && this.frameBuffer[n8] >= 0) {
                this.frameBuffer[n8] = nArray[n9];
            }
            ++n8;
            ++n9;
        }
    }

    public void setScale(int n, int n2) {
        if (MeBoy.keepProportions) {
            if (n * 18 > n2 * 20) {
                n = n2 * 20 / 18;
            } else {
                n2 = n * 18 / 20;
            }
        }
        if (n == this.scaledWidth && n2 == this.scaledHeight) {
            return;
        }
        this.scale = n != 160 || n2 != 144;
        this.scaledWidth = n;
        this.scaledHeight = n2;
        this.scaledBuffer = (int[])(this.scale ? new int[this.scaledWidth * this.scaledHeight] : null);
    }

    public void setGBCPalette(int n, int n2) {
        super.setGBCPalette(n, n2);
        if ((n & 6) == 0) {
            int n3 = n >> 1;
            this.gbcPalette[n3] = this.gbcPalette[n3] & 0xFFFFFF;
        }
    }
}

