/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class Dmgcpu
implements Runnable {
    private final int F_ZERO;
    private final int F_SUBTRACT;
    private final int F_HALFCARRY;
    private final int F_CARRY;
    protected final int INSTRS_PER_DIV;
    protected final int BASE_INSTRS_IN_MODE_0;
    protected final int BASE_INSTRS_IN_MODE_2;
    protected final int BASE_INSTRS_IN_MODE_3;
    protected int INSTRS_IN_MODE_0 = 51;
    protected int INSTRS_IN_MODE_2 = 20;
    protected int INSTRS_IN_MODE_3 = 43;
    public final int INT_VBLANK;
    public final int INT_LCDC;
    public final int INT_TIMA;
    public final int INT_SER;
    public final int INT_P10;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int sp;
    private int hl;
    private byte[] decoderMemory;
    private int localPC;
    private int globalPC;
    private int decoderMaxCruise;
    private int instrCount;
    private int graphicsChipMode;
    private int nextModeTime;
    private int nextTimaOverflow;
    private int nextTimedInterrupt;
    public boolean interruptsEnabled = false;
    public boolean interruptsArmed = false;
    private boolean timaActive;
    private boolean interruptEnableRequested;
    protected boolean p10Requested;
    protected boolean gbcFeatures;
    protected int gbcRamBank;
    protected boolean hdmaRunning;
    public byte[][] memory = new byte[8][];
    private byte[] mainRam;
    public byte[] oam = new byte[256];
    public byte[] registers = new byte[256];
    private int divReset;
    private int instrsPerTima = 256;
    private int buttonState;
    public GraphicsChip graphicsChip;
    public GBCanvas screen;
    public boolean terminate;
    public String cartName;
    private int cartType;
    private byte[][] rom;
    public byte[][] cartRam;
    private int currentRomBank = 1;
    int loadedRomBanks;
    private int[] romTouch;
    private int currentRamBank;
    private boolean mbc1LargeRamMode;
    private boolean cartRamEnabled;
    public byte[] rtcReg = new byte[5];
    private int lastRtcUpdate;
    private int[] incflags = new int[256];
    private int[] decflags = new int[256];
    private int[] soundLength = new int[3];
    private int[] soundVolume = new int[3];
    private int[] soundFrequency = new int[3];
    private int[] soundStartVolume = new int[2];
    private int[] soundVolumeDelta = new int[2];
    private int[] soundVolumeDeltaPeriod = new int[2];
    private int[] soundVolumeDeltaStep = new int[2];
    private final int MASTER_VOLUME;
    private Player player;
    private MIDIControl synth;
    static int[] midiLookup = new int[2048];
    private static final int[] cyclesPerInstr;
    private static int[] cyclesPerInstrShift;

    public Dmgcpu(String string, GBCanvas gBCanvas) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.INSTRS_PER_DIV = 64;
        this.BASE_INSTRS_IN_MODE_0 = 51;
        this.BASE_INSTRS_IN_MODE_2 = 20;
        this.BASE_INSTRS_IN_MODE_3 = 43;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.MASTER_VOLUME = 8;
        this.cartName = string;
        this.screen = gBCanvas;
        this.initCartridge();
        this.graphicsChip = MeBoy.advancedGraphics ? new AdvancedGraphicsChip(this) : new SimpleGraphicsChip(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.interruptsEnabled = false;
        this.a = this.gbcFeatures ? 17 : 1;
        this.b = 0;
        this.c = 19;
        this.d = 0;
        this.e = 216;
        this.f = 176;
        this.hl = 333;
        this.setPC(256);
        this.sp = 65534;
        this.graphicsChipMode = 0;
        this.nextModeTime = 0;
        this.timaActive = false;
        this.interruptEnableRequested = false;
        this.nextTimedInterrupt = 0;
        this.initIncDecFlags();
        this.ioHandlerReset();
        if (MeBoy.enableSound) {
            this.initSound();
        }
    }

    public Dmgcpu(String string, GBCanvas gBCanvas, byte[] byArray) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.INSTRS_PER_DIV = 64;
        this.BASE_INSTRS_IN_MODE_0 = 51;
        this.BASE_INSTRS_IN_MODE_2 = 20;
        this.BASE_INSTRS_IN_MODE_3 = 43;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.MASTER_VOLUME = 8;
        this.cartName = string;
        this.screen = gBCanvas;
        this.initCartridge();
        this.graphicsChip = MeBoy.advancedGraphics ? new AdvancedGraphicsChip(this) : new SimpleGraphicsChip(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.unflatten(byArray);
        this.initIncDecFlags();
        if (MeBoy.enableSound) {
            this.initSound();
        }
    }

    private void initSound() {
        try {
            this.player = Manager.createPlayer((String)"device://midi");
            this.player.realize();
            this.player.start();
            this.synth = (MIDIControl)this.player.getControl("MIDIControl");
            if (MeBoy.advancedSound) {
                this.synth.shortMidiEvent(192, 81, 0);
                this.synth.shortMidiEvent(193, 81, 0);
                this.synth.shortMidiEvent(194, 81, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initIncDecFlags() {
        int n;
        this.incflags[0] = 160;
        for (n = 16; n < 256; n += 16) {
            this.incflags[n] = 32;
        }
        this.decflags[0] = 192;
        for (n = 1; n < 256; ++n) {
            this.decflags[n] = 64 + ((n & 0xF) == 15 ? 32 : 0);
        }
    }

    public void unflatten(byte[] byArray) {
        boolean bl;
        int n = 0;
        byte by = byArray[n++];
        boolean bl2 = bl = byArray[n++] != 0;
        if (by != 1 || bl != this.gbcFeatures) {
            throw new RuntimeException(MeBoy.literal[48]);
        }
        this.a = byArray[n++] & 0xFF;
        this.b = byArray[n++] & 0xFF;
        this.c = byArray[n++] & 0xFF;
        this.d = byArray[n++] & 0xFF;
        this.e = byArray[n++] & 0xFF;
        this.f = byArray[n++] & 0xFF;
        this.sp = byArray[n++] & 0xFF;
        this.sp = (this.sp << 8) + (byArray[n++] & 0xFF);
        this.hl = byArray[n++] & 0xFF;
        this.hl = (this.hl << 8) + (byArray[n++] & 0xFF);
        int n2 = byArray[n++] & 0xFF;
        n2 = (n2 << 8) + (byArray[n++] & 0xFF);
        this.instrCount = GBCanvas.getInt(byArray, n);
        this.nextModeTime = GBCanvas.getInt(byArray, n += 4);
        this.nextTimaOverflow = GBCanvas.getInt(byArray, n += 4);
        this.nextTimedInterrupt = GBCanvas.getInt(byArray, n += 4);
        n += 4;
        this.timaActive = byArray[n++] != 0;
        this.graphicsChipMode = byArray[n++];
        this.interruptsEnabled = byArray[n++] != 0;
        this.interruptsArmed = byArray[n++] != 0;
        this.interruptEnableRequested = byArray[n++] != 0;
        System.arraycopy(byArray, n, this.mainRam, 0, this.mainRam.length);
        System.arraycopy(byArray, n += this.mainRam.length, this.oam, 0, 160);
        System.arraycopy(byArray, n += 160, this.registers, 0, 256);
        this.divReset = GBCanvas.getInt(byArray, n += 256);
        this.instrsPerTima = GBCanvas.getInt(byArray, n += 4);
        n += 4;
        for (int i = 0; i < this.cartRam.length; ++i) {
            System.arraycopy(byArray, n, this.cartRam[i], 0, 8192);
            n += 8192;
        }
        this.currentRomBank = GBCanvas.getInt(byArray, n);
        this.mapRom(this.currentRomBank);
        this.currentRamBank = GBCanvas.getInt(byArray, n += 4);
        n += 4;
        if (this.currentRamBank != 0) {
            this.mapRam(this.currentRamBank);
        }
        this.mbc1LargeRamMode = byArray[n++] != 0;
        this.cartRamEnabled = byArray[n++] != 0;
        System.arraycopy(byArray, n, this.rtcReg, 0, this.rtcReg.length);
        n += this.rtcReg.length;
        n = this.graphicsChip.unflatten(byArray, n);
        if (this.gbcFeatures) {
            this.gbcRamBank = byArray[n++] & 0xFF;
            boolean bl3 = this.hdmaRunning = byArray[n++] != 0;
            if ((this.registers[77] & 0x80) != 0) {
                this.INSTRS_IN_MODE_0 = 51;
                this.INSTRS_IN_MODE_2 = 20;
                this.INSTRS_IN_MODE_3 = 43;
            }
        }
        this.setPC(n2);
        if (n != byArray.length) {
            throw new RuntimeException(MeBoy.literal[49] + ": " + n + ", " + byArray.length);
        }
    }

    public byte[] flatten() {
        int n = 53 + this.mainRam.length + 416 + 8192 * this.cartRam.length + this.rtcReg.length + 8192 + 48;
        if (this.gbcFeatures) {
            n += 8323;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        byArray[n2++] = 1;
        byArray[n2++] = (byte)(this.gbcFeatures ? 1 : 0);
        byArray[n2++] = (byte)this.a;
        byArray[n2++] = (byte)this.b;
        byArray[n2++] = (byte)this.c;
        byArray[n2++] = (byte)this.d;
        byArray[n2++] = (byte)this.e;
        byArray[n2++] = (byte)this.f;
        byArray[n2++] = (byte)(this.sp >> 8);
        byArray[n2++] = (byte)this.sp;
        byArray[n2++] = (byte)(this.hl >> 8);
        byArray[n2++] = (byte)this.hl;
        int n3 = this.localPC + this.globalPC;
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)n3;
        GBCanvas.setInt(byArray, n2, this.instrCount);
        GBCanvas.setInt(byArray, n2 += 4, this.nextModeTime);
        GBCanvas.setInt(byArray, n2 += 4, this.nextTimaOverflow);
        GBCanvas.setInt(byArray, n2 += 4, this.nextTimedInterrupt);
        n2 += 4;
        byArray[n2++] = (byte)(this.timaActive ? 1 : 0);
        byArray[n2++] = (byte)this.graphicsChipMode;
        byArray[n2++] = (byte)(this.interruptsEnabled ? 1 : 0);
        byArray[n2++] = (byte)(this.interruptsArmed ? 1 : 0);
        byArray[n2++] = (byte)(this.interruptEnableRequested ? 1 : 0);
        System.arraycopy(this.mainRam, 0, byArray, n2, this.mainRam.length);
        System.arraycopy(this.oam, 0, byArray, n2 += this.mainRam.length, 160);
        System.arraycopy(this.registers, 0, byArray, n2 += 160, 256);
        GBCanvas.setInt(byArray, n2 += 256, this.divReset);
        GBCanvas.setInt(byArray, n2 += 4, this.instrsPerTima);
        n2 += 4;
        for (int i = 0; i < this.cartRam.length; ++i) {
            System.arraycopy(this.cartRam[i], 0, byArray, n2, 8192);
            n2 += 8192;
        }
        GBCanvas.setInt(byArray, n2, this.currentRomBank);
        GBCanvas.setInt(byArray, n2 += 4, this.currentRamBank);
        n2 += 4;
        byArray[n2++] = (byte)(this.mbc1LargeRamMode ? 1 : 0);
        byArray[n2++] = (byte)(this.cartRamEnabled ? 1 : 0);
        System.arraycopy(this.rtcReg, 0, byArray, n2, this.rtcReg.length);
        n2 += this.rtcReg.length;
        n2 = this.graphicsChip.flatten(byArray, n2);
        if (this.gbcFeatures) {
            byArray[n2++] = (byte)this.gbcRamBank;
            byArray[n2++] = (byte)(this.hdmaRunning ? 1 : 0);
        }
        if (n2 != byArray.length) {
            throw new RuntimeException("error#21: " + n2 + ", " + byArray.length);
        }
        return byArray;
    }

    public final int addressRead(int n) {
        if (n < 40960) {
            return this.memory[n >> 13][n & 0x1FFF];
        }
        if (n < 49152) {
            if (this.currentRamBank >= 8) {
                this.rtcSync();
                return this.rtcReg[this.currentRamBank - 8];
            }
            return this.memory[n >> 13][n & 0x1FFF];
        }
        if ((n & 0x1000) == 0) {
            return this.mainRam[n & 0xFFF];
        }
        if (n < 65024) {
            return this.mainRam[(n & 0xFFF) + this.gbcRamBank * 4096];
        }
        if (n < 65280) {
            if (n > 65184) {
                return 255;
            }
            return this.oam[n - 65024] & 0xFF;
        }
        return this.ioRead(n - 65280);
    }

    public final void addressWrite(int n, int n2) {
        int n3 = n >> 12;
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.cartridgeWrite(n, n2);
                break;
            }
            case 8: 
            case 9: {
                this.graphicsChip.addressWrite(n - 32768, (byte)n2);
                break;
            }
            case 10: 
            case 11: {
                this.cartridgeWrite(n, n2);
                break;
            }
            case 12: {
                this.mainRam[n - 49152] = (byte)n2;
                break;
            }
            case 13: {
                this.mainRam[n - 53248 + this.gbcRamBank * 4096] = (byte)n2;
                break;
            }
            case 14: {
                this.mainRam[n - 57344] = (byte)n2;
                break;
            }
            case 15: {
                if (n < 65024) {
                    this.mainRam[n - 61440 + this.gbcRamBank * 4096] = (byte)n2;
                    break;
                }
                if (n < 65280) {
                    this.oam[n - 65024] = (byte)n2;
                    break;
                }
                this.ioWrite(n - 65280, n2);
            }
        }
    }

    private final void pushPC() {
        int n = this.globalPC + this.localPC;
        if (this.sp >> 13 == 6) {
            this.mainRam[--this.sp - 49152] = (byte)(n >> 8);
            this.mainRam[--this.sp - 49152] = (byte)n;
        } else {
            this.addressWrite(--this.sp, n >> 8);
            this.addressWrite(--this.sp, n & 0xFF);
        }
    }

    private final void popPC() {
        if (this.sp >> 13 == 6) {
            this.setPC((this.mainRam[this.sp++ - 49152] & 0xFF) + ((this.mainRam[this.sp++ - 49152] & 0xFF) << 8));
        } else {
            this.setPC((this.addressRead(this.sp++) & 0xFF) + ((this.addressRead(this.sp++) & 0xFF) << 8));
        }
    }

    private final int registerRead(int n) {
        switch (n) {
            case 0: {
                return this.b;
            }
            case 1: {
                return this.c;
            }
            case 2: {
                return this.d;
            }
            case 3: {
                return this.e;
            }
            case 4: {
                return this.hl >> 8;
            }
            case 5: {
                return this.hl & 0xFF;
            }
            case 6: {
                return this.addressRead(this.hl) & 0xFF;
            }
            case 7: {
                return this.a;
            }
        }
        return -1;
    }

    private final void registerWrite(int n, int n2) {
        switch (n) {
            case 0: {
                this.b = n2;
                return;
            }
            case 1: {
                this.c = n2;
                return;
            }
            case 2: {
                this.d = n2;
                return;
            }
            case 3: {
                this.e = n2;
                return;
            }
            case 4: {
                this.hl = this.hl & 0xFF | n2 << 8;
                return;
            }
            case 5: {
                this.hl = this.hl & 0xFF00 | n2;
                return;
            }
            case 6: {
                this.addressWrite(this.hl, n2);
                return;
            }
            case 7: {
                this.a = n2;
                return;
            }
        }
    }

    private void performHdma() {
        int n = ((this.registers[81] & 0xFF) << 8) + (this.registers[82] & 0xFF & 0xF0);
        int n2 = ((this.registers[83] & 0x1F) << 8) + (this.registers[84] & 0xF0) + 32768;
        for (int i = 0; i < 16; ++i) {
            this.addressWrite(n2 + i, this.addressRead(n + i));
        }
        this.registers[81] = (byte)(((n += 16) & 0xFF00) >> 8);
        this.registers[82] = (byte)(n & 0xF0);
        this.registers[83] = (byte)(((n2 += 16) & 0x1F00) >> 8);
        this.registers[84] = (byte)(n2 & 0xF0);
        if (this.registers[85] == 0) {
            this.hdmaRunning = false;
        }
        this.registers[85] = (byte)(this.registers[85] - 1);
    }

    public void playSound(int n, int n2) {
        if (this.player == null) {
            return;
        }
        try {
            int n3 = 18 + n * 5;
            int n4 = ((this.registers[n3 + 2] & 7) << 8) + (this.registers[n3 + 1] & 0xFF);
            int n5 = midiLookup[n4];
            if ((this.registers[n3 + 2] & 0x40) == 0) {
                this.soundLength[n] = Integer.MAX_VALUE;
            }
            if (n < 2) {
                this.soundStartVolume[n] = n2;
                this.soundVolumeDelta[n] = (this.registers[n3] & 8) != 0 ? 1 : -1;
                this.soundVolumeDeltaPeriod[n] = this.registers[n3] & 7;
                this.soundVolumeDeltaStep[n] = 0;
                if (this.soundVolumeDeltaPeriod[n] == 0) {
                    this.soundVolumeDelta[n] = 0;
                }
            }
            if (n == 2) {
                n5 -= 12;
            }
            if (MeBoy.advancedSound) {
                if (this.soundFrequency[n] > 0) {
                    this.synth.shortMidiEvent(128 + n, this.soundFrequency[n], 127);
                }
                this.soundFrequency[n] = n5;
                this.synth.shortMidiEvent(176 + n, 7, n2 * 8);
                if (n == 0) {
                    this.synth.shortMidiEvent(224, 0, 64);
                }
                this.synth.shortMidiEvent(144 + n, n5, 127);
            } else {
                if (this.soundFrequency[n] > 0) {
                    this.synth.shortMidiEvent(128 + n, this.soundFrequency[n], this.soundVolume[n] * 8);
                }
                this.soundFrequency[n] = n5;
                this.synth.shortMidiEvent(144 + n, n5, n2 * 8);
            }
            this.soundVolume[n] = n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateSoundFrequency() {
        if (this.player == null) {
            return;
        }
        if (this.soundFrequency[0] <= 0 || !MeBoy.advancedSound) {
            return;
        }
        int n = ((this.registers[20] & 7) << 8) + (this.registers[19] & 0xFF);
        int n2 = midiLookup[n];
        try {
            int n3 = 8192 + 1000 * (n2 - this.soundFrequency[0]);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 16383) {
                n3 = 16383;
            }
            this.synth.shortMidiEvent(224, n3 & 0x7F, n3 >> 7);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateSound(int n) {
        if (this.player == null) {
            return;
        }
        if (this.soundFrequency[n] <= 0) {
            return;
        }
        try {
            int n2 = n;
            this.soundLength[n2] = this.soundLength[n2] - 4;
            if (this.soundLength[n] <= 0) {
                this.stopSound(n);
            }
            if (n < 2 && this.soundVolumeDelta[n] != 0) {
                int n3 = n;
                this.soundVolumeDeltaStep[n3] = this.soundVolumeDeltaStep[n3] + 1;
                if (this.soundVolumeDeltaStep[n3] >= this.soundVolumeDeltaPeriod[n]) {
                    this.soundVolumeDeltaStep[n] = 0;
                    this.soundVolume[n] = this.soundVolume[n] + this.soundVolumeDelta[n] & 0xF;
                    if (this.soundVolume[n] == 0) {
                        this.stopSound(n);
                    } else if (MeBoy.advancedSound) {
                        this.synth.shortMidiEvent(176 + n, 7, this.soundVolume[n] * 8);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopSound(int n) {
        if (this.player == null) {
            return;
        }
        try {
            if (this.soundFrequency[n] > 0) {
                if (MeBoy.advancedSound) {
                    this.synth.shortMidiEvent(128 + n, this.soundFrequency[n], 127);
                } else {
                    this.synth.shortMidiEvent(128 + n, this.soundFrequency[n], this.soundVolume[n] * 8);
                }
            }
            this.soundFrequency[n] = -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void checkInterrupts() {
        this.pushPC();
        int n = this.registers[255] & this.registers[15];
        if ((n & 1) != 0) {
            this.setPC(64);
            this.registers[15] = (byte)(this.registers[15] - 1);
        } else if ((n & 2) != 0) {
            this.setPC(72);
            this.registers[15] = (byte)(this.registers[15] - 2);
        } else if ((n & 4) != 0) {
            this.setPC(80);
            this.registers[15] = (byte)(this.registers[15] - 4);
        } else if ((n & 8) != 0) {
            this.setPC(88);
            this.registers[15] = (byte)(this.registers[15] - 8);
        } else if ((n & 0x10) != 0) {
            this.setPC(96);
            this.registers[15] = (byte)(this.registers[15] - 16);
        }
        this.interruptsEnabled = false;
        this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
    }

    private final void initiateInterrupts() {
        if (this.instrCount - this.nextModeTime >= 0) {
            if (this.graphicsChipMode == 3) {
                this.graphicsChipMode = 0;
                this.nextModeTime += this.INSTRS_IN_MODE_0;
                int n = this.registers[68] & 0xFF;
                if (n < 144) {
                    if (this.gbcFeatures && this.hdmaRunning) {
                        this.performHdma();
                    }
                    if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 2) != 0 && (this.registers[65] & 8) != 0) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    }
                }
            } else if (this.graphicsChipMode == 0) {
                int n;
                this.graphicsChipMode = 2;
                this.nextModeTime += this.INSTRS_IN_MODE_2;
                this.registers[68] = (byte)(this.registers[68] + 1);
                if ((this.registers[68] & 0xFF) == 154) {
                    this.registers[68] = 0;
                }
                if ((n = this.registers[68] & 0xFF) < 144 && (this.registers[65] & 0x20) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 2);
                }
                if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 2) != 0 && (this.registers[65] & 0x40) != 0 && (this.registers[69] & 0xFF) == n) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 2);
                }
                if (n == 144) {
                    this.graphicsChip.vBlank();
                    if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 1) != 0) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 1);
                        if ((this.registers[65] & 0x10) != 0 && (this.registers[255] & 2) != 0) {
                            this.registers[15] = (byte)(this.registers[15] | 2);
                        }
                    }
                    for (int i = 0; i < 3; ++i) {
                        this.updateSound(i);
                    }
                }
                if (n == 0 && this.p10Requested) {
                    this.p10Requested = false;
                    if ((this.registers[255] & 0x10) != 0) {
                        this.registers[15] = (byte)(this.registers[15] | 0x10);
                    }
                    this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                }
            } else {
                this.graphicsChipMode = 3;
                this.nextModeTime += this.INSTRS_IN_MODE_3;
                int n = this.registers[68] & 0xFF;
                if (n < 144) {
                    this.graphicsChip.notifyScanline(n);
                }
            }
        }
        if (this.timaActive && this.instrCount - this.nextTimaOverflow >= 0) {
            this.nextTimaOverflow += this.instrsPerTima * (256 - (this.registers[6] & 0xFF));
            if ((this.registers[255] & 4) != 0) {
                this.interruptsArmed = true;
                this.registers[15] = (byte)(this.registers[15] | 4);
            }
        }
        if (this.interruptEnableRequested) {
            this.interruptsEnabled = true;
            this.interruptEnableRequested = false;
        }
        this.nextTimedInterrupt = this.nextModeTime;
        if (this.timaActive && this.nextTimaOverflow < this.nextTimedInterrupt) {
            this.nextTimedInterrupt = this.nextTimaOverflow;
        }
    }

    public final void setPC(int n) {
        if (n < 65280) {
            this.decoderMemory = this.memory[n >> 13];
            this.localPC = n & 0x1FFF;
            this.globalPC = n & 0xE000;
            int n2 = this.decoderMaxCruise = n < 57344 ? 8189 : 7677;
            if (this.gbcFeatures && this.gbcRamBank > 1 && n >= 49152) {
                this.decoderMaxCruise &= 0xFFF;
            }
        } else {
            this.decoderMemory = this.registers;
            this.localPC = n & 0xFF;
            this.globalPC = 65280;
            this.decoderMaxCruise = 253;
        }
    }

    private final void executeShift(int n) {
        int n2 = n & 7;
        int n3 = this.registerRead(n2);
        this.instrCount += cyclesPerInstrShift[n];
        if ((n & 0xC0) == 0) {
            switch (n & 0xF8) {
                case 0: {
                    this.f = 0;
                    if (n3 >= 128) {
                        this.f = 16;
                    }
                    n3 = n3 << 1 & 0xFF;
                    if ((this.f & 0x10) == 0) break;
                    n3 |= 1;
                    break;
                }
                case 8: {
                    this.f = 0;
                    if ((n3 & 1) != 0) {
                        this.f = 16;
                    }
                    n3 >>= 1;
                    if ((this.f & 0x10) == 0) break;
                    n3 |= 0x80;
                    break;
                }
                case 16: {
                    int n4 = n3 >= 128 ? 16 : 0;
                    n3 = n3 << 1 & 0xFF;
                    if ((this.f & 0x10) != 0) {
                        n3 |= 1;
                    }
                    this.f = n4;
                    break;
                }
                case 24: {
                    int n5 = (n3 & 1) != 0 ? 16 : 0;
                    n3 >>= 1;
                    if ((this.f & 0x10) != 0) {
                        n3 |= 0x80;
                    }
                    this.f = n5;
                    break;
                }
                case 32: {
                    this.f = 0;
                    if ((n3 & 0x80) != 0) {
                        this.f = 16;
                    }
                    n3 = n3 << 1 & 0xFF;
                    break;
                }
                case 40: {
                    this.f = 0;
                    if ((n3 & 1) != 0) {
                        this.f = 16;
                    }
                    n3 = (n3 & 0x80) + (n3 >> 1);
                    break;
                }
                case 48: {
                    n3 = (n3 & 0xF) << 4 | n3 >> 4;
                    this.f = 0;
                    break;
                }
                case 56: {
                    this.f = 0;
                    if ((n3 & 1) != 0) {
                        this.f = 16;
                    }
                    n3 >>= 1;
                }
            }
            if (n3 == 0) {
                this.f |= 0x80;
            }
            this.registerWrite(n2, n3);
        } else {
            int n6 = 1 << ((n & 0x38) >> 3);
            if ((n & 0xC0) == 64) {
                this.f = this.f & 0x10 | 0x20;
                if ((n3 & n6) == 0) {
                    this.f |= 0x80;
                }
            } else if ((n & 0xC0) == 128) {
                this.registerWrite(n2, n3 & 255 - n6);
            } else if ((n & 0xC0) == 192) {
                this.registerWrite(n2, n3 | n6);
            }
        }
    }

    private final void executeDAA() {
        int n = this.a >> 4 & 0xF;
        int n2 = this.a & 0xF;
        int n3 = this.f & 0x50;
        if ((this.f & 0x40) == 0) {
            if ((this.f & 0x10) == 0) {
                if (n <= 8 && n2 >= 10 && (this.f & 0x20) == 0) {
                    this.a += 6;
                }
                if (n <= 9 && n2 <= 3 && (this.f & 0x20) != 0) {
                    this.a += 6;
                }
                if (n >= 10 && n2 <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                    n3 |= 0x10;
                }
                if (n >= 9 && n2 >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                    n3 |= 0x10;
                }
                if (n >= 10 && n2 <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                    n3 |= 0x10;
                }
            } else {
                if (n <= 2 && n2 <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                }
                if (n <= 2 && n2 >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                }
                if (n <= 3 && n2 <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                }
            }
        } else if ((this.f & 0x10) == 0) {
            if (n <= 8 && n2 >= 6 && (this.f & 0x20) != 0) {
                this.a += 250;
            }
        } else {
            if (n >= 7 && n2 <= 9 && (this.f & 0x20) == 0) {
                this.a += 160;
            }
            if (n >= 6 && n2 >= 6 && (this.f & 0x20) != 0) {
                this.a += 154;
            }
        }
        this.a &= 0xFF;
        if (this.a == 0) {
            n3 |= 0x80;
        }
        this.f = n3;
    }

    private final void executeALU(int n) {
        int n2 = this.registerRead(n & 7);
        switch ((n & 0x38) >> 3) {
            case 1: {
                if ((this.f & 0x10) != 0) {
                    ++n2;
                }
            }
            case 0: {
                this.f = (this.a & 0xF) + (n2 & 0xF) >= 16 ? 32 : 0;
                this.a += n2;
                if (this.a > 255) {
                    this.f |= 0x10;
                    this.a &= 0xFF;
                }
                if (this.a != 0) break;
                this.f |= 0x80;
                break;
            }
            case 3: {
                if ((this.f & 0x10) != 0) {
                    ++n2;
                }
            }
            case 2: {
                this.f = 64;
                if ((this.a & 0xF) < (n2 & 0xF)) {
                    this.f |= 0x20;
                }
                this.a -= n2;
                if (this.a < 0) {
                    this.f |= 0x10;
                    this.a &= 0xFF;
                }
                if (this.a != 0) break;
                this.f |= 0x80;
                break;
            }
            case 4: {
                this.a &= n2;
                if (this.a == 0) {
                    this.f = 160;
                    break;
                }
                this.f = 32;
                break;
            }
            case 5: {
                this.a ^= n2;
                this.f = this.a == 0 ? 128 : 0;
                break;
            }
            case 6: {
                this.a |= n2;
                this.f = this.a == 0 ? 128 : 0;
                break;
            }
            case 7: {
                this.f = 64;
                if (this.a == n2) {
                    this.f |= 0x80;
                } else if (this.a < n2) {
                    this.f |= 0x10;
                }
                if ((this.a & 0xF) >= (n2 & 0xF)) break;
                this.f |= 0x20;
            }
        }
    }

    public final void run() {
        try {
            int n;
            this.terminate = false;
            int n2 = 0;
            System.gc();
            this.graphicsChip.timer = n = (int)System.currentTimeMillis();
            while (!this.terminate) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                if (this.localPC <= this.decoderMaxCruise) {
                    n7 = this.decoderMemory[this.localPC++] & 0xFF;
                    n6 = this.decoderMemory[this.localPC];
                    n5 = n6 & 0xFF;
                    n4 = this.decoderMemory[this.localPC + 1];
                } else {
                    n3 = this.localPC + this.globalPC;
                    n7 = this.addressRead(n3++) & 0xFF;
                    n6 = this.addressRead(n3);
                    n5 = n6 & 0xFF;
                    n4 = this.addressRead(n3 + 1);
                    this.setPC(n3);
                }
                switch (n7) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.localPC += 2;
                        this.b = n4 & 0xFF;
                        this.c = n5;
                        break;
                    }
                    case 2: {
                        this.addressWrite(this.b << 8 | this.c, this.a);
                        break;
                    }
                    case 3: {
                        ++this.c;
                        if (this.c != 256) break;
                        this.c = 0;
                        this.b = this.b + 1 & 0xFF;
                        break;
                    }
                    case 4: {
                        this.b = this.b + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.b];
                        break;
                    }
                    case 5: {
                        this.b = this.b - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.b];
                        break;
                    }
                    case 6: {
                        ++this.localPC;
                        this.b = n5;
                        break;
                    }
                    case 7: {
                        if (this.a >= 128) {
                            this.f = 16;
                            this.a = (this.a << 1) + 1 & 0xFF;
                            break;
                        }
                        if (this.a == 0) {
                            this.f = 128;
                            break;
                        }
                        this.a <<= 1;
                        this.f = 0;
                        break;
                    }
                    case 8: {
                        this.localPC += 2;
                        n2 = ((n4 & 0xFF) << 8) + n5;
                        this.addressWrite(n2, this.sp);
                        this.addressWrite(n2 + 1, this.sp >> 8);
                        break;
                    }
                    case 9: {
                        this.hl += (this.b << 8) + this.c;
                        if ((this.hl & 0xFFFF0000) != 0) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 10: {
                        this.a = this.addressRead((this.b << 8) + this.c) & 0xFF;
                        break;
                    }
                    case 11: {
                        --this.c;
                        if (this.c >= 0) break;
                        this.c = 255;
                        this.b = this.b - 1 & 0xFF;
                        break;
                    }
                    case 12: {
                        this.c = this.c + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.c];
                        break;
                    }
                    case 13: {
                        this.c = this.c - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.c];
                        break;
                    }
                    case 14: {
                        ++this.localPC;
                        this.c = n5;
                        break;
                    }
                    case 15: {
                        this.f = (this.a & 1) == 1 ? 16 : 0;
                        this.a >>= 1;
                        if ((this.f & 0x10) != 0) {
                            this.a |= 0x80;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 16: {
                        ++this.localPC;
                        if (!this.gbcFeatures || (this.registers[77] & 1) == 0) break;
                        n3 = this.registers[77] & 0xFE;
                        int n8 = 1;
                        if ((n3 & 0x80) != 0) {
                            n3 &= 0x7F;
                        } else {
                            n8 = 2;
                            n3 |= 0x80;
                        }
                        this.INSTRS_IN_MODE_0 = 51 * n8;
                        this.INSTRS_IN_MODE_2 = 20 * n8;
                        this.INSTRS_IN_MODE_3 = 43 * n8;
                        this.registers[77] = (byte)n3;
                        break;
                    }
                    case 17: {
                        this.localPC += 2;
                        this.d = n4 & 0xFF;
                        this.e = n5;
                        break;
                    }
                    case 18: {
                        this.addressWrite((this.d << 8) + this.e, this.a);
                        break;
                    }
                    case 19: {
                        ++this.e;
                        if (this.e != 256) break;
                        this.e = 0;
                        this.d = this.d + 1 & 0xFF;
                        break;
                    }
                    case 20: {
                        this.d = this.d + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.d];
                        break;
                    }
                    case 21: {
                        this.d = this.d - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.d];
                        break;
                    }
                    case 22: {
                        ++this.localPC;
                        this.d = n5;
                        break;
                    }
                    case 23: {
                        n2 = (this.a & 0x80) != 0 ? 16 : 0;
                        this.a <<= 1;
                        if ((this.f & 0x10) != 0) {
                            this.a |= 1;
                        }
                        this.a &= 0xFF;
                        if (this.a == 0) {
                            n2 |= 0x80;
                        }
                        this.f = n2;
                        break;
                    }
                    case 24: {
                        this.localPC += 1 + n6;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    case 25: {
                        this.hl += (this.d << 8) + this.e;
                        if ((this.hl & 0xFFFF0000) != 0) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 26: {
                        this.a = this.addressRead((this.d << 8) + this.e) & 0xFF;
                        break;
                    }
                    case 27: {
                        --this.e;
                        if (this.e >= 0) break;
                        this.e = 255;
                        this.d = this.d - 1 & 0xFF;
                        break;
                    }
                    case 28: {
                        this.e = this.e + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.e];
                        break;
                    }
                    case 29: {
                        this.e = this.e - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.e];
                        break;
                    }
                    case 30: {
                        ++this.localPC;
                        this.e = n5;
                        break;
                    }
                    case 31: {
                        n2 = (this.a & 1) != 0 ? 16 : 0;
                        this.a >>= 1;
                        if ((this.f & 0x10) != 0) {
                            this.a |= 0x80;
                        }
                        if (this.a == 0) {
                            n2 |= 0x80;
                        }
                        this.f = n2;
                        break;
                    }
                    case 32: {
                        if (this.f < 128) {
                            this.localPC += 1 + n6;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 33: {
                        this.localPC += 2;
                        this.hl = ((n4 & 0xFF) << 8) + n5;
                        break;
                    }
                    case 34: {
                        this.addressWrite(this.hl++, this.a);
                        break;
                    }
                    case 35: {
                        this.hl = this.hl + 1 & 0xFFFF;
                        break;
                    }
                    case 36: {
                        n5 = (this.hl >> 8) + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[n5];
                        this.hl = (this.hl & 0xFF) + (n5 << 8);
                        break;
                    }
                    case 37: {
                        n5 = (this.hl >> 8) - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[n5];
                        this.hl = (this.hl & 0xFF) + (n5 << 8);
                        break;
                    }
                    case 38: {
                        ++this.localPC;
                        this.hl = this.hl & 0xFF | n5 << 8;
                        break;
                    }
                    case 39: {
                        this.executeDAA();
                        break;
                    }
                    case 40: {
                        if (this.f >= 128) {
                            this.localPC += 1 + n6;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 41: {
                        this.hl *= 2;
                        if ((this.hl & 0xFFFF0000) != 0) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 42: {
                        this.a = this.addressRead(this.hl++) & 0xFF;
                        break;
                    }
                    case 43: {
                        this.hl = this.hl - 1 & 0xFFFF;
                        break;
                    }
                    case 44: {
                        n5 = this.hl + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[n5];
                        this.hl = (this.hl & 0xFF00) + n5;
                        break;
                    }
                    case 45: {
                        n5 = this.hl - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[n5];
                        this.hl = (this.hl & 0xFF00) + n5;
                        break;
                    }
                    case 46: {
                        ++this.localPC;
                        this.hl = this.hl & 0xFF00 | n5;
                        break;
                    }
                    case 47: {
                        this.a = ~this.a & 0xFF;
                        this.f |= 0x60;
                        break;
                    }
                    case 48: {
                        if ((this.f & 0x10) == 0) {
                            this.localPC += 1 + n6;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 49: {
                        this.localPC += 2;
                        this.sp = ((n4 & 0xFF) << 8) + n5;
                        break;
                    }
                    case 50: {
                        this.addressWrite(this.hl--, this.a);
                        break;
                    }
                    case 51: {
                        this.sp = this.sp + 1 & 0xFFFF;
                        break;
                    }
                    case 52: {
                        n5 = this.addressRead(this.hl) + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[n5];
                        this.addressWrite(this.hl, n5);
                        break;
                    }
                    case 53: {
                        n5 = this.addressRead(this.hl) - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[n5];
                        this.addressWrite(this.hl, n5);
                        break;
                    }
                    case 54: {
                        ++this.localPC;
                        this.addressWrite(this.hl, n5);
                        break;
                    }
                    case 55: {
                        this.f = this.f & 0x80 | 0x10;
                        break;
                    }
                    case 56: {
                        if ((this.f & 0x10) != 0) {
                            this.localPC += 1 + n6;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 57: {
                        this.hl += this.sp;
                        if (this.hl > 65535) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 58: {
                        this.a = this.addressRead(this.hl--) & 0xFF;
                        break;
                    }
                    case 59: {
                        this.sp = this.sp - 1 & 0xFFFF;
                        break;
                    }
                    case 60: {
                        this.a = this.a + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.a];
                        break;
                    }
                    case 61: {
                        this.a = this.a - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.a];
                        break;
                    }
                    case 62: {
                        ++this.localPC;
                        this.a = n5;
                        break;
                    }
                    case 63: {
                        this.f = this.f & 0x90 ^ 0x10;
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 65: {
                        this.b = this.c;
                        break;
                    }
                    case 66: {
                        this.b = this.d;
                        break;
                    }
                    case 67: {
                        this.b = this.e;
                        break;
                    }
                    case 68: {
                        this.b = this.hl >> 8;
                        break;
                    }
                    case 69: {
                        this.b = this.hl & 0xFF;
                        break;
                    }
                    case 70: {
                        this.b = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 71: {
                        this.b = this.a;
                        break;
                    }
                    case 72: {
                        this.c = this.b;
                        break;
                    }
                    case 73: {
                        break;
                    }
                    case 74: {
                        this.c = this.d;
                        break;
                    }
                    case 75: {
                        this.c = this.e;
                        break;
                    }
                    case 76: {
                        this.c = this.hl >> 8;
                        break;
                    }
                    case 77: {
                        this.c = this.hl & 0xFF;
                        break;
                    }
                    case 78: {
                        this.c = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 79: {
                        this.c = this.a;
                        break;
                    }
                    case 80: {
                        this.d = this.b;
                        break;
                    }
                    case 81: {
                        this.d = this.c;
                        break;
                    }
                    case 82: {
                        break;
                    }
                    case 83: {
                        this.d = this.e;
                        break;
                    }
                    case 84: {
                        this.d = this.hl >> 8;
                        break;
                    }
                    case 85: {
                        this.d = this.hl & 0xFF;
                        break;
                    }
                    case 86: {
                        this.d = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 87: {
                        this.d = this.a;
                        break;
                    }
                    case 88: {
                        this.e = this.b;
                        break;
                    }
                    case 89: {
                        this.e = this.c;
                        break;
                    }
                    case 90: {
                        this.e = this.d;
                        break;
                    }
                    case 91: {
                        break;
                    }
                    case 92: {
                        this.e = this.hl >> 8;
                        break;
                    }
                    case 93: {
                        this.e = this.hl & 0xFF;
                        break;
                    }
                    case 94: {
                        this.e = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 95: {
                        this.e = this.a;
                        break;
                    }
                    case 96: {
                        this.hl = this.hl & 0xFF | this.b << 8;
                        break;
                    }
                    case 97: {
                        this.hl = this.hl & 0xFF | this.c << 8;
                        break;
                    }
                    case 98: {
                        this.hl = this.hl & 0xFF | this.d << 8;
                        break;
                    }
                    case 99: {
                        this.hl = this.hl & 0xFF | this.e << 8;
                        break;
                    }
                    case 100: {
                        break;
                    }
                    case 101: {
                        this.hl = (this.hl & 0xFF) * 257;
                        break;
                    }
                    case 102: {
                        this.hl = this.hl & 0xFF | (this.addressRead(this.hl) & 0xFF) << 8;
                        break;
                    }
                    case 103: {
                        this.hl = this.hl & 0xFF | this.a << 8;
                        break;
                    }
                    case 104: {
                        this.hl = this.hl & 0xFF00 | this.b;
                        break;
                    }
                    case 105: {
                        this.hl = this.hl & 0xFF00 | this.c;
                        break;
                    }
                    case 106: {
                        this.hl = this.hl & 0xFF00 | this.d;
                        break;
                    }
                    case 107: {
                        this.hl = this.hl & 0xFF00 | this.e;
                        break;
                    }
                    case 108: {
                        this.hl = (this.hl >> 8) * 257;
                        break;
                    }
                    case 109: {
                        break;
                    }
                    case 110: {
                        this.hl = this.hl & 0xFF00 | this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 111: {
                        this.hl = this.hl & 0xFF00 | this.a;
                        break;
                    }
                    case 112: {
                        this.addressWrite(this.hl, this.b);
                        break;
                    }
                    case 113: {
                        this.addressWrite(this.hl, this.c);
                        break;
                    }
                    case 114: {
                        this.addressWrite(this.hl, this.d);
                        break;
                    }
                    case 115: {
                        this.addressWrite(this.hl, this.e);
                        break;
                    }
                    case 116: {
                        this.addressWrite(this.hl, this.hl >> 8);
                        break;
                    }
                    case 117: {
                        this.addressWrite(this.hl, this.hl);
                        break;
                    }
                    case 118: {
                        this.interruptsEnabled = true;
                        if (this.interruptsArmed) {
                            this.nextTimedInterrupt = this.instrCount;
                            break;
                        }
                        while (!this.interruptsArmed) {
                            this.instrCount = this.nextTimedInterrupt;
                            this.initiateInterrupts();
                        }
                        this.nextTimedInterrupt = ++this.instrCount;
                        break;
                    }
                    case 119: {
                        this.addressWrite(this.hl, this.a);
                        break;
                    }
                    case 120: {
                        this.a = this.b;
                        break;
                    }
                    case 121: {
                        this.a = this.c;
                        break;
                    }
                    case 122: {
                        this.a = this.d;
                        break;
                    }
                    case 123: {
                        this.a = this.e;
                        break;
                    }
                    case 124: {
                        this.a = this.hl >> 8;
                        break;
                    }
                    case 125: {
                        this.a = this.hl & 0xFF;
                        break;
                    }
                    case 126: {
                        this.a = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 127: {
                        break;
                    }
                    case 167: {
                        if (this.a == 0) {
                            this.f = 160;
                            break;
                        }
                        this.f = 32;
                        break;
                    }
                    case 175: {
                        this.a = 0;
                        this.f = 128;
                        break;
                    }
                    case 192: {
                        if (this.f >= 128) break;
                        this.popPC();
                        break;
                    }
                    case 193: {
                        this.c = this.addressRead(this.sp++) & 0xFF;
                        this.b = this.addressRead(this.sp++) & 0xFF;
                        break;
                    }
                    case 194: {
                        if (this.f < 128) {
                            this.setPC(((n4 & 0xFF) << 8) + n5);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 195: {
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    case 196: {
                        this.localPC += 2;
                        if (this.f >= 128) break;
                        this.pushPC();
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    case 197: {
                        this.addressWrite(--this.sp, this.b);
                        this.addressWrite(--this.sp, this.c);
                        break;
                    }
                    case 198: {
                        ++this.localPC;
                        this.f = (this.a & 0xF) + (n5 & 0xF) >= 16 ? 32 : 0;
                        this.a += n5;
                        if (this.a > 255) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 199: {
                        this.pushPC();
                        this.setPC(0);
                        break;
                    }
                    case 200: {
                        if (this.f < 128) break;
                        this.popPC();
                        break;
                    }
                    case 201: {
                        this.popPC();
                        break;
                    }
                    case 202: {
                        if (this.f >= 128) {
                            this.setPC(((n4 & 0xFF) << 8) + n5);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 203: {
                        ++this.localPC;
                        this.executeShift(n5);
                        break;
                    }
                    case 204: {
                        this.localPC += 2;
                        if (this.f < 128) break;
                        this.pushPC();
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    case 205: {
                        this.localPC += 2;
                        this.pushPC();
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    case 206: {
                        ++this.localPC;
                        if ((this.f & 0x10) != 0) {
                            ++n5;
                        }
                        this.f = (this.a & 0xF) + (n5 & 0xF) >= 16 ? 32 : 0;
                        this.a += n5;
                        if (this.a > 255) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 207: {
                        this.pushPC();
                        this.setPC(8);
                        break;
                    }
                    case 208: {
                        if ((this.f & 0x10) != 0) break;
                        this.popPC();
                        break;
                    }
                    case 209: {
                        this.e = this.addressRead(this.sp++) & 0xFF;
                        this.d = this.addressRead(this.sp++) & 0xFF;
                        break;
                    }
                    case 210: {
                        if ((this.f & 0x10) == 0) {
                            this.setPC(((n4 & 0xFF) << 8) + n5);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 212: {
                        this.localPC += 2;
                        if ((this.f & 0x10) != 0) break;
                        this.pushPC();
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    case 213: {
                        this.addressWrite(--this.sp, this.d);
                        this.addressWrite(--this.sp, this.e);
                        break;
                    }
                    case 214: {
                        ++this.localPC;
                        this.f = 64;
                        if ((this.a & 0xF) < (n5 & 0xF)) {
                            this.f |= 0x20;
                        }
                        this.a -= n5;
                        if (this.a < 0) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                            break;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 215: {
                        this.pushPC();
                        this.setPC(16);
                        break;
                    }
                    case 216: {
                        if ((this.f & 0x10) == 0) break;
                        this.popPC();
                        break;
                    }
                    case 217: {
                        this.interruptsEnabled = true;
                        if (this.interruptsArmed) {
                            this.nextTimedInterrupt = this.instrCount;
                        }
                        this.popPC();
                        break;
                    }
                    case 218: {
                        if ((this.f & 0x10) != 0) {
                            this.setPC(((n4 & 0xFF) << 8) + n5);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 220: {
                        this.localPC += 2;
                        if ((this.f & 0x10) == 0) break;
                        this.pushPC();
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    case 222: {
                        ++this.localPC;
                        if ((this.f & 0x10) != 0) {
                            ++n5;
                        }
                        this.f = 64;
                        if ((this.a & 0xF) < (n5 & 0xF)) {
                            this.f |= 0x20;
                        }
                        this.a -= n5;
                        if (this.a < 0) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                            break;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 223: {
                        this.pushPC();
                        this.setPC(24);
                        break;
                    }
                    case 224: {
                        ++this.localPC;
                        this.ioWrite(n5, this.a);
                        break;
                    }
                    case 225: {
                        this.hl = ((this.addressRead(this.sp + 1) & 0xFF) << 8) + (this.addressRead(this.sp) & 0xFF);
                        this.sp += 2;
                        break;
                    }
                    case 226: {
                        this.ioWrite(this.c, this.a);
                        break;
                    }
                    case 229: {
                        this.addressWrite(--this.sp, this.hl >> 8);
                        this.addressWrite(--this.sp, this.hl);
                        break;
                    }
                    case 230: {
                        ++this.localPC;
                        this.a &= n5;
                        if (this.a == 0) {
                            this.f = 128;
                            break;
                        }
                        this.f = 0;
                        break;
                    }
                    case 231: {
                        this.pushPC();
                        this.setPC(32);
                        break;
                    }
                    case 232: {
                        ++this.localPC;
                        this.sp += n6;
                        this.f = 0;
                        if (this.sp <= 65535 && this.sp >= 0) break;
                        this.sp &= 0xFFFF;
                        this.f = 16;
                        break;
                    }
                    case 233: {
                        this.setPC(this.hl);
                        break;
                    }
                    case 234: {
                        this.localPC += 2;
                        this.addressWrite(((n4 & 0xFF) << 8) + n5, this.a);
                        break;
                    }
                    case 238: {
                        ++this.localPC;
                        this.a ^= n5;
                        this.f = 0;
                        if (this.a != 0) break;
                        this.f = 128;
                        break;
                    }
                    case 239: {
                        this.pushPC();
                        this.setPC(40);
                        break;
                    }
                    case 240: {
                        ++this.localPC;
                        this.a = this.ioRead(n5) & 0xFF;
                        break;
                    }
                    case 241: {
                        this.f = this.addressRead(this.sp++) & 0xFF;
                        this.a = this.addressRead(this.sp++) & 0xFF;
                        break;
                    }
                    case 242: {
                        this.a = this.ioRead(this.c) & 0xFF;
                        break;
                    }
                    case 243: {
                        this.interruptsEnabled = false;
                        break;
                    }
                    case 245: {
                        this.addressWrite(--this.sp, this.a);
                        this.addressWrite(--this.sp, this.f);
                        break;
                    }
                    case 246: {
                        ++this.localPC;
                        this.a |= n5;
                        this.f = 0;
                        if (this.a != 0) break;
                        this.f = 128;
                        break;
                    }
                    case 247: {
                        this.pushPC();
                        this.setPC(48);
                        break;
                    }
                    case 248: {
                        ++this.localPC;
                        this.hl = this.sp + n6;
                        this.f = 0;
                        if ((this.hl & 0xFFFF0000) == 0) break;
                        this.f = 16;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    case 249: {
                        this.sp = this.hl;
                        break;
                    }
                    case 250: {
                        this.localPC += 2;
                        this.a = this.addressRead(((n4 & 0xFF) << 8) + n5) & 0xFF;
                        break;
                    }
                    case 251: {
                        this.interruptEnableRequested = true;
                        this.nextTimedInterrupt = this.instrCount + cyclesPerInstr[n7] + 1;
                        break;
                    }
                    case 254: {
                        ++this.localPC;
                        int n9 = this.f = (this.a & 0xF) < (n5 & 0xF) ? 96 : 64;
                        if (this.a == n5) {
                            this.f |= 0x80;
                            break;
                        }
                        if (this.a >= n5) break;
                        this.f |= 0x10;
                        break;
                    }
                    case 255: {
                        this.pushPC();
                        this.setPC(56);
                        break;
                    }
                    default: {
                        if ((n7 & 0xC0) == 128) {
                            this.executeALU(n7);
                            break;
                        }
                        throw new RuntimeException(Integer.toHexString(n7));
                    }
                }
                this.instrCount += cyclesPerInstr[n7];
                if (this.instrCount - this.nextTimedInterrupt < 0) continue;
                this.initiateInterrupts();
                if (!this.interruptsArmed || !this.interruptsEnabled) continue;
                this.checkInterrupts();
            }
        }
        catch (Exception exception) {
            this.terminate();
            exception.printStackTrace();
            MeBoy.showError(null, "error#20", exception);
        }
    }

    private final void ioHandlerReset() {
        this.ioWrite(15, 1);
        this.ioWrite(38, 241);
        this.ioWrite(64, 145);
        this.ioWrite(71, 252);
        this.ioWrite(72, 255);
        this.ioWrite(73, 255);
        this.registers[85] = -128;
        this.hdmaRunning = false;
    }

    private final int ioRead(int n) {
        if (n == 65) {
            int n2 = this.registers[65];
            if (this.registers[68] == this.registers[69]) {
                n2 |= 4;
            }
            n2 = (this.registers[68] & 0xFF) >= 144 ? (n2 |= 1) : (n2 |= this.graphicsChipMode);
            return n2;
        }
        if (n == 4) {
            return (byte)((this.instrCount - this.divReset - 1) / 64);
        }
        if (n == 5) {
            if (!this.timaActive) {
                return this.registers[n];
            }
            return (this.instrCount + this.instrsPerTima * 256 - this.nextTimaOverflow) / this.instrsPerTima;
        }
        return this.registers[n];
    }

    public void ioWrite(int n, int n2) {
        switch (n) {
            case 0: {
                int n3 = 0;
                if ((n2 & 0x10) == 0) {
                    n3 |= this.buttonState & 0xF;
                }
                if ((n2 & 0x20) == 0) {
                    n3 |= this.buttonState >> 4;
                }
                this.registers[0] = (byte)(0xF0 | ~n3 & 0xF);
                break;
            }
            case 2: {
                this.registers[2] = (byte)n2;
                if ((this.registers[2] & 1) != 1) break;
                this.registers[1] = -1;
                if ((this.registers[255] & 8) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 8);
                    if (this.interruptsEnabled) {
                        this.nextTimedInterrupt = this.instrCount;
                    }
                }
                this.registers[2] = (byte)(this.registers[2] & 0x7F);
                break;
            }
            case 4: {
                this.divReset = this.instrCount;
                break;
            }
            case 5: {
                if (!this.timaActive) break;
                this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - (n2 & 0xFF));
                break;
            }
            case 7: {
                if ((n2 & 4) != 0) {
                    if (!this.timaActive) {
                        this.timaActive = true;
                        this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - (this.registers[5] & 0xFF));
                    }
                    this.instrsPerTima = 4 << 2 * (n2 - 1 & 3);
                } else if (this.timaActive) {
                    this.timaActive = false;
                    this.registers[5] = (byte)((this.instrCount + this.instrsPerTima * 256 - this.nextTimaOverflow) / this.instrsPerTima);
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 15: {
                this.registers[n] = (byte)n2;
                boolean bl = this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                if (!this.interruptsArmed || !this.interruptsEnabled) break;
                this.nextTimedInterrupt = this.instrCount;
                break;
            }
            case 18: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0xF0) != 0) break;
                this.stopSound(0);
                break;
            }
            case 20: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0x80) != 0) {
                    this.soundLength[0] = 64 - (this.registers[17] & 0x3F);
                    this.playSound(0, this.registers[18] >> 4 & 0xF);
                    break;
                }
                this.updateSoundFrequency();
                break;
            }
            case 23: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0xF0) != 0) break;
                this.stopSound(1);
                break;
            }
            case 25: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0x80) == 0) break;
                this.soundLength[1] = 64 - (this.registers[22] & 0x3F);
                this.playSound(1, this.registers[23] >> 4 & 0xF);
                break;
            }
            case 26: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0x80) != 0) break;
                this.stopSound(2);
                this.registers[38] = (byte)(this.registers[38] & 0xFB);
                break;
            }
            case 28: {
                this.registers[n] = (byte)n2;
                if ((this.registers[n] & 0x60) != 0) break;
                this.stopSound(2);
                break;
            }
            case 30: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0x80) == 0) break;
                this.soundLength[2] = 256 - (this.registers[27] & 0xFF);
                this.playSound(2, 8 >> (this.registers[28] >> 5 & 3) & 7);
                break;
            }
            case 64: {
                this.graphicsChip.UpdateLCDCFlags(n2);
                this.registers[n] = (byte)n2;
                break;
            }
            case 65: {
                this.registers[n] = (byte)(n2 & 0xF8);
                break;
            }
            case 70: {
                System.arraycopy(this.memory[n2 >> 5], n2 << 8 & 0x1F00, this.oam, 0, 160);
                break;
            }
            case 71: {
                this.graphicsChip.decodePalette(0, n2);
                if (this.registers[n] == (byte)n2) break;
                this.registers[n] = (byte)n2;
                this.graphicsChip.invalidateAll(0);
                break;
            }
            case 72: {
                this.graphicsChip.decodePalette(4, n2);
                if (this.registers[n] == (byte)n2) break;
                this.registers[n] = (byte)n2;
                this.graphicsChip.invalidateAll(1);
                break;
            }
            case 73: {
                this.graphicsChip.decodePalette(8, n2);
                if (this.registers[n] == (byte)n2) break;
                this.registers[n] = (byte)n2;
                this.graphicsChip.invalidateAll(2);
                break;
            }
            case 74: {
                if ((n2 & 0xFF) >= 144) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 75: {
                if ((n2 & 0xFF) >= 167) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 77: {
                if (this.gbcFeatures) {
                    this.registers[n] = (byte)((n2 & 0x7F) + (this.registers[n] & 0x80));
                    break;
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 79: {
                if (this.gbcFeatures) {
                    this.graphicsChip.setVRamBank(n2 & 1);
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 85: {
                if (this.gbcFeatures) {
                    if (!this.hdmaRunning && (n2 & 0x80) == 0) {
                        int n4 = ((this.registers[81] & 0xFF) << 8) + (this.registers[82] & 0xF0);
                        int n5 = ((this.registers[83] & 0x1F) << 8) + (this.registers[84] & 0xF0);
                        int n6 = (n2 & 0x7F) * 16 + 16;
                        for (int i = 0; i < n6; ++i) {
                            this.graphicsChip.addressWrite(n5 + i, (byte)this.addressRead(n4 + i));
                        }
                        this.registers[85] = -1;
                        break;
                    }
                    if ((n2 & 0x80) != 0) {
                        this.hdmaRunning = true;
                        this.registers[85] = (byte)(n2 & 0x7F);
                        break;
                    }
                    this.hdmaRunning = false;
                    this.registers[85] = (byte)(this.registers[85] | 0x80);
                    break;
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 104: {
                if (this.gbcFeatures) {
                    this.registers[105] = (byte)this.graphicsChip.getGBCPalette(n2 & 0x3F);
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 105: {
                if (this.gbcFeatures) {
                    this.graphicsChip.setGBCPalette(this.registers[104] & 0x3F, n2 & 0xFF);
                    if (this.registers[104] < 0) {
                        int n7 = this.registers[104] + 1 & 0x3F;
                        this.registers[104] = (byte)(n7 + 128);
                        this.registers[105] = (byte)this.graphicsChip.getGBCPalette(n7);
                        break;
                    }
                    this.registers[n] = (byte)n2;
                    break;
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 106: {
                if (this.gbcFeatures) {
                    this.registers[107] = (byte)this.graphicsChip.getGBCPalette((n2 & 0x3F) + 64);
                }
                this.registers[106] = (byte)n2;
                break;
            }
            case 107: {
                if (this.gbcFeatures) {
                    this.graphicsChip.setGBCPalette((this.registers[106] & 0x3F) + 64, n2 & 0xFF);
                    if (this.registers[106] < 0) {
                        int n8 = this.registers[106] + 1 & 0x3F;
                        this.registers[106] = (byte)(n8 + 128);
                        this.registers[107] = (byte)this.graphicsChip.getGBCPalette(n8 + 64);
                        break;
                    }
                    this.registers[n] = (byte)n2;
                    break;
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 112: {
                if (this.gbcFeatures) {
                    this.gbcRamBank = (n2 & 7) < 2 ? 1 : n2 & 7;
                    if (this.globalPC >= 49152) {
                        this.setPC(this.globalPC + this.localPC);
                    }
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 255: {
                this.registers[n] = (byte)n2;
                boolean bl = this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                if (!this.interruptsArmed || !this.interruptsEnabled) break;
                this.nextTimedInterrupt = this.instrCount;
                break;
            }
            default: {
                this.registers[n] = (byte)n2;
            }
        }
    }

    private final void initCartridge() {
        InputStream inputStream;
        try {
            inputStream = Connector.openInputStream((String)this.cartName);
        }
        catch (IOException iOException) {
            inputStream = null;
        }
        if (inputStream == null) {
            throw new RuntimeException(MeBoy.literal[49] + " (" + this.cartName + ")");
        }
        try {
            int n;
            int n2;
            int n3;
            byte[] byArray = new byte[8192];
            int n4 = 8192;
            int n5 = 0;
            do {
                n3 = inputStream.read(byArray, 8192 - n4, n4);
                n5 += n3;
            } while ((n4 -= n3) > 0 && n3 > 0);
            if (n5 < 512 || byArray[260] != -50 || byArray[269] != 115 || byArray[280] != -120) {
                throw new RuntimeException(this.cartName + " " + MeBoy.literal[78]);
            }
            String string = "";
            for (n2 = 308; n2 < 323; ++n2) {
                if (byArray[n2] < 31 || byArray[n2] >= 128) continue;
                string = string + (char)byArray[n2];
            }
            this.screen.updateCartID(string);
            this.cartType = byArray[327] & 0xFF;
            n2 = this.lookUpCartSize(byArray[328]);
            this.gbcFeatures = (byArray[323] & 0x80) == 128 && !MeBoy.disableColor;
            this.mainRam = this.gbcFeatures ? new byte[32768] : new byte[8192];
            this.gbcRamBank = 1;
            if (n2 <= MeBoy.lazyLoadingThreshold) {
                this.rom = new byte[n2 * 2][8192];
                this.rom[0] = byArray;
                for (n = 1; n < n2 * 2; ++n) {
                    n4 = 8192;
                    if (n3 <= 0) continue;
                    do {
                        n3 = inputStream.read(this.rom[n], 8192 - n4, n4);
                        n5 += n3;
                    } while ((n4 -= n3) > 0 && n3 > 0);
                }
            } else {
                this.rom = new byte[n2 * 2][];
                this.rom[0] = byArray;
                this.rom[1] = new byte[8192];
                n4 = 8192;
                if (n3 > 0) {
                    do {
                        n3 = inputStream.read(this.rom[1], 8192 - n4, n4);
                        n5 += n3;
                    } while ((n4 -= n3) > 0 && n3 > 0);
                }
                this.loadedRomBanks = 1;
            }
            inputStream.close();
            this.memory[0] = this.rom[0];
            this.memory[1] = this.rom[1];
            this.romTouch = new int[this.rom.length / 2];
            this.mapRom(1);
            n = this.getNumRAMBanks();
            MeBoy.log("Loaded '" + this.cartName + "'. " + n2 + " banks = " + n2 * 16 + " kB, " + n + " RAM banks.");
            MeBoy.log("Type: " + this.cartType + (this.gbcFeatures ? " (color)" : " (bw)"));
            if (n == 0) {
                n = 1;
            }
            this.cartRam = new byte[n][8192];
            this.memory[5] = this.cartRam[0];
            this.lastRtcUpdate = (int)System.currentTimeMillis();
        }
        catch (Exception exception) {
            throw new RuntimeException(MeBoy.literal[49] + " (" + this.cartName + ", " + exception + ")");
        }
    }

    private final void mapRom(int n) {
        this.currentRomBank = n &= (this.rom.length >> 1) - 1;
        this.romTouch[n] = this.instrCount;
        if (this.rom[n * 2] == null) {
            try {
                InputStream inputStream;
                int n2;
                int n3;
                int n4;
                byte[][] byArrayArray = new byte[2][];
                if (this.loadedRomBanks >= MeBoy.lazyLoadingThreshold) {
                    n4 = 0;
                    int n5 = Integer.MIN_VALUE;
                    int n6 = this.rom.length >> 1;
                    for (n3 = 1; n3 < n6; ++n3) {
                        if (this.rom[n3 * 2] == null || (n2 = this.instrCount - this.romTouch[n3]) <= n5) continue;
                        n5 = n2;
                        n4 = n3;
                    }
                    byArrayArray[0] = this.rom[n4 * 2];
                    byArrayArray[1] = this.rom[n4 * 2 + 1];
                    this.rom[n4 * 2] = null;
                    this.rom[n4 * 2 + 1] = null;
                } else {
                    byArrayArray[0] = new byte[8192];
                    byArrayArray[1] = new byte[8192];
                    ++this.loadedRomBanks;
                }
                n4 = n * 16384;
                try {
                    inputStream = Connector.openInputStream((String)this.cartName);
                }
                catch (IOException iOException) {
                    inputStream = null;
                }
                if (inputStream != null) {
                    long l = 0L;
                    while (n4 > 0) {
                        l = inputStream.skip(n4);
                        if (l == 0L) {
                            inputStream.close();
                            inputStream = null;
                            break;
                        }
                        n4 = (int)((long)n4 - l);
                    }
                }
                if (inputStream == null) {
                    throw new RuntimeException("Failed skipping to " + n);
                }
                for (int i = n * 2; i < n * 2 + 2; ++i) {
                    n3 = 8192;
                    this.rom[i] = byArrayArray[i & 1];
                    while ((n3 -= (n2 = inputStream.read(this.rom[i], 8192 - n3, n3))) > 0 && n2 > 0) {
                    }
                }
                inputStream.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("error#22, " + exception);
            }
        }
        this.memory[2] = this.rom[n * 2];
        this.memory[3] = this.rom[n * 2 + 1];
        if ((this.globalPC & 0xC000) == 16384) {
            this.setPC(this.localPC + this.globalPC);
        }
    }

    private final void mapRam(int n) {
        this.currentRamBank = n;
        if (this.currentRamBank < this.cartRam.length) {
            this.memory[5] = this.cartRam[this.currentRamBank];
        }
    }

    private final void cartridgeWrite(int n, int n2) {
        int n3 = n >> 13;
        int n4 = n & 0x1FFF;
        switch (this.cartType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (n3 == 0) {
                    this.cartRamEnabled = (n2 & 0xF) == 10;
                    break;
                }
                if (n3 == 1) {
                    int n5 = n2 & 0x1F;
                    if (n5 == 0) {
                        n5 = 1;
                    }
                    this.mapRom(this.currentRomBank & 0x60 | n5);
                    break;
                }
                if (n3 == 2) {
                    if (this.mbc1LargeRamMode) {
                        this.mapRam(n2 & 3);
                        break;
                    }
                    this.mapRom(this.currentRomBank & 0x1F | (n2 & 3) << 5);
                    break;
                }
                if (n3 == 3) {
                    this.mbc1LargeRamMode = (n2 & 1) == 1;
                    break;
                }
                if (n3 != 5 || this.memory[n3] == null) break;
                this.memory[n3][n4] = (byte)n2;
                break;
            }
            case 5: 
            case 6: {
                if (n3 == 1) {
                    if ((n & 0x100) != 0) {
                        int n6 = n2 & 0xF;
                        if (n6 == 0) {
                            n6 = 1;
                        }
                        this.mapRom(n6);
                        break;
                    }
                    this.cartRamEnabled = (n2 & 0xF) == 10;
                    break;
                }
                if (n3 != 5 || this.memory[n3] == null) break;
                this.memory[n3][n4] = (byte)n2;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (n3 == 0) {
                    this.cartRamEnabled = (n2 & 0xF) == 10;
                    break;
                }
                if (n3 == 1) {
                    int n7 = n2 & 0x7F;
                    if (n7 == 0) {
                        n7 = 1;
                    }
                    this.mapRom(n7);
                    break;
                }
                if (n3 == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(n2 & 0xF);
                    break;
                }
                if (n3 == 3 || n3 != 5) break;
                if (this.currentRamBank >= 8) {
                    this.rtcSync();
                    this.rtcReg[this.currentRamBank - 8] = (byte)n2;
                    break;
                }
                if (this.memory[n3] == null) break;
                this.memory[n3][n4] = (byte)n2;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (n >> 12 == 1) {
                    this.cartRamEnabled = (n2 & 0xF) == 10;
                    break;
                }
                if (n >> 12 == 2) {
                    int n8 = this.currentRomBank & 0xFF00 | n2;
                    this.mapRom(n8);
                    break;
                }
                if (n >> 12 == 3) {
                    int n9 = this.currentRomBank & 0xFF | (n2 & 1) << 8;
                    this.mapRom(n9);
                    break;
                }
                if (n3 == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(n2 & 0xF);
                    break;
                }
                if (n3 != 5 || this.memory[n3] == null) break;
                this.memory[n3][n4] = (byte)n2;
            }
        }
    }

    protected final void rtcSync() {
        if ((this.rtcReg[4] & 0x40) == 0) {
            int n = (int)System.currentTimeMillis();
            while (n - this.lastRtcUpdate > 1000) {
                this.lastRtcUpdate += 1000;
                this.rtcReg[0] = (byte)(this.rtcReg[0] + 1);
                if (this.rtcReg[0] != 60) continue;
                this.rtcReg[0] = 0;
                this.rtcReg[1] = (byte)(this.rtcReg[1] + 1);
                if (this.rtcReg[1] != 60) continue;
                this.rtcReg[1] = 0;
                this.rtcReg[2] = (byte)(this.rtcReg[2] + 1);
                if (this.rtcReg[2] != 24) continue;
                this.rtcReg[2] = 0;
                this.rtcReg[3] = (byte)(this.rtcReg[3] + 1);
                if (this.rtcReg[3] != 0) continue;
                this.rtcReg[4] = (byte)((this.rtcReg[4] | this.rtcReg[4] << 7) ^ 1);
            }
        }
    }

    public final void rtcSkip(int n) {
        int n2 = n + this.rtcReg[0];
        this.rtcReg[0] = (byte)(n2 % 60);
        if ((n2 /= 60) == 0) {
            return;
        }
        this.rtcReg[1] = (byte)((n2 += this.rtcReg[1]) % 60);
        if ((n2 /= 60) == 0) {
            return;
        }
        this.rtcReg[2] = (byte)((n2 += this.rtcReg[2]) % 24);
        if ((n2 /= 24) == 0) {
            return;
        }
        n2 = n2 + (this.rtcReg[3] & 0xFF) + ((this.rtcReg[4] & 1) << 8);
        this.rtcReg[3] = (byte)n2;
        if (n2 > 511) {
            this.rtcReg[4] = (byte)(this.rtcReg[4] | 0x80);
        }
        this.rtcReg[4] = (byte)((this.rtcReg[4] & 0xFE) + (n2 >> 8 & 1));
    }

    private final int getNumRAMBanks() {
        switch (this.rom[0][329]) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: 
            case 5: 
            case 6: {
                return 16;
            }
        }
        return 0;
    }

    private final int lookUpCartSize(int n) {
        if (n < 8) {
            return 2 << n;
        }
        if (n == 82) {
            return 72;
        }
        if (n == 83) {
            return 80;
        }
        if (n == 84) {
            return 96;
        }
        return -1;
    }

    public final boolean hasBattery() {
        return this.cartType == 3 || this.cartType == 9 || this.cartType == 27 || this.cartType == 30 || this.cartType == 6 || this.cartType == 16 || this.cartType == 19;
    }

    public void buttonDown(int n) {
        this.buttonState |= 1 << n;
        this.p10Requested = true;
    }

    public void buttonUp(int n) {
        this.buttonState &= 255 - (1 << n);
        this.p10Requested = true;
    }

    public void setScale(int n, int n2) {
        this.graphicsChip.setScale(n, n2);
    }

    public int getLastSkipCount() {
        return this.graphicsChip.lastSkipCount;
    }

    public boolean isTerminated() {
        return this.terminate;
    }

    public void terminate() {
        this.terminate = true;
        this.stopSound(0);
        this.stopSound(1);
        this.stopSound(2);
    }

    public byte[] getRtcReg() {
        return this.rtcReg;
    }

    public byte[][] getCartRam() {
        return this.cartRam;
    }

    public void releaseReferences() {
        this.incflags = null;
        this.decflags = null;
        this.rtcReg = null;
        this.cartRam = null;
        this.rom = null;
        this.romTouch = null;
        this.cartName = null;
        this.graphicsChip = null;
        this.mainRam = null;
        this.screen = null;
        this.memory = null;
        this.decoderMemory = null;
        System.gc();
    }

    static {
        int[] nArray = new int[]{100, 210, 313, 410, 502, 589, 671, 748, 821, 890, 955, 1016, 1074, 1129, 1181, 1229, 1275, 1319, 1360, 1398, 1435, 1469, 1502, 1532, 1561, 1589, 1615, 1639, 1662, 1684, 1704, 1723, 1742, 1759, 1775, 1790, 1805, 1819, 1832, 1844, 1855, 1866, 1876, 1886, 1895, 1904, 1912, 1919, 1927, 1934, 1940, 1946, 1952, 1957, 1962, 1967, 1972, 1976, 1980, 1984, 1988, 1991, 1994, 1997, 2000, 2003, 2005, 2008, 2010, 2012, 2014, 2016, 2018, 2020, 2021, 2023, 2024, 2026, 2027, 2028, 2029, 2048};
        int n = 0;
        for (int i = 0; i < 2048; ++i) {
            if (i == nArray[n]) {
                ++n;
            }
            Dmgcpu.midiLookup[i] = 36 + n;
        }
        cyclesPerInstr = new int[]{1, 3, 2, 2, 1, 1, 2, 1, 5, 2, 2, 2, 1, 1, 2, 1, 1, 3, 2, 2, 1, 1, 2, 1, 3, 2, 2, 2, 1, 1, 2, 1, 3, 3, 2, 2, 1, 1, 2, 1, 3, 2, 2, 2, 1, 1, 2, 1, 3, 3, 2, 2, 3, 3, 3, 1, 3, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 5, 3, 4, 4, 6, 4, 2, 4, 5, 4, 4, 0, 6, 6, 2, 4, 5, 3, 4, 0, 6, 4, 2, 4, 5, 4, 4, 0, 6, 0, 2, 4, 3, 3, 2, 0, 0, 4, 2, 4, 4, 1, 4, 0, 0, 0, 2, 4, 3, 3, 2, 1, 0, 4, 2, 4, 3, 2, 4, 1, 0, 0, 2, 4};
        cyclesPerInstrShift = new int[]{2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2};
    }
}

