/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import utilitare.FCTicker;

public class FCList {
    private Vector items = new Vector();
    public int selectedIndex = 0;
    public Font textFont;
    public int lineSpacing;
    public String listTitle;
    public String leftListComm;
    public String middleListComm;
    public String rightListComm;
    public int posX;
    public int posY;
    public int lWidth;
    public int lHeight;
    public boolean hasBorder;
    public int borderType;
    public int borderColor;
    public int textColor;
    public int selectTextColor;
    public int selectRectColor;
    public int backColor;
    public Image backImage;
    public int listMode;
    private int curSelPos = 0;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int scrollOffsetBar = 0;
    private int noListLines = 0;
    private FCTicker selectedItemTicker;
    private FCTicker titleTicker;

    public FCList(Font textfont, int linespacing, String listtitle, String leftlistComm, String middlelistComm, String rightlistComm, int posx, int posy, int lwidth, int lheight, boolean hasborder, int bordertype, int bordercolor, int textcolor, int selecttextColor, int selectrectColor, int backcolor, Image backimage, int listmode) {
        this.textFont = textfont;
        this.lineSpacing = linespacing;
        this.listTitle = listtitle;
        this.leftListComm = leftlistComm;
        this.middleListComm = middlelistComm;
        this.rightListComm = rightlistComm;
        this.posX = posx + this.textFont.charWidth('A');
        this.posY = posy + this.textFont.getHeight();
        this.lWidth = lwidth - 2 * this.textFont.charWidth('A');
        this.lHeight = lheight - 3 * this.textFont.getHeight();
        this.hasBorder = hasborder;
        this.borderType = bordertype;
        this.borderColor = bordercolor;
        this.textColor = textcolor;
        this.selectTextColor = selecttextColor;
        this.selectRectColor = selectrectColor;
        this.backColor = backcolor;
        this.backImage = backimage;
        this.listMode = listmode;
        this.titleTicker = new FCTicker(this.listTitle, this.textFont, posx + 3 * this.textFont.charWidth('A'), posy, lwidth - 6 * this.textFont.charWidth('A'), 0xFFFFFF, 0, this.backImage, 0);
        this.selectedItemTicker = new FCTicker("", this.textFont, this.posX + 3, -100, this.lWidth - 6, this.selectTextColor, this.selectRectColor, null, 0);
    }

    public void draw(Graphics g) {
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cWid = g.getClipWidth();
        int cHei = g.getClipHeight();
        this.drawBox(g);
        this.drawMultiline(g);
        this.titleTicker.draw(g);
        g.setClip(cX, cY, cWid, cHei);
    }

    private void selectedIndexChanged() {
        int spSize = this.lineSpacing * this.textFont.getHeight() / 100;
        this.selectedItemTicker.setPosition(this.posX + 3, this.posY + 1 + spSize / 2 - this.textFont.getHeight() / 2 + this.curSelPos * spSize);
        this.selectedItemTicker.setText((String)this.items.elementAt(this.selectedIndex));
    }

    public void addItem(String itemul) {
        this.items.addElement(itemul);
        this.computeScrolls();
        this.selectedIndexChanged();
    }

    public int Count() {
        int retValue = 0;
        retValue = this.items.size();
        return retValue;
    }

    public void removeAllItems() {
        this.items.removeAllElements();
        this.selectedIndex = 0;
        this.curSelPos = 0;
        this.scrollOffset = 0;
        this.maxScrollOffset = 0;
        this.scrollOffsetBar = 0;
        this.noListLines = 0;
    }

    public void scrollDown() {
        --this.selectedIndex;
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.items.size() - 1;
            this.curSelPos = this.noListLines - 1;
        } else {
            --this.curSelPos;
            if (this.curSelPos < 0) {
                this.curSelPos = 0;
            }
        }
        this.scrollOffset = this.selectedIndex - this.curSelPos;
        this.computeScrollOff();
        this.selectedIndexChanged();
    }

    public void scrollUp() {
        ++this.selectedIndex;
        if (this.selectedIndex >= this.items.size()) {
            this.selectedIndex = 0;
            this.curSelPos = 0;
        } else {
            ++this.curSelPos;
            if (this.curSelPos >= this.noListLines) {
                this.curSelPos = this.noListLines - 1;
            }
        }
        this.scrollOffset = this.selectedIndex - this.curSelPos;
        this.computeScrollOff();
        this.selectedIndexChanged();
    }

    private void computeScrollOff() {
        float py = (float)this.scrollOffset / (float)this.maxScrollOffset;
        this.scrollOffsetBar = (int)(py * (float)this.lHeight);
    }

    private void computeScrolls() {
        int spSize = this.lineSpacing * this.textFont.getHeight() / 100;
        int lH = this.items.size() * spSize;
        this.noListLines = (this.lHeight - 2) / spSize;
        if (this.noListLines > this.items.size()) {
            this.noListLines = this.items.size();
        }
        this.scrollOffset = 0;
        this.maxScrollOffset = this.items.size() - this.noListLines;
    }

    private void drawBox(Graphics g) {
        int px = this.posX - this.textFont.charWidth('A');
        int py = this.posY - this.textFont.getHeight();
        int bw = this.lWidth + 2 * this.textFont.charWidth('A');
        int bh = this.lHeight + 3 * this.textFont.getHeight();
        g.clipRect(px, py, bw, bh);
        g.setColor(this.backColor);
        g.fillRect(px, py, bw, bh);
        if (this.backImage != null) {
            int nx = bw / this.backImage.getWidth() + 1;
            int ny = bh / this.backImage.getHeight() + 1;
            for (int ii = 0; ii < nx; ++ii) {
                for (int jj = 0; jj < ny; ++jj) {
                    g.drawImage(this.backImage, ii * this.backImage.getWidth(), jj * this.backImage.getHeight(), 0);
                }
            }
        }
        int midd = px + bw / 2;
        g.setColor(this.textColor);
        g.drawString(this.leftListComm, px + 1, py + bh - 1, 36);
        g.drawString(this.middleListComm, midd, py + bh - 1, 33);
        g.drawString(this.rightListComm, px + bw - 1, py + bh - 1, 40);
        if (this.hasBorder && this.borderType == 0) {
            int ppx = px + (this.posX - px) / 2;
            int ppy = py + (this.posY - py) / 2;
            int bbw = this.posX + this.lWidth + (this.posX - px) / 2;
            int bbh2 = this.posY + this.lHeight + this.textFont.getHeight() / 2;
            g.setColor(this.borderColor);
            int l1 = this.posX + 2 * this.textFont.charWidth('A');
            int l2 = this.posX + this.lWidth - 2 * this.textFont.charWidth('A');
            g.drawLine(ppx, ppy, l1, ppy);
            g.drawLine(l2, ppy, bbw, ppy);
            g.drawLine(bbw, ppy, bbw, bbh2);
            g.drawLine(bbw, bbh2, ppx, bbh2);
            g.drawLine(ppx, bbh2, ppx, ppy);
        }
    }

    private void drawMultiline(Graphics g) {
        if (this.items.size() > 0) {
            int spSize = this.lineSpacing * this.textFont.getHeight() / 100;
            g.setClip(this.posX + 1, this.posY + 1, this.lWidth - 2, this.lHeight - 2);
            g.setColor(this.textColor);
            for (int ii = this.scrollOffset; ii < this.scrollOffset + this.noListLines; ++ii) {
                g.drawString((String)this.items.elementAt(ii), this.posX + 2, this.posY + 2 + spSize / 2 - this.textFont.getHeight() / 2 + (ii - this.scrollOffset) * spSize, 0);
            }
            g.setColor(this.selectRectColor);
            g.fillRect(this.posX + 2, this.posY + 2 + this.curSelPos * spSize, this.lWidth - 4, spSize);
            this.selectedItemTicker.draw(g);
            int px = this.posX - this.textFont.charWidth('A');
            int py = this.posY - this.textFont.getHeight();
            int bw = this.lWidth + 2 * this.textFont.charWidth('A');
            int bh = this.lHeight + 3 * this.textFont.getHeight();
            g.setClip(px + bw - this.textFont.charWidth('A'), py, this.textFont.charWidth('A'), bh);
            g.setColor(this.borderColor);
            g.fillRect(px + bw - this.textFont.charWidth('A') / 2 - this.textFont.charWidth('A') / 4, this.posY, this.textFont.charWidth('A') / 2, this.lHeight);
            g.fillRect(px + bw - this.textFont.charWidth('A'), this.posY + this.scrollOffsetBar - this.textFont.getHeight() / 2, this.textFont.charWidth('A'), this.textFont.getHeight());
        }
    }
}

