/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class BTConn
implements DiscoveryListener {
    public String loginfo = "";
    public String BTurl = "";
    public ServiceRecord[] recs;
    public StreamConnection comCon;
    public boolean DEBUG = false;
    static final String DEBUG_address = "0013FDC157C8";
    protected UUID uuid = new UUID(256L);
    public int[] attr = new int[]{0, 1, 256};
    protected int inquiryMode = 10390323;
    protected int connectionOptions = 0;
    protected int stopToken = 255;
    public Vector deviceList = new Vector();
    public Vector devicefchubList = new Vector();
    public Vector serviceList = new Vector();
    public Vector serviceNameList = new Vector();
    public Vector fullServiceList = new Vector();
    public Vector fullServiceNameList = new Vector();
    public Vector devNameList = new Vector();
    public int devs = 0;

    public void getNames() {
        for (int uuu = 0; uuu < this.deviceList.size(); ++uuu) {
            this.devNameList.addElement(this.getDeviceStr((RemoteDevice)this.deviceList.elementAt(uuu)));
        }
    }

    public void connecTUrl(String cUrl) {
        try {
            this.comCon = (StreamConnection)Connector.open((String)cUrl);
        }
        catch (Exception ee) {
            this.loginfo = "bt conn error";
        }
    }

    public void connecTInd(int cInd) {
        try {
            this.BTurl = ((ServiceRecord)this.serviceList.elementAt(cInd)).getConnectionURL(this.connectionOptions, false);
            this.comCon = (StreamConnection)Connector.open((String)this.BTurl);
        }
        catch (Exception ee) {
            this.loginfo = "bt conn error";
        }
    }

    public void connecT() {
        try {
            int servIndex = -1;
            for (int yyy = 0; yyy < this.serviceList.size(); ++yyy) {
                String cSerN = this.findServiceName((ServiceRecord)this.serviceList.elementAt(yyy));
                if (cSerN.indexOf("FASTCODE_MOBILE_REMOTE") <= -1) continue;
                servIndex = yyy;
            }
            if (servIndex >= 0) {
                try {
                    this.BTurl = ((ServiceRecord)this.serviceList.elementAt(servIndex)).getConnectionURL(this.connectionOptions, false);
                    this.comCon = (StreamConnection)Connector.open((String)this.BTurl);
                    this.loginfo = "bt conn ok";
                }
                catch (Exception exception) {}
            } else {
                this.loginfo = "bt no fc hub";
            }
        }
        catch (Exception ee) {
            this.loginfo = "bt no fc hub";
        }
    }

    public boolean testFCHUB() {
        boolean retValue = false;
        try {
            int servIndex = -1;
            for (int yyy = 0; yyy < this.serviceList.size(); ++yyy) {
                String cSerN = this.findServiceName((ServiceRecord)this.serviceList.elementAt(yyy));
                if (cSerN.indexOf("FASTCODE_MOBILE_HUB") <= -1) continue;
                servIndex = yyy;
            }
            if (servIndex >= 0) {
                try {
                    retValue = true;
                }
                catch (Exception exception) {}
            } else {
                retValue = false;
            }
        }
        catch (Exception ee) {
            retValue = false;
        }
        return retValue;
    }

    public void startDeviceInquiry() {
        this.deviceList.removeAllElements();
        try {
            this.loginfo = "Start inquiry method - this will take few seconds...";
            DiscoveryAgent agent = this.getAgent();
            agent.startInquiry(this.inquiryMode, (DiscoveryListener)this);
        }
        catch (Exception e) {
            this.loginfo = e.toString();
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        this.loginfo = "A device discovered (" + this.getDeviceStr(btDevice) + ")";
        this.deviceList.addElement(btDevice);
        ++this.devs;
    }

    public void inquiryCompleted(int discType) {
        this.loginfo = "Inquiry compeleted";
    }

    public void startServiceSearch(RemoteDevice device) {
        this.serviceList.removeAllElements();
        try {
            this.loginfo = "Start search for Serial Port Profile service from " + this.getDeviceStr(device);
            UUID[] uuids = new UUID[]{this.uuid};
            this.getAgent().searchServices(this.attr, uuids, device, (DiscoveryListener)this);
        }
        catch (Exception e) {
            this.loginfo = e.toString();
        }
    }

    public void servicesDiscovered(int transId, ServiceRecord[] records) {
        this.loginfo = "Service discovered.";
        for (int i = 0; i < records.length; ++i) {
            if (this.findServiceName(records[i]).toUpperCase().indexOf("COM") < 0) continue;
            this.serviceList.addElement(records[i]);
        }
    }

    public String findServiceName(ServiceRecord sr) {
        String sName = "";
        try {
            DataElement elm = sr.getAttributeValue(256);
            if (elm != null && elm.getDataType() == 32) {
                sName = elm.getValue().toString();
            }
        }
        catch (Throwable tt) {
            sName = "ERROR";
        }
        return sName;
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        String msg = null;
        switch (respCode) {
            case 1: {
                msg = "the service search completed normally";
                break;
            }
            case 2: {
                msg = "the service search request was cancelled by a call to DiscoveryAgent.cancelServiceSearch()";
                break;
            }
            case 3: {
                msg = "an error occurred while processing the request";
                break;
            }
            case 4: {
                msg = "no records were found during the service search";
                break;
            }
            case 6: {
                msg = "the device specified in the search request could not be reached or the local device could not establish a connection to the remote device";
            }
        }
        this.loginfo = msg;
    }

    private void handleConnection(final String url) {
        Thread echo = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StreamConnection stream = null;
                try {
                    int r;
                    stream = (StreamConnection)Connector.open((String)url);
                    InputStream in = stream.openInputStream();
                    OutputStream out = stream.openOutputStream();
                    do {
                        r = in.read();
                        out.write(r);
                        out.flush();
                    } while (r != BTConn.this.stopToken);
                }
                catch (IOException e) {
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        echo.start();
    }

    private DiscoveryAgent getAgent() {
        try {
            return LocalDevice.getLocalDevice().getDiscoveryAgent();
        }
        catch (BluetoothStateException e) {
            throw new Error(e.getMessage());
        }
    }

    public String getDeviceStr(RemoteDevice btDevice) {
        return this.getFriendlyName(btDevice) + " - 0x" + btDevice.getBluetoothAddress();
    }

    private String getFriendlyName(RemoteDevice btDevice) {
        try {
            return btDevice.getFriendlyName(false);
        }
        catch (IOException e) {
            return "no name available";
        }
    }
}

