/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FCTicker {
    public String tickerText;
    public Font textFont;
    public int posX;
    public int posY;
    public int tWidth;
    public int textColor;
    public int backColor;
    public Image backImage;
    public int tickSpeed = 0;
    private long sLineLastTime = 0L;
    private int tickerOffset = 0;
    private int maxTickerOffset = 0;
    private int tickerDifference = 0;

    public FCTicker(String tickertext, Font textfont, int posx, int posy, int twidth, int textcolor, int backcolor, Image backimage, int tickspeed) {
        this.tickerText = tickertext;
        this.textFont = textfont;
        this.posX = posx;
        this.posY = posy;
        this.tWidth = twidth;
        this.textColor = textcolor;
        this.backColor = backcolor;
        this.backImage = backimage;
        this.tickSpeed = tickspeed;
        this.setText(tickertext);
    }

    public void setText(String boxtext) {
        this.tickerText = boxtext;
        this.tickerOffset = 0;
        int uiu = this.textFont.stringWidth(boxtext);
        this.tickerDifference = uiu - this.tWidth;
        if (this.tickerDifference < 0) {
            this.tickerDifference = 0;
        }
        this.maxTickerOffset = this.tickerDifference + 20;
    }

    public void setPosition(int posx, int posy) {
        this.posX = posx;
        this.posY = posy;
    }

    public void draw(Graphics g) {
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cWid = g.getClipWidth();
        int cHei = g.getClipHeight();
        this.drawBox(g);
        this.drawSingleline(g);
        g.setClip(cX, cY, cWid, cHei);
    }

    private void drawBox(Graphics g) {
        g.clipRect(this.posX, this.posY, this.tWidth, this.textFont.getHeight());
        g.setColor(this.backColor);
        g.fillRect(this.posX, this.posY, this.tWidth, this.textFont.getHeight());
        if (this.backImage != null) {
            int nx = this.tWidth / this.backImage.getWidth() + 1;
            int ny = this.textFont.getHeight() / this.backImage.getHeight() + 1;
            for (int ii = 0; ii < nx; ++ii) {
                for (int jj = 0; jj < ny; ++jj) {
                    g.drawImage(this.backImage, ii * this.backImage.getWidth(), jj * this.backImage.getHeight(), 0);
                }
            }
        }
    }

    private void drawSingleline(Graphics g) {
        g.setClip(this.posX, this.posY, this.tWidth, this.textFont.getHeight());
        g.setColor(this.textColor);
        if (this.tickerDifference > 0) {
            long sLinectime = System.currentTimeMillis();
            if (sLinectime - this.sLineLastTime > (long)this.tickSpeed) {
                if (this.tickerOffset < 10) {
                    g.drawString(this.tickerText, this.posX, this.posY, 20);
                } else if (this.tickerOffset < this.tickerDifference + 10) {
                    g.drawString(this.tickerText, this.posX - this.tickerOffset + 10, this.posY, 20);
                } else if (this.tickerOffset < this.maxTickerOffset) {
                    g.drawString(this.tickerText, this.posX - this.tickerDifference, this.posY, 20);
                } else {
                    g.drawString(this.tickerText, this.posX - this.tickerDifference + (this.tickerOffset - this.maxTickerOffset), this.posY, 20);
                }
                this.sLineLastTime = sLinectime;
                ++this.tickerOffset;
                if (this.tickerOffset > this.maxTickerOffset + this.tickerDifference) {
                    this.tickerOffset = 0;
                }
            }
        } else {
            g.drawString(this.tickerText, this.posX - this.tickerOffset, this.posY, 20);
        }
    }
}

