/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;

public class Landscape {
    private Body a;
    private Shape b;
    protected int segmentCount = 0;
    protected FXVector[] startpoints = new FXVector[128];
    protected FXVector[] endpoints = new FXVector[128];
    protected short[] faces = new short[128];
    private int c = 0;
    private int[] d = new int[32];
    private int e = 0;
    private int f = 0;
    public static final short FACE_NONE = 0;
    public static final short FACE_LEFT = 1;
    public static final short FACE_RIGHT = 2;
    private int g = 0;
    private Contact[] h = new Contact[32];

    public Landscape() {
        this.b = new Shape(new FXVector[0]);
        this.a = new Body(0, 0, this.b, false);
    }

    public Landscape(Landscape landscape) {
        this.b = new Shape(new FXVector[0]);
        this.a = new Body(0, 0, this.b, false);
        if (landscape == null) {
            return;
        }
        this.b.frictionFX = landscape.b.frictionFX;
        this.b.elasticityFX = landscape.b.elasticityFX;
        this.segmentCount = landscape.segmentCount;
        this.startpoints = new FXVector[Math.max(128, this.segmentCount)];
        this.endpoints = new FXVector[Math.max(128, this.segmentCount)];
        this.faces = new short[Math.max(128, this.segmentCount)];
        for (int i = 0; i < this.segmentCount; ++i) {
            this.startpoints[i] = new FXVector(landscape.startpoints[i]);
            this.endpoints[i] = new FXVector(landscape.endpoints[i]);
            this.faces[i] = landscape.faces[i];
        }
    }

    public Landscape copy() {
        return new Landscape(this);
    }

    public void addSegment(FXVector fXVector, FXVector fXVector2, short s) {
        FXVector fXVector3 = fXVector.xFX < fXVector2.xFX ? fXVector : fXVector2;
        FXVector fXVector4 = fXVector.xFX < fXVector2.xFX ? fXVector2 : fXVector;
        if (fXVector2.xFX <= fXVector.xFX & s != 0) {
            s = (short)(s == 2 ? 1 : 2);
        }
        this.startpoints = World.a(this.startpoints, this.segmentCount);
        this.endpoints = World.a(this.endpoints, this.segmentCount);
        this.faces = World.a(this.faces, this.segmentCount);
        this.startpoints[this.segmentCount] = fXVector3;
        this.endpoints[this.segmentCount] = fXVector4;
        this.faces[this.segmentCount] = s;
        ++this.segmentCount;
        this.sortArrays();
    }

    public void removeSegment(int n) {
        if (n < this.segmentCount) {
            this.startpoints[n] = this.startpoints[this.segmentCount - 1];
            this.endpoints[this.segmentCount] = this.endpoints[this.segmentCount - 1];
            this.faces[this.segmentCount] = this.faces[this.segmentCount - 1];
            --this.segmentCount;
            this.sortArrays();
        }
    }

    protected final void sortArrays() {
        int n = 0;
        for (int i = 1; i < this.segmentCount; ++i) {
            FXVector fXVector = this.startpoints[i];
            FXVector fXVector2 = this.endpoints[i];
            short s = this.faces[i];
            for (n = i - 1; n >= 0 && this.startpoints[n].xFX > fXVector.xFX; --n) {
                this.startpoints[n + 1] = this.startpoints[n];
                this.endpoints[n + 1] = this.endpoints[n];
                this.faces[n + 1] = this.faces[n];
            }
            this.startpoints[n + 1] = fXVector;
            this.endpoints[n + 1] = fXVector2;
            this.faces[n + 1] = s;
        }
    }

    protected final void initCollision() {
        this.c = 0;
        this.d = new int[32];
        this.e = 0;
        this.f = 0;
    }

    protected final void collisionCheckBody(World world, Body body) {
        int n;
        int n2;
        if (!body.a) {
            return;
        }
        if ((body.i & this.a.i) != 0) {
            return;
        }
        for (n2 = 0; n2 < this.e; ++n2) {
            if (this.d[n2] == -1 || this.endpoints[this.d[n2]].xFX >= body.e) continue;
            --this.f;
            this.d[n2] = -1;
        }
        n2 = 0;
        while (this.c < this.segmentCount && this.startpoints[this.c].xFX < body.f) {
            if (this.endpoints[this.c].xFX < body.e) {
                ++this.c;
                continue;
            }
            n = 1;
            while (n2 < this.e) {
                if (this.d[n2] == -1) {
                    this.d[n2] = this.c;
                    ++this.f;
                    n = 0;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                this.d = World.a(this.d, this.e);
                this.d[this.e++] = this.c;
                ++this.f;
            }
            if (this.e > this.f << 1) {
                this.e = World.b(this.d, this.e);
            }
            ++this.c;
        }
        for (n = 0; n < this.e; ++n) {
            if (this.d[n] < 0 || body.g > Math.max(this.endpoints[this.d[n]].yFX, this.startpoints[this.d[n]].yFX) || Math.min(this.startpoints[this.d[n]].yFX, this.endpoints[this.d[n]].yFX) > body.h) continue;
            int n3 = this.d[n];
            Body body2 = body;
            World world2 = world;
            Landscape landscape = this;
            if (body2.shape instanceof MultiShape) {
                int n4 = ((MultiShape)body2.shape).getShapeCount();
                for (int i = 0; i < n4; ++i) {
                    Contact contact = Collision.detectCollision(body2, i, landscape, n3);
                    if (contact == null) continue;
                    world2.d = World.a(world2.d, world2.c);
                    world2.d[world2.c] = contact;
                    ++world2.c;
                }
                continue;
            }
            Contact contact = Collision.detectCollision(body2, landscape, n3);
            if (contact == null) continue;
            world2.d = World.a(world2.d, world2.c);
            world2.d[world2.c] = contact;
            ++world2.c;
        }
    }

    protected void resetContacts() {
        for (int i = 0; i < this.g; ++i) {
            if (this.h[i] == null || this.h[i].c) continue;
            if (World.e < World.f.length) {
                World.f[World.e++] = this.h[i];
                this.h[i].c = true;
            }
            this.h[i] = null;
        }
        Landscape landscape = this;
        int n = landscape.g;
        int n2 = 0;
        for (int i = landscape.g - 1; n2 < i; --i) {
            while (landscape.h[n2] != null && n2 < i) {
                ++n2;
            }
            while (landscape.h[i] == null && n2 < i) {
                --i;
            }
            if (n2 >= i) continue;
            landscape.h[n2] = landscape.h[i];
            landscape.h[i] = null;
            n = i;
        }
        while (n > 0 && landscape.h[n - 1] == null) {
            --n;
        }
        landscape.g = n;
    }

    protected void addContact(Contact contact) {
        this.h = World.a(this.h, this.g);
        this.h[this.g] = contact;
        ++this.g;
    }

    public Contact[] getContacts() {
        return this.h;
    }

    public final void fillVertices(FXVector[] fXVectorArray, int n) {
        fXVectorArray[0] = this.startpoints[0];
        fXVectorArray[1] = this.endpoints[0];
    }

    protected Contact getContact(Body body, int n, int n2) {
        for (int i = 0; i < this.g; ++i) {
            Contact contact = this.h[i];
            if (contact == null || (contact.a != body || n != 0 || n2 != 0) && (contact.b != body || n != 0 || n2 != 0)) continue;
            return this.h[i];
        }
        return null;
    }

    public Body getBody() {
        return this.a;
    }

    public Shape getShape() {
        return this.b;
    }

    public int segmentCount() {
        return this.segmentCount;
    }

    public FXVector[] elementStartPoints() {
        return this.startpoints;
    }

    public FXVector[] elementEndPoints() {
        return this.endpoints;
    }

    public FXVector startPoint(int n) {
        return this.startpoints[n];
    }

    public FXVector endPoint(int n) {
        return this.endpoints[n];
    }
}

