/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;

public class World {
    private FXVector h = new FXVector(0, 409600);
    private int i = 0;
    private int j = 0;
    static int a = 204;
    static long b = 0x1000000 / a;
    private static int k = 10;
    private static int l = 5;
    public static final int SHAPE_MAX_VERTICES = 12;
    protected ShapeSet shapeSet = new ShapeSet();
    private Body[] m = new Body[128];
    private int n = Integer.MIN_VALUE;
    private int o = Integer.MAX_VALUE;
    private int p = 0;
    private Body[] q = new Body[128];
    private int r = 0;
    private int s = this.p;
    private Landscape t = new Landscape();
    int c = 0;
    Contact[] d = new Contact[128];
    static int e = 0;
    static Contact[] f = new Contact[32];
    private int u = 0;
    private Constraint[] v = new Constraint[32];
    static int g = 0;
    private int w = 0;
    protected UserData userData = null;

    public World() {
    }

    protected World(ShapeSet shapeSet) {
        this.shapeSet = shapeSet;
    }

    public World(World world) {
        if (world == null) {
            return;
        }
        this.shapeSet = world.shapeSet.copy();
        this.h.assign(world.h);
        this.i = world.i;
        this.j = world.j;
        this.n = world.n;
        this.o = world.o;
        this.addWorld(world);
        if (world.t != null) {
            this.setLandscape(world.t.copy());
        }
        if (world.userData != null) {
            this.userData = world.userData.copy();
        }
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public static int getTimestepFX() {
        return a;
    }

    public static long getInverseTimestepFX() {
        return b;
    }

    public static void setTimestepFX(int n) {
        a = n;
        b = 0x1000000 / a;
    }

    public static void setConstraintIterations(int n) {
        k = n;
    }

    public void setSimulationArea(int n, int n2) {
        this.n = n << 12;
        this.o = n2 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.shapeSet;
    }

    public Body[] addWorld(World world) {
        int n;
        int n2 = world.w;
        Body[] bodyArray = new Body[n2];
        for (n = 0; n < world.p; ++n) {
            Body body = world.q[n].copy();
            this.addBody(body);
            body.calculateAABB(0);
            bodyArray[world.q[n].id] = body;
        }
        for (n = 0; n < world.u; ++n) {
            this.addConstraint(world.v[n].copy(bodyArray));
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.id = this.w++;
            this.q = World.a(this.q, this.p);
            this.q[this.p++] = body;
            this.shapeSet.registerShape(body.shape);
            this.a();
            body.forceUpdate();
        }
    }

    public void setLandscape(Landscape landscape) {
        this.t = landscape;
    }

    public Landscape getLandscape() {
        return this.t;
    }

    public void removeBody(Body body) {
        int n;
        int n2;
        if (body.id < 0) {
            return;
        }
        for (n2 = 0; n2 < this.p; ++n2) {
            if (this.q[n2] != body) continue;
            this.q[n2] = null;
            break;
        }
        this.p = World.a((Object[])this.q, this.p);
        this.a();
        n2 = this.u;
        for (n = 0; n < n2; ++n) {
            if (!this.v[n].concernsBody(body)) continue;
            this.v[n] = null;
        }
        this.u = World.a(this.v, this.u);
        n = this.c;
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.d[n2].concernsBody(body)) continue;
            this.d[n2] = null;
        }
        this.c = World.a((Object[])this.d, this.c);
    }

    public void removeConstraint(Constraint constraint) {
        int n = this.u;
        for (int i = 0; i < n; ++i) {
            if (this.v[i] != constraint) continue;
            this.v[i] = null;
        }
        this.u = World.a(this.v, this.u);
    }

    static final int[] a(int[] nArray, int n) {
        if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n) {
        if (sArray.length <= n) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n) {
        if (bodyArray.length <= n) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n) {
        if (contactArray.length <= n) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n) {
        if (fXVectorArray.length <= n) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n) {
        if ((n = this.bodyIndexOf(n)) < 0) {
            return null;
        }
        return this.q[n];
    }

    protected Body findBody(Body body) {
        if (body == null) {
            return null;
        }
        int n = this.bodyIndexOf(body.id);
        if (n < 0) {
            return null;
        }
        return this.q[n];
    }

    public Body findBodyAt(int n, int n2) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i = 0; i < this.getBodyCount(); ++i) {
            Body body = bodyArray[i];
            fXVector.assignFX(n, n2);
            if (n < body.getAABBMinXFX() || n > body.getAABBMaxXFX() || n2 < body.getAABBMinYFX() || n2 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int j = 0; j < fXVectorArray.length; ++j) {
                long l;
                long l2 = (long)fXVector.xFX * (long)fXVectorArray[j].xFX + (long)fXVector.yFX * (long)fXVectorArray[j].yFX >> 12;
                long l3 = l = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[j].yFX >> 12;
                for (int k = 1; k < fXVectorArray2.length; ++k) {
                    long l4 = (long)fXVectorArray2[k].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[k].yFX * (long)fXVectorArray[j].yFX >> 12;
                    if (l > l4) {
                        l = l4;
                    }
                    if (l3 >= l4) continue;
                    l3 = l4;
                }
                if (l <= l2 && l3 >= l2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n) {
        for (int i = 0; i < this.p; ++i) {
            if (this.q[i].id != n) continue;
            return i;
        }
        return -1;
    }

    protected Constraint findConstraint(Constraint constraint) {
        int n = this.indexOf(constraint);
        if (n < 0) {
            return null;
        }
        return this.v[n];
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i = 0; i < this.u; ++i) {
            if (!this.v[i].equals(constraint)) continue;
            return i;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n = this.u;
            Constraint[] constraintArray2 = this.v;
            if (this.v.length <= n) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.v = constraintArray;
            this.v[this.u++] = constraint;
        }
    }

    public void setGravity(int n) {
        this.h = new FXVector(0, n << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.h = fXVector;
    }

    public void setDampingLateralFX(int n) {
        this.i = n;
    }

    public void setDampingRotationalFX(int n) {
        this.j = n;
    }

    public void tick() {
        int n;
        int n2;
        Body[] bodyArray = this.q;
        Constraint[] constraintArray = this.v;
        for (n2 = this.r; n2 < this.s; ++n2) {
            if (!bodyArray[n2].a || !bodyArray[n2].c) continue;
            bodyArray[n2].applyAcceleration(this.h);
            bodyArray[n2].calculateAABB(a);
        }
        this.checkCollisions();
        Contact.a(this.d, this.c);
        Contact.a(this.d, this.c, this.t);
        for (n2 = 0; n2 < this.c; ++n2) {
            this.d[n2].precalculate();
        }
        for (n2 = 0; n2 < this.u; ++n2) {
            constraintArray[n2].precalculate();
        }
        for (g = 0; g < k; ++g) {
            for (n2 = 0; n2 < this.u; ++n2) {
                constraintArray[n2].applyMomentum();
            }
            for (n2 = 0; n2 < this.c; ++n2) {
                this.d[n2].applyMomentum();
            }
        }
        for (n2 = 0; n2 < this.u; ++n2) {
            constraintArray[n2].postStep();
        }
        n2 = 4096 - this.i;
        int n3 = 4096 - this.j;
        for (n = this.r; n < this.s; ++n) {
            bodyArray[n].integrateVelocity(a);
            bodyArray[n].updateVelocity(n2, n3);
        }
        for (n = 0; n < this.c; ++n) {
            this.d[n].precalculatePositionCorrection(a);
        }
        long l = 0L;
        long l2 = 0L;
        for (g = 0; g < World.l; ++g) {
            for (n3 = 0; n3 < this.c; ++n3) {
                l2 = this.d[n3].applyMomentumPositionCorrectionFX();
                l = l < l2 ? l2 : l;
            }
            if (l < 32L) break;
        }
        for (n3 = this.r; n3 < this.s; ++n3) {
            bodyArray[n3].integrateVirtualVelocity(a);
        }
    }

    protected void checkCollisions() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.c; ++n3) {
            this.d[n3] = null;
        }
        n3 = this.c = 0;
        this.t.initCollision();
        this.a();
        int n4 = 0;
        int n5 = 0;
        for (n2 = this.r; n2 < this.s; ++n2) {
            n = this.q[n2].e;
            this.t.collisionCheckBody(this, this.q[n2]);
            for (int i = 0; i < n5; ++i) {
                if (this.m[i] == null) continue;
                if (this.m[i].f < n) {
                    --n4;
                    this.m[i] = null;
                    continue;
                }
                if (this.q[n2].g > this.m[i].h || this.m[i].g > this.q[n2].h) continue;
                Body body = this.m[i];
                Body body2 = this.q[n2];
                World world = this;
                if (!body2.a && !body.a || (body2.i & body.i) != 0 || !body2.b || !body.b) continue;
                if (body2.shape instanceof MultiShape || body.shape instanceof MultiShape) {
                    int n6 = 1;
                    int n7 = 1;
                    if (body2.shape instanceof MultiShape) {
                        n6 = ((MultiShape)body2.shape).getShapeCount();
                    }
                    if (body.shape instanceof MultiShape) {
                        n7 = ((MultiShape)body.shape).getShapeCount();
                    }
                    for (int j = 0; j < n6; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            Contact contact = Collision.detectCollision(body2, j, body, k);
                            if (contact == null) continue;
                            world.d = World.a(world.d, world.c);
                            world.d[world.c] = contact;
                            ++world.c;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world.d = World.a(world.d, world.c);
                world.d[world.c] = contact;
                ++world.c;
            }
            this.m = World.a(this.m, n5);
            this.m[n5++] = this.q[n2];
            if (n5 <= ++n4 << 1) continue;
            n5 = World.a((Object[])this.m, n5);
        }
        this.t.resetContacts();
        for (n2 = this.r; n2 < this.s; ++n2) {
            this.q[n2].resetContacts();
        }
        this.t.getBody();
        for (n = n3; n < this.c; ++n) {
            Contact contact = this.d[n];
            this.d[n].c = false;
            contact.a.addContact(contact);
            contact.b.addContact(contact);
        }
    }

    private static int a(Object[] objectArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (objectArray[n3] != null && n3 < n) {
                ++n3;
            }
            while (objectArray[n] == null && n3 < n) {
                --n;
            }
            if (n3 < n) {
                objectArray[n3] = objectArray[n];
                objectArray[n] = null;
            }
            if (objectArray[n] == null) {
                n2 = n;
            }
            --n;
        }
        while (n2 > 0 && objectArray[n2 - 1] == null) {
            --n2;
        }
        return n2;
    }

    static final int b(int[] nArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (nArray[n3] != -1 && n3 < n) {
                ++n3;
            }
            while (nArray[n] == -1 && n3 < n) {
                --n;
            }
            if (n3 < n) {
                nArray[n3] = nArray[n];
                nArray[n] = -1;
                n2 = n;
            }
            --n;
        }
        return n2;
    }

    private final void a() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.p; ++n) {
            Body body = this.q[n];
            for (n2 = n - 1; n2 >= 0 && this.q[n2].e > body.e; --n2) {
                this.q[n2 + 1] = this.q[n2];
            }
            this.q[n2 + 1] = body;
        }
        this.r = -1;
        this.s = this.p;
        for (n = 0; n < this.p; ++n) {
            if (this.r < 0 && this.q[n].f > this.n) {
                this.r = n;
            }
            if (this.q[n].e >= this.o) continue;
            this.s = n + 1;
        }
        if (this.r < 0) {
            this.r = 0;
        }
    }

    public FXVector getGravity() {
        return this.h;
    }

    public int getDampingLateralFX() {
        return this.i;
    }

    public int getDampingRotationalFX() {
        return this.j;
    }

    protected int getAreaStartFX() {
        return this.n;
    }

    protected int getAreaEndFX() {
        return this.o;
    }

    public int getBodyCount() {
        return this.p;
    }

    public Body[] getBodies() {
        return this.q;
    }

    public int getBodyStartIndex() {
        return this.r;
    }

    public int getBodyEndIndex() {
        return this.s;
    }

    public int getConstraintCount() {
        return this.u;
    }

    public Constraint[] getConstraints() {
        return this.v;
    }

    public int getContactCount() {
        return this.c;
    }

    public Contact[] getContacts() {
        return this.d;
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n = 0;
        contactArray = contactArray.getContacts();
        for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
            contactArray2[n++] = contactArray[i];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i = 0; i < n; ++i) {
            bodyArray[i].positionFX().xFX += fXVector.xFX;
            bodyArray[i].positionFX().yFX += fXVector.yFX;
            bodyArray[i].calculateAABB(0);
        }
    }
}

