/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import at.emini.physics2D.Body;
import at.emini.physics2D.Shape;
import at.emini.physics2D.util.FXVector;
import com.ximad.pvn.game.XBody;
import com.ximad.pvn.screens.GameScreen;
import com.ximad.pvn.utils.Utils;

public class Box2d {
    public static final float PHYSICAL_GRAVITY = 10.0f;
    public static final int PHYSICAL_STEPS_PER_SECOND = 19;

    public static XBody b2createCircleBody(int x, int y, int radius, int density, int friction, int restitution, boolean isStatic, boolean isBullet, boolean isPlayerPenetratable, boolean isPlayer, boolean fixedRotation) {
        Shape ball = Shape.createCircle(radius);
        ball.setElasticity(restitution);
        ball.setMass((int)((double)density * Math.PI * (double)radius * (double)radius / 500.0));
        XBody b = new XBody(x, y, ball, !isStatic);
        GameScreen.world.addBody(b);
        return b;
    }

    public static XBody b2createPolygonBody(int x, int y, int[] polyShape, int pointCount, int density, int friction, int restitution, boolean isStatic, boolean isBullet, boolean isFinish, boolean rotation, float angle) {
        float halfY;
        int i;
        FXVector[] polyVector = new FXVector[polyShape.length / 2];
        float area = 0.0f;
        for (i = 0; i < polyShape.length / 2; ++i) {
            polyVector[i] = new FXVector(polyShape[i * 2] - x << 12, polyShape[i * 2 + 1] - y << 12);
        }
        for (i = 2; i < polyShape.length / 2; ++i) {
            float a = (float)Math.sqrt((polyShape[2 * i] - polyShape[0]) * (polyShape[2 * i] - polyShape[0]) + (polyShape[2 * i + 1] - polyShape[1]) * (polyShape[2 * i + 1] - polyShape[1]));
            float b = (float)Math.sqrt((polyShape[2 * i - 2] - polyShape[0]) * (polyShape[2 * i - 2] - polyShape[0]) + (polyShape[2 * i - 1] - polyShape[1]) * (polyShape[2 * i - 1] - polyShape[1]));
            float c = (float)Math.sqrt((polyShape[2 * i - 2] - polyShape[2 * i]) * (polyShape[2 * i - 2] - polyShape[2 * i]) + (polyShape[2 * i - 1] - polyShape[2 * i + 1]) * (polyShape[2 * i - 1] - polyShape[2 * i + 1]));
            float p = (a + b + c) / 2.0f;
            area = (float)((double)area + Math.sqrt(p * (p - a) * (p - b) * (p - c)));
        }
        Shape rect = new Shape(polyVector);
        rect.correctCentroid();
        if (!isStatic) {
            rect.setElasticity(restitution);
        } else {
            rect.setElasticity(100);
        }
        rect.setFriction(friction);
        rect.setMass((int)(area * (float)density / 500.0f));
        float anf = (float)((double)(angle / 180.0f) * Math.PI);
        float halfX = (polyShape[0] - polyShape[4]) / 2;
        if (halfX < 0.0f) {
            halfX *= -1.0f;
        }
        if ((halfY = (float)((polyShape[5] - polyShape[1]) / 2)) < 0.0f) {
            halfY *= -1.0f;
        }
        if (polyShape.length == 6) {
            int left = 1000;
            int top = 1000;
            if (polyVector[0].xAsInt() < left) {
                left = polyVector[0].xAsInt();
            }
            if (polyVector[1].xAsInt() < left) {
                left = polyVector[1].xAsInt();
            }
            if (polyVector[2].xAsInt() < left) {
                left = polyVector[2].xAsInt();
            }
            if (polyVector[0].yAsInt() < top) {
                top = polyVector[0].yAsInt();
            }
            if (polyVector[1].yAsInt() < top) {
                top = polyVector[1].yAsInt();
            }
            if (polyVector[2].yAsInt() < top) {
                top = polyVector[2].yAsInt();
            }
            if (left < 0) {
                left *= -1;
            }
            if (top < 0) {
                top *= -1;
            }
            halfX = left;
            halfY = top;
        }
        float offsetX = (float)((double)halfX * Math.cos(anf) - (double)halfY * Math.sin(anf));
        float offsetY = (float)((double)halfY * Math.cos(anf) + (double)halfX * Math.sin(anf));
        XBody rectBody = new XBody(x + Utils.round(offsetX), y + Utils.round(offsetY), rect, !isStatic);
        rectBody.setRotationDeg((int)angle);
        GameScreen.world.addBody(rectBody);
        return rectBody;
    }

    public static int getCenterX(Body box2dId) {
        return box2dId.positionFX().xAsInt();
    }

    public static int getCenterY(Body box2dId) {
        return box2dId.positionFX().yAsInt();
    }

    public static int getX(Body box2dId) {
        return box2dId.positionFX().xAsInt();
    }

    public static int getY(Body box2dId) {
        return box2dId.positionFX().yAsInt();
    }

    public static void stopAngularVelocity(Body box2dId) {
    }

    public static void destroyGameObject(Body box2dId) {
        GameScreen.world.removeBody(box2dId);
    }

    public static int getMass(Body box2dId) {
        return box2dId.shape().getMass();
    }

    public static int getAngle(Body box2dId) {
        return (box2dId.rotation2FX() >> 105414356) * 360 / 100;
    }

    public static void moveBodyOutside(Body box2dId) {
        box2dId.setPositionFX(new FXVector(500, -100));
        box2dId.setDynamic(false);
    }

    public static void applyForceToCenter(Body body, int px, int py) {
        body.setDynamic(true);
        body.applyMomentum(FXVector.newVector(px, py));
    }

    public static int getLinearVelocityX(Body box2dId) {
        return box2dId.velocityFX().xAsInt();
    }

    public static int getLinearVelocityY(Body box2dId) {
        return box2dId.velocityFX().yAsInt();
    }

    public static void setMass(Body box2dId, int i) {
    }

    public static void setVelocity(Body box2dId, int i, int j) {
    }

    public static void applyImpulseToCenter(Body body, int px, int py) {
        body.setDynamic(true);
        body.applyMomentum(FXVector.newVector(px, py));
    }

    public static void stopLinearVelocity(Body box2dId) {
    }
}

