/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.pandas;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.TraceEffect;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.game.pandas.PandaMini;
import com.ximad.pvn.utils.ArrayList;

public class PandaTriple
extends Panda {
    public void OnCollision(PhysicalGameObject obj, float force) {
        if (MyWorld.playerPanda != null && !this.isDying && this == MyWorld.playerPanda) {
            MyWorld.onFly = false;
            this.isDying = true;
            MyWorld.playerPanda = null;
        }
    }

    public void ability() {
        if (this.trick) {
            SoundSystem.SOUND_ON_ABILITY.play();
            Box2d.applyForceToCenter(PandaMini.createMainPanda(Box2d.getCenterX(this.box2dId), Box2d.getCenterY(this.box2dId)), Box2d.getLinearVelocityX(this.box2dId), Box2d.getLinearVelocityY(this.box2dId));
            Box2d.applyForceToCenter(PandaMini.createPanda(Box2d.getCenterX(this.box2dId), Box2d.getCenterY(this.box2dId)), (int)((float)Box2d.getLinearVelocityX(this.box2dId) * 0.6f), (int)((float)Box2d.getLinearVelocityY(this.box2dId) * 0.6f));
            Box2d.applyForceToCenter(PandaMini.createPanda(Box2d.getCenterX(this.box2dId), Box2d.getCenterY(this.box2dId)), (int)((float)Box2d.getLinearVelocityX(this.box2dId) * 1.7f), (int)((float)Box2d.getLinearVelocityY(this.box2dId) * 1.7f));
            Box2d.destroyGameObject(this.box2dId);
            MyWorld.livesDisapearedPanda += 2;
            this.trick = false;
            MyWorld.physicalGameObjects.remove(this);
        }
    }

    public static void createPanda(int x, int y) {
        PandaTriple panda = new PandaTriple();
        panda.typeDinamicalObjects = 102;
        panda.isCircle = true;
        panda.restitution = 43;
        panda.friction = 3;
        panda.radius = 15;
        panda.density = 40;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        panda.setShape(shape, false, false);
        panda.frames = Textures.pandaGhost;
        panda.nFrames = 8;
        MyWorld.physicalGameObjects.add(panda);
        panda.mass = Box2d.getMass(panda.box2dId);
        MyWorld.playerPanda = panda;
        Camera.setTarget(panda);
        panda.box2dId.setParent(panda);
        panda.box2dId.addCollisionLayer(1);
        TraceEffect.createSpecialTrace(panda);
    }

    public static void launchPanda(int RawX, int RawY) {
        PandaTriple.createPanda(RawX, RawY);
        Box2d.applyForceToCenter(MyWorld.playerPanda.box2dId, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceX, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceY);
    }

    public void update(long dt) {
        this.checkDeadPanda(dt);
        this.checkDistance();
        super.update(dt);
    }
}

