/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PandaSeeker;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.pandas.Panda;

public class Camera {
    private static final int MOVE_TO_START_TIME_AFTER_PANDA_DISAPPEAR = 4000;
    boolean isScrolling;
    boolean show_tutorial;
    public static int lastPandaX;
    public static int lastPandaY;
    public static int position;
    public static int far_layer_offset;
    public static int mid_layer_offset;
    int camera_center;
    private static final int MID_LAYER_POSITION_COEF = 4;
    private static final int FAR_LAYER_POSITION_COEF = 10;
    private static final int MAX_CAMERA_SPEED = 20;
    int time_tick;
    private boolean canScroll;
    public static int tick;
    public static int time_wait;
    public static boolean isScrollingStart;
    public static int level_size;
    public static boolean earlyF;
    public static boolean canScrollStart;
    public static boolean isFollowing;
    public static PhysicalGameObject pObj;
    public static int scrollspeed;

    public static void setPosition(int p) {
        position = p;
        far_layer_offset = position / 10;
        mid_layer_offset = position / 4;
    }

    public void init() {
        this.isScrolling = false;
        this.show_tutorial = false;
        position = 0;
        far_layer_offset = 0;
        mid_layer_offset = 0;
        this.camera_center = position + Application.screenWidth / 2;
        scrollspeed = 0;
        this.time_tick = 0;
        tick = 0;
        time_wait = 0;
    }

    public void reset() {
    }

    public void update(long dt) {
        if (MyWorld.onLevelStart && !MyWorld.onTutorial) {
            if (this.isScrolling) {
                MyWorld.onLevelStart = false;
            }
            if ((tick = (int)((long)tick + dt)) > 5000) {
                this.moveToStart();
            }
        }
        if (isScrollingStart && canScrollStart && (time_wait = (int)((long)time_wait + dt)) > 4000) {
            this.moveToStart();
        }
        if (isFollowing) {
            if (MyWorld.onWin || MyWorld.onLost) {
                isFollowing = false;
            } else {
                this.followTargetToDeath();
            }
        }
        if (this.isScrolling) {
            this.camera_scroll();
        }
        if (earlyF) {
            this.moveToEnd();
        }
        if (MyWorld.playerPanda != null) {
            lastPandaX = Box2d.getCenterX(MyWorld.playerPanda.box2dId);
        } else if (isFollowing && pObj != null) {
            lastPandaX = Box2d.getCenterX(Camera.pObj.box2dId);
        }
    }

    private boolean moveToEnd() {
        if (this.isScrolling || this.canScroll) {
            earlyF = false;
            return false;
        }
        scrollspeed = 30;
        far_layer_offset = (position += scrollspeed) / 10;
        mid_layer_offset = position / 4;
        if (position >= MyWorld.center - Application.screenWidth / 2) {
            position = MyWorld.center - Application.screenWidth / 2;
            far_layer_offset = position / 10;
            mid_layer_offset = position / 4;
            scrollspeed = 0;
            earlyF = false;
            return true;
        }
        return false;
    }

    private void followTargetToDeath() {
        if (this.isScrolling) {
            isFollowing = false;
            pObj = null;
            return;
        }
        if (pObj != null) {
            int width_div_2 = Application.screenWidth / 2;
            int x = Box2d.getX(Camera.pObj.box2dId);
            if (position + width_div_2 < x) {
                far_layer_offset = (position += -(lastPandaX - x)) / 10;
                mid_layer_offset = position / 4;
            }
            if (position >= MyWorld.center - width_div_2) {
                position = MyWorld.center - width_div_2;
                far_layer_offset = position / 10;
                mid_layer_offset = position / 4;
            }
            if (position < 0) {
                position = 0;
                far_layer_offset = 0;
                mid_layer_offset = 0;
            }
        }
    }

    private void moveToStart() {
        far_layer_offset = (position -= 20) / 10;
        mid_layer_offset = position / 4;
        if (position <= 0) {
            position = 0;
            far_layer_offset = 0;
            mid_layer_offset = 0;
            scrollspeed = 0;
            isScrollingStart = false;
            MyWorld.onLevelStart = false;
            time_wait = 0;
        }
    }

    public void stop_scrolling() {
        this.isScrolling = false;
        if (!(!canScrollStart || MyWorld.onWin && MyWorld.onLost)) {
            canScrollStart = false;
        }
    }

    public void camera_scroll() {
        far_layer_offset = (position += scrollspeed) / 10;
        mid_layer_offset = position / 4;
        if (position < 0) {
            position = 0;
            far_layer_offset = 0;
            mid_layer_offset = 0;
            this.isScrolling = false;
        }
        if (position > level_size - Application.screenWidth) {
            position = level_size - Application.screenWidth;
            far_layer_offset = position / 10;
            mid_layer_offset = position / 4;
            this.isScrolling = false;
        }
    }

    public void start_scrolling(int x1, int x2) {
        if (Math.abs(x1 - x2) > 15) {
            this.isScrolling = true;
            scrollspeed = (x1 - x2) / 4;
            if (scrollspeed > 20) {
                scrollspeed = 20;
            }
            if (scrollspeed < -20) {
                scrollspeed = -20;
            }
        }
    }

    public void setTargetById(Panda target) {
        pObj = target;
        lastPandaX = Box2d.getCenterX(target.box2dId);
        position = Box2d.getX(target.box2dId) - Application.screenWidth / 2;
        far_layer_offset = position / 10;
        mid_layer_offset = position / 4;
        if (position < 0) {
            position = 0;
            far_layer_offset = 0;
            mid_layer_offset = 0;
        }
        if (position > level_size - Application.screenWidth) {
            position = level_size - Application.screenWidth;
            far_layer_offset = position / 10;
            mid_layer_offset = position / 4;
        }
    }

    public static void setTarget(PhysicalGameObject panda) {
        pObj = panda;
        PandaSeeker.mPS.target = (Panda)panda;
    }

    public boolean moveToEndSpeed(int sp) {
        scrollspeed = sp;
        far_layer_offset = (position += scrollspeed) / 10;
        mid_layer_offset = position / 4;
        if (position >= MyWorld.center - Application.screenWidth / 2) {
            position = MyWorld.center - Application.screenWidth / 2;
            far_layer_offset = position / 10;
            mid_layer_offset = position / 4;
            scrollspeed = 0;
            this.canScroll = false;
            return true;
        }
        return false;
    }

    public boolean moveToStartSpeed(int sp) {
        this.isScrolling = false;
        scrollspeed = sp;
        far_layer_offset = (position -= scrollspeed) / 10;
        mid_layer_offset = position / 4;
        if (position <= 0) {
            position = 0;
            far_layer_offset = 0;
            mid_layer_offset = 0;
            scrollspeed = 0;
            this.canScroll = false;
            return true;
        }
        return false;
    }
}

