#
#      BluePadServer.py
#
#      Copyright 2007 - 2008 	Joaquim Rocha <joaquimrocha1@gmail.com>   
#								Valerio Valerio <vdv100@gmail.com>
#						
#
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#


from gettext import textdomain, gettext as _
from threading import Thread
import bluetooth


import BluePadUinput
import BluePadApplet


class server_start:
	
	def __init__(self,bpa):
			self.client_sock = 0
			self.bpa = bpa
			BluePad_UUD = BluePadUinput.get_uinput_user_dev()
			BluePad_EVBITS = BluePadUinput.get_BluePad_EVBITS()
			uinput_dev = BluePadUinput.find_uinput()
			self.uinputInterface = BluePadUinput.start_uinput(uinput_dev,BluePad_UUD, BluePad_EVBITS)
			self.keyRelease = False
			self.mouseCounter = 0
			print "Server initialized"
			
			self.rcv_keys = receive_keys(self,self.bpa)
			self.rcv_keys.start()	
		
	
	
class receive_keys(Thread):
		
		
		"""
		Create the BluePad device.
		Open a l2cap server and client socket to accept communication 
		from the mobile phone.
		Process the keys send by the mobile phone.
		@param widget: Current widget
		@type widget: gtk widget
		"""
		def __init__(self,bps,bpa):
			
			Thread.__init__(self)
			self.bps = bps
			self.bpa = bpa
			print "Receive_keys Thread started"
			
		def run(self):
			
			try:
				
				uinput_dev = BluePadUinput.find_uinput()
				print uinput_dev
				server_sock=bluetooth.BluetoothSocket( bluetooth.L2CAP )
				port = 0x1001
				server_sock.bind(("",port))	
				server_sock.listen(1)	
				print _("Listening on port 1001")
				
				self.bps.client_sock,address = server_sock.accept()
				data = self.bps.client_sock.recv(1024)
				print data
				self.bpa.isConnect = True
				
				
				
				while data:
					
					data = self.bps.client_sock.recv(1024)
					print data
					value = str(data)
					key = 0
					
					
					if value == "-1":
						self.bps.client_sock.close()
						print "Connection closed by phone"
						BluePadUinput.destroy_uinput(self.bps.uinputInterface)
						self.bpa.isConnect = False
					
					else:
						
						try:
							
							key = int(value)
							BluePadUinput.uinput_sendkey(self.bps.uinputInterface,key)
						except(ValueError):
							process_keys(self.bps,value)
							print "Error: Is not a int"
							
					
			except bluetooth.BluetoothError:
					print _("Lost Connection.")
			self.bps.client_sock.close()
			
					
def process_keys(self,value):
		
		print "MouseCounter:"
		print self.mouseCounter
		 	
		if value == "released":
			
			self.mouseCounter = 0
			
		if value == "e":	# direita
	
			if self.mouseCounter in range(0,2):	
					
				BluePadUinput.uinput_mouse(self.uinputInterface,2,0)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,10,0)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,15,0)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,25,0)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,40,0)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"
			
		elif value == "w": # esquerda
			
					
				
			if self.mouseCounter in range(0,2):	
					
				BluePadUinput.uinput_mouse(self.uinputInterface,-2,0)
				self.mouseCounter+=1
			
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-10,0)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-15,0)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-25,0)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-40,0)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"
					
			
		elif value == "n": # north
		
					
			BluePadUinput.uinput_mouse(self.uinputInterface,0,-2)
			
			if self.mouseCounter in range(0,2):	
				
				BluePadUinput.uinput_mouse(self.uinputInterface,0,-2)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				#BluePadUinput.uinput_mouse(self.uinputInterface,0,-10)
				
				for n in range(1,10):
					BluePadUinput.uinput_mouse(self.uinputInterface,0,-1)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				#BluePadUinput.uinput_mouse(self.uinputInterface,0,-15)
				
				for n in range(1,15):
					BluePadUinput.uinput_mouse(self.uinputInterface,0,-1)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				#BluePadUinput.uinput_mouse(self.uinputInterface,0,-25)
				
				for n in range(1,25):
					BluePadUinput.uinput_mouse(self.uinputInterface,0,-1)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
				
				#BluePadUinput.uinput_mouse(self.uinputInterface,0,-40)
				
				for n in range(1,40):
					BluePadUinput.uinput_mouse(self.uinputInterface,0,-1)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"		
			
		elif value == "s": # south
			
					
			BluePadUinput.uinput_mouse(self.uinputInterface,0,2)
			
			if self.mouseCounter in range(0,2):	
					
				BluePadUinput.uinput_mouse(self.uinputInterface,0,2)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,0,10)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,0,15)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,0,25)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
			
				BluePadUinput.uinput_mouse(self.uinputInterface,0,40)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"		
			
		elif value == "sw":
			
			if self.mouseCounter in range(0,2):	
					
				BluePadUinput.uinput_mouse(self.uinputInterface,-2,2)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-10,10)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-15,15)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-25,25)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-40,40)
				self.mouseCounter+=1
				
			else :
				
				"ERRO"		
			
		elif value == "nw":
			
			if self.mouseCounter in range(0,2):	
					
				BluePadUinput.uinput_mouse(self.uinputInterface,-2,-2)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-10,-10)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-15,-15)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-25,-25)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,-40,-40)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"
			
		elif value == "se":
			
			if self.mouseCounter in range(0,2):	
					
				BluePadUinput.uinput_mouse(self.uinputInterface,2,2)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,10,10)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,15,15)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,25,25)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
			
				BluePadUinput.uinput_mouse(self.uinputInterface,40,40)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"
		elif value == "ne":
			
			
			if self.mouseCounter in range(0,2):	
				
				BluePadUinput.uinput_mouse(self.uinputInterface,2,-2)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(2,6) :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,10,-10)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(6,10)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,15,-15)
				self.mouseCounter+=1
				
			if self.mouseCounter in range(10,15)  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,25,-25)
				self.mouseCounter+=1
				
			if self.mouseCounter >= 15  :
				
				BluePadUinput.uinput_mouse(self.uinputInterface,40,-40)
				self.mouseCounter+=1
				
			else :
				
				"ERROR"
			
		elif value == "lb": # mouse left button
			print "mouse left button"
			key = 0x110
			BluePadUinput.uinput_sendkey(self.uinputInterface,key)
		
		elif value == "rb": # mouse right button
			key = 0x111
			BluePadUinput.uinput_sendkey(self.uinputInterface,key)
			print "mouse right button"
		
		else:
			
			print "ignored key"
			
def disconnect_by_pc(self):
	
	BluePadUinput.destroy_uinput(self.uinputInterface)
	
	self.client_sock.close()
	
	print "Connection close by computer"
				
	
