/*
 * Decompiled with CFR 0.152.
 */
package library;

import App.Main;
import common.JccFunction;
import common.JccObject;
import common.JccType;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.io.Connector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import library.BaseLibrary;
import library.lib_stdlib.jcc_System;
import library.lib_stdlib.jcc_Vector;
import runtime.JccVoid;

public class stdlib
extends BaseLibrary {
    JccFunction[] vFunc;
    Hashtable htFunc;
    Hashtable htObjects;
    Random rand;
    Calendar calendar;

    public JccObject getObject(String name) {
        return (JccObject)this.htObjects.get(name);
    }

    public JccObject createObject(int num) {
        switch (num) {
            case 0: {
                return new jcc_System();
            }
            case 1: {
                return new jcc_Vector();
            }
        }
        return null;
    }

    public String getName() {
        return "stdlib";
    }

    public String[] requires() {
        String[] req = new String[]{"corelib"};
        return req;
    }

    public String getFuncName(int iFunc) {
        return new String(this.vFunc[iFunc].name);
    }

    public void init(boolean bCompilation) {
        if (bCompilation) {
            this.htObjects = new Hashtable();
            jcc_System obj_System = new jcc_System();
            obj_System.iObject = 0;
            ((JccObject)obj_System).initCompileTime();
            this.htObjects.put("System", obj_System);
            jcc_Vector obj_Vector = new jcc_Vector();
            obj_Vector.iObject = 1;
            ((JccObject)obj_Vector).initCompileTime();
            this.htObjects.put("Vector", obj_Vector);
            this.vFunc = new JccFunction[17];
            this.htFunc = new Hashtable();
            JccFunction f_print = new JccFunction("print", JccType.TYPE_VOID, false);
            f_print.iFunc = 0;
            f_print.args = new JccType[1];
            f_print.args[0] = JccType.TYPE_STRING;
            this.vFunc[0] = f_print;
            this.htFunc.put(f_print.getSpec(), f_print);
            JccFunction f_yield = new JccFunction("yield", JccType.TYPE_VOID, false);
            f_yield.iFunc = 1;
            f_yield.args = new JccType[0];
            this.vFunc[1] = f_yield;
            this.htFunc.put(f_yield.getSpec(), f_yield);
            JccFunction f_sleep = new JccFunction("sleep", JccType.TYPE_VOID, false);
            f_sleep.iFunc = 2;
            f_sleep.args = new JccType[1];
            f_sleep.args[0] = JccType.TYPE_INT;
            this.vFunc[2] = f_sleep;
            this.htFunc.put(f_sleep.getSpec(), f_sleep);
            JccFunction f_currentTime = new JccFunction("currentTime", JccType.TYPE_INT, false);
            f_currentTime.iFunc = 3;
            f_currentTime.args = new JccType[0];
            this.vFunc[3] = f_currentTime;
            this.htFunc.put(f_currentTime.getSpec(), f_currentTime);
            JccFunction f_freeMemory = new JccFunction("freeMemory", JccType.TYPE_INT, false);
            f_freeMemory.iFunc = 4;
            f_freeMemory.args = new JccType[0];
            this.vFunc[4] = f_freeMemory;
            this.htFunc.put(f_freeMemory.getSpec(), f_freeMemory);
            JccFunction f_totalMemory = new JccFunction("totalMemory", JccType.TYPE_INT, false);
            f_totalMemory.iFunc = 5;
            f_totalMemory.args = new JccType[0];
            this.vFunc[5] = f_totalMemory;
            this.htFunc.put(f_totalMemory.getSpec(), f_totalMemory);
            JccFunction f_platformRequest = new JccFunction("platformRequest", JccType.TYPE_BOOL, false);
            f_platformRequest.iFunc = 6;
            f_platformRequest.args = new JccType[1];
            f_platformRequest.args[0] = JccType.TYPE_STRING;
            this.vFunc[6] = f_platformRequest;
            this.htFunc.put(f_platformRequest.getSpec(), f_platformRequest);
            JccFunction f_gc = new JccFunction("gc", JccType.TYPE_VOID, false);
            f_gc.iFunc = 7;
            f_gc.args = new JccType[0];
            this.vFunc[7] = f_gc;
            this.htFunc.put(f_gc.getSpec(), f_gc);
            JccFunction f_random = new JccFunction("random", JccType.TYPE_INT, false);
            f_random.iFunc = 8;
            f_random.args = new JccType[0];
            this.vFunc[8] = f_random;
            this.htFunc.put(f_random.getSpec(), f_random);
            JccFunction f_byteToStr = new JccFunction("byteToStr", JccType.TYPE_STRING, false);
            f_byteToStr.iFunc = 9;
            f_byteToStr.args = new JccType[1];
            f_byteToStr.args[0] = JccType.TYPE_BYTE_A;
            this.vFunc[9] = f_byteToStr;
            this.htFunc.put(f_byteToStr.getSpec(), f_byteToStr);
            JccFunction f_strStartsWith = new JccFunction("strStartsWith", JccType.TYPE_BOOL, false);
            f_strStartsWith.iFunc = 10;
            f_strStartsWith.args = new JccType[2];
            f_strStartsWith.args[0] = JccType.TYPE_STRING;
            f_strStartsWith.args[1] = JccType.TYPE_STRING;
            this.vFunc[10] = f_strStartsWith;
            this.htFunc.put(f_strStartsWith.getSpec(), f_strStartsWith);
            JccFunction f_strEndsWith = new JccFunction("strEndsWith", JccType.TYPE_BOOL, false);
            f_strEndsWith.iFunc = 11;
            f_strEndsWith.args = new JccType[2];
            f_strEndsWith.args[0] = JccType.TYPE_STRING;
            f_strEndsWith.args[1] = JccType.TYPE_STRING;
            this.vFunc[11] = f_strEndsWith;
            this.htFunc.put(f_strEndsWith.getSpec(), f_strEndsWith);
            JccFunction f_strGetBytes = new JccFunction("strGetBytes", JccType.TYPE_BYTE_A, false);
            f_strGetBytes.iFunc = 12;
            f_strGetBytes.args = new JccType[1];
            f_strGetBytes.args[0] = JccType.TYPE_STRING;
            this.vFunc[12] = f_strGetBytes;
            this.htFunc.put(f_strGetBytes.getSpec(), f_strGetBytes);
            JccFunction f_getTimeField = new JccFunction("getTimeField", JccType.TYPE_INT, false);
            f_getTimeField.iFunc = 13;
            f_getTimeField.args = new JccType[1];
            f_getTimeField.args[0] = JccType.TYPE_INT;
            this.vFunc[13] = f_getTimeField;
            this.htFunc.put(f_getTimeField.getSpec(), f_getTimeField);
            JccFunction f_getTimeString = new JccFunction("getTimeString", JccType.TYPE_STRING, false);
            f_getTimeString.iFunc = 14;
            f_getTimeString.args = new JccType[0];
            this.vFunc[14] = f_getTimeString;
            this.htFunc.put(f_getTimeString.getSpec(), f_getTimeString);
            JccFunction f_getProperty = new JccFunction("getProperty", JccType.TYPE_STRING, false);
            f_getProperty.iFunc = 15;
            f_getProperty.args = new JccType[1];
            f_getProperty.args[0] = JccType.TYPE_STRING;
            this.vFunc[15] = f_getProperty;
            this.htFunc.put(f_getProperty.getSpec(), f_getProperty);
            JccFunction f_sendSMS = new JccFunction("sendSMS", JccType.TYPE_VOID, false);
            f_sendSMS.iFunc = 16;
            f_sendSMS.args = new JccType[2];
            f_sendSMS.args[0] = JccType.TYPE_STRING;
            f_sendSMS.args[1] = JccType.TYPE_STRING;
            this.vFunc[16] = f_sendSMS;
            this.htFunc.put(f_sendSMS.getSpec(), f_sendSMS);
        } else {
            this.rand = new Random();
            this.calendar = Calendar.getInstance();
        }
    }

    public JccFunction getFunction(String name) {
        return (JccFunction)this.htFunc.get(name);
    }

    public Object callFunction(int num, Object[] arglist) throws Exception {
        switch (num) {
            case 0: {
                this.print((String)arglist[0]);
                Main.singleton.f.append((String)arglist[0]);
                return JccVoid.singleton;
            }
            case 1: {
                this.yield();
                return JccVoid.singleton;
            }
            case 2: {
                this.sleep((Integer)arglist[0]);
                return JccVoid.singleton;
            }
            case 3: {
                return new Integer(this.currentTime());
            }
            case 4: {
                return new Integer(this.freeMemory());
            }
            case 5: {
                return new Integer(this.totalMemory());
            }
            case 6: {
                boolean b = this.platformRequest((String)arglist[0]);
                if (b) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            case 7: {
                this.gc();
                return JccVoid.singleton;
            }
            case 8: {
                return new Integer(this.random());
            }
            case 9: {
                Object[] arr = (Object[])arglist[0];
                byte[] data = new byte[arr.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = ((Integer)arr[i]).byteValue();
                }
                return this.byteToStr(data);
            }
            case 10: {
                if (this.strStartsWith((String)arglist[0], (String)arglist[1])) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            case 11: {
                if (this.strEndsWith((String)arglist[0], (String)arglist[1])) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            case 12: {
                byte[] data = this.strGetBytes((String)arglist[0]);
                Integer[] oa = new Integer[data.length];
                for (int i = 0; i < oa.length; ++i) {
                    oa[i] = new Integer(data[i]);
                }
                return oa;
            }
            case 13: {
                return new Integer(this.getTimeField((Integer)arglist[0]));
            }
            case 14: {
                return this.getTimeString();
            }
            case 15: {
                return this.getProperty((String)arglist[0]);
            }
            case 16: {
                this.sendSMS((String)arglist[0], (String)arglist[1]);
                return JccVoid.singleton;
            }
        }
        return JccVoid.singleton;
    }

    public void print(String s) {
        System.out.println(s);
    }

    public void yield() {
        Thread.yield();
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int currentTime() {
        return (int)System.currentTimeMillis();
    }

    public int freeMemory() {
        return (int)Runtime.getRuntime().freeMemory();
    }

    public int totalMemory() {
        return (int)Runtime.getRuntime().totalMemory();
    }

    public boolean platformRequest(String s) {
        try {
            return Main.singleton.platformRequest(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void gc() {
        System.gc();
    }

    public int random() {
        return this.rand.nextInt();
    }

    public String byteToStr(byte[] arr) {
        return new String(arr);
    }

    public boolean strStartsWith(String s1, String s2) {
        return s1.startsWith(s2);
    }

    public boolean strEndsWith(String s1, String s2) {
        return s1.endsWith(s2);
    }

    public byte[] strGetBytes(String s) {
        return s.getBytes();
    }

    public int getTimeField(int fld) {
        return Calendar.getInstance().get(fld);
    }

    public String getTimeString() {
        return Calendar.getInstance().getTime().toString();
    }

    public String getProperty(String s) {
        return System.getProperty(s);
    }

    public void sendSMS(String number, String text) throws Exception {
        MessageConnection msc = (MessageConnection)Connector.open((String)("sms://" + number));
        TextMessage msg = (TextMessage)msc.newMessage("text");
        msg.setPayloadText(text);
        msc.send((Message)msg);
    }
}

