/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Displayable;
import mwnw.sg.CutScene;
import mwnw.sg.GameCanvas;
import mwnw.sg.Globals;
import mwnw.sg.Graphic;
import mwnw.sg.Map;
import mwnw.sg.Projectile;
import mwnw.sg.SoundPlayer;
import mwnw.sg.Trigger;

class Logic {
    private static final byte MAX_SCRIPT_SIZE = 48;
    private static final int LOGIC_ACCURACY_MS = 300;
    private static final int MAX_TRIGGERS = 4;
    private static final int SG_EFFECT_DISABLED = -2;
    private static final int SG_EFFECT_PRE_STARTING_UP = -1;
    private static final int SG_EFFECT_STARTING_UP = 0;
    private static final int SG_EFFECT_WAIT = 8;
    private static final int SG_POWER_DOWN = 9;
    private static final int SG_EFFECT_SIMPLE_MODE = 10;
    private static final int SG_EFFECT_WAITING_FOREVER = 11;
    private static final int SG_EFFECT_NEW = 12;
    private int sgMode = -2;
    private static final int SG_NEW_TYPE_DISABLED = 0;
    private static final int SG_NEW_TYPE_ACTIVATED = 1;
    private static final int SCRIPT_RESULT_CONTINUE = 0;
    private static final int SCRIPT_RESULT_ERROR = 1;
    private static final int SCRIPT_RESULT_EXIT = 2;
    public static final int KILL_ALL_SPAWN_KEYCARD = 0;
    public static final int KILL_ALL_DO_NOTHING = 1;
    public static final int KILL_ALL_RUN_SCRIPT = 2;
    private static final int SG_PRE_STARTUP_WAIT = 1500;
    private static final int SG_STARTUP_WAIT = 4000;
    private static final int SG_PASS_THROUGH_TIME = 6000;
    private static final int SG_SHOW_RESTART_MESSAGE = 4000;
    private static final int SG_LOCK_SET_DELAY_MS = 2800;
    private static final int STARGATE_ANIM_DELAY = 2;
    private static final int STARGATE_ANIM_DELAY_MS = 300;
    private static final int LOGIC_DEFAULT_MONSTERS_TO_KILL = 8;
    private static final int LOGIC_MONSTER_INDEX_SIZE = 2;
    private static final int LOGIC_GRAPHIC_SG_FRONT = 0;
    private static final int LOGIC_GRAPHIC_SG_BACK = 1;
    private static final int LOGIC_GRAPHIC_SG_BASE = 2;
    private static final int LOGIC_GRAPHIC_GUY = 3;
    private static final int LOGIC_GRAPHIC_GUY2 = 4;
    private static final int LOGIC_GRAPHIC_COUNT = 5;
    public boolean scriptRunning = false;
    private long exitTimer = 0L;
    private long sgTimer = 0L;
    public byte mission = 0;
    public byte gameMode = 0;
    public byte[] monsters = new byte[2];
    byte monstersToKill = 0;
    private String[] script = null;
    private Trigger[] triggers = null;
    private int scriptIndex = 0;
    private int scriptSize = 0;
    private byte activeTriggers = 0;
    private long timerThink = 0L;
    boolean ignoreLevelReinit = false;
    byte spawnOdds = 0;
    byte killAllBehavior = 0;
    byte stargateNewType = 0;
    int sgFrontIndex = 0;
    int sgBackIndex = 0;
    short forceSpawnX = 0;
    short forceSpawnY = 0;
    private Graphic[] graphic = new Graphic[5];

    Logic() {
    }

    public void Unload() {
        this.script = null;
        this.triggers = null;
        System.gc();
    }

    public void ResetTriggers() {
        if (this.triggers != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.triggers[i] == null) continue;
                this.triggers[i].Reset();
            }
        }
        this.activeTriggers = 0;
    }

    public void AddTrigger(byte by, int n, String string) {
        if (this.triggers == null) {
            this.triggers = new Trigger[4];
        }
        if (this.triggers[this.activeTriggers] == null) {
            this.triggers[this.activeTriggers] = new Trigger();
        }
        this.triggers[this.activeTriggers].type = by;
        this.triggers[this.activeTriggers].x = n;
        this.triggers[this.activeTriggers].text = string;
        this.triggers[this.activeTriggers].active = true;
        this.activeTriggers = (byte)(this.activeTriggers + 1);
    }

    public void ResetLevel() {
        Globals.KillGame();
        this.ResetTriggers();
        this.sgMode = -2;
        this.sgTimer = 0L;
        this.monstersToKill = (byte)8;
        this.spawnOdds = (byte)-2;
        this.killAllBehavior = 0;
        this.exitTimer = 0L;
        this.forceSpawnX = 0;
        this.forceSpawnY = 0;
        if (this.monsters != null) {
            for (int i = 0; i < 2; ++i) {
                this.monsters[i] = 127;
            }
        }
    }

    boolean RunScript() {
        this.scriptRunning = true;
        while (this.scriptIndex < this.scriptSize && this.script[this.scriptIndex] != null && this.script[this.scriptIndex] != "") {
            int n = this.ProcessNextLine();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this.scriptRunning = false;
                    return false;
                }
                case 2: {
                    this.scriptRunning = false;
                    return true;
                }
            }
        }
        GameCanvas gameCanvas = Globals.GetGameCanvas();
        Globals.ClearCommands((Displayable)gameCanvas);
        Globals.SetCommands(9, (Displayable)gameCanvas, gameCanvas);
        this.ResetLevel();
        gameCanvas.SetState((byte)9);
        SoundPlayer.playMidi(SoundPlayer.THEME2);
        this.scriptRunning = false;
        return true;
    }

    boolean InitNewGame(byte by) {
        Globals.runScriptASAP = false;
        this.ignoreLevelReinit = false;
        this.LoadScript(by);
        return this.RunScript();
    }

    boolean InitAndRunLevel(byte by) {
        Globals.GetGameCanvas().loading = true;
        Globals.GetGameCanvas().repaint();
        Globals.GetGameCanvas().serviceRepaints();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Globals.curMap != null) {
            Globals.curMap.Kill();
            Globals.curMap = null;
            System.gc();
        }
        Globals.curMap = new Map();
        try {
            Globals.curMap.Load(by);
        }
        catch (Exception exception) {
            Globals.curMap.Kill();
            Globals.curMap = null;
            System.gc();
            Globals.GetGameCanvas().resume();
            Globals.ShowError(exception.getMessage());
            return false;
        }
        Globals.GetGameCanvas().loading = false;
        return true;
    }

    public int ProcessNextLine() {
        String[] stringArray = this.SeparateCurrentLine();
        String string = stringArray[0];
        if (stringArray[0].compareTo("load") == 0) {
            Globals.GetGameCanvas().StartLoad(0);
            Globals.GetGameCanvas().SetState((byte)0);
            this.ResetLevel();
            this.ResetTriggers();
            int n = Integer.parseInt(stringArray[1]);
            if (!this.InitAndRunLevel((byte)n)) {
                Globals.GetGameCanvas().EndLoad();
                return 1;
            }
            Globals.GetGameCanvas().EndLoad();
        } else if (stringArray[0].compareTo("as") == 0) {
            int n;
            int n2;
            int n3 = Integer.parseInt(stringArray[1]);
            if (!this.BuildStargate(n3, n2 = Integer.parseInt(stringArray[2]), n = Integer.parseInt(stringArray[3]))) {
                return 1;
            }
            this.sgMode = 12;
        } else if (stringArray[0].compareTo("ae") == 0) {
            this.ActivateExistingStargate(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].compareTo("dm") == 0) {
            Globals.enemyMgr.Kill();
        } else if (stringArray[0].compareTo("ik") == 0) {
            Globals.cutScene.IgnoreKeysForAwhile(700);
        } else if (stringArray[0].compareTo("se") == 0) {
            Globals.enemyMgr.Init();
        } else {
            if (stringArray[0].compareTo("ac") == 0) {
                if (Globals.gameState != 8 && !this.ignoreLevelReinit && !Globals.InitGame()) {
                    return 1;
                }
                this.ignoreLevelReinit = false;
                Globals.ResetTime();
                Globals.thePlayer.ResetKeys();
                return 2;
            }
            if (stringArray[0].compareTo("mc") == 0) {
                this.monstersToKill = Byte.parseByte(stringArray[1]);
                Globals.enemyMgr.SetMonstersToKillCount(this.monstersToKill);
            } else if (stringArray[0].compareTo("cm") == 0) {
                int n = Integer.parseInt(stringArray[1]);
                if (n < 0 || n >= 2) {
                    // empty if block
                }
                this.monsters[n] = Byte.parseByte(stringArray[2]);
            } else if (stringArray[0].compareTo("ss") == 0) {
                if (Globals.projectileMgr != null) {
                    Globals.projectileMgr.KillProjectileByType((byte)2);
                }
                if (stringArray[1].compareTo("cut") == 0) {
                    Globals.GetGameCanvas().SetState((byte)8);
                } else if (stringArray[1].compareTo("ret") == 0) {
                    Globals.GetGameCanvas().SetState((byte)0);
                    this.ResetTriggers();
                    this.ignoreLevelReinit = true;
                }
            } else if (stringArray[0].compareTo("st") == 0) {
                int n = 0;
                if (stringArray.length == 3) {
                    n = Integer.parseInt(stringArray[2]);
                }
                if (Globals.cutScene == null) {
                    Globals.cutScene = new CutScene();
                }
                Globals.cutScene.SetText(stringArray[1], n);
            } else if (stringArray[0].compareTo("sk") == 0) {
                this.killAllBehavior = Byte.parseByte(stringArray[1]);
            } else if (stringArray[0].compareTo("sp") == 0) {
                short s = Short.parseShort(stringArray[1]);
                short s2 = Short.parseShort(stringArray[2]);
                Globals.curMap.SetPlayerStart(s, s2);
                Globals.thePlayer.SetXY(s, s2);
            } else if (stringArray[0].compareTo("sy") == 0) {
                if (Globals.cutScene == null) {
                    Globals.cutScene = new CutScene();
                }
                String string2 = null;
                if (stringArray.length == 3) {
                    string2 = stringArray[2];
                }
                Globals.cutScene.SetType(Byte.parseByte(stringArray[1]), string2);
            } else if (stringArray[0].compareTo("tr") == 0) {
                int n = Integer.parseInt(stringArray[2]);
                if (stringArray[1].compareTo("say") == 0) {
                    this.AddTrigger((byte)0, n, stringArray[3]);
                } else if (stringArray[1].compareTo("message") == 0) {
                    this.AddTrigger((byte)1, n, stringArray[3]);
                } else if (stringArray[1].compareTo("monsters") == 0) {
                    this.AddTrigger((byte)3, n, stringArray[3]);
                }
            } else if (stringArray[0].compareTo("sg") == 0 && !this.ScriptAddGuy(3, stringArray)) {
                return 1;
            }
        }
        return 0;
    }

    public String[] SeparateCurrentLine() {
        System.out.println("ParseLine: " + this.script[this.scriptIndex]);
        if (this.scriptIndex > 0) {
            this.script[this.scriptIndex - 1] = null;
        }
        int n = 0;
        int n2 = this.script[this.scriptIndex].indexOf("|", 0);
        while (n2 >= 0) {
            ++n;
            ++n2;
            n2 = this.script[this.scriptIndex].indexOf("|", n2);
        }
        String[] stringArray = new String[n + 1];
        int n3 = 0;
        n2 = this.script[this.scriptIndex].indexOf("|", 0);
        n = 0;
        while (n2 >= 0) {
            stringArray[n] = new String(this.script[this.scriptIndex].substring(n3, n2));
            n3 = n2 + 1;
            ++n;
            n2 = this.script[this.scriptIndex].indexOf("|", n3);
        }
        int n4 = this.script[this.scriptIndex].length();
        stringArray[n] = new String(this.script[this.scriptIndex].substring(n3, n4));
        ++this.scriptIndex;
        return stringArray;
    }

    public boolean AddGuy(int n, int n2, int n3, int n4, byte by, int n5) {
        this.graphic[n] = null;
        System.gc();
        this.graphic[n] = new Graphic();
        this.graphic[n].Load("/chars/" + n2 + ".png");
        int n6 = -1;
        if (by == 1) {
            n6 = Globals.projectileMgr.Add((byte)1, (byte)1, (byte)1, (short)n3, (short)n4, this.graphic[n]);
            if (n6 < 0) {
                return false;
            }
            Globals.projectileMgr.SetSpecial(n6, (byte)1);
        } else {
            n6 = Globals.projectileMgr.Add((byte)1, (byte)1, (byte)16, (short)n3, (short)n4, this.graphic[n]);
            if (n6 < 0) {
                return false;
            }
        }
        Globals.projectileMgr.SetDepthSortMod(n6, (short)n5);
        return true;
    }

    private boolean ScriptAddGuy(int n, String[] stringArray) {
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        byte by = Byte.parseByte(stringArray[4]);
        int n5 = Integer.parseInt(stringArray[5]);
        return this.AddGuy(n, n2, n3, n4, by, n5);
    }

    public boolean BuildStargate(int n, int n2, int n3) {
        Globals.buildStargate = true;
        if (this.graphic[0] == null) {
            this.graphic[0] = new Graphic();
            this.graphic[0].Load("/chars/gate_front.png");
            this.graphic[0].SetFrameInfo((byte)3, (byte)1);
        }
        if (this.graphic[1] == null) {
            this.graphic[1] = new Graphic();
            this.graphic[1].Load("/chars/gate_back.png");
            this.graphic[1].SetFrameInfo((byte)3, (byte)1);
        }
        if (this.graphic[2] == null) {
            this.graphic[2] = new Graphic();
            this.graphic[2].Load("/chars/gate_base.png");
        }
        this.stargateNewType = (byte)n3;
        int n4 = 0;
        n4 = Globals.projectileMgr.Add((byte)1, (byte)1, (byte)16, (short)n, (short)n2, this.graphic[2]);
        Globals.projectileMgr.SetDepthSortMod(n4, (short)-40);
        this.sgFrontIndex = Globals.projectileMgr.Add((byte)1, (byte)1, (byte)16, (short)(n - 8), (short)(n2 - 25), this.graphic[0]);
        Globals.projectileMgr.SetDepthSortMod(this.sgFrontIndex, (short)-9);
        Globals.projectileMgr.SetFrame(this.sgFrontIndex, (byte)4);
        this.sgBackIndex = Globals.projectileMgr.Add((byte)1, (byte)1, (byte)16, (short)(n + 7), (short)(n2 - 22), this.graphic[1]);
        Globals.projectileMgr.SetDepthSortMod(this.sgBackIndex, (short)5);
        Globals.projectileMgr.SetFrame(this.sgBackIndex, (byte)4);
        if (n3 == 1) {
            Globals.projectileMgr.Add((byte)1, (byte)1, (byte)15, (short)(n + 7), (short)(n2 - 25), null);
        }
        return true;
    }

    public void ActivateExistingStargate(int n, int n2) {
        this.stargateNewType = 1;
        Globals.projectileMgr.Add((byte)1, (byte)1, (byte)15, (short)(n + 7), (short)(n2 - 25), null);
    }

    public boolean ProcessStargateEffectNew() {
        this.sgTimer = Globals.GetTick() + 300L;
        if (this.stargateNewType == 1) {
            Projectile projectile = Globals.projectileMgr.projectiles[this.sgFrontIndex];
            Projectile projectile2 = Globals.projectileMgr.projectiles[this.sgBackIndex];
            projectile.curFrame = (byte)((projectile.curFrame + 1) % (projectile.graphic.framesX - 1));
            projectile2.curFrame = (byte)((projectile2.curFrame + 1) % (projectile2.graphic.framesX - 1));
        }
        if (this.exitTimer != 0L && this.exitTimer < Globals.GetTick()) {
            Globals.runScriptASAP = true;
            this.exitTimer = 0L;
        }
        return true;
    }

    public boolean ProcessStargateEffect() {
        if (this.sgTimer > Globals.GetTick()) {
            return true;
        }
        if (this.sgMode == 12) {
            return this.ProcessStargateEffectNew();
        }
        return false;
    }

    public boolean EnteredStargate() {
        Globals.thePlayer.controlLevel = (byte)2;
        if (this.sgMode == 11) {
            this.sgTimer = Globals.GetTick() + 6000L;
            this.sgMode = 9;
            SoundPlayer.playEffect(SoundPlayer.GOPEN);
        } else if (Globals.curMap.stargateTile == -1 && this.exitTimer == 0L) {
            SoundPlayer.playEffect(SoundPlayer.GOPEN);
            this.exitTimer = Globals.GetTick() + 2200L;
        }
        return true;
    }

    public boolean ProcessTrigger(int n) {
        switch (this.triggers[n].type) {
            case 0: {
                Globals.GetGameCanvas().SetMessage(this.triggers[n].text, 0);
                break;
            }
            case 1: {
                Globals.GetGameCanvas().SetStatusMessage(this.triggers[n].text, 0);
                break;
            }
            case 3: {
                Globals.enemyMgr.SetMonstersToKillCount(Byte.parseByte(this.triggers[n].text));
            }
        }
        this.triggers[n].active = false;
        return true;
    }

    public boolean LoadScript(byte by) {
        int n;
        int n2 = Globals.resources.downloadId * 3 + by;
        DataInputStream dataInputStream = null;
        InputStream inputStream = new Object().getClass().getResourceAsStream("/m" + n2 + ".txt");
        dataInputStream = new DataInputStream(inputStream);
        if (inputStream != null) {
            inputStream = null;
        }
        byte[] byArray = new byte[Short.MAX_VALUE];
        try {
            dataInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        this.script = new String[42];
        this.script[0] = "";
        int n3 = 0;
        char c = '\u0000';
        boolean bl = false;
        for (n = 0; n < byArray.length; ++n) {
            c = (char)byArray[n];
            if (c != '\r' && c != '\n' && c != '\u0000') {
                if (bl) continue;
                int n4 = n3;
                this.script[n4] = this.script[n4] + c;
                continue;
            }
            if (c == '\n') {
                bl = false;
                if (n + 1 < byArray.length) {
                    if ((char)byArray[n + 1] == '#') {
                        bl = true;
                    }
                } else {
                    this.script[++n3] = "";
                    break;
                }
                if (bl) continue;
                this.script[++n3] = "";
                continue;
            }
            if (c == '\u0000') break;
        }
        for (n = 0; n < this.script.length; ++n) {
            System.out.println(n + ":" + this.script[n]);
        }
        this.scriptSize = n3;
        this.scriptIndex = 0;
        return true;
    }

    boolean CheckTriggers() {
        boolean bl = true;
        for (int i = 0; i < this.activeTriggers; ++i) {
            if (!this.triggers[i].active || Globals.thePlayer.x < this.triggers[i].x || (bl = this.ProcessTrigger(i))) continue;
            return false;
        }
        return bl;
    }

    void Update() {
        boolean bl = true;
        if (this.sgMode != -2 && !(bl = this.ProcessStargateEffect())) {
            return;
        }
        if (this.timerThink < Globals.GetTick()) {
            this.timerThink = Globals.GetTick() + 300L;
            if (Globals.gameState == 0) {
                this.CheckTriggers();
            }
        }
    }
}

