/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mwnw.sg.Globals;

class SplashCanvas
extends Canvas
implements CommandListener {
    String line1;
    String line2;
    Timer timer;
    SplashTimer splashTimer;
    Timer dataTimer = null;
    UpdateTimer updateTimer = null;
    private long splashDelay = 3000L;
    private long startSplash = 0L;
    private boolean ended = false;
    private boolean downloading = false;
    private boolean doDownload = false;
    int nextImage = 1;
    private Image img = null;
    int frame = 0;
    byte nextState = (byte)2;

    public SplashCanvas(int n, boolean bl, byte by) {
        this.nextState = by;
        this.doDownload = false;
        this.Init(n);
    }

    public SplashCanvas() {
        this.Init(1);
    }

    private void Init(int n) {
        this.nextImage = n;
        Globals.screenWidth = (short)this.getWidth();
        Globals.screenHeight = (short)this.getHeight();
        Globals.screenCenterX = (short)(Globals.screenWidth / 2);
        Globals.screenCenterY = (short)(Globals.screenHeight / 2);
        this.setCommandListener(this);
        this.timer = new Timer();
        this.splashTimer = new SplashTimer();
        if (n == 5) {
            this.timer.schedule((TimerTask)this.splashTimer, 0L, 20L);
        } else {
            this.timer.schedule((TimerTask)this.splashTimer, 0L, 50L);
        }
        this.LoadNextImage();
    }

    private boolean LoadNextImage() {
        this.startSplash = 0L;
        if (this.nextImage > 4) {
            if (!this.ended) {
                this.EndSplash();
            }
            return false;
        }
        if (this.nextImage == 4) {
            if (this.dataTimer == null && this.updateTimer == null) {
                this.dataTimer = new Timer();
                this.updateTimer = new UpdateTimer();
                this.dataTimer.schedule((TimerTask)this.updateTimer, 1L);
            }
            Globals.enterInput = false;
        }
        try {
            if (this.nextImage > 0) {
                this.img = Image.createImage((String)("/splash" + this.nextImage + ".png"));
            } else {
                this.img = null;
                switch (this.nextImage) {
                    case 1: {
                        this.line1 = "SkyZone";
                        this.line2 = "Entertainment";
                        break;
                    }
                    case 2: {
                        this.line1 = "MachineWorks";
                        this.line2 = "Northwest, LLC";
                        break;
                    }
                    case 3: {
                        this.line1 = "";
                        this.line2 = "";
                    }
                }
            }
        }
        catch (IOException iOException) {
            Globals.ShowError(iOException.getMessage());
        }
        ++this.nextImage;
        return true;
    }

    public void pause() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void resume() {
        this.splashTimer = new SplashTimer();
        this.timer.schedule((TimerTask)this.splashTimer, 0L, 50L);
    }

    public void EndSplash() {
        this.ended = true;
        this.timer.cancel();
        this.timer = null;
        if (this.dataTimer != null) {
            this.dataTimer.cancel();
            this.dataTimer = null;
        }
        this.img = null;
        Globals.app.EndSplash(this.nextState);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (!this.ended && !this.downloading) {
            if (!Globals.enterInput) {
                return;
            }
            this.LoadNextImage();
        }
    }

    protected void keyPressed(int n) {
        if (n == -10) {
            return;
        }
        if (!this.ended && !this.downloading) {
            if (!Globals.enterInput) {
                return;
            }
            this.LoadNextImage();
        }
    }

    public void paint(Graphics graphics) {
        if (!this.ended) {
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            ++this.frame;
            graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
            if (this.nextImage > 3) {
                graphics.setColor(0, 0, 0);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRect(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
            int n = graphics.getFont().getHeight() + 9;
            if (this.img != null) {
                graphics.drawImage(this.img, Globals.screenWidth / 2 - this.img.getWidth() / 2, Globals.screenHeight / 2 - this.img.getHeight() / 2, 0);
            } else {
                graphics.setColor(255, 0, 0);
                graphics.drawString(this.line1, (int)Globals.screenCenterX, Globals.screenCenterY - n, 1 | 0x10);
                graphics.drawString(this.line2, (int)Globals.screenCenterX, (int)Globals.screenCenterY, 1 | 0x10);
            }
            graphics.setColor(255, 0, 0);
            String string = "Failed Download";
            graphics.drawString(Globals.errorString, (int)Globals.screenCenterX, Globals.screenHeight - n, 1 | 0x10);
            if (this.nextState == 23) {
                graphics.drawString(string, (int)Globals.screenCenterX, Globals.screenHeight - 46, 1 | 0x10);
            }
        }
    }

    class UpdateTimer
    extends TimerTask {
        boolean started = false;

        UpdateTimer() {
        }

        public final void run() {
            if (!this.started) {
                SplashCanvas.this.dataTimer.cancel();
                this.started = true;
                SplashCanvas.this.downloading = true;
                if (!Globals.resources.InitResources(SplashCanvas.this.doDownload) && SplashCanvas.this.doDownload) {
                    SplashCanvas.this.nextState = (byte)23;
                }
                if (SplashCanvas.this.doDownload) {
                    SplashCanvas.this.EndSplash();
                }
                SplashCanvas.this.downloading = false;
            }
        }
    }

    class SplashTimer
    extends TimerTask {
        SplashTimer() {
        }

        public final void run() {
            Globals.UpdateTime();
            long l = Globals.GetTick();
            if (SplashCanvas.this.startSplash == 0L) {
                SplashCanvas.this.startSplash = l;
            } else if (l - SplashCanvas.this.splashDelay > SplashCanvas.this.startSplash) {
                SplashCanvas.this.startSplash = l;
                SplashCanvas.this.LoadNextImage();
                return;
            }
            SplashCanvas.this.repaint();
        }
    }
}

