/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import mwnw.sg.Globals;
import mwnw.sg.Graphic;
import mwnw.sg.Point;
import mwnw.sg.Rect;
import mwnw.sg.Tile;

class Map {
    public static final byte LEVEL_TILE_NOT_ANIMATED = 1;
    public static final byte LEVEL_TILE_ANIMATED_FAST = 2;
    public static final byte LEVEL_TILE_ANIMATED_MEDIUM = 3;
    public static final byte LEVEL_TILE_ANIMATED_SLOW = 4;
    public static final byte MAX_COLLISION_RECTS = 10;
    public static final byte COLLISION_DEFAULT_SOFT = 0;
    public static final byte COLLISION_DEFAULT_HARD = 1;
    public static final byte SEAM_CHECK_SIZE = 50;
    public static final byte AUTO_SCROLL_MAX_AMOUNT = 16;
    public static final short AUTO_SCROLL_START_DELAY = 400;
    public static final byte AUTO_SCROLL_DISABLED = 0;
    public static final byte AUTO_SCROLL_NORMAL = 1;
    public static final byte TILE_NONE = -1;
    public byte mapId = (byte)-1;
    public short width;
    public short height;
    public short widthInTiles;
    public short heightInTiles;
    public Rect screenRect = new Rect(0, 0, Globals.screenWidth, Globals.screenHeight);
    public short startX;
    public short startY;
    byte numImages = 0;
    short numTiles = 0;
    Tile[] tiles = null;
    Graphic[] tileGfx = null;
    long animTimer = 0L;
    boolean animNextFrame = false;
    byte hardnessDefault = 0;
    int totalRects = 0;
    Rect[] rects = null;
    int numRects = 0;
    short monsterTopHardness;
    short playerTopHardness;
    short minPlayerY = 0;
    short maxPlayerY = 0;
    short minMonsterY = 0;
    short maxMonsterY = 0;
    public byte autoScrollMode = 0;
    short autoScrollMod = 0;
    long timerAutoScroll = 0L;
    boolean autoScrollTriggered = false;
    int stargateTile = -1;
    short mapTop;
    String mapTitle = "";
    String mapMessage = "";

    public void Kill() {
        int n;
        for (n = 0; n < this.tiles.length; ++n) {
            this.tiles[n] = null;
        }
        this.tiles = null;
        System.gc();
        for (n = 0; n < this.tileGfx.length; ++n) {
            if (this.tileGfx[n] != null) {
                this.tileGfx[n].Kill();
            }
            this.tileGfx[n] = null;
        }
        this.tileGfx = null;
        System.gc();
        for (n = 0; n < this.rects.length; ++n) {
            this.rects[n] = null;
        }
        this.rects = null;
        System.gc();
    }

    public void SetPlayerStart(short s, short s2) {
        this.startX = s;
        this.startY = s2;
    }

    public void Load(byte by) throws IOException {
        try {
            Object object;
            int n;
            this.mapId = by;
            this.startX = (short)16;
            this.startY = (short)160;
            Globals.thePlayer.haveKeycard = false;
            boolean bl = false;
            byte[] byArray = Globals.resources.LoadBytes("/lvl" + by + "/" + by + ".dat");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n2 = 0;
            String string = "";
            n2 = dataInputStream.readShort();
            string = "";
            for (n = 0; n < n2; ++n) {
                string = string + (char)dataInputStream.readByte();
            }
            this.mapTitle = string;
            n2 = dataInputStream.readShort();
            string = "";
            for (n = 0; n < n2; ++n) {
                string = string + (char)dataInputStream.readByte();
            }
            this.mapMessage = string;
            this.width = dataInputStream.readShort();
            this.height = dataInputStream.readShort();
            this.screenRect.x = dataInputStream.readShort();
            this.screenRect.y = dataInputStream.readShort();
            this.numImages = dataInputStream.readByte();
            this.numTiles = dataInputStream.readShort();
            this.tiles = new Tile[this.numTiles];
            for (n = 0; n < this.numTiles; ++n) {
                object = new Tile();
                ((Tile)object).gfxIndex = dataInputStream.readByte();
                ((Tile)object).x = dataInputStream.readShort();
                ((Tile)object).y = dataInputStream.readShort();
                ((Tile)object).w = dataInputStream.readByte();
                ((Tile)object).h = dataInputStream.readByte();
                if (((Tile)object).h < 0) {
                    ((Tile)object).h = (short)(((Tile)object).h + 256);
                }
                ((Tile)object).behavior = dataInputStream.readByte();
                ((Tile)object).frames = dataInputStream.readByte();
                ((Tile)object).frameWidth = dataInputStream.readByte();
                ((Tile)object).frameDelay = dataInputStream.readByte();
                ((Tile)object).curFrame = dataInputStream.readByte();
                ((Tile)object).frameSpeed = dataInputStream.readByte();
                ((Tile)object).frameFlag = dataInputStream.readByte();
                this.tiles[n] = object;
            }
            this.playerTopHardness = dataInputStream.readShort();
            this.monsterTopHardness = dataInputStream.readShort();
            this.numRects = dataInputStream.readShort();
            this.rects = new Rect[this.numRects];
            for (n = 0; n < this.numRects; ++n) {
                object = new Rect();
                ((Rect)object).x = dataInputStream.readShort();
                ((Rect)object).y = dataInputStream.readShort();
                ((Rect)object).w = dataInputStream.readShort();
                ((Rect)object).h = dataInputStream.readShort();
                this.rects[n] = object;
            }
            this.widthInTiles = (short)(this.width / 32);
            this.heightInTiles = (short)(this.height / 32);
            this.tileGfx = new Graphic[this.numImages];
            for (n = 0; n < this.numImages; n = (int)((byte)(n + 1))) {
                this.tileGfx[n] = new Graphic();
                this.tileGfx[n].Load("/lvl" + by + "/" + n + ".png");
            }
            block19: for (n = 0; n < this.numTiles; ++n) {
                object = this.tiles[n];
                if (object == null) continue;
                if (((Tile)object).frames > 1) {
                    if (this.tileGfx[((Tile)object).gfxIndex] == null) continue;
                    this.tileGfx[((Tile)object).gfxIndex].SetFrameInfo(((Tile)object).frames, (byte)1);
                    switch (((Tile)object).frameDelay) {
                        case 4: 
                        case 5: {
                            ((Tile)object).frameDelay = 1;
                            break;
                        }
                        case 6: 
                        case 7: {
                            ((Tile)object).frameDelay = (byte)2;
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            ((Tile)object).frameDelay = (byte)3;
                            break;
                        }
                        case 0: {
                            ((Tile)object).frameDelay = 1;
                        }
                    }
                    ((Tile)object).frameDelayCount = ((Tile)object).frameDelay;
                }
                switch (((Tile)object).behavior) {
                    case 99: {
                        ((Tile)object).visible = false;
                        continue block19;
                    }
                    case 16: {
                        this.stargateTile = n;
                        Globals.projectileMgr.Add((byte)1, (byte)1, (byte)15, (short)(((Tile)object).x + 15), (short)(((Tile)object).y - 8 + ((Tile)object).h), null);
                        continue block19;
                    }
                    case 6: {
                        this.startX = ((Tile)object).x;
                        this.startY = (short)(((Tile)object).y + ((Tile)object).h);
                        ((Tile)object).visible = false;
                        continue block19;
                    }
                    case 17: {
                        Globals.projectileMgr.Add((byte)1, (byte)1, (byte)16, (short)(((Tile)object).x + ((Tile)object).w / ((Tile)object).frames / 2), (short)(((Tile)object).y + ((Tile)object).h), this.tileGfx[((Tile)object).gfxIndex]);
                        ((Tile)object).visible = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            Globals.ShowError(exception.getMessage());
        }
    }

    public void DrawMap(Graphics graphics) {
        int n;
        if (this.animTimer < Globals.GetTick()) {
            this.animNextFrame = true;
            this.animTimer = Globals.GetTick() + 50L;
        } else {
            this.animNextFrame = false;
        }
        Object var2_2 = null;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        for (n = this.screenRect.y / 32; n <= (this.screenRect.y + Globals.screenHeight) / 32; ++n) {
            for (int i = this.screenRect.x / 32; i <= (this.screenRect.x + Globals.screenWidth) / 32; ++i) {
                n5 = i;
                if (n5 >= this.widthInTiles) {
                    n5 -= this.widthInTiles;
                }
                if ((n4 = n * this.widthInTiles + n5) >= this.numTiles) continue;
                Tile tile = this.tiles[n4];
                if (!tile.visible) continue;
                if (tile.frameDelay != 1 && this.animNextFrame) {
                    tile.frameDelayCount = (byte)(tile.frameDelayCount - 1);
                    if (tile.frameDelayCount < 1) {
                        tile.frameDelayCount = tile.frameDelay;
                        tile.curFrame = (byte)(tile.curFrame + 1);
                        tile.curFrame = this.stargateTile == n4 && this.mapId == 0 ? (byte)(tile.curFrame % (tile.frames - 1)) : (byte)(tile.curFrame % tile.frames);
                    }
                }
                if (n4 < 0) continue;
                s = tile.x;
                s2 = tile.y;
                s3 = tile.w;
                s4 = tile.h;
                n2 = s - this.screenRect.x;
                n3 = s2 - this.screenRect.y;
                if (tile.frames > 1) {
                    graphics.setClip(n2, n3, (int)tile.frameWidth, (int)tile.h);
                    graphics.drawImage(this.tileGfx[tile.gfxIndex].img, n2 - tile.curFrame * tile.frameWidth, n3, 0);
                    graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
                    continue;
                }
                graphics.drawImage(this.tileGfx[tile.gfxIndex].img, n2 - tile.curFrame * tile.frameWidth, n3, 0);
            }
        }
        for (n = this.widthInTiles * this.heightInTiles; n < this.numTiles; ++n) {
            Tile tile = this.tiles[n];
            if (!tile.visible) continue;
            if (tile.frameDelay != 1 && this.animNextFrame) {
                tile.frameDelayCount = (byte)(tile.frameDelayCount - 1);
                if (tile.frameDelayCount < 1) {
                    tile.frameDelayCount = tile.frameDelay;
                    tile.curFrame = (byte)(tile.curFrame + 1);
                    tile.curFrame = this.stargateTile == n && this.mapId == 0 ? (byte)(tile.curFrame % (tile.frames - 1)) : (byte)(tile.curFrame % tile.frames);
                }
            }
            if (n < 0) continue;
            s = tile.x;
            s2 = tile.y;
            s3 = tile.w;
            s4 = tile.h;
            n2 = s - this.screenRect.x;
            n3 = s2 - this.screenRect.y;
            if (tile.frames > 1) {
                graphics.setClip(n2, n3, (int)tile.frameWidth, (int)tile.h);
                graphics.drawImage(this.tileGfx[tile.gfxIndex].img, n2 - tile.curFrame * tile.frameWidth, n3, 0);
                graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
                continue;
            }
            graphics.drawImage(this.tileGfx[tile.gfxIndex].img, n2 - tile.curFrame * tile.frameWidth, n3, 0);
        }
    }

    boolean ValidPosition(short s, short s2) {
        if (s2 < this.monsterTopHardness) {
            return false;
        }
        if (s2 > this.height) {
            return false;
        }
        if (s < 0) {
            return false;
        }
        return s <= this.width;
    }

    public boolean ValidPositionAccurate(short s, short s2) {
        if (s2 < this.playerTopHardness) {
            return false;
        }
        if (s2 > this.height) {
            return false;
        }
        if (s < 0) {
            return false;
        }
        if (s > this.width) {
            return false;
        }
        if (this.hardnessDefault == 0) {
            for (int i = 0; i < this.rects.length; ++i) {
                if (!this.rects[i].Collide(s, s2)) continue;
                return false;
            }
        }
        return true;
    }

    boolean PositionIsOnScreen(short s, short s2, byte by) {
        return this.screenRect.Collide(s, s2, by, by);
    }

    short WorldToScreenX(short s) {
        return (short)(s - this.screenRect.x);
    }

    Point WorldToScreen(short s, short s2) {
        Point point = new Point();
        point.y = (short)(s2 - this.screenRect.y);
        point.x = (short)(s - this.screenRect.x);
        return point;
    }

    public void ModRenderPos(short s, short s2) {
        this.screenRect.x = (short)(this.screenRect.x + s);
        this.screenRect.y = (short)(this.screenRect.y + s2);
        this.CheckRenderPosBounds();
    }

    public void ScrollFollowXY(short s, short s2, short s3) {
        short s4 = (short)(s - Globals.screenCenterX);
        short s5 = (short)(s2 - Globals.screenCenterY);
        if (this.autoScrollMode == 1) {
            s4 = (short)(s4 - this.autoScrollMod);
        }
        if (this.screenRect.x < s4 - s3) {
            this.screenRect.x = (short)(s4 - s3);
        } else if (this.screenRect.x > s4 + s3) {
            this.screenRect.x = (short)(s4 + s3);
        }
        this.screenRect.y = s5;
        this.CheckRenderPosBounds();
    }

    private void CheckRenderPosBounds() {
        if (this.screenRect.y < this.mapTop) {
            this.screenRect.y = this.mapTop;
        }
        if (this.screenRect.y > this.height - Globals.screenHeight) {
            this.screenRect.y = (short)(this.height - Globals.screenHeight);
        }
        if (this.screenRect.x < 0) {
            this.screenRect.x = 0;
        }
        if (this.screenRect.x > this.width - Globals.screenWidth) {
            this.screenRect.x = (short)(this.width - Globals.screenWidth);
        }
    }

    public Point GetRandomPositionOffScreen() {
        Point point = new Point();
        point.x = Globals.RandShort(this.width);
        point.y = (short)(Globals.RandShort(this.height - (this.playerTopHardness + 20)) + (this.playerTopHardness - 10));
        if (!this.PositionIsOnScreen(point.x, point.y, (byte)15) && this.ValidPositionAccurate(point.x, point.y)) {
            return point;
        }
        return null;
    }

    void SetTileAnimation(short s, byte by) {
        this.tiles[s].frameDelay = by;
        this.tiles[s].frameDelayCount = by;
        if (by == 1) {
            this.tiles[s].curFrame = (byte)(this.tileGfx[this.tiles[s].gfxIndex].framesX - 1);
        }
    }

    byte GetTileAnimation(short s) {
        return this.tiles[s].frameDelay;
    }
}

