/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import app.GameAppState;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreen {
    short[] x;
    short[] y;
    short[] width;
    public byte id;
    byte elementsTxt;
    byte elementsImg;
    short xImg;
    short yImg;
    Image image;
    public String nextSplash;
    public boolean loadingMode;

    public SplashScreen(DataInputStream dis) {
        try {
            int i;
            this.elementsTxt = dis.readByte();
            this.elementsImg = dis.readByte();
            this.x = new short[this.elementsTxt];
            this.y = new short[this.elementsTxt];
            this.width = new short[this.elementsTxt];
            this.id = dis.readByte();
            for (i = 0; i < this.elementsTxt; ++i) {
                this.x[i] = (short)(dis.readShort() + GameAppState.SCREEN_DELTA_X);
                this.y[i] = (short)(dis.readShort() + GameAppState.SCREEN_DELTA_Y);
                this.width[i] = dis.readShort();
            }
            for (i = 0; i < this.elementsImg; ++i) {
                this.xImg = (short)(dis.readShort() + GameAppState.SCREEN_DELTA_X);
                this.yImg = (short)(dis.readShort() + GameAppState.SCREEN_DELTA_Y);
                this.image = Image.createImage((String)dis.readUTF());
            }
            this.nextSplash = dis.readUTF();
            if (this.nextSplash.compareTo("null") == 0) {
                this.nextSplash = null;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.loadingMode = false;
    }

    public SplashScreen(byte number) {
        this.id = number;
    }

    public void paint(Graphics g) {
        if (!this.loadingMode) {
            if (this.image != null) {
                g.drawImage(this.image, (int)this.xImg, (int)this.yImg, 0);
            }
            int elementsTxt = GameAppState.StrStory[GameAppState.language][this.id].length;
            for (int i = 0; i < elementsTxt; ++i) {
                GameAppState.drawText(GameAppState.StrStory[GameAppState.language][this.id][i], g, this.x[i], this.y[i], this.width[i], 10, 0);
            }
        } else {
            GameAppState.drawString(GameAppState.StrLoading[GameAppState.language], g, GameAppState.xPosition(500), GameAppState.yPosition(500), 1);
            this.loadingMode = false;
        }
    }
}

