/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Frame;
import engine.SpriteAnimation;
import engine.Tile;
import engine.TilesImage;
import java.io.DataInputStream;

public class SpriteAnimationSet {
    private SpriteAnimationSet[] spriteAnimationsSet;
    private int spriteAnimationsSetCount;
    public SpriteAnimation[] spriteAnimations;
    public int spriteAnimationsCount;
    private int animationsSetFramesCount;
    public TilesImage tilesImage;
    private Frame[] animationsSetFrames;

    public SpriteAnimationSet(DataInputStream disAnimationFrames, DataInputStream disAnimationDescription, SpriteAnimationSet[] spriteAnimationsSet) {
        try {
            int i;
            this.spriteAnimationsSet = spriteAnimationsSet;
            this.spriteAnimationsSetCount = this.spriteAnimationsSet == null ? 0 : this.spriteAnimationsSet.length;
            if (disAnimationFrames == null) {
                this.animationsSetFramesCount = 0;
                this.spriteAnimationsCount = 0;
                return;
            }
            Tile[] tiles = new Tile[disAnimationFrames.readShort()];
            for (i = 0; i < tiles.length; ++i) {
                tiles[i] = new Tile(disAnimationFrames.readShort(), disAnimationFrames.readShort(), disAnimationFrames.readShort(), disAnimationFrames.readShort());
                tiles[i].id = (short)i;
            }
            this.animationsSetFramesCount = disAnimationFrames.readShort();
            this.animationsSetFrames = new Frame[this.animationsSetFramesCount];
            for (i = 0; i < this.animationsSetFramesCount; ++i) {
                int tilesCount = disAnimationFrames.readShort();
                this.animationsSetFrames[i] = new Frame(tilesCount);
                for (int j = 0; j < tilesCount; ++j) {
                    this.animationsSetFrames[i].addTile(tiles[disAnimationFrames.readShort()], disAnimationFrames.readShort(), disAnimationFrames.readShort());
                }
            }
            disAnimationFrames.close();
            disAnimationFrames = null;
            this.spriteAnimationsCount = disAnimationDescription.readByte();
            this.spriteAnimations = new SpriteAnimation[this.spriteAnimationsCount];
            for (i = 0; i < this.spriteAnimationsCount; ++i) {
                this.spriteAnimations[i] = new SpriteAnimation(disAnimationDescription, this.animationsSetFrames, i);
            }
            block6: for (i = 0; i < this.spriteAnimationsCount; ++i) {
                for (int j = 0; j < this.spriteAnimationsCount; ++j) {
                    if (this.spriteAnimations[i].nextAnimationName.compareTo(this.spriteAnimations[j].animationName) != 0) continue;
                    this.spriteAnimations[i].nextAnimationId = this.spriteAnimations[j].animationId;
                    continue block6;
                }
            }
            disAnimationDescription.close();
            disAnimationDescription = null;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public SpriteAnimation returnSpriteAnimation(String name) {
        for (int i = 0; i < this.spriteAnimationsCount; ++i) {
            if (this.spriteAnimations[i].animationName.compareTo(name) != 0) continue;
            return this.spriteAnimations[i];
        }
        return null;
    }

    public SpriteAnimation returnSpriteAnimation(int id) {
        for (int i = 0; i < this.spriteAnimationsCount; ++i) {
            if (this.spriteAnimations[i].animationId != id) continue;
            return this.spriteAnimations[i];
        }
        return null;
    }

    public int returnSpriteAnimationID(String name) {
        for (int i = 0; i < this.spriteAnimationsCount; ++i) {
            if (this.spriteAnimations[i].animationName.compareTo(name) != 0) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.spriteAnimationsSet = null;
        this.spriteAnimations = null;
        this.animationsSetFrames = null;
    }
}

