/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MCanvas;
import game.MMidlet;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class Background
extends TiledLayer {
    MMidlet myMidlet;
    static int TILE_WIDTH = 24;
    static int TILE_HEIGHT = 24;
    static int mapColumns = 20;
    static int mapRows = 30;
    static int currentMission;
    static int[] layerMap;

    public Background() throws Exception {
        super(mapColumns, mapRows, Image.createImage((String)"/img/map.png"), TILE_WIDTH, TILE_HEIGHT);
        super.setPosition(0, 0);
    }

    public void setMissionMap(int mission) {
        try {
            ++mission;
            String textFileContent = "";
            boolean lineCounter = false;
            int missionCounter = 0;
            DataInputStream dis = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/data/background"));
            textFileContent = "";
            try {
                do {
                    textFileContent = dis.readUTF().trim();
                } while (mission != ++missionCounter);
            }
            catch (EOFException eof) {
                // empty catch block
            }
            char[] tmpMass = textFileContent.toCharArray();
            String tmpValue = "";
            int counter = 0;
            for (int i = 0; i < tmpMass.length; ++i) {
                if (tmpMass[i] != ',') {
                    tmpValue = tmpValue + String.valueOf(tmpMass[i]);
                    continue;
                }
                Background.layerMap[counter] = Integer.valueOf(tmpValue);
                ++counter;
                tmpValue = "";
            }
            tmpMass = null;
            System.gc();
            dis.close();
        }
        catch (IOException ioe) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430! " + ioe);
        }
    }

    void advance(int windowX, int windowY) {
        super.fillCells(0, 0, mapColumns, mapRows, 0);
        int startX = this.startColumnIndex(windowX);
        int startY = this.startRowIndex(windowY);
        int countDrawRows = this.getRow(MCanvas.DISP_HEIGHT, startY, windowY);
        int countDrawColumns = this.getColumn(MCanvas.DISP_WIDTH, startX, windowX);
        for (int i = startY; i < countDrawRows; ++i) {
            for (int j = startX; j < countDrawColumns; ++j) {
                int index = mapColumns * i + j;
                this.setCell(j, i, layerMap[index]);
            }
        }
    }

    public int getRow(int DISP_HEIGHT, int startY, int windowY) {
        if (startY + DISP_HEIGHT / TILE_HEIGHT + 3 < mapRows) {
            return startY + DISP_HEIGHT / TILE_HEIGHT + 3;
        }
        return mapRows;
    }

    public int getColumn(int DISP_WIDTH, int startX, int windowX) {
        if (startX + DISP_WIDTH / TILE_WIDTH + 3 < mapColumns) {
            return startX + DISP_WIDTH / TILE_WIDTH + 3;
        }
        return mapColumns;
    }

    public int startRowIndex(int windowY) {
        if (windowY / TILE_HEIGHT - 1 > 0) {
            return windowY / TILE_HEIGHT - 1;
        }
        return 0;
    }

    public int startColumnIndex(int windowX) {
        if (windowX / TILE_WIDTH - 1 > 0) {
            return windowX / TILE_WIDTH - 1;
        }
        return 0;
    }

    static {
        layerMap = new int[mapColumns * mapRows];
    }
}

