/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.TiledLayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private static final int INVERTED_AXES = 4;
    private static final int X_FLIP = 2;
    private static final int Y_FLIP = 1;
    private static final int ALPHA_BITMASK = -16777216;
    Image sourceImage;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int dRefX;
    int dRefY;
    int collisionRectX;
    int collisionRectY;
    int collisionRectWidth;
    int collisionRectHeight;
    int t_currentTransformation;

    public Sprite(Image image) {
        super(image.getWidth(), image.getHeight());
        this.initializeFrames(image, image.getWidth(), image.getHeight(), false);
        this.initCollisionRectBounds();
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        super(frameWidth, frameHeight);
        if (frameWidth < 1 || frameHeight < 1 || image.getWidth() % frameWidth != 0 || image.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(image, frameWidth, frameHeight, false);
        this.initCollisionRectBounds();
    }

    public Sprite(Sprite s) {
        super(s != null ? s.getWidth() : 0, s != null ? s.getHeight() : 0);
        if (s == null) {
            throw new NullPointerException();
        }
        this.sourceImage = Image.createImage((Image)s.sourceImage);
        this.numberFrames = s.numberFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        System.arraycopy(s.frameCoordsX, 0, this.frameCoordsX, 0, s.getRawFrameCount());
        System.arraycopy(s.frameCoordsY, 0, this.frameCoordsY, 0, s.getRawFrameCount());
        this.x = s.getX();
        this.y = s.getY();
        this.dRefX = s.dRefX;
        this.dRefY = s.dRefY;
        this.collisionRectX = s.collisionRectX;
        this.collisionRectY = s.collisionRectY;
        this.collisionRectWidth = s.collisionRectWidth;
        this.collisionRectHeight = s.collisionRectHeight;
        this.srcFrameWidth = s.srcFrameWidth;
        this.srcFrameHeight = s.srcFrameHeight;
        this.setVisible(s.isVisible());
        this.frameSequence = new int[s.getFrameSequenceLength()];
        this.setFrameSequence(s.frameSequence);
        this.setFrame(s.getFrame());
        this.setRefPixelPosition(s.getRefPixelX(), s.getRefPixelY());
    }

    public void defineReferencePixel(int x, int y) {
        this.dRefX = x;
        this.dRefY = y;
    }

    public void setRefPixelPosition(int x, int y) {
        this.x = x - this.dRefX;
        this.y = y - this.dRefY;
    }

    public int getRefPixelX() {
        return this.x + this.dRefX;
    }

    public int getRefPixelY() {
        return this.y + this.dRefY;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = sequenceIndex;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getRawFrameCount() {
        return this.numberFrames;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    public final void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            g.setClip(this.x, this.y, this.srcFrameWidth, this.srcFrameHeight);
            g.drawImage(this.sourceImage, this.x - this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.y - this.frameCoordsY[this.frameSequence[this.sequenceIndex]], 20);
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i = 0; i < this.numberFrames; ++i) {
                this.frameSequence[i] = i;
            }
            return;
        }
        if (sequence.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (sequence[i] >= 0 && sequence[i] < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[sequence.length];
        System.arraycopy(sequence, 0, this.frameSequence, 0, sequence.length);
        this.sequenceIndex = 0;
    }

    public void setImage(Image img, int frameWidth, int frameHeight) {
        if (frameWidth < 1 || frameHeight < 1 || img.getWidth() % frameWidth != 0 || img.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        int noOfFrames = img.getWidth() / frameWidth * (img.getHeight() / frameHeight);
        boolean maintainCurFrame = true;
        if (noOfFrames < this.numberFrames) {
            maintainCurFrame = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != frameWidth || this.srcFrameHeight != frameHeight) {
            int oldX = this.x + this.dRefX;
            int oldY = this.y + this.dRefY;
            this.setWidthImpl(frameWidth);
            this.setHeightImpl(frameHeight);
            this.initializeFrames(img, frameWidth, frameHeight, maintainCurFrame);
            this.initCollisionRectBounds();
            this.x = oldX - this.dRefX;
            this.y = oldY - this.dRefY;
        } else {
            this.initializeFrames(img, frameWidth, frameHeight, maintainCurFrame);
        }
    }

    public void defineCollisionRectangle(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.collisionRectX = x;
        this.collisionRectY = y;
        this.collisionRectWidth = width;
        this.collisionRectHeight = height;
    }

    public void setTransform(int transform) {
    }

    public final boolean collidesWith(Sprite s, boolean pixelLevel) {
        if (!s.visible || !this.visible) {
            return false;
        }
        int otherLeft = s.x + s.collisionRectX;
        int otherTop = s.y + s.collisionRectY;
        int otherRight = otherLeft + s.collisionRectWidth;
        int otherBottom = otherTop + s.collisionRectHeight;
        int left = this.x + this.collisionRectX;
        int top = this.y + this.collisionRectY;
        int right = left + this.collisionRectWidth;
        int bottom = top + this.collisionRectHeight;
        return this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom);
    }

    public final boolean collidesWith(TiledLayer t, boolean pixelLevel) {
        if (!t.visible || !this.visible) {
            return false;
        }
        int tLx1 = t.x;
        int tLy1 = t.y;
        int tLx2 = tLx1 + t.width;
        int tLy2 = tLy1 + t.height;
        int tW = t.cellWidth;
        int tH = t.cellHeight;
        int sx1 = this.x + this.collisionRectX;
        int sy1 = this.y + this.collisionRectY;
        int sx2 = sx1 + this.collisionRectWidth;
        int sy2 = sy1 + this.collisionRectHeight;
        int tNumCols = t.columns;
        int tNumRows = t.rows;
        if (!this.intersectRect(tLx1, tLy1, tLx2, tLy2, sx1, sy1, sx2, sy2)) {
            return false;
        }
        int startCol = sx1 <= tLx1 ? 0 : (sx1 - tLx1) / tW;
        int startRow = sy1 <= tLy1 ? 0 : (sy1 - tLy1) / tH;
        int endCol = sx2 < tLx2 ? (sx2 - 1 - tLx1) / tW : tNumCols - 1;
        int endRow = sy2 < tLy2 ? (sy2 - 1 - tLy1) / tH : tNumRows - 1;
        for (int row = startRow; row <= endRow; ++row) {
            for (int col = startCol; col <= endCol; ++col) {
                if (t.cellMatrix[row][col] == 0) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean collidesWith(Image image, int x, int y, boolean pixelLevel) {
        int bottom;
        int right;
        int top;
        int left;
        int otherBottom;
        if (!this.visible) {
            return false;
        }
        int otherLeft = x;
        int otherTop = y;
        int otherRight = x + image.getWidth();
        return this.intersectRect(otherLeft, otherTop, otherRight, otherBottom = y + image.getHeight(), left = this.x + this.collisionRectX, top = this.y + this.collisionRectY, right = left + this.collisionRectWidth, bottom = top + this.collisionRectHeight);
    }

    private void initializeFrames(Image image, int fWidth, int fHeight, boolean maintainCurFrame) {
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        int numHorizontalFrames = imageW / fWidth;
        int numVerticalFrames = imageH / fHeight;
        this.sourceImage = image;
        this.srcFrameWidth = fWidth;
        this.srcFrameHeight = fHeight;
        this.numberFrames = numHorizontalFrames * numVerticalFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!maintainCurFrame) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int currentFrame = 0;
        for (int yy = 0; yy < imageH; yy += fHeight) {
            for (int xx = 0; xx < imageW; xx += fWidth) {
                this.frameCoordsX[currentFrame] = xx;
                this.frameCoordsY[currentFrame] = yy;
                if (!this.customSequenceDefined) {
                    this.frameSequence[currentFrame] = currentFrame;
                }
                ++currentFrame;
            }
        }
    }

    private void initCollisionRectBounds() {
        this.collisionRectX = 0;
        this.collisionRectY = 0;
        this.collisionRectWidth = this.width;
        this.collisionRectHeight = this.height;
    }

    private boolean intersectRect(int r1x1, int r1y1, int r1x2, int r1y2, int r2x1, int r2y1, int r2x2, int r2y2) {
        return r2x1 < r1x2 && r2y1 < r1y2 && r2x2 > r1x1 && r2y2 > r1y1;
    }
}

