/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class VirtualKeyboard {
    VirtualKeyboardListener vkl;
    boolean debug = false;
    boolean enabled = true;
    boolean visible = true;
    int mCanvasWidth;
    int mCanvasHeight;
    int mDeltaX;
    int mDeltaY;
    int coverage;
    int xPressed = -1;
    int yPressed = -1;
    int xDragged = -1;
    int yDragged = -1;
    int xReleased = -1;
    int yReleased = -1;
    TouchBox currentTB = null;
    public static final int K_LSK = -6;
    public static final int K_RSK = -7;
    public static final int K_UP = -1;
    public static final int K_DOWN = -2;
    public static final int K_LEFT = -3;
    public static final int K_RIGHT = -4;
    public static final int K_OK = -5;
    static final int K_0 = 48;
    static final int K_1 = 49;
    static final int K_2 = 50;
    static final int K_3 = 51;
    static final int K_4 = 52;
    static final int K_5 = 53;
    static final int K_6 = 54;
    static final int K_7 = 55;
    static final int K_8 = 56;
    static final int K_9 = 57;
    public static final int K_STAR = 42;
    public static final int K_POUND = 35;
    static final int K_GAME1 = 0;
    static final int K_GAME2 = 0;
    static final int K_GAME3 = 0;
    static final int K_GAME4 = 0;
    static final int K_VOID = -999;
    public static final int MAP_DEFAULT = 0;
    public static final int MAP1 = 1;
    public static final int MAP2 = 2;
    public static final int MAP3 = 3;
    public static final int MAP4 = 4;
    public static final int MAP5 = 5;
    public static final int MAP6 = 6;
    public static final int MAP7 = 7;
    public static final int MAP8 = 8;
    public static final int MAP9 = 9;
    public static final int MAP_MAX_NUMBER = 10;
    int[] defaultMap = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};
    TouchBox[][] mBoxesSet = null;
    int currentSet;

    public VirtualKeyboard(VirtualKeyboardListener virtualKeyboardListener, int n, int n2) {
        this.vkl = virtualKeyboardListener;
        this.mCanvasWidth = n;
        this.mCanvasHeight = n2;
        this.mBoxesSet = new TouchBox[10][];
        this.coverage = 100;
        this.registerTouchBoxes(0, 3, this.coverage, this.defaultMap);
        this.currentSet = 0;
    }

    public int getCurrentSet() {
        return this.currentSet;
    }

    public boolean registerTouchBoxes(int n, TouchBox[] touchBoxArray) {
        if (n >= 10 || touchBoxArray == null) {
            return false;
        }
        this.mBoxesSet[n] = touchBoxArray;
        this.currentSet = n;
        return true;
    }

    public boolean registerTouchBoxes(int n, int n2, int n3, int[] nArray) {
        if (n >= 10) {
            return false;
        }
        TouchBox[] touchBoxArray = new TouchBox[nArray.length];
        this.coverage = n3;
        this.mDeltaX = this.mCanvasWidth / n2;
        this.mDeltaY = this.getHeight() / (nArray.length / n2);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n5 = i % n2;
            n4 = i / n2;
            touchBoxArray[i] = new TouchBox(n5 * this.mDeltaX, n4 * this.mDeltaY + this.mCanvasHeight - this.getHeight(), this.mDeltaX, this.mDeltaY, nArray[i], true);
            if (!this.debug) continue;
            System.out.println("Box[" + i + "]= " + touchBoxArray[i].x + "," + touchBoxArray[i].y + " : " + touchBoxArray[i].w + "," + touchBoxArray[i].h);
        }
        this.mBoxesSet[n] = touchBoxArray;
        this.currentSet = n;
        return true;
    }

    public boolean registerTouchBoxes(int n, int n2, int n3, int[] nArray, Image[] imageArray, Image[] imageArray2) {
        if (nArray.length < imageArray.length) {
            if (this.debug) {
                System.out.println("Keymap is shorter than Imagemap");
            }
            return false;
        }
        if (this.registerTouchBoxes(n, n2, n3, nArray)) {
            for (int i = 0; i < imageArray.length; ++i) {
                this.mBoxesSet[this.currentSet][i].img = imageArray[i];
                if (imageArray2 == null) continue;
                this.mBoxesSet[this.currentSet][i].img2 = imageArray2[i];
            }
            if (this.debug) {
                System.out.println("registerTouchBoxes(int set, int cols, int coverage, int[] keyMap, Image[] imgMap)");
            }
            return true;
        }
        return false;
    }

    boolean selectSet(int n) {
        if (n >= 10) {
            return false;
        }
        this.currentSet = n;
        return true;
    }

    public void activate() {
        this.enable();
        this.show();
    }

    public void deactivate() {
        this.disable();
        this.hide();
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void show() {
        this.visible = true;
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getHeight() {
        return this.mCanvasHeight * this.coverage / 100;
    }

    public int getYPos() {
        return this.mCanvasHeight - this.getHeight();
    }

    public void draw(Graphics graphics) {
        int n;
        if (this.debug) {
            for (n = 0; n < this.mBoxesSet[this.currentSet].length; ++n) {
                graphics.drawRect(this.mBoxesSet[this.currentSet][n].x, this.mBoxesSet[this.currentSet][n].y, this.mBoxesSet[this.currentSet][n].w, this.mBoxesSet[this.currentSet][n].h);
            }
        }
        if (this.visible) {
            for (n = 0; n < this.mBoxesSet[this.currentSet].length; ++n) {
                if (this.mBoxesSet[this.currentSet][n].img2 != null) {
                    if (this.currentTB == this.mBoxesSet[this.currentSet][n]) {
                        this.mBoxesSet[this.currentSet][n].draw2(graphics);
                        continue;
                    }
                    this.mBoxesSet[this.currentSet][n].draw(graphics);
                    continue;
                }
                this.mBoxesSet[this.currentSet][n].draw(graphics);
            }
        }
    }

    TouchBox getTouchBox(int n, int n2) {
        for (int i = 0; i < this.mBoxesSet[this.currentSet].length; ++i) {
            if (n < this.mBoxesSet[this.currentSet][i].x || n > this.mBoxesSet[this.currentSet][i].x + this.mBoxesSet[this.currentSet][i].w || n2 < this.mBoxesSet[this.currentSet][i].y || n2 > this.mBoxesSet[this.currentSet][i].y + this.mBoxesSet[this.currentSet][i].h || this.mBoxesSet[this.currentSet][i].key == 0) continue;
            return this.mBoxesSet[this.currentSet][i];
        }
        if (this.debug) {
            System.out.println("getTouchBox(" + n + "," + n2 + "): NONE");
        }
        return null;
    }

    public void run() {
    }

    public void pointerPressed(int n, int n2) {
        if (!this.enabled) {
            return;
        }
        this.xPressed = n;
        this.yPressed = n2;
        TouchBox touchBox = this.getTouchBox(n, n2);
        if (touchBox != null) {
            if (!touchBox.isKey) {
                this.vkl.virtualIdPressed(this.currentSet, touchBox.key);
                return;
            }
            if (touchBox != this.currentTB) {
                if (this.currentTB != null && this.currentTB.key != -999) {
                    this.vkl.virtualKeyReleased(this.currentTB.key);
                }
                if (touchBox.key != -999) {
                    this.currentTB = touchBox;
                }
                if (touchBox.key != -999) {
                    this.vkl.virtualKeyPressed(touchBox.key);
                }
            }
        } else if (this.currentTB != null) {
            if (this.currentTB.isKey) {
                this.vkl.virtualKeyReleased(this.currentTB.key);
            }
            this.currentTB = null;
        }
    }

    public void pointerDragged(int n, int n2) {
        if (!this.enabled) {
            return;
        }
        this.xDragged = n;
        this.yDragged = n2;
        TouchBox touchBox = this.getTouchBox(n, n2);
        if (touchBox != null) {
            if (touchBox != this.currentTB) {
                if (this.currentTB != null && this.currentTB.key != -999) {
                    this.vkl.virtualKeyReleased(this.currentTB.key);
                }
                this.currentTB = touchBox;
                if (touchBox.key != -999) {
                    this.vkl.virtualKeyPressed(touchBox.key);
                }
            }
        } else if (this.currentTB != null && this.currentTB.key != -999) {
            this.vkl.virtualKeyReleased(this.currentTB.key);
            this.currentTB = null;
        }
    }

    public void pointerReleased(int n, int n2) {
        if (!this.enabled) {
            return;
        }
        TouchBox touchBox = this.getTouchBox(n, n2);
        if (touchBox != null) {
            if (!touchBox.isKey) {
                this.vkl.virtualIdReleased(this.currentSet, touchBox.key);
            } else if (touchBox.key != -999) {
                this.vkl.virtualKeyReleased(touchBox.key);
            }
        }
        this.currentTB = null;
    }

    public void setListener(VirtualKeyboardListener virtualKeyboardListener) {
        this.vkl = virtualKeyboardListener;
    }

    class TouchBox {
        public int x;
        public int y;
        public int w;
        public int h;
        public int key;
        boolean isKey;
        Image img = null;
        Image img2 = null;

        TouchBox(int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.key = n5;
            this.isKey = bl;
        }

        TouchBox(int n, int n2, int n3, int n4, int n5, boolean bl, Image image) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.key = n5;
            this.isKey = bl;
            this.img = image;
            this.img2 = null;
        }

        TouchBox(int n, int n2, int n3, int n4, int n5, boolean bl, Image image, Image image2) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.key = n5;
            this.isKey = bl;
            this.img = image;
            this.img2 = image2;
        }

        public void draw(Graphics graphics) {
            if (this.img != null) {
                graphics.drawImage(this.img, this.x + (this.w >> 1) - (this.img.getWidth() >> 1), this.y + (this.h >> 1) - (this.img.getHeight() >> 1), 0);
            }
        }

        public void draw2(Graphics graphics) {
            if (this.img2 != null) {
                graphics.drawImage(this.img2, this.x + (this.w >> 1) - (this.img2.getWidth() >> 1), this.y + (this.h >> 1) - (this.img2.getHeight() >> 1), 0);
            }
        }
    }
}

