/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Actor;
import cc.jmap.games.BalanceMidlet;
import cc.jmap.games.Cloud;
import cc.jmap.games.GameEngine;
import cc.jmap.games.GameObject;
import cc.jmap.games.Hand;
import cc.jmap.games.I18NResource;
import cc.jmap.games.SoundPlayer;
import cc.jmap.games.Stick;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameLogic {
    public static final int SCREEN_HEIGHT = 680;
    public static final int SCREEN_WIDTH = 340;
    public static int score = 0;
    public static long now = 0L;
    public static int sensorValue = 0;
    public static int sensorValue2 = 0;
    public static double sensorAngle = 0.0;
    public static double[] ANGLES = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.833, 16.67, 17.5, 18.33, 19.17, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.25, 27.5, 28.75, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.25, 37.5, 38.75, 40.0, 41.0, 42.0, 43.0, 44.0, 46.0, 48.0, 50.0, 51.0, 53.0, 55.0, 57.0, 58.0, 60.0, 62.0, 64.0, 66.0, 70.0, 75.0, 80.0, 85.0, 90.0};
    public static double stickAngleOnScreen = 0.0;
    public static double stickAngleInReal = 0.0;
    public static long startTime = 0L;
    public static long pauseTime = 0L;
    public static GameLogic instance = null;
    public static final int STATE_GAME_GO_BFORE_PLAY = 0;
    public static final int STATE_GAME_PLAY = 1;
    public static final int STATE_GAME_PLAY_PAUSED = 2;
    public static final int STATE_GAME_ENDING = 3;
    public static final int STATE_GAME_END = 4;
    public static int state = 1;
    private static boolean goShown = false;
    public static int gameOverScore = 0;
    public static int gameOverH = 100;
    public static double stickAccInReal = 0.0;
    public static double stickVelInReal = 0.0;
    public static double gAccOnStick = 0.0;
    public static Random ran = new Random(System.currentTimeMillis());
    SoundPlayer player = null;
    Cloud cloud = null;
    Actor actor = null;
    Hand hand = null;
    Stick stick = null;
    private int oldState;
    private long goTimeStamp = 0L;
    private int goCount = 0;
    private int[] goIndexes;
    private int endingCount;

    public GameLogic() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        this.goIndexes = nArray;
        this.endingCount = 0;
        instance = this;
        this.cloud = new Cloud();
        this.actor = new Actor();
        this.hand = new Hand();
        this.stick = new Stick();
    }

    public static void setGameOverScore() {
        gameOverScore = score;
    }

    public static int getGameLevel() {
        if (score < 600) {
            return score / 150;
        }
        if (score < 1800) {
            return score / 100 - 2;
        }
        return 18;
    }

    public static double getMaxStickSpeed_fixed() {
        return 3.0;
    }

    public static double getMaxStickSpeed() {
        int level = GameLogic.getGameLevel();
        if (level < 1) {
            return 2.5;
        }
        if (level < 2) {
            return 2.6;
        }
        if (level < 4) {
            return 2.7;
        }
        if (level < 6) {
            return 2.8;
        }
        if (level < 8) {
            return 2.9;
        }
        if (level < 10) {
            return 3.0;
        }
        if (level < 12) {
            return 3.0;
        }
        if (level < 14) {
            return 3.1;
        }
        if (level < 15) {
            return 3.2;
        }
        if (level < 16) {
            return 3.3;
        }
        if (level < 17) {
            return 3.4;
        }
        if (level < 18) {
            return 3.5;
        }
        if (level < 19) {
            return 3.6;
        }
        return 3.7;
    }

    public static double getSlowFactor() {
        int level = GameLogic.getGameLevel();
        if (level < 2) {
            return 2.2;
        }
        if (level < 4) {
            return 1.8;
        }
        if (level < 6) {
            return 1.5;
        }
        if (level < 8) {
            return 1.0;
        }
        if (level < 10) {
            return 0.9;
        }
        if (level < 12) {
            return 0.8;
        }
        if (level < 16) {
            return 0.7;
        }
        if (level < 20) {
            return 0.6;
        }
        return 0.5;
    }

    public static void restartGame() {
        if (state == 4) {
            instance.GoToPlay();
            System.out.println("GmaeLogic restartGame()");
        }
    }

    public static void backToMenu() {
        if (state == 4 || state == 2) {
            BalanceMidlet.instance.gotoMain();
            System.out.println("GmaeLogic backToMenu()");
        }
    }

    public static void uploadScore() {
        BalanceMidlet.submitScore(gameOverScore);
    }

    public void pauseGame() {
        if (state == 1) {
            this.oldState = state;
            state = 2;
            SoundPlayer.pause();
            BalanceMidlet.engine.pauseEngine();
            GameEngine.repaint();
        }
    }

    public void resumeGame() {
        if (state == 2) {
            state = this.oldState;
            SoundPlayer.resume();
            BalanceMidlet.engine.resumeEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic resumeGame()");
        }
    }

    public void startGame() {
        if (goShown) {
            this.GoToPlay();
            return;
        }
        state = 0;
        goShown = true;
        GameEngine.repaint();
    }

    public void GoToPlay() {
        this.hand.reset();
        this.cloud.reset();
        this.stick.reset();
        this.actor.reset();
        pauseTime = 0L;
        sensorValue = 0;
        sensorValue2 = 0;
        sensorAngle = 0.0;
        stickAngleOnScreen = 0.0;
        stickAngleInReal = 0.0;
        this.endingCount = 0;
        gameOverScore = 0;
        score = 0;
        startTime = System.currentTimeMillis();
        state = 1;
        SoundPlayer.playFile(1);
        BalanceMidlet.instance.openSensor();
    }

    public void endingGame() {
        GameLogic.setGameOverScore();
        state = 3;
        SoundPlayer.playStop(1);
        SoundPlayer.playFile(2);
        BalanceMidlet.instance.closeSensor();
    }

    public void endGame() {
        state = 4;
    }

    public int getState() {
        return state;
    }

    public void initLevel() {
    }

    public void drawBackground(Graphics g, GameCanvas canvas) {
        Image bg0 = (Image)GameObject.bgImgVec.elementAt(0);
        g.drawImage(bg0, 0, 0, 20);
    }

    public void drawCloud(Graphics g, GameCanvas canvas) {
        this.cloud.render(g, canvas);
    }

    public void drawActor(Graphics g, GameCanvas canvas) {
        this.actor.render(g, canvas);
    }

    public void drawHand(Graphics g, GameCanvas canvas) {
        try {
            this.hand.render(g, canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawStick(Graphics g, GameCanvas canvas) {
        try {
            this.stick.render(g, canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawScore(Graphics g, GameCanvas canvas) {
        this.drawScore(g, canvas, 350, 20);
    }

    public void drawScore(Graphics g, GameCanvas canvas, int x, int y) {
        if (score < 0) {
            score = 0;
        }
        int sco = score;
        int W = 45;
        int DW = 20;
        System.out.println("sco: " + sco);
        if (sco >= 1000) {
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 180 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 135 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[10], x - 45 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else if (sco >= 100) {
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 135 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[10], x - 45 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else if (sco >= 10) {
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[10], x - 45 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else {
            g.drawImage(GameObject.scoreImgs[10], x - 45 - 20, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        }
    }

    public void drawDebug(Graphics g, GameCanvas canvas) {
        g.drawString("sensor2 raw:" + String.valueOf(sensorValue2), 10, 10, 0);
        g.drawString("sensor raw:" + String.valueOf(sensorValue), 10, 25, 0);
        g.drawString("sensor angle:" + String.valueOf(sensorAngle), 10, 40, 0);
        g.drawString("stick angle:" + String.valueOf(stickAngleOnScreen), 10, 55, 0);
        g.drawString("state:" + String.valueOf(state), 10, 70, 0);
        g.drawString("stick real v:" + String.valueOf(stickVelInReal), 10, 85, 0);
        g.drawString("cforce:" + String.valueOf(Cloud.getSpeedForce()), 10, 100, 0);
        g.drawString("a.state:" + String.valueOf(Actor.state), 10, 115, 0);
        g.drawString("c.targetS:" + String.valueOf(Cloud.nextTargetSpeed), 10, 130, 0);
        g.drawString("c.windS:" + String.valueOf(Cloud.windspeed), 10, 145, 0);
        g.drawString("starttime:" + String.valueOf(startTime), 10, 160, 0);
        g.drawString("pausetime:" + String.valueOf(pauseTime), 10, 175, 0);
    }

    public void drawSoundBtn(Graphics g, GameCanvas canvas) {
        g.drawImage(GameObject.iconImgs[4], 10, 10, 20);
        Image mimg = null;
        mimg = SoundPlayer.musicFlag ? GameObject.iconImgs[1] : GameObject.iconImgs[0];
        g.drawImage(mimg, 260, 70, 20);
        Image simg = null;
        simg = SoundPlayer.soundFlag ? GameObject.iconImgs[3] : GameObject.iconImgs[2];
        g.drawImage(simg, 310, 70, 20);
    }

    public void drawGameOverBtn(Graphics g, GameCanvas canvas) {
        Image aimg = GameObject.gameOverImgs[1];
        g.drawImage(aimg, 0, 640 - aimg.getHeight(), 20);
        aimg = GameObject.gameOverImgs[2];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 640 - aimg.getHeight(), 20);
        aimg = GameObject.gameOverImgs[3];
        g.drawImage(aimg, 360 - aimg.getWidth(), 640 - aimg.getHeight(), 20);
    }

    public void drawGameOver(Graphics g, GameCanvas canvas) {
        this.drawGameOverBtn(g, canvas);
        gameOverH = 40;
        Image aimg = GameObject.gameOverImgs[0];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, gameOverH, 20);
        aimg = (Image)GameObject.actorImgVec.elementAt(3);
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, gameOverH + 50, 20);
        aimg = GameObject.gameOverImgs[4];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, gameOverH + 340, 20);
        int x = 213;
        int XW = 25;
        int sco = gameOverScore;
        if (sco < 10) {
            x = 205;
        } else if (sco < 100) {
            x = 230;
        } else if (sco < 1000) {
            x = 255;
        } else if (sco < 10000) {
            x = 280;
        }
        this.drawScore(g, canvas, x, gameOverH + 340 + 40);
    }

    public void drawPause(Graphics g, GameCanvas canvas) {
        Image aimg = I18NResource.i18Imgs[8];
        System.out.println(g + "/" + canvas + "/" + aimg);
        if (aimg != null) {
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        }
    }

    public void drawGo(Graphics g, GameCanvas canvas) {
        if (now > this.goTimeStamp && this.goCount < 10) {
            this.goTimeStamp = now + 600L;
            ++this.goCount;
        }
        int index = this.goIndexes[this.goCount % this.goIndexes.length];
        Image aimg = GameObject.goImgs[index];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        aimg = I18NResource.i18Imgs[9];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 147, 20);
    }

    public void step() {
        now = System.currentTimeMillis();
        score = (int)((now - startTime) / 100L);
        if (score >= 9999) {
            score = 9999;
        }
        if (state == 1) {
            double vmax = GameLogic.getMaxStickSpeed();
            this.actor.step();
            this.hand.step();
            this.cloud.step();
            stickAccInReal = stickAngleInReal / 30.0;
            stickVelInReal = stickVelInReal + stickAccInReal + Cloud.getSpeedForce();
            if (stickVelInReal > vmax) {
                stickVelInReal = vmax;
            } else if (stickVelInReal < -1.0 * vmax) {
                stickVelInReal = -1.0 * vmax;
            }
            stickAngleOnScreen += stickVelInReal / GameLogic.getSlowFactor();
            if (stickAngleOnScreen > 70.0) {
                stickAngleOnScreen = 90.0;
                this.endingGame();
            } else if (stickAngleOnScreen < -70.0) {
                stickAngleOnScreen = -90.0;
                this.endingGame();
            }
            this.stick.setAngle(stickAngleOnScreen);
        }
    }

    public void setSensorValue(int value1_raw, int value2) {
        int LIMIT = 130;
        sensorValue2 = value2;
        sensorValue = value1_raw;
        double value = (double)value1_raw * (double)value1_raw / 60.0;
        double vidx = value * (1.0 + (double)value2 / 120.0);
        if (vidx > 130.0) {
            vidx = 130.0;
        }
        sensorAngle = value1_raw < 0 ? -1.0 * vidx : vidx;
        stickAngleInReal = 0.0 - sensorAngle;
    }

    public void paint(Graphics g, GameCanvas canvas) {
        now = System.currentTimeMillis();
        if (state == 4) {
            return;
        }
        if (state == 0) {
            this.drawBackground(g, canvas);
            this.drawGo(g, canvas);
            return;
        }
        if (state == 1) {
            this.step();
        }
        this.drawBackground(g, canvas);
        this.drawCloud(g, canvas);
        this.drawActor(g, canvas);
        if (state == 1) {
            this.drawStick(g, canvas);
            this.drawHand(g, canvas);
            this.drawScore(g, canvas);
            this.drawSoundBtn(g, canvas);
        } else if (state == 3) {
            if (this.endingCount++ > 15) {
                this.endGame();
                this.drawGameOver(g, canvas);
            }
            this.drawStick(g, canvas);
            this.drawHand(g, canvas);
            this.actor.step();
            this.hand.step();
            this.stick.step();
        }
        if (state == 2) {
            this.drawPause(g, canvas);
        }
    }
}

