/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Hand
extends GameObject {
    public double[] SIN_TABLE = new double[]{0.0, 0.052, 0.104, 0.156, 0.207, 0.258, 0.309, 0.358, 0.406, 0.453, 0.499, 0.544, 0.587, 0.629, 0.669, 0.707, 0.743, 0.777, 0.809, 0.838, 0.866, 0.891, 0.913, 0.933, 0.951, 0.965, 0.978, 0.987, 0.994, 0.998, 0.999, 0.998, 0.994, 0.987, 0.978, 0.965, 0.951, 0.933, 0.913, 0.891, 0.866, 0.838, 0.809, 0.777, 0.743, 0.707, 0.669, 0.629, 0.587, 0.544, 0.5, 0.453, 0.406, 0.358, 0.309, 0.258, 0.207, 0.156, 0.104, 0.052, 0.0, -0.05, -0.1, -0.15, -0.2, -0.25, -0.3, -0.35, -0.4, -0.45, -0.49, -0.54, -0.58, -0.62, -0.66, -0.7, -0.74, -0.77, -0.8, -0.83, -0.86, -0.89, -0.91, -0.93, -0.95, -0.96, -0.97, -0.98, -0.99, -0.99, -0.99, -0.99, -0.99, -0.98, -0.97, -0.96, -0.95, -0.93, -0.91, -0.89, -0.86, -0.83, -0.8, -0.77, -0.74, -0.7, -0.66, -0.62, -0.58, -0.54, -0.5, -0.45, -0.4, -0.35, -0.3, -0.25, -0.2, -0.15, -0.1, -0.05};
    public double[] COS_TABLE = new double[]{1.0, 0.99, 0.99, 0.98, 0.97, 0.96, 0.95, 0.93, 0.91, 0.89, 0.86, 0.83, 0.8, 0.77, 0.74, 0.7, 0.66, 0.62, 0.58, 0.54, 0.5, 0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0.02, -0.0, -0.1, -0.1, -0.2, -0.2, -0.3, -0.3, -0.4, -0.4, -0.4, -0.5, -0.5, -0.6, -0.6, -0.7, -0.7, -0.7, -0.8, -0.8, -0.8, -0.8, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.9, -0.8, -0.8, -0.8, -0.8, -0.7, -0.7, -0.7, -0.6, -0.6, -0.5, -0.5, -0.5, -0.4, -0.4, -0.3, -0.3, -0.2, -0.2, -0.1, -0.1, -0.0, 0.03, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.49, 0.54, 0.58, 0.62, 0.66, 0.7, 0.74, 0.77, 0.8, 0.83, 0.86, 0.89, 0.91, 0.93, 0.95, 0.96, 0.97, 0.98, 0.99, 0.99};
    private static final int RX = 180;
    private static final int RY = 617;
    private int index = 2;
    final int[] offset_x = new int[]{33, 33, 30, 33, 36};
    final int offset_y;
    private double angle = 0.0;
    private double angle_step = 3.0;
    private double angle_step_target = 3.0;
    private double angle_step_diff = 0.01;
    private double xaxis = 3.0;
    private double yaxis = 3.0;
    private double xaxis_target = 3.0;
    private double yaxis_target = 3.0;
    private double xaxis_diff = 0.01;
    private double yaxis_diff = 0.01;
    private int xoff = 0;
    private int yoff = 0;
    public static int pX = 180;
    public static int pY = 617;

    public Hand() {
        this.offset_y = 3;
    }

    void render(Graphics g, GameCanvas canvas) {
        Image img = (Image)GameObject.handImgVec.elementAt(this.index);
        g.drawImage(img, pX - this.offset_x[this.index], pY - 3, 20);
    }

    void reset() {
        pX = 180;
        pY = 617;
        this.angle = 0.0;
        this.angle_step = 3.0;
        this.angle_step_target = 3.0;
        this.angle_step_diff = 0.01;
        this.xaxis = 3.0;
        this.yaxis = 3.0;
        this.xaxis_target = 3.0;
        this.yaxis_target = 3.0;
        this.xaxis_diff = 0.01;
        this.yaxis_diff = 0.01;
        this.xoff = 0;
        this.yoff = 0;
    }

    void step() {
        int level;
        int tblidx;
        if (GameLogic.instance.getState() == 3) {
            pY += 10;
            return;
        }
        this.angle += this.angle_step;
        if (this.angle < 45.0) {
            this.index = 4;
        } else if (this.angle > 45.0 && this.angle < 135.0) {
            this.index = 2;
        } else if (this.angle > 135.0 && this.angle < 225.0) {
            this.index = 0;
        } else if (this.angle > 225.0 && this.angle < 315.0) {
            this.index = 2;
        } else if (this.angle > 315.0) {
            this.index = 4;
        }
        System.out.println(String.valueOf(this.angle) + "/" + this.index);
        if (this.angle > 360.0) {
            this.angle -= 360.0;
        }
        if ((tblidx = (int)(this.angle / 3.0 + 0.5)) > 119) {
            tblidx = 119;
        }
        if ((level = GameLogic.getGameLevel()) < 2) {
            this.xaxis_target = 5.0;
            this.yaxis_target = 3.0;
            this.xaxis_diff = 0.01;
            this.yaxis_diff = 0.01;
            this.angle_step_target = 4.0;
            this.angle_step_diff = 0.01;
        } else if (level < 4) {
            this.xaxis_target = 10.0;
            this.yaxis_target = 6.0;
            this.xaxis_diff = 0.01;
            this.yaxis_diff = 0.01;
            this.angle_step_target = 6.0;
            this.angle_step_diff = 0.01;
        } else if (level < 8) {
            this.xaxis_target = 20.0;
            this.yaxis_target = 9.0;
            this.xaxis_diff = 0.01;
            this.yaxis_diff = 0.01;
            this.angle_step_target = 8.0;
            this.angle_step_diff = 0.01;
        } else if (level < 12) {
            this.xaxis_target = 25.0;
            this.yaxis_target = 11.0;
            this.xaxis_diff = 0.01;
            this.yaxis_diff = 0.01;
            this.angle_step_target = 11.0;
            this.angle_step_diff = 0.01;
        }
        if (this.xaxis_target > this.xaxis) {
            this.xaxis += this.xaxis_diff;
        }
        if (this.yaxis_target > this.yaxis) {
            this.yaxis += this.yaxis_diff;
        }
        if (this.angle_step_target > this.angle_step) {
            this.xaxis += this.angle_step_diff;
        }
        this.xoff = (int)(this.xaxis * this.COS_TABLE[tblidx] + 0.5);
        this.yoff = (int)(this.yaxis * this.SIN_TABLE[tblidx] + 0.5);
        pX = 180 + this.xoff;
        pY = 617 + this.yoff;
    }
}

