/*
 * Decompiled with CFR 0.152.
 */
package org.json.me;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;

public class JSONArray {
    private Vector a;

    public JSONArray() {
        this.a = new Vector();
    }

    public JSONArray(JSONTokener jSONTokener) {
        this();
        if (jSONTokener.nextClean() != '[') {
            throw jSONTokener.syntaxError("A JSONArray text must start with '['");
        }
        if (jSONTokener.nextClean() == ']') {
            return;
        }
        jSONTokener.back();
        block4: while (true) {
            if (jSONTokener.nextClean() == ',') {
                jSONTokener.back();
                this.a.addElement(null);
            } else {
                jSONTokener.back();
                this.a.addElement(jSONTokener.nextValue());
            }
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == ']') {
                        return;
                    }
                    jSONTokener.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String string) {
        this(new JSONTokener(string));
    }

    public JSONArray(Vector vector) {
        if (vector == null) {
            this.a = new Vector();
            return;
        }
        int n = vector.size();
        this.a = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.a.addElement(vector.elementAt(i));
        }
    }

    public Object get(int n) {
        Object object = this.opt(n);
        if (object == null) {
            throw new JSONException("JSONArray[" + n + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int n) {
        Object object = this.get(n);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).toLowerCase().equals("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).toLowerCase().equals("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + n + "] is not a Boolean.");
    }

    public double getDouble(int n) {
        Object object = this.get(n);
        try {
            return Double.valueOf((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("JSONArray[" + n + "] is not a number.");
        }
    }

    public int getInt(int n) {
        this.get(n);
        return (int)this.getDouble(n);
    }

    public JSONArray getJSONArray(int n) {
        Object object = this.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + n + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int n) {
        Object object = this.get(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONArray[" + n + "] is not a JSONObject.");
    }

    public long getLong(int n) {
        this.get(n);
        return (long)this.getDouble(n);
    }

    public String getString(int n) {
        return this.get(n).toString();
    }

    public boolean isNull(int n) {
        return JSONObject.NULL.equals(this.opt(n));
    }

    public String join(String string) {
        int n = this.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(JSONObject.a(this.a.elementAt(i)));
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.a.size();
    }

    public Object opt(int n) {
        if (n < 0 || n >= this.length()) {
            return null;
        }
        return this.a.elementAt(n);
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(int n) {
        return this.optDouble(n, Double.NaN);
    }

    public double optDouble(int n, double d2) {
        try {
            return this.getDouble(n);
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public JSONArray optJSONArray(int n) {
        Object object = this.opt(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return null;
    }

    public JSONObject optJSONObject(int n) {
        Object object = this.opt(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return null;
    }

    public long optLong(int n) {
        return this.optLong(n, 0L);
    }

    public long optLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(int n) {
        return this.optString(n, "");
    }

    public String optString(int n, String string) {
        Object object = this.opt(n);
        if (object != null) {
            return object.toString();
        }
        return string;
    }

    public JSONArray put(boolean bl) {
        this.put(bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Vector vector) {
        this.put(new JSONArray(vector));
        return this;
    }

    public JSONArray put(double d2) {
        Double d3 = new Double(d2);
        JSONObject.a(d3);
        this.put(d3);
        return this;
    }

    public JSONArray put(int n) {
        this.put(new Integer(n));
        return this;
    }

    public JSONArray put(long l) {
        this.put(new Long(l));
        return this;
    }

    public JSONArray put(Object object) {
        this.a.addElement(object);
        return this;
    }

    public JSONArray put(int n, boolean bl) {
        this.put(n, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int n, Vector vector) {
        this.put(n, new JSONArray(vector));
        return this;
    }

    public JSONArray put(int n, double d2) {
        this.put(n, new Double(d2));
        return this;
    }

    public JSONArray put(int n, int n2) {
        this.put(n, new Integer(n2));
        return this;
    }

    public JSONArray put(int n, long l) {
        this.put(n, new Long(l));
        return this;
    }

    public JSONArray put(int n, Object object) {
        JSONObject.a(object);
        if (n < 0) {
            throw new JSONException("JSONArray[" + n + "] not found.");
        }
        if (n < this.length()) {
            this.a.setElementAt(object, n);
        } else {
            while (n != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(object);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONObject.put(jSONArray.getString(i), this.opt(i));
        }
        return jSONObject;
    }

    public String toString() {
        try {
            return "[" + this.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) {
        return this.a(n, 0);
    }

    final String a(int n, int n2) {
        int n3 = this.length();
        if (n3 == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        if (n3 == 1) {
            stringBuffer.append(JSONObject.a(this.a.elementAt(0), n, n2));
        } else {
            int n4;
            int n5 = n2 + n;
            stringBuffer.append('\n');
            for (n4 = 0; n4 < n3; ++n4) {
                if (n4 > 0) {
                    stringBuffer.append(",\n");
                }
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.a(this.a.elementAt(n4), n, n5));
            }
            stringBuffer.append('\n');
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean bl = false;
            int n = this.length();
            writer.write(91);
            for (int i = 0; i < n; ++i) {
                Object e2;
                if (bl) {
                    writer.write(44);
                }
                if ((e2 = this.a.elementAt(i)) instanceof JSONObject) {
                    ((JSONObject)e2).write(writer);
                } else if (e2 instanceof JSONArray) {
                    ((JSONArray)e2).write(writer);
                } else {
                    writer.write(JSONObject.a(e2));
                }
                bl = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

