/*
 * Decompiled with CFR 0.152.
 */
package com.wistrand.midlet.valentine;

import com.wistrand.midlet.fp.FP;
import com.wistrand.midlet.sprite.KeyListener;
import com.wistrand.midlet.sprite.Sprite;
import com.wistrand.midlet.sprite.SpriteCanvas;
import com.wistrand.midlet.valentine.BalloonSprite;
import com.wistrand.midlet.valentine.HeartSprite;
import com.wistrand.midlet.valentine.MultiStar;
import com.wistrand.midlet.valentine.Util;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Main
extends MIDlet
implements CommandListener,
KeyListener {
    SpriteCanvas canvas;
    private Command exitCommand = new Command("No love", 7, 99);
    private Command addCommand = new Command("Love", 1, 1);
    private Command runCommand = new Command("Play", 8, 1);
    private Command setupCommand = new Command("Setup", 2, 2);
    Display display;
    public static Main theMain;
    Form welcomeForm;
    Form setupForm;
    TextField userName;
    RecordStore rs;
    String name = "";
    ChoiceGroup colors;
    String color = Util.colors[0];
    static int ID_NAME;
    static int ID_COLOR;
    static String RS_NAME;
    int detailLevel = 1;
    int maxDetailLevel = 1;

    public Main() {
        theMain = this;
        this.display = Display.getDisplay((MIDlet)this);
        this.loadDb();
        if (this.color.equals("")) {
            this.color = Util.colors[0];
        }
        boolean bl = this.name.length() > 0;
        this.welcomeForm = new Form("Hi");
        this.setupForm = new Form("Setup");
        this.userName = new TextField(bl ? "Is that you again?" : "It's nice with a name?", this.name, 18, 0);
        this.setupForm.append((Item)this.userName);
        this.colors = new ChoiceGroup("Background", 1);
        int n = 0;
        while (n < Util.colors.length) {
            this.colors.append(Util.colors[n], null);
            if (Util.colors[n].equals(this.color)) {
                this.colors.setSelectedIndex(n / 2, true);
            }
            n += 2;
        }
        this.setupForm.append((Item)this.colors);
        this.setupForm.addCommand(this.runCommand);
        this.setupForm.setCommandListener((CommandListener)this);
        if (!bl) {
            Util.setName(Util.makeName());
        }
        this.welcomeForm.append((Item)new StringItem(bl ? "Is that you?" : Util.makeText(), this.name));
        this.welcomeForm.addCommand(this.runCommand);
        this.welcomeForm.addCommand(this.setupCommand);
        this.welcomeForm.setCommandListener((CommandListener)this);
        this.canvas = new SpriteCanvas(this.display, this);
        this.canvas.setCommandListener(this);
        this.canvas.setBgColor(0xFFFFFF);
        this.canvas.addCommand(this.exitCommand);
        this.canvas.addCommand(this.addCommand);
        int n2 = 0;
        while (n2 < 1) {
            this.addHeart();
            ++n2;
        }
    }

    void openDb() {
        try {
            if (this.rs == null) {
                this.rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
            }
            if (this.rs.getNumRecords() != 2) {
                byte[] byArray = "".getBytes();
                this.rs.closeRecordStore();
                RecordStore.deleteRecordStore((String)RS_NAME);
                this.rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
                this.rs.addRecord(byArray, 0, byArray.length);
                this.rs.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void loadDb() {
        this.openDb();
        try {
            this.name = new String(this.rs.getRecord(ID_NAME));
            this.color = new String(this.rs.getRecord(ID_COLOR));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void saveDb() {
        this.openDb();
        try {
            byte[] byArray = this.name.getBytes();
            byte[] byArray2 = this.color.getBytes();
            this.rs.setRecord(ID_NAME, byArray, 0, byArray.length);
            this.rs.setRecord(ID_COLOR, byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void addHeart() {
        int n = this.canvas.getWidth() / 2;
        int n2 = this.canvas.getHeight() / 2;
        this.canvas.add(new HeartSprite(this.canvas, n, n2));
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.runCommand) {
            this.name = this.userName.getString();
            int n = this.colors.getSelectedIndex();
            if (n != -1) {
                this.color = Util.colors[n * 2];
                this.canvas.setBgColor(Util.getColor(this.color));
            }
            String string = "";
            if (this.name.length() == 0) {
                this.name = Util.makeName();
                string = "I will call you " + this.name;
            } else {
                string = "Hi " + this.name;
            }
            Util.setName(this.name);
            this.saveDb();
            this.startHeart();
            BalloonSprite balloonSprite = new BalloonSprite(this.canvas, string, this.canvas.getWidth() / 2 << 8, this.canvas.getHeight() / 2 << 8);
            this.canvas.add(balloonSprite);
        } else if (command == this.setupCommand) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.setupForm);
        } else if (command == this.addCommand) {
            this.addHeart();
        } else if (command == this.exitCommand) {
            try {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void startHeart() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        this.canvas.start();
    }

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.welcomeForm);
    }

    public void pauseApp() {
        this.canvas.stop();
    }

    public void destroyApp(boolean bl) {
        this.saveDb();
        this.canvas.stop();
    }

    void exitRequested() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void keyPressed(int n, int n2) {
        switch (n2) {
            case 1: {
                Sprite sprite = (Sprite)this.canvas.sprites.elementAt(FP.rnd(0, this.canvas.sprites.size()));
                MultiStar multiStar = new MultiStar(this.canvas.bgColor, this.canvas);
                multiStar.setParent(sprite, 0, 0);
                this.canvas.addBefore(multiStar, sprite);
                break;
            }
            case 6: {
                Sprite sprite = (Sprite)this.canvas.sprites.elementAt(FP.rnd(0, this.canvas.sprites.size()));
                if (sprite instanceof BalloonSprite) {
                    ((BalloonSprite)sprite).setText(Util.makeText());
                    break;
                }
                BalloonSprite balloonSprite = new BalloonSprite(this.canvas, Util.makeText(), sprite.x, sprite.y);
                this.canvas.add(balloonSprite);
                break;
            }
            case 2: {
                this.canvas.clearSprites();
                this.addHeart();
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                break;
            }
        }
        switch (n) {
            case 53: {
                this.canvas.clearBgImage();
                this.color = Util.nextColor();
                this.canvas.bgColor = Util.getColor(this.color);
                break;
            }
            case 55: {
                this.canvas.bUseBgImage = !this.canvas.bUseBgImage;
                break;
            }
            case 49: {
                this.canvas.nShowInfo = (this.canvas.nShowInfo + 1) % (SpriteCanvas.MAXINFO + 1);
                break;
            }
            case 50: {
                this.detailLevel = (this.detailLevel + 1) % (this.maxDetailLevel + 1);
                break;
            }
        }
    }

    static {
        ID_NAME = 1;
        ID_COLOR = 2;
        RS_NAME = "info";
    }
}

