/*
 * Decompiled with CFR 0.152.
 */
package com.wistrand.midlet.valentine;

public class Wobbler {
    int max = 256;
    int delta = 0;
    int wobble = 0;
    int decay = 240;

    public Wobbler(int n, int n2) {
        this.max = n;
        this.decay = n2;
    }

    public void update() {
        if (!this.isActive()) {
            return;
        }
        this.delta = this.decay * this.delta >> 8;
        if (this.delta == 0) {
            this.wobble = 0;
        } else {
            this.wobble += this.delta;
            if (this.wobble > this.max) {
                this.wobble = this.max;
                this.delta = -this.delta;
            }
            if (this.wobble < -this.max) {
                this.wobble = -this.max;
                this.delta = -this.delta;
            }
        }
    }

    public void start(int n) {
        this.delta = n;
    }

    public void stop() {
        this.delta = 0;
    }

    public boolean isActive() {
        return this.delta != 0;
    }

    public int getValue() {
        return this.isActive() ? Math.abs(this.delta) * this.wobble >> 8 : 0;
    }
}

