/*
 * Decompiled with CFR 0.152.
 */
package com.wistrand.midlet.sprite;

import com.wistrand.midlet.sprite.KeyListener;
import com.wistrand.midlet.sprite.Sprite;
import com.wistrand.midlet.sprite.SpriteHandler;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteCanvas
extends Canvas
implements Runnable,
SpriteHandler {
    public Display display;
    public Vector sprites = new Vector();
    public int bgColor = 0xFFFFFF;
    boolean bRun = false;
    Thread runner = null;
    boolean bPaused = false;
    Image offImage = null;
    Graphics offGraphics = null;
    public Image bgImage = null;
    public Graphics bgGraphics = null;
    public boolean bUseBgImage = false;
    public int nShowInfo = 0;
    public static int MAXINFO = 2;
    public KeyListener kl;
    int bgX = 0;
    int bgY = 0;
    int bgStep = 10;
    long targetTime = 33L;
    long delay = 1L;
    long updateTime = 0L;
    long minDelay = 10L;

    public SpriteCanvas(Display display, KeyListener keyListener) {
        this.display = display;
        this.kl = keyListener;
    }

    protected void hideNotify() {
        this.bRun = false;
        this.offImage = null;
        this.offGraphics = null;
    }

    protected void showNotify() {
        if (this.offImage == null) {
            this.offImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.offGraphics = this.offImage.getGraphics();
        }
    }

    public void clearBgImage() {
        this.bUseBgImage = false;
        this.bgImage = null;
        this.bgGraphics = null;
    }

    void makeBgImage() {
        if (this.bgImage == null) {
            this.bgX = 0;
            this.bgY = 0;
            this.bgImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.bgGraphics = this.bgImage.getGraphics();
            this.paintBg(this.bgGraphics);
            this.bgStep = this.bgImage.getWidth() / 16;
        }
        int n = this.bgColor >> 16 & 0xFF;
        int n2 = this.bgColor >> 8 & 0xFF;
        int n3 = this.bgColor & 0xFF;
        if (this.bgY < this.bgImage.getHeight()) {
            int n4 = Math.min(255, 0 + 255 * this.bgX / this.bgImage.getWidth());
            int n5 = Math.min(255, 0 + 255 * this.bgY / this.bgImage.getHeight());
            int n6 = Math.min(255, n3 + this.bgColor & 0xFF);
            int n7 = n4 << 16 | n5 << 8 | n6;
            this.bgGraphics.setColor(n7);
            this.bgGraphics.fillRect(this.bgX, this.bgY, this.bgStep, this.bgStep);
            this.bgX += this.bgStep;
            if (this.bgX >= this.bgImage.getWidth()) {
                this.bgY += this.bgStep;
                this.bgX = 0;
            }
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (this.kl != null) {
            this.kl.keyPressed(n, n2);
        }
    }

    public void clearSprites() {
        this.sprites.setSize(0);
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public void togglePause() {
        this.bPaused = !this.bPaused;
    }

    public boolean isRunning() {
        return this.runner != null && this.bRun;
    }

    public void paint(Graphics graphics) {
        if (this.offImage != null && graphics != null) {
            graphics.drawImage(this.offImage, 0, 0, 20);
        }
    }

    private void paintAll(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.bUseBgImage) {
            this.makeBgImage();
            graphics.drawImage(this.bgImage, 0, 0, 20);
        } else {
            this.paintBg(graphics);
        }
        this.paintSprites(graphics);
        if (this.nShowInfo > 0) {
            this.paintInfo(graphics);
        }
    }

    void paintSprites(Graphics graphics) {
        int n = 0;
        while (n < this.sprites.size()) {
            Sprite sprite = (Sprite)this.sprites.elementAt(n);
            sprite.paint(graphics);
            ++n;
        }
    }

    void updateSprites() {
        int n = 0;
        while (n < this.sprites.size()) {
            Sprite sprite = (Sprite)this.sprites.elementAt(n);
            sprite.update();
            ++n;
        }
    }

    void paintBg(Graphics graphics) {
        if (graphics != null) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    void paintInfo(Graphics graphics) {
        graphics.setColor(this.bgColor ^ 0xFFFFFF);
        int n = 8;
        int n2 = 5;
        int n3 = 5;
        graphics.drawString("ms/frame: " + this.updateTime, n3, n2, 20);
        graphics.drawString("delay: " + this.delay, n3, n2 += n, 20);
        graphics.drawString("sprites: " + this.sprites.size(), n3, n2 += n, 20);
        n2 += n;
        if (this.nShowInfo > 1) {
            Runtime runtime = Runtime.getRuntime();
            graphics.drawString("free: " + runtime.freeMemory(), n3, n2, 20);
            graphics.drawString("total: " + runtime.totalMemory(), n3, n2 += n, 20);
            n2 += n;
        }
    }

    public void add(Sprite sprite) {
        this.sprites.addElement(sprite);
    }

    public void addAfter(Sprite sprite, Sprite sprite2) {
        int n = this.sprites.indexOf(sprite2);
        if (n != -1) {
            this.sprites.insertElementAt(sprite, n + 1);
        } else {
            this.add(sprite);
        }
    }

    public void addBefore(Sprite sprite, Sprite sprite2) {
        int n = this.sprites.indexOf(sprite2);
        if (n > 0) {
            this.sprites.insertElementAt(sprite, n - 1);
        } else {
            this.sprites.insertElementAt(sprite, 0);
        }
    }

    public void remove(Sprite sprite) {
        this.sprites.removeElement(sprite);
    }

    public void run() {
        while (this.bRun) {
            try {
                if (this.bPaused) {
                    Thread.sleep(500L);
                    continue;
                }
                long l = System.currentTimeMillis();
                Thread.sleep(this.delay);
                this.updateSprites();
                this.paintAll(this.offGraphics);
                this.repaint();
                this.serviceRepaints();
                this.updateTime = System.currentTimeMillis() - l;
                long l2 = this.targetTime - this.updateTime;
                this.delay = Math.max(this.minDelay, l2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stop() {
        this.bRun = false;
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.bRun = true;
            this.runner.start();
        }
    }
}

