/*
 * Decompiled with CFR 0.152.
 */
package map;

import game.GParam;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import map.Stage;

public class MapManager {
    private Stage stageMapObj;
    private Sprite forwardArrow;
    private short forwardHintCount = 0;
    private boolean forwardHint = false;
    private byte lengthInScreen = (byte)6;
    private short X_POS = 0;
    private boolean nextBlock_Lock;
    private boolean lastNB_Lock = this.nextBlock_Lock = false;
    private boolean backBlock_Lock;
    private boolean lastBB_Lock = this.backBlock_Lock = false;
    private Sprite[] bg_Spr;
    private byte[] bg_MapData;
    private boolean bg_Visible = true;
    private short bg_Y_POS = 0;
    private byte bg_X_Shift = 0;
    private Sprite[] mg1_MainSpr;
    private byte[] mg1_MainMapData;
    private boolean mg1_Visible = true;
    private short mg1_Y_POS = 0;
    private byte mg1_Y_Shift = 0;
    private Sprite[] mg2_MainSpr;
    private byte[] mg2_MainMapData;
    private boolean mg2_Visible = true;
    private short mg2_Y_POS = 0;
    private byte mg2_Y_Shift = 0;
    private byte mg_LastPixelLimit = (byte)5;
    private byte mg_X_Shift = 0;
    private byte mg_X_LastShift = (byte)-1;
    private short mg_LastCameraX = 0;
    private short mg_LockAbs = 0;
    private short mg_StartIndex = 0;
    private short mg_LastIndex = 0;
    private short mg_TileWidth = 0;
    private short mg_EventIndex = 0;
    private Vector[] mg_EventVct;
    private short mg_ActArea_X = 0;
    private short mg_ActArea_Z = 0;
    private short mg_ActArea_W = 0;
    private short mg_ActArea_H = 0;
    private Sprite[] fg_MainSpr;
    private byte[] fg_MapData;
    private boolean fg_Visible = true;
    private short fg_Y_POS = 0;
    private byte fg_X_Shift = 0;
    private short fg_StartIndex = 0;
    private short fg_TileWidth = 0;
    private short loopTemp = 0;

    public void initial() {
        this.X_POS = 0;
        this.lastNB_Lock = this.nextBlock_Lock = false;
        this.lastBB_Lock = this.backBlock_Lock = false;
        this.bg_Spr = null;
        this.bg_MapData = null;
        this.bg_Visible = true;
        this.bg_Y_POS = 0;
        this.bg_X_Shift = 0;
        this.mg1_MainSpr = null;
        this.mg1_MainMapData = null;
        this.mg1_Visible = true;
        this.mg1_Y_POS = 0;
        this.mg1_Y_Shift = 0;
        this.mg2_MainSpr = null;
        this.mg2_MainMapData = null;
        this.mg2_Visible = true;
        this.mg2_Y_POS = 0;
        this.mg2_Y_Shift = 0;
        this.mg_X_Shift = 0;
        this.mg_X_LastShift = (byte)-1;
        this.mg_LastCameraX = 0;
        this.mg_LockAbs = 0;
        this.mg_StartIndex = 0;
        this.mg_LastIndex = 0;
        this.mg_TileWidth = 0;
        this.mg_EventIndex = 0;
        this.mg_EventVct = null;
        this.mg_ActArea_X = 0;
        this.mg_ActArea_Z = 0;
        this.mg_ActArea_W = 0;
        this.mg_ActArea_H = 0;
        this.fg_MainSpr = null;
        this.fg_MapData = null;
        this.fg_Visible = true;
        this.fg_Y_POS = 0;
        this.fg_X_Shift = 0;
        this.fg_StartIndex = 0;
        this.fg_TileWidth = 0;
        this.loopTemp = 0;
    }

    public void preload(Stage stage) {
        try {
            this.stageMapObj = stage;
            this.bg_Spr = this.stageMapObj.getBG_Sprs();
            if (this.bg_Spr != null) {
                this.bg_MapData = this.stageMapObj.getBG_MapData();
                this.bg_Visible = true;
            } else {
                this.bg_Visible = false;
            }
            this.mg1_MainSpr = this.stageMapObj.getMG1_Sprs();
            if (this.mg1_MainSpr != null) {
                this.mg1_MainMapData = this.stageMapObj.getMG1_MapData();
                this.mg1_Visible = true;
            } else {
                this.mg1_Visible = false;
            }
            this.mg2_MainSpr = this.stageMapObj.getMG2_Sprs();
            if (this.mg2_MainSpr != null) {
                this.mg2_MainMapData = this.stageMapObj.getMG2_MapData();
                this.mg_TileWidth = (short)this.mg2_MainSpr[0].getWidth();
                this.mg2_Visible = true;
            } else {
                this.mg2_Visible = false;
            }
            this.fg_MainSpr = this.stageMapObj.getFG_Sprs();
            if (this.fg_MainSpr != null) {
                this.fg_MapData = this.stageMapObj.getFG_MapData();
                this.fg_TileWidth = (short)this.fg_MainSpr[0].getWidth();
                this.fg_Visible = true;
            } else {
                this.fg_Visible = false;
            }
            this.mg_EventVct = this.stageMapObj.getEvents();
            Image tempImg = Image.createImage((String)"/images/arrow_r.png");
            this.forwardArrow = new Sprite(tempImg);
        }
        catch (IOException e) {
            System.err.println("Failed loading images!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLayers_Y_POS(int b, int mg1, int mg2, int f) {
        this.bg_Y_POS = (short)b;
        this.mg1_Y_POS = (short)mg1;
        this.mg2_Y_POS = (short)mg2;
        this.fg_Y_POS = (short)f;
        this.forwardArrow.setPosition(this.X_POS + GParam.ForwardMark_POS[0], this.mg1_Y_POS + GParam.ForwardMark_POS[1]);
    }

    public void setActArea(int x, int z, int w, int h) {
        this.mg_ActArea_X = (short)x;
        this.mg_ActArea_Z = (short)z;
        this.mg_ActArea_W = (short)w;
        this.mg_ActArea_H = (short)h;
        if (w < 0) {
            this.mg_ActArea_W = 1;
        }
        if (h < 0) {
            this.mg_ActArea_H = 1;
        }
    }

    public short getActArea_L() {
        return this.mg_ActArea_X;
    }

    public short getActArea_U() {
        return this.mg_ActArea_Z;
    }

    public short getActArea_R() {
        return (short)(this.mg_ActArea_X + this.mg_ActArea_W);
    }

    public short getActArea_D() {
        return (short)(this.mg_ActArea_Z + this.mg_ActArea_H);
    }

    public void forward_Lock() {
        this.lastNB_Lock = this.nextBlock_Lock = true;
    }

    public void forward_unLock() {
        this.nextBlock_Lock = false;
    }

    public void backward_Lock() {
        this.lastBB_Lock = this.backBlock_Lock = true;
    }

    public void backward_unLock() {
        this.backBlock_Lock = false;
    }

    public int mapToMGIndex(int x) {
        int index = x / this.mg_TileWidth;
        if ((index -= 2) < 0) {
            index = 0;
        } else if (index > this.mg2_MainMapData.length - this.lengthInScreen) {
            index = this.mg2_MainMapData.length - this.lengthInScreen;
        }
        return index;
    }

    public int getMGShift(int x) {
        int offsetX = (240 - this.mg_TileWidth) / 2 - x;
        offsetX += this.mg_StartIndex * this.mg_TileWidth;
        offsetX = Math.max(Math.min(offsetX, 0), -this.mg_TileWidth);
        return offsetX;
    }

    public void goRoll(int pixel) {
        if (this.lastNB_Lock && !this.nextBlock_Lock) {
            if (this.mg_LockAbs == 0) {
                this.mg_LockAbs = (short)((240 + this.mg_TileWidth) / 2 + this.mg_StartIndex * this.mg_TileWidth);
            }
            if (this.mg_LockAbs >= pixel) {
                this.mg_LockAbs = (short)pixel;
                this.lastNB_Lock = this.nextBlock_Lock;
                this.mg_LockAbs = 0;
                this.moveCamera(pixel);
                this.mg_LastCameraX = (short)pixel;
            } else {
                this.moveCamera(this.mg_LockAbs);
                this.mg_LastCameraX = this.mg_LockAbs = (short)(this.mg_LockAbs + this.mg_LastPixelLimit);
            }
            this.forwardHint = true;
            this.forwardArrow.setVisible(true);
        } else if (this.lastBB_Lock && !this.backBlock_Lock) {
            if (this.mg_LockAbs == 0) {
                this.mg_LockAbs = (short)((240 - this.mg_TileWidth) / 2 + this.mg_StartIndex * this.mg_TileWidth);
            }
            if (this.mg_LockAbs <= pixel) {
                this.mg_LockAbs = (short)pixel;
                this.lastBB_Lock = this.backBlock_Lock;
                this.mg_LockAbs = 0;
                this.moveCamera(pixel);
                this.mg_LastCameraX = (short)pixel;
            } else {
                this.moveCamera(this.mg_LockAbs);
                this.mg_LastCameraX = this.mg_LockAbs = (short)(this.mg_LockAbs - this.mg_LastPixelLimit);
            }
        } else if (pixel != this.mg_LastCameraX) {
            if (Math.abs(pixel - this.mg_LastCameraX) > this.mg_LastPixelLimit && this.mg_LastCameraX != 0) {
                pixel = pixel - this.mg_LastCameraX >= 0 ? this.mg_LastCameraX + this.mg_LastPixelLimit : this.mg_LastCameraX - this.mg_LastPixelLimit;
            }
            this.moveCamera(pixel);
            this.mg_LastCameraX = (short)pixel;
        }
    }

    public void moveCamera(int pixel) {
        this.mg_StartIndex = (short)this.mapToMGIndex(pixel);
        if (this.nextBlock_Lock && this.mg_StartIndex > this.mg_LastIndex) {
            this.mg_StartIndex = this.mg_LastIndex;
        }
        if (this.backBlock_Lock && this.mg_StartIndex < this.mg_LastIndex) {
            this.mg_StartIndex = this.mg_LastIndex;
        }
        if (this.mg_StartIndex > this.mg_LastIndex) {
            this.BG_Roll_Proc(-3);
        } else if (this.mg_StartIndex < this.mg_LastIndex) {
            this.BG_Roll_Proc(3);
        }
        this.mg_LastIndex = this.mg_StartIndex;
        this.mg_X_Shift = (byte)this.getMGShift(pixel);
        if (this.mg_X_LastShift != this.mg_X_Shift) {
            this.FG_Roll_Proc(pixel);
            this.mg_X_LastShift = this.mg_X_Shift;
        }
    }

    public int virt2Scr_x(int x) {
        return x + this.mg_X_Shift - this.mg_StartIndex * this.mg_TileWidth;
    }

    public int scr_x2Virt(int x) {
        return x + this.mg_StartIndex * this.mg_TileWidth - this.mg_X_Shift;
    }

    public short getStartIndex() {
        return this.mg_StartIndex;
    }

    public byte getX_Shift() {
        return this.mg_X_Shift;
    }

    public short getTileWidth() {
        return this.mg_TileWidth;
    }

    public int mapToFGIndex(int x) {
        int index = x / this.fg_TileWidth;
        if ((index -= 2) < 0) {
            index = 0;
        } else if (index > this.fg_MapData.length - this.lengthInScreen) {
            index = this.fg_MapData.length - this.lengthInScreen;
        }
        return index;
    }

    public int getFGShift(int x) {
        int offsetX = (240 - this.fg_TileWidth) / 2 - x;
        offsetX += this.fg_StartIndex * this.fg_TileWidth;
        offsetX = Math.max(Math.min(offsetX, 0), -this.fg_TileWidth);
        return offsetX;
    }

    public void FG_Roll_Proc(int pixel) {
        if (this.fg_Visible) {
            short xTemp = (short)(pixel + pixel / 2);
            this.fg_StartIndex = (short)this.mapToFGIndex(xTemp);
            this.fg_X_Shift = (byte)this.getFGShift(xTemp);
        }
    }

    public void BG_Roll_Proc(int pixel) {
        if (this.bg_Visible) {
            this.bg_X_Shift = (byte)(this.bg_X_Shift + (byte)pixel);
            if (this.bg_X_Shift >= 0) {
                this.rotateRightArray(this.bg_MapData);
                this.bg_X_Shift = (byte)(this.bg_X_Shift - this.bg_Spr[0].getWidth());
            } else if (this.bg_X_Shift < -this.bg_Spr[0].getWidth()) {
                this.rotateLeftArray(this.bg_MapData);
                this.bg_X_Shift = (byte)(this.bg_X_Shift + this.bg_Spr[0].getWidth());
            }
        }
    }

    public void paintBG(Graphics g) {
        if (this.bg_Visible) {
            int i = 0;
            while (i < this.lengthInScreen) {
                if (i < this.bg_MapData.length && this.bg_MapData[i] >= 0) {
                    this.bg_Spr[this.bg_MapData[i]].setPosition(this.X_POS + this.bg_X_Shift + i * this.bg_Spr[this.bg_MapData[i]].getWidth(), (int)this.bg_Y_POS);
                    this.bg_Spr[this.bg_MapData[i]].paint(g);
                }
                ++i;
            }
        }
    }

    public void paintMG1(Graphics g) {
        if (this.mg1_Visible) {
            int i = 0;
            while (i < this.lengthInScreen) {
                this.loopTemp = (short)(i + this.mg_StartIndex);
                if (this.loopTemp < this.mg1_MainMapData.length && this.mg1_MainMapData[this.loopTemp] >= 0) {
                    this.mg1_MainSpr[this.mg1_MainMapData[this.loopTemp]].setPosition(this.X_POS + this.mg_X_Shift + i * this.mg1_MainSpr[this.mg1_MainMapData[this.loopTemp]].getWidth(), this.mg1_Y_POS + this.mg1_Y_Shift);
                    this.mg1_MainSpr[this.mg1_MainMapData[this.loopTemp]].paint(g);
                }
                ++i;
            }
        }
        if (this.forwardHint) {
            this.forwardArrow.paint(g);
            this.forwardHintCount = (short)(this.forwardHintCount + 1);
            if (this.forwardHintCount % 10 == 0) {
                this.forwardArrow.setVisible(!this.forwardArrow.isVisible());
                if (this.forwardHintCount >= 80) {
                    this.forwardHint = false;
                    this.forwardHintCount = 0;
                }
            }
        }
    }

    public void paintMG2(Graphics g) {
        if (this.mg2_Visible) {
            int i = 0;
            while (i < this.lengthInScreen) {
                this.loopTemp = (short)(this.mg_StartIndex + i);
                if (this.loopTemp < this.mg2_MainMapData.length && this.mg2_MainMapData[this.loopTemp] >= 0) {
                    this.mg2_MainSpr[this.mg2_MainMapData[this.loopTemp]].setPosition(this.X_POS + this.mg_X_Shift + i * this.mg2_MainSpr[this.mg2_MainMapData[this.loopTemp]].getWidth(), this.mg2_Y_POS + this.mg2_Y_Shift);
                    this.mg2_MainSpr[this.mg2_MainMapData[this.loopTemp]].paint(g);
                }
                ++i;
            }
        }
    }

    public void paintFG(Graphics g) {
        if (this.fg_Visible) {
            int i = 0;
            while (i < this.lengthInScreen) {
                this.loopTemp = (short)(i + this.fg_StartIndex);
                if (this.loopTemp < this.fg_MapData.length && this.fg_MapData[this.loopTemp] >= 0) {
                    this.fg_MainSpr[this.fg_MapData[this.loopTemp]].setPosition(this.X_POS + this.fg_X_Shift + i * this.fg_MainSpr[this.fg_MapData[this.loopTemp]].getWidth(), (int)this.fg_Y_POS);
                    this.fg_MainSpr[this.fg_MapData[this.loopTemp]].paint(g);
                }
                ++i;
            }
        }
    }

    public Vector getEvent(int index) {
        if (this.mg_StartIndex + index >= this.mg_EventVct.length) {
            return null;
        }
        return this.mg_EventVct[this.mg_StartIndex + index];
    }

    public void rotateLeftArray(byte[] data) {
        int i = data.length - 1;
        while (i > 0) {
            data[0] = (byte)(data[0] + data[i]);
            data[i] = (byte)(data[0] - data[i]);
            data[0] = (byte)(data[0] - data[i]);
            --i;
        }
    }

    public void rotateRightArray(byte[] data) {
        int i = 0;
        while (i < data.length - 1) {
            int n = i;
            data[n] = (byte)(data[n] + data[data.length - 1]);
            data[data.length - 1] = (byte)(data[i] - data[data.length - 1]);
            int n2 = i++;
            data[n2] = (byte)(data[n2] - data[data.length - 1]);
        }
    }
}

