/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GameWorld
implements Constants {
    private Engine engine;
    private int score;
    private int[] snake;
    private int snakeLength;
    private int growCounter;
    private int prevDX;
    private int prevDY;
    private int foodX;
    private int foodY;
    private int state;
    private static final int GS_READY = -1;
    private static final int GS_PLAYING = 0;
    private static final int GS_GAMEOVER = 1;
    private static final int GS_COMPLETE = 2;
    private static final int ENTRY = 2;
    private static final int BLOCK_SIZE = 4;
    private static final int SNAKE_GROW = 8;
    private static final int SNAKE_WIDTH = 60;
    private static final int SNAKE_HEIGHT = 80;

    public GameWorld(Engine engine) {
        this.engine = engine;
        this.resetSnake();
    }

    private void resetSnake() {
        this.snake = new int[9600];
        this.snakeLength = 2;
        this.snake[1] = 30;
        this.snake[0] = 8;
        this.prevDX = -1;
        this.prevDY = 0;
        this.growCounter = 8;
        this.score = 0;
        this.placeFood();
        Engine.resetKeyBuffers();
        this.state = -1;
    }

    public void paint(Graphics graphics) {
        Engine.cls(graphics, 0);
        graphics.setColor(0xFFFFFF);
        int n = this.snakeLength;
        while (n != 0) {
            int n2 = this.snake[--n] * 4;
            int n3 = this.snake[--n] * 4;
            graphics.fillRect(n2, n3, 4, 4);
        }
        graphics.setColor(0xFF0000);
        graphics.fillRect(this.foodX * 4, this.foodY * 4, 4, 4);
        if (this.state != 0) {
            graphics.setColor(255);
            graphics.fillRect(0, 160 - (FontMgr.charHeight[1] >> 1) - 2, 240, (FontMgr.charHeight[1] << 1) + 4);
            graphics.setColor(0xFFFFFF);
            FontMgr.drawString(1, graphics, this.state == 1 ? "GAME OVER" : (this.state == -1 ? Engine.text[37] : "COMPLETE"), 120, 160 - (FontMgr.charHeight[1] >> 1), 17);
            FontMgr.drawString(1, graphics, "Score: " + this.score, 120, 160 + (FontMgr.charHeight[1] >> 1), 17);
        }
    }

    public void tick() {
        if (this.state != 0) {
            if (Engine.hasAnyKeyPressed()) {
                if (this.state == -1) {
                    if (Demo.isEnabled()) {
                        Engine.initDemoTimer(30);
                    }
                    this.state = 0;
                } else {
                    Engine.state = 40;
                }
            }
            return;
        }
        if (Demo.isEnabled() && Engine.tickDemoTimer()) {
            Engine.state = 40;
            return;
        }
        if (this.growCounter > 0) {
            --this.growCounter;
            this.snakeLength += 2;
            if (this.snakeLength >= this.snake.length) {
                Engine.resetKeyBuffers();
                this.state = 2;
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        if (this.prevDX != 1 && Engine.key(4)) {
            n = -1;
        } else if (this.prevDX != -1 && Engine.key(8)) {
            n = 1;
        } else if (this.prevDY != 1 && Engine.key(1)) {
            n2 = -1;
        } else if (this.prevDY != -1 && Engine.key(2)) {
            n2 = 1;
        }
        System.arraycopy(this.snake, 0, this.snake, 2, this.snakeLength - 2);
        if (n == 0 && n2 == 0) {
            n = this.prevDX;
            n2 = this.prevDY;
        } else {
            this.prevDX = n;
            this.prevDY = n2;
        }
        int n3 = this.snake[3] + n;
        int n4 = this.snake[2] + n2;
        if (n3 < 0) {
            n3 = 59;
        } else if (n3 > 59) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 79;
        } else if (n4 > 79) {
            n4 = 0;
        }
        this.snake[1] = n3;
        this.snake[0] = n4;
        if (n3 == this.foodX && n4 == this.foodY) {
            this.score += 10;
            this.growCounter += 8;
            this.placeFood();
        }
        int n5 = this.snakeLength;
        while (n5 != 2) {
            int n6 = this.snake[--n5];
            int n7 = this.snake[--n5];
            if (n3 != n6 || n4 != n7) continue;
            Engine.resetKeyBuffers();
            this.state = 1;
        }
    }

    private void placeFood() {
        boolean bl;
        int n = Engine.rndPositive(60);
        int n2 = Engine.rndPositive(80);
        int n3 = n;
        int n4 = n2;
        block0: do {
            bl = false;
            int n5 = this.snakeLength;
            while (n5 != 0) {
                int n6 = this.snake[--n5];
                int n7 = this.snake[--n5];
                if (n3 != n6 || n4 != n7) continue;
                if (++n3 > 59) {
                    n3 = 0;
                }
                if (n3 == n && ++n4 > 79) {
                    n4 = 0;
                }
                bl = true;
                continue block0;
            }
        } while (bl);
        this.foodX = n3;
        this.foodY = n4;
    }
}

