/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class S3dResource {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_IMAGE2D = 0;
    public static final int TYPE_TEXTURE = 1;
    public static final int TYPE_M3G = 2;
    public static final int TYPE_SPRITE3D = 3;
    public static final int TYPE_MESH = 4;
    public Object[] ref;
    public int refInt;
    public int refInt2;
    public int animCount;
    boolean inUse = false;
    public static final int FLAGS_NULL = 0;
    public static final int FLAGS_TEXTURE_REPLACE = 1;
    public static final int FLAGS_TEXTURE_DECAL = 2;
    public static final int FLAGS_TEXTURE_ADD = 4;
    public static final int FLAGS_TEXTURE_BLEND = 8;
    public static final int FLAGS_TEXTURE_MODULATE = 16;
    public static final int FLAGS_STATIC_MESH = 2;
    public static final int REFTYPE = 0;
    private static S3dResource[] cache;
    private static int nextCacheID;
    private static Appearance[] appearance;
    protected static final int IMAGE_IMAGE = 0;
    protected static final int IMAGE_REGIONS = 1;
    protected static final int TEXTURE_TEXTURE = 0;
    protected static final int TEXTURE_REGIONS = 1;
    protected static final int TEXTURE_IMAGE2D = 2;
    protected static final int M3G_M3G = 0;
    protected static final int M3G_MESH = 1;
    protected static final int M3G_TEXTURES = 2;
    protected static final int BILLBOARD_SPRITE3D = 0;
    protected static final int BILLBOARD_TEXTURE = 1;
    protected static final int BILLBOARD_APPEARANCE = 2;
    public static final int MESH_IB = 0;
    public static final int MESH_TEXTURE = 1;
    public static final int MESH_IMAGE = 2;
    public static final int MESH_REGIONS = 3;
    public static final int MESH_VB = 4;
    public static final int MESH_APPEARANCE = 5;
    public static final int MESH_S3D_APPEARANCE = 6;
    public static final int PRIMITIVE_CUBE = 0;
    public static final int PRIMITIVE_TRIGRID = 1;
    public static final int DUPLICATE_FLAG_NONE = 0;
    public static final int DUPLICATE_FLAG_COPY_VB = 1;
    float[] v1 = new float[3];
    float[] v2 = new float[3];

    public static void createCache(int n) {
        cache = new S3dResource[n];
        for (int i = 0; i < cache.length; ++i) {
            S3dResource.cache[i] = new S3dResource();
        }
        nextCacheID = 0;
    }

    public static S3dResource create(boolean bl) {
        int n;
        for (n = nextCacheID; n < cache.length; ++n) {
            if (S3dResource.cache[n].inUse) continue;
            S3dResource.cache[n].inUse = true;
            nextCacheID = n + 1;
            return cache[n];
        }
        for (n = 0; n < nextCacheID; ++n) {
            if (S3dResource.cache[n].inUse) continue;
            S3dResource.cache[n].inUse = true;
            nextCacheID = n + 1;
            return cache[n];
        }
        if (bl) {
            cache[nextCacheID %= cache.length].release();
            S3dResource.cache[S3dResource.nextCacheID].inUse = true;
            return cache[++nextCacheID - 1];
        }
        return null;
    }

    public static S3dResource find(int n) {
        for (int i = 0; i < cache.length; ++i) {
            if (!S3dResource.cache[i].inUse || S3dResource.cache[i].refInt != n) continue;
            return cache[i];
        }
        return null;
    }

    public static void releaseAll() {
        for (int i = 0; i < cache.length; ++i) {
            cache[i].release();
        }
        nextCacheID = 0;
    }

    public S3dResource() {
    }

    public S3dResource(int n) throws Exception {
        this();
        byte[] byArray = ResourceMaster.getResource(n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        if (dataInputStream.readByte() != 0) {
            // empty if block
        }
    }

    public S3dResource(String string, short[] sArray) throws Exception {
        this();
        this.loadImage(string, sArray, 0);
        this.inUse = true;
    }

    public S3dResource(S3dResource s3dResource, VertexBuffer vertexBuffer, IndexBuffer indexBuffer, S3dAppearance s3dAppearance, int n) {
        this();
        this.inUse = true;
        if ((n & 2) != 0) {
            this.createStaticMesh(vertexBuffer, indexBuffer, s3dAppearance);
        } else {
            this.createDynamicMesh(s3dResource, vertexBuffer, indexBuffer, s3dAppearance);
        }
    }

    public void destroy() {
        S3dResource.releaseAll();
    }

    public void release() {
        if (this.ref != null) {
            for (int i = 0; i < this.ref.length; ++i) {
                this.ref[i] = null;
            }
            this.ref = null;
        }
        this.inUse = false;
    }

    public static String getReportStats() {
        int n = 0;
        for (int i = 0; i < cache.length; ++i) {
            n += S3dResource.cache[i].inUse ? 1 : 0;
        }
        return "References in use = " + n;
    }

    public void loadImage(String string, short[] sArray, int n) throws Exception {
        this.ref = new Object[2];
        this.ref[0] = Loader.load((String)string)[0];
        this.ref[1] = new short[sArray.length];
        System.arraycopy(sArray, 0, this.ref[1], 0, sArray.length);
    }

    public void loadTexture(int n, byte[] byArray, int n2) throws Exception {
        System.out.println("load tex " + n + ", flags=" + n2);
        this.ref = new Object[3];
        byte[] byArray2 = ResourceMaster.getResource(n);
        Image image = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
        this.ref[2] = new Image2D(100, (Object)image);
        this.refInt = ((Image2D)this.ref[2]).getWidth();
        this.refInt2 = ((Image2D)this.ref[2]).getHeight();
        this.ref[1] = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.ref[1], 0, byArray.length);
        image = new Texture2D((Image2D)this.ref[2]);
        this.ref[0] = image;
        if ((n2 & 1) != 0) {
            image.setBlending(228);
        } else if ((n2 & 4) != 0) {
            image.setBlending(224);
        } else if ((n2 & 8) != 0) {
            image.setBlending(225);
        } else if ((n2 & 0x10) != 0) {
            image.setBlending(227);
        } else {
            image.setBlending(226);
        }
        image.setWrapping(241, 241);
    }

    public void loadTexture(int n, short[] sArray, int n2) throws Exception {
        this.ref = new Object[3];
        byte[] byArray = ResourceMaster.getResource(n);
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        this.ref[2] = new Image2D(100, (Object)image);
        this.refInt = ((Image2D)this.ref[2]).getWidth();
        this.refInt2 = ((Image2D)this.ref[2]).getHeight();
        this.ref[1] = new short[sArray.length];
        System.arraycopy(sArray, 0, this.ref[1], 0, sArray.length);
        image = new Texture2D((Image2D)this.ref[2]);
        this.ref[0] = image;
        if ((n2 & 1) != 0) {
            image.setBlending(228);
        } else if ((n2 & 4) != 0) {
            image.setBlending(224);
        } else if ((n2 & 8) != 0) {
            image.setBlending(225);
        } else if ((n2 & 0x10) != 0) {
            image.setBlending(227);
        } else {
            image.setBlending(226);
        }
        image.setWrapping(241, 241);
    }

    public void loadTexture(int n, float[] fArray, int n2) throws Exception {
        this.ref = new Object[3];
        byte[] byArray = ResourceMaster.getResource(n);
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        this.ref[2] = new Image2D(100, (Object)image);
        this.refInt = ((Image2D)this.ref[2]).getWidth();
        int n3 = ((Image2D)this.ref[2]).getHeight();
        this.ref[1] = new short[fArray.length];
        short[] sArray = (short[])this.ref[1];
        for (int i = 0; i < fArray.length; i += 2) {
            sArray[i] = (short)(fArray[i] * (float)this.refInt);
            sArray[i + 1] = (short)(fArray[i + 1] * (float)n3);
        }
        Texture2D texture2D = new Texture2D((Image2D)this.ref[2]);
        this.ref[0] = texture2D;
        if ((n2 & 1) != 0) {
            texture2D.setBlending(228);
        } else if ((n2 & 4) != 0) {
            texture2D.setBlending(224);
        } else if ((n2 & 8) != 0) {
            texture2D.setBlending(225);
        } else if ((n2 & 0x10) != 0) {
            texture2D.setBlending(227);
        } else {
            texture2D.setBlending(226);
        }
        texture2D.setFiltering(2, 8);
        texture2D.setWrapping(241, 241);
    }

    public void loadTexture(Image2D image2D, int n) throws Exception {
        this.ref = new Object[3];
        this.ref[2] = image2D;
        this.refInt = ((Image2D)this.ref[2]).getWidth();
        this.refInt2 = ((Image2D)this.ref[2]).getHeight();
        Texture2D texture2D = new Texture2D((Image2D)this.ref[2]);
        this.ref[0] = texture2D;
        if ((n & 1) != 0) {
            texture2D.setBlending(228);
        } else if ((n & 4) != 0) {
            texture2D.setBlending(224);
        } else if ((n & 8) != 0) {
            texture2D.setBlending(225);
        } else if ((n & 0x10) != 0) {
            texture2D.setBlending(227);
        } else {
            texture2D.setBlending(226);
        }
        texture2D.setWrapping(241, 241);
    }

    public void loadTexture(Image image, int n) throws Exception {
        this.ref = new Object[3];
        this.ref[2] = new Image2D(100, (Object)image);
        this.refInt = ((Image2D)this.ref[2]).getWidth();
        this.refInt2 = ((Image2D)this.ref[2]).getHeight();
        Texture2D texture2D = new Texture2D((Image2D)this.ref[2]);
        this.ref[0] = texture2D;
        if ((n & 1) != 0) {
            texture2D.setBlending(228);
        } else if ((n & 4) != 0) {
            texture2D.setBlending(224);
        } else if ((n & 8) != 0) {
            texture2D.setBlending(225);
        } else if ((n & 0x10) != 0) {
            texture2D.setBlending(227);
        } else {
            texture2D.setBlending(226);
        }
        texture2D.setWrapping(241, 241);
    }

    public void loadTexture(int n, int n2) throws Exception {
        System.out.println("load tex " + n);
        this.ref = new Object[3];
        byte[] byArray = ResourceMaster.getResource(n);
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        this.ref[2] = new Image2D(100, (Object)image);
        this.refInt = ((Image2D)this.ref[2]).getWidth();
        this.refInt2 = ((Image2D)this.ref[2]).getHeight();
        image = new Texture2D((Image2D)this.ref[2]);
        this.ref[0] = image;
        if ((n2 & 1) != 0) {
            image.setBlending(228);
        } else if ((n2 & 4) != 0) {
            image.setBlending(224);
        } else if ((n2 & 8) != 0) {
            image.setBlending(225);
        } else if ((n2 & 0x10) != 0) {
            image.setBlending(227);
        } else {
            image.setBlending(226);
        }
        image.setWrapping(241, 241);
        System.out.println("done");
    }

    public void createRegionGridData(int n, int n2) {
        int n3 = this.refInt / n;
        int n4 = this.refInt2 / n2;
        int n5 = n3 * n4;
        int n6 = n5 * 2 * 4;
        this.ref[1] = new byte[n6];
        byte[] byArray = (byte[])this.ref[1];
        int n7 = n * 256 / this.refInt;
        int n8 = n2 * 256 / this.refInt2;
        int n9 = 0;
        for (int i = 0; i < n5; ++i) {
            byte by = (byte)(i % n3 * n7 - 128);
            byte by2 = (byte)(i / n3 * n8 - 128);
            byte by3 = (byte)(by + n7 - 1);
            byte by4 = (byte)(by2 + n8 - 1);
            byArray[n9++] = by;
            byArray[n9++] = by2;
            byArray[n9++] = by;
            byArray[n9++] = by4;
            byArray[n9++] = by3;
            byArray[n9++] = by2;
            byArray[n9++] = by3;
            byArray[n9++] = by4;
        }
    }

    public void fillRegionData(int n, byte[] byArray, int n2) {
        if (this.isResourceTexture()) {
            if (this.ref[1] == null) {
                byArray[n2 + 5] = -128;
                byArray[n2 + 2] = -128;
                byArray[n2 + 1] = -128;
                byArray[n2 + 0] = -128;
                byArray[n2 + 7] = 127;
                byArray[n2 + 6] = 127;
                byArray[n2 + 4] = 127;
                byArray[n2 + 3] = 127;
            } else {
                for (int i = 0; i < 8; ++i) {
                    System.out.println(i + " ) " + ((byte[])this.ref[1])[i]);
                }
                System.arraycopy(this.ref[1], n * 8, byArray, n2, 8);
            }
        }
    }

    public void fillRegionDataForQuads(int n, short[] sArray, int n2) {
        if (this.isResourceTexture()) {
            short[] sArray2 = (short[])this.ref[1];
            int n3 = n * 4;
            sArray[n2 + 0] = sArray2[n3 + 0];
            sArray[n2 + 1] = sArray2[n3 + 1];
            sArray[n2 + 2] = sArray2[n3 + 0];
            sArray[n2 + 3] = sArray2[n3 + 3];
            sArray[n2 + 4] = sArray2[n3 + 2];
            sArray[n2 + 5] = sArray2[n3 + 1];
            sArray[n2 + 6] = sArray2[n3 + 2];
            sArray[n2 + 7] = sArray2[n3 + 3];
        }
    }

    public int getTextureWidth() {
        if (this.isResourceTexture()) {
            return this.refInt;
        }
        return -1;
    }

    public int getTextureHeight() {
        return this.getTextureWidth();
    }

    public void loadMesh(int n) throws Exception {
        this.ref = new Object[2];
        byte[] byArray = ResourceMaster.getResource(n);
        this.ref[0] = Loader.load((byte[])byArray, (int)0)[0];
        this.ref[1] = S3dResource.getSubMesh((Node)this.ref[0], 0);
    }

    public void loadMesh(String string, int n, int n2) throws Exception {
        System.out.println("Loading mesh " + string);
        this.ref = new Object[2];
        this.ref[0] = Loader.load((String)string)[0];
        System.out.println("loaded");
        this.ref[1] = S3dResource.getSubMesh((Node)this.ref[0], n2);
        System.out.println("get submesh");
        this.refInt = n;
    }

    public void checkMeshUVs(String string, int n) throws Exception {
        System.out.println("Loading mesh " + string);
        try {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)Engine.parent)).getClass().getResourceAsStream(string));
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            int[] nArray = M3GParser.getSectionOffsets(byArray);
            System.out.println("sections: " + nArray.length);
            int[] nArray2 = M3GParser.getChunkOffsets(byArray, nArray[nArray.length - 1], 20);
            int[] nArray3 = M3GParser.getChunkOffsets(byArray, nArray[nArray.length - 1], 20);
            System.out.println("chunks: " + nArray3.length);
            for (int i = 0; i < nArray3.length; ++i) {
                int[] nArray4 = M3GParser.getUVs(byArray, nArray3[i]);
                if (nArray4 == null) continue;
                System.out.println(i + " --- UVs --- " + (nArray4.length >> 1));
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            Engine.debugWrite("loadMesh exception: " + exception.getMessage(), true);
        }
    }

    public void loadMeshNew(String string, int n) throws Exception {
        System.out.println("Loading mesh " + string);
        try {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)Engine.parent)).getClass().getResourceAsStream(string));
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            this.ref = new Object[2];
            this.ref[0] = Loader.load((String)string)[0];
            this.ref[1] = S3dResource.getSubMesh((Node)this.ref[0], 0);
            Image2D image2D = new Image2D(100, (Object)Image.createImage((String)("/" + M3GParser.getExternalRefName(byArray, 12))));
            dataInputStream.close();
        }
        catch (Exception exception) {
            Engine.debugWrite("loadMesh exception: " + exception.getMessage(), true);
        }
    }

    public static S3dResource[] loadMeshList(String string, int n) throws Exception {
        Object3D[] object3DArray = Loader.load((String)("/" + string + ".m3g"));
        S3dResource[] s3dResourceArray = new S3dResource[object3DArray.length];
        for (int i = 0; i < object3DArray.length; ++i) {
            s3dResourceArray[i] = S3dResource.create(false);
            s3dResourceArray[i].ref = new Object[1];
            s3dResourceArray[i].ref[0] = object3DArray[i];
            Group group = (Group)object3DArray[i];
            for (int j = 0; j < group.getChildCount(); ++j) {
                Node node = group.getChild(j);
            }
        }
        return s3dResourceArray;
    }

    public void createBillboard(S3dResource s3dResource, S3dAppearance s3dAppearance, int n, int n2) {
        this.ref = new Object[3];
        this.refInt = n;
        this.ref[1] = s3dResource;
        this.ref[2] = s3dAppearance.app;
        this.ref[0] = this.recreateBillboardSprite();
    }

    public void recreateBillboard(int n, int n2) {
        this.prepareBillboardRegion((Sprite3D)this.ref[0], n);
        this.refInt = n;
    }

    public int getBillboardRegion() {
        return this.refInt;
    }

    protected Sprite3D recreateBillboardSprite() {
        Sprite3D sprite3D = new Sprite3D(true, ((S3dResource)this.ref[1]).getResourceImage(), (Appearance)this.ref[2]);
        this.prepareBillboardRegion(sprite3D, this.refInt);
        return sprite3D;
    }

    protected void prepareBillboardRegion(Sprite3D sprite3D, int n) {
        short[] sArray = ((S3dResource)this.ref[1]).getResourceRegions();
        sprite3D.setCrop((int)sArray[n * 4 + 0], (int)sArray[n * 4 + 1], sArray[n * 4 + 2] - sArray[n * 4 + 0], sArray[n * 4 + 3] - sArray[n * 4 + 1]);
        sArray = null;
    }

    public void createPrimitive(S3dResource s3dResource, int n, boolean bl, int[] nArray, int[] nArray2, int n2) {
        S3dAppearance s3dAppearance;
        this.ref = new Object[7];
        if (s3dResource != null) {
            this.ref[2] = s3dResource.getResourceImage();
            this.ref[3] = s3dResource.getResourceRegions();
            this.ref[1] = s3dResource.getResourceTexture();
        }
        switch (n) {
            case 0: {
                if (bl) {
                    s3dAppearance = new S3dAppearance();
                    s3dAppearance.setTexture(0, (Texture2D)this.ref[1]);
                    this.ref[0] = S3dPrimitiveCuboid.createDynamicIB();
                    this.ref[4] = S3dPrimitiveCuboid.createDynamicVB((Texture2D)this.ref[1], (short[])this.ref[3], nArray, nArray2, n2);
                    this.ref[5] = s3dAppearance.app;
                    this.ref[6] = s3dAppearance;
                    break;
                }
                this.ref[0] = S3dPrimitiveCuboid.create((Texture2D)this.ref[1], (short[])this.ref[3], nArray, nArray2, n2);
                break;
            }
        }
        if (bl) {
            s3dAppearance = new S3dAppearance();
            s3dAppearance.setTexture(0, (Texture2D)this.ref[1]);
            this.ref[0] = S3dPrimitiveCuboid.createDynamicIB();
            this.ref[4] = S3dPrimitiveCuboid.createDynamicVB((Texture2D)this.ref[1], (short[])this.ref[3], nArray, nArray2, n2);
            this.ref[5] = s3dAppearance.app;
            this.ref[6] = s3dAppearance;
        } else {
            this.ref[0] = S3dPrimitiveCuboid.create((Texture2D)this.ref[1], (short[])this.ref[3], nArray, nArray2, n2);
        }
    }

    public void createDynamicMesh(S3dResource s3dResource, VertexBuffer vertexBuffer, IndexBuffer indexBuffer, S3dAppearance s3dAppearance) {
        this.ref = new Object[6];
        if (s3dResource.isResourceTexture()) {
            this.ref[1] = s3dResource.ref[0];
        } else {
            this.ref[1] = new Texture2D((Image2D)s3dResource.ref[0]);
            ((Texture2D)this.ref[1]).setBlending(226);
            ((Texture2D)this.ref[1]).setWrapping(241, 241);
        }
        this.ref[3] = null;
        this.ref[0] = indexBuffer;
        this.ref[4] = vertexBuffer;
        this.ref[5] = s3dAppearance.app;
    }

    public void createStaticMesh(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, S3dAppearance s3dAppearance) {
        this.ref = new Object[1];
        this.ref[0] = new Mesh(vertexBuffer, indexBuffer, s3dAppearance.app);
        this.refInt = -1;
    }

    public void duplicate(S3dResource s3dResource, int n) {
        this.ref = new Object[s3dResource.ref.length];
        if (s3dResource.ref[0] instanceof Texture2D) {
            this.ref[0] = ((Texture2D)s3dResource.ref[0]).duplicate();
            for (int i = 1; i < this.ref.length; ++i) {
                this.ref[i] = s3dResource.ref[i];
            }
        } else if (s3dResource.ref[0] instanceof Node) {
            if (n == 1) {
                Mesh mesh = (Mesh)s3dResource.ref[0];
                this.ref[0] = new Mesh((VertexBuffer)mesh.getVertexBuffer().duplicate(), mesh.getIndexBuffer(0), mesh.getAppearance(0));
            } else {
                this.ref[0] = ((Node)s3dResource.ref[0]).duplicate();
            }
        }
    }

    public void startAnimation(int n, int n2) {
        Object var3_3 = null;
        this.animCount = 0;
    }

    public boolean tick(int n) {
        this.animCount += n;
        if (((Node)this.ref[0]).animate(this.animCount) == Integer.MAX_VALUE) {
            this.animCount = 0;
            return true;
        }
        return false;
    }

    public static void stopAnimation(Object object, int n) {
        Mesh mesh = (Mesh)object;
        int n2 = mesh.getAnimationTrackCount();
        for (int i = 0; i < n2; ++i) {
            mesh.getAnimationTrack(i).getController().setWeight(0.0f);
        }
    }

    public static void changeAppearanceMode(Object object, int n, int n2) {
        Mesh mesh = (Mesh)object;
        if (mesh != null) {
            Appearance appearance = mesh.getAppearance(n);
            switch (n2) {
                case 0: {
                    appearance.setCompositingMode(S3dAppearance.solidCompositing);
                    break;
                }
                case 1: {
                    appearance.setCompositingMode(S3dAppearance.alphaCompositing);
                    appearance.getCompositingMode().setAlphaThreshold(0.5f);
                    break;
                }
                case 5: {
                    appearance.setCompositingMode(S3dAppearance.alphaaddCompositing);
                    appearance.getCompositingMode().setAlphaThreshold(0.5f);
                }
            }
        }
    }

    public static void changePolygonMode(Appearance appearance, int n) {
        PolygonMode polygonMode = appearance.getPolygonMode();
        if (polygonMode == null) {
            return;
        }
        if ((n & 0x10) != 0 && polygonMode.getShading() != 164) {
            polygonMode.setShading(164);
        }
        if ((n & 0x20) != 0 && polygonMode.getShading() != 165) {
            polygonMode.setShading(165);
        }
        if ((n & 1) != 0 && polygonMode.getCulling() != 160) {
            polygonMode.setCulling(160);
        }
        if ((n & 2) != 0 && polygonMode.getCulling() != 161) {
            polygonMode.setCulling(161);
        }
        if ((n & 3) != 0 && polygonMode.getCulling() != 162) {
            polygonMode.setCulling(162);
        }
        if ((n & 4) != 0 && polygonMode.getWinding() != 168) {
            polygonMode.setWinding(168);
        }
        if ((n & 8) != 0 && polygonMode.getWinding() != 169) {
            polygonMode.setWinding(169);
        }
        if ((n & 0x100) != 0) {
            polygonMode.setLocalCameraLightingEnable(false);
        }
        if ((n & 0x200) != 0) {
            polygonMode.setLocalCameraLightingEnable(true);
        }
        if ((n & 0x40) != 0) {
            polygonMode.setPerspectiveCorrectionEnable(false);
        }
        if ((n & 0x80) != 0) {
            polygonMode.setPerspectiveCorrectionEnable(true);
        }
    }

    public static void changeFilteringMode(Appearance appearance, int n) {
        Texture2D texture2D = appearance.getTexture(0);
        if (texture2D == null) {
            return;
        }
        if ((n & 0x200) != 0) {
            texture2D.setBlending(228);
        }
        if (appearance.getCompositingMode() == null || appearance.getCompositingMode().getAlphaThreshold() > 0.0f) {
            return;
        }
        int n2 = 208;
        int n3 = 210;
        if ((n & 2) != 0) {
            n2 = 210;
        } else if ((n & 4) != 0) {
            n2 = 209;
        }
        if ((n & 0x10) != 0) {
            n3 = 209;
        }
        texture2D.setFiltering(n2, n3);
    }

    public static void changeAllPolygonModes(int n) {
        int n2 = appearance.length;
        while (--n2 >= 0) {
            S3dResource.changePolygonMode(appearance[n2], n);
        }
    }

    public static void changeAllFiltering(int n) {
        int n2 = appearance.length;
        while (--n2 >= 0) {
            S3dResource.changeFilteringMode(appearance[n2], n);
        }
    }

    public static int getAppearanceID(S3dResource s3dResource, int n) {
        Mesh mesh = S3dResource.getSubMesh((Node)s3dResource.ref[1], n);
        int n2 = appearance.length;
        while (--n2 >= 0) {
            if (mesh.getAppearance(0) != appearance[n2]) continue;
            return n2;
        }
        return -1;
    }

    public static void fillAppearanceArray() {
        appearance = new Appearance[0];
        int n = cache.length;
        while (--n >= 0) {
            if (!S3dResource.cache[n].inUse || !(S3dResource.cache[n].ref[0] instanceof Node)) continue;
            Node node = (Node)S3dResource.cache[n].ref[0];
            int n2 = S3dResource.getSubMeshCount(node);
            while (--n2 >= 0) {
                Mesh mesh = S3dResource.getSubMesh(node, n2);
                int n3 = mesh.getSubmeshCount();
                while (--n3 >= 0) {
                    boolean bl = false;
                    int n4 = appearance.length;
                    while (--n4 >= 0) {
                        if (mesh.getAppearance(n3) != appearance[n4]) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    Appearance[] appearanceArray = new Appearance[appearance.length];
                    System.arraycopy(appearance, 0, appearanceArray, 0, appearance.length);
                    appearance = new Appearance[appearanceArray.length + 1];
                    System.arraycopy(appearanceArray, 0, appearance, 0, appearanceArray.length);
                    S3dResource.appearance[appearanceArray.length] = mesh.getAppearance(n3);
                }
            }
        }
    }

    public static void drawNativeObject(Object object, S3dTransform s3dTransform, Object object2) {
        if (object != null) {
            S3dGfxDriver.g3d.render((Node)object, s3dTransform == null ? null : s3dTransform.xform);
        }
    }

    public Object getSubMesh(int n) {
        return ((Node)this.ref[0]).find(n);
    }

    public void paint3DSubMeshID(int n, S3dTransform s3dTransform, S3dObject s3dObject) {
        Node node = (Node)((Node)this.ref[0]).find(n);
        if (node != null) {
            S3dGfxDriver.g3d.render(node, s3dTransform == null ? null : s3dTransform.xform);
        }
    }

    public static void paint3DMesh(S3dResource s3dResource) {
        S3dGfxDriver.g3d.render((Node)s3dResource.ref[0], null);
    }

    public static void paint3DMesh(S3dResource s3dResource, S3dTransform s3dTransform) {
        S3dGfxDriver.g3d.render((Node)s3dResource.ref[0], s3dTransform.xform);
    }

    public void paint3D(S3dTransform s3dTransform) {
        if (this.ref == null) {
            return;
        }
        if (this.ref[0] instanceof IndexBuffer) {
            if ((S3dDebug.drawFeatureSet & 4) == 0) {
                return;
            }
            S3dGfxDriver.g3d.render((VertexBuffer)this.ref[4], (IndexBuffer)this.ref[0], (Appearance)this.ref[5], s3dTransform == null ? null : s3dTransform.xform);
        } else if (this.ref[0] instanceof Sprite3D) {
            if ((S3dDebug.drawFeatureSet & 2) == 0) {
                return;
            }
            S3dGfxDriver.g3d.render((Node)((Sprite3D)this.ref[0]), s3dTransform == null ? null : s3dTransform.xform);
        } else {
            if ((S3dDebug.drawFeatureSet & 1) == 0) {
                return;
            }
            S3dGfxDriver.g3d.render((Node)this.ref[0], s3dTransform == null ? null : s3dTransform.xform);
        }
    }

    public void paint3DMultiple(Object object, S3dTransform s3dTransform, Object object2, S3dTransform s3dTransform2) {
        s3dTransform2.getPosition(this.v1);
        s3dTransform.getPosition(this.v2);
        GluVector3f.sub(this.v1, this.v2);
        ((Node)object2).setTransform(s3dTransform.xform);
        ((Node)object).setTransform(s3dTransform.xform);
        this.paint3D(null);
        ((Node)object2).translate(-this.v2[0], -this.v2[1], -this.v2[2]);
    }

    public Node getResourceAsNode(S3dObject s3dObject) {
        Object object = this.ref[0] instanceof IndexBuffer ? new Mesh((VertexBuffer)this.ref[4], (IndexBuffer)this.ref[0], (Appearance)this.ref[5]) : (this.ref[0] instanceof Sprite3D ? this.recreateBillboardSprite() : (Node)this.ref[0]);
        return object;
    }

    public void setMeshAppearance(S3dAppearance s3dAppearance) {
        if (this.isResourceDynamicMesh()) {
            this.ref[5] = s3dAppearance.app;
        } else if (this.isResourceStaticMesh()) {
            if (this.ref[0] instanceof Mesh) {
                Mesh mesh = (Mesh)this.ref[0];
                mesh.setAppearance(0, s3dAppearance.app);
            } else if (this.ref[0] instanceof IndexBuffer) {
                this.ref[5] = s3dAppearance.app;
                this.ref[6] = s3dAppearance;
            }
        }
    }

    public static Node getNodeFromUserID(Mesh mesh, int n) {
        return (Node)mesh.find(n);
    }

    public static Mesh getSubMesh(Node node, int n) {
        if (node == null) {
            return null;
        }
        if (node instanceof Mesh) {
            if (n == 0) {
                return (Mesh)node;
            }
            --n;
        }
        if (node instanceof World || node instanceof Group) {
            Group group = (Group)node;
            for (int i = 0; i < group.getChildCount(); ++i) {
                Node node2 = group.getChild(i);
                Mesh mesh = S3dResource.getSubMesh(node2, n);
                if (mesh != null) {
                    return mesh;
                }
                if (!(node2 instanceof Mesh)) continue;
                --n;
            }
        }
        return null;
    }

    public Camera getCamerab(int n) {
        return (Camera)((World)this.ref[0]).find(n);
    }

    public Camera getCamera(int n) {
        return this.getCamera((Node)this.ref[0], n);
    }

    private Camera getCamera(Node node, int n) {
        if (node == null) {
            return null;
        }
        if (node instanceof Camera) {
            if (n == 0) {
                return (Camera)node;
            }
            --n;
        }
        if (node instanceof World || node instanceof Group) {
            Group group = (Group)node;
            for (int i = 0; i < group.getChildCount(); ++i) {
                Node node2 = group.getChild(i);
                Camera camera = this.getCamera(node2, n);
                if (camera != null) {
                    return camera;
                }
                if (!(node2 instanceof Camera)) continue;
                --n;
            }
        }
        return null;
    }

    public static void strip() {
        int n = cache.length;
        while (--n >= 0) {
            Node node;
            if (!S3dResource.cache[n].inUse || !((node = (Node)S3dResource.cache[n].ref[0]) instanceof World) && !(node instanceof Group)) continue;
            Group group = (Group)node;
            for (int i = 0; i < group.getChildCount(); ++i) {
                Node node2 = group.getChild(i);
                if (node2 instanceof Mesh) {
                    Mesh mesh = (Mesh)node2;
                    mesh.getVertexBuffer().setNormals(null);
                }
                if (!(node2 instanceof Group) && !(node2 instanceof Light) && !(node2 instanceof Camera)) continue;
                group.removeChild(node2);
                --i;
            }
        }
    }

    public static void output() {
        int n = cache.length;
        while (--n >= 0) {
            if (!S3dResource.cache[n].inUse) continue;
            System.out.println("cache " + n + " ===");
            Node node = (Node)S3dResource.cache[n].ref[0];
            if (node instanceof World || node instanceof Group) {
                Group group = (Group)node;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    Node node2 = group.getChild(i);
                    System.out.print("group, child=" + i + "/" + group.getChildCount() + " = " + S3dResource.getSubMeshCount(node2) + " - " + node2.getUserID() + " ");
                    if (node2 instanceof Mesh) {
                        System.out.println("mesh");
                        continue;
                    }
                    if (node2 instanceof Group) {
                        System.out.println("group");
                        continue;
                    }
                    if (node2 instanceof Light) {
                        System.out.println("light");
                        continue;
                    }
                    if (node2 instanceof Camera) {
                        System.out.println("camera");
                        continue;
                    }
                    System.out.println("something");
                }
                continue;
            }
            System.out.println("not a world/group");
        }
    }

    public static void setNewTexture(Object object, String string) {
        Mesh mesh = (Mesh)object;
        try {
            Texture2D texture2D = new Texture2D(new Image2D(100, (Object)Image.createImage((String)string)));
            Appearance appearance = new Appearance();
            appearance.setTexture(0, texture2D);
            mesh.setAppearance(0, appearance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getSubMeshCount(Node node) {
        if (node instanceof Mesh) {
            return 1;
        }
        int n = 0;
        if (node instanceof World || node instanceof Group) {
            Group group = (Group)node;
            for (int i = 0; i < group.getChildCount(); ++i) {
                n += S3dResource.getSubMeshCount(group.getChild(i));
            }
        }
        return n;
    }

    public static void renderAllDataFromMesh(Node node) {
        System.out.println("---");
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            if (node.find(i) == null) continue;
            System.out.println("Found i = " + i);
        }
        if (node instanceof World || node instanceof Group) {
            Group group = (Group)node;
            for (int i = 0; i < group.getChildCount(); ++i) {
                S3dResource.renderAllDataFromMesh(group.getChild(i));
            }
        }
    }

    public void setMeshHack1() {
        System.out.println("ref[REFTYPE] = " + this.ref[0]);
        if (!this.isResourceDynamicMesh() && this.isResourceStaticMesh()) {
            World world = (World)this.ref[0];
            Mesh mesh = S3dResource.getSubMesh((Node)world, 0);
            System.out.println(" obj = " + mesh);
            if (mesh != null) {
                Mesh mesh2 = mesh;
                Appearance appearance = mesh2.getAppearance(0);
                PolygonMode polygonMode = appearance.getPolygonMode();
                polygonMode.setLocalCameraLightingEnable(true);
            }
        }
    }

    public int getResourceType() {
        if (this.ref[0] instanceof Image2D) {
            return 0;
        }
        if (this.ref[0] instanceof Texture2D) {
            return 1;
        }
        if (this.ref[0] instanceof Sprite3D) {
            return 3;
        }
        if (this.ref[0] instanceof Node) {
            return 2;
        }
        if (this.ref[0] instanceof IndexBuffer) {
            return 4;
        }
        return -1;
    }

    public boolean isResourceImage() {
        return this.ref[0] instanceof Image2D;
    }

    public boolean isResourceTexture() {
        return this.ref[0] instanceof Texture2D;
    }

    public boolean isResourceBillboard() {
        return this.ref[0] instanceof Sprite3D;
    }

    public boolean isResourceStaticMesh() {
        if (this.ref[0] instanceof IndexBuffer) {
            return true;
        }
        return this.ref[0] instanceof Node;
    }

    public boolean isResourceDynamicMesh() {
        return this.ref[0] instanceof IndexBuffer;
    }

    public Image2D getResourceImage() {
        if (this.isResourceImage()) {
            return (Image2D)this.ref[0];
        }
        if (this.isResourceTexture()) {
            return (Image2D)this.ref[2];
        }
        return null;
    }

    public short[] getResourceRegions() {
        if (this.isResourceTexture()) {
            return (short[])this.ref[1];
        }
        return null;
    }

    public Texture2D getResourceTexture() {
        if (this.isResourceTexture()) {
            return (Texture2D)this.ref[0];
        }
        return null;
    }

    public Node getResourceStaticMesh() {
        if (this.isResourceStaticMesh()) {
            return (Node)this.ref[0];
        }
        return null;
    }
}

