/*
 * Decompiled with CFR 0.152.
 */
public class GluVector3f {
    public static final float[] theta0 = new float[]{1.0f, 0.0f, 0.0f};
    public static final float[] theta90 = new float[]{0.0f, 0.0f, 1.0f};
    public static final float[] theta180 = new float[]{-1.0f, 0.0f, 0.0f};
    public static final float[] theta270 = new float[]{0.0f, 0.0f, -1.0f};
    public static final int PERPENDICULAR_DISTANCE_BEFORE_LINE = -1;
    public static final int PERPENDICULAR_DISTANCE_AFTER_LINE = -2;
    static float[] tempV1 = new float[3];
    static float[] tempV2 = new float[3];

    public static float magnitude(float[] fArray) {
        return GluFloat.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
    }

    public static float magnitudeSquared(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2];
    }

    public static void quantize(float[] fArray, int n) {
        fArray[0] = (int)(fArray[0] / (float)n);
        fArray[1] = (int)(fArray[1] / (float)n);
        fArray[2] = (int)(fArray[2] / (float)n);
        fArray[0] = fArray[0] * (float)n;
        fArray[1] = fArray[1] * (float)n;
        fArray[2] = fArray[2] * (float)n;
    }

    public static boolean equals(float[] fArray, float[] fArray2, float f) {
        float f2 = fArray[0] - fArray2[0];
        if (f2 < -f || f2 > f) {
            return false;
        }
        f2 = fArray[1] - fArray2[1];
        if (f2 < -f || f2 > f) {
            return false;
        }
        f2 = fArray[2] - fArray2[2];
        return !(f2 < -f) && !(f2 > f);
    }

    public static void normalize(float[] fArray) {
        float f = fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
        float f2 = GluFloat.sqrt(f);
        if ((double)f2 == 0.0) {
            return;
        }
        f2 = 1.0f / f2;
        fArray[0] = fArray[0] * f2;
        fArray[1] = fArray[1] * f2;
        fArray[2] = fArray[2] * f2;
    }

    public static float distance(float[] fArray, float[] fArray2) {
        return GluFloat.sqrt(GluVector3f.squaredDistance(fArray, fArray2));
    }

    public static float distanceSquared(float[] fArray, float[] fArray2) {
        float f = fArray2[0] - fArray[0];
        float f2 = fArray2[1] - fArray[1];
        float f3 = fArray2[2] - fArray[2];
        return f * f + f2 * f2 + f3 * f3;
    }

    public static float squaredDistance(float[] fArray, float[] fArray2) {
        float f = fArray2[0] - fArray[0];
        float f2 = fArray2[1] - fArray[1];
        float f3 = fArray2[2] - fArray[2];
        return f * f + f2 * f2 + f3 * f3;
    }

    public static float dot(float[] fArray, float[] fArray2) {
        return fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2];
    }

    public static void cross(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }

    public static void assign(float[] fArray, float[] fArray2) {
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[1];
        fArray2[2] = fArray[2];
    }

    public static void neg(float[] fArray) {
        fArray[0] = -fArray[0];
        fArray[1] = -fArray[1];
        fArray[2] = -fArray[2];
    }

    public static void add(float[] fArray, float[] fArray2) {
        fArray[0] = fArray[0] + fArray2[0];
        fArray[1] = fArray[1] + fArray2[1];
        fArray[2] = fArray[2] + fArray2[2];
    }

    public static void sub(float[] fArray, float[] fArray2) {
        fArray[0] = fArray[0] - fArray2[0];
        fArray[1] = fArray[1] - fArray2[1];
        fArray[2] = fArray[2] - fArray2[2];
    }

    public static void sub(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] - fArray3[0];
        fArray[1] = fArray2[1] - fArray3[1];
        fArray[2] = fArray2[2] - fArray3[2];
    }

    public static void mul(float[] fArray, float f) {
        fArray[0] = fArray[0] * f;
        fArray[1] = fArray[1] * f;
        fArray[2] = fArray[2] * f;
    }

    public static void div(float[] fArray, float f) {
        float f2 = 1.0f / f;
        fArray[0] = fArray[0] * f2;
        fArray[1] = fArray[1] * f2;
        fArray[2] = fArray[2] * f2;
    }

    public static void slerp(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        fArray3[0] = fArray[0] + (fArray2[0] - fArray[0]) * f;
        fArray3[1] = fArray[1] + (fArray2[1] - fArray[1]) * f;
        fArray3[2] = fArray[2] + (fArray2[2] - fArray[2]) * f;
    }

    public static void slerp(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray[0] + (fArray2[0] - fArray[0]) * f;
        fArray[1] = fArray[1] + (fArray2[1] - fArray[1]) * f;
        fArray[2] = fArray[2] + (fArray2[2] - fArray[2]) * f;
    }

    public static void closer(float[] fArray, float[] fArray2, float f) {
        fArray[0] = GluFloat.closer(fArray[0], fArray2[0], f);
        fArray[1] = GluFloat.closer(fArray[1], fArray2[1], f);
        fArray[2] = GluFloat.closer(fArray[2], fArray2[2], f);
    }

    public static boolean lineIntersectionXZ(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        float f = (fArray[2] - fArray3[2]) * (fArray4[0] - fArray3[0]) - (fArray[0] - fArray3[0]) * (fArray4[2] - fArray3[2]);
        float f2 = (fArray[2] - fArray3[2]) * (fArray2[0] - fArray[0]) - (fArray[0] - fArray3[0]) * (fArray2[2] - fArray[2]);
        float f3 = (fArray2[0] - fArray[0]) * (fArray4[2] - fArray3[2]) - (fArray2[2] - fArray[2]) * (fArray4[0] - fArray3[0]);
        float f4 = f / f3;
        float f5 = f2 / f3;
        if (f4 >= 0.0f && f4 <= 1.0f && f5 >= 0.0f && f5 <= 1.0f) {
            if (GluFloat.verboseDebug) {
                System.out.println("v3_LineIntersectionXZ:");
                GluVector3f.debug("va", fArray);
                GluVector3f.debug("vb", fArray2);
                GluVector3f.debug("vc", fArray3);
                GluVector3f.debug("vd", fArray4);
                GluFloat.debug("rn", f);
                GluFloat.debug("sn", f2);
                GluFloat.debug("r", f4);
                GluFloat.debug("s", f5);
            }
            if (fArray5 != null) {
                fArray5[0] = fArray[0] + f4 * (fArray2[0] - fArray[0]);
                fArray5[2] = fArray[2] + f4 * (fArray2[2] - fArray[2]);
            }
            return true;
        }
        return false;
    }

    public static boolean circleIntersectionXZ(float[] fArray, float f, float[] fArray2, float f2) {
        float f3 = (fArray[0] - fArray2[0]) * (fArray[0] - fArray2[0]) + (fArray[2] - fArray2[2]) * (fArray[2] - fArray2[2]);
        return (f + f2) * (f + f2) <= f3;
    }

    public static float getPerpendicularDistanceXZ(float[] fArray, float[] fArray2, float[] fArray3, boolean bl) {
        if (bl) {
            float f = fArray2[0] - fArray[0];
            float f2 = fArray2[2] - fArray[2];
            float f3 = fArray3[0] - fArray[0];
            float f4 = fArray3[2] - fArray[2];
            float f5 = (f3 * f + f4 * f2) / (f * f + f2 * f2);
            float f6 = fArray3[0] - (fArray[0] + f5 * f);
            float f7 = fArray3[2] - (fArray[2] + f5 * f2);
            float f8 = GluFloat.sqrt(f6 * f6 + f7 * f7);
            return f8;
        }
        GluVector3f.tempV1[0] = fArray3[0] - fArray[0];
        GluVector3f.tempV1[1] = 0.0f;
        GluVector3f.tempV1[2] = fArray3[2] - fArray[2];
        GluVector3f.tempV2[0] = fArray2[0] - fArray[0];
        GluVector3f.tempV2[1] = 0.0f;
        GluVector3f.tempV2[2] = fArray2[2] - fArray[2];
        float f = GluVector3f.dot(tempV1, tempV2);
        float f9 = GluVector3f.dot(tempV2, tempV2);
        if (f < 0.0f) {
            return -1.0f;
        }
        if (f9 <= f) {
            return -2.0f;
        }
        float f10 = f / f9;
        float[] fArray4 = new float[]{fArray[0] + f10 * tempV2[0], 0.0f, fArray[2] + f10 * tempV2[2]};
        return GluVector3f.distance(fArray3, fArray4);
    }

    public static float getPerpendicularDistanceSquaredXZ(float[] fArray, float[] fArray2, float[] fArray3, boolean bl) {
        if (bl) {
            float f = fArray2[0] - fArray[0];
            float f2 = fArray2[2] - fArray[2];
            float f3 = fArray3[0] - fArray[0];
            float f4 = fArray3[2] - fArray[2];
            float f5 = (f3 * f + f4 * f2) / (f * f + f2 * f2);
            float f6 = fArray3[0] - (fArray[0] + f5 * f);
            float f7 = fArray3[2] - (fArray[2] + f5 * f2);
            return f6 * f6 + f7 * f7;
        }
        GluVector3f.tempV1[0] = fArray3[0] - fArray[0];
        GluVector3f.tempV1[1] = 0.0f;
        GluVector3f.tempV1[2] = fArray3[2] - fArray[2];
        GluVector3f.tempV2[0] = fArray2[0] - fArray[0];
        GluVector3f.tempV2[1] = 0.0f;
        GluVector3f.tempV2[2] = fArray2[2] - fArray[2];
        float f = GluVector3f.dot(tempV1, tempV2);
        float f8 = GluVector3f.dot(tempV2, tempV2);
        if (f < 0.0f) {
            return -1.0f;
        }
        if (f8 <= f) {
            return -2.0f;
        }
        float f9 = f / f8;
        float[] fArray4 = new float[]{fArray[0] + f9 * tempV2[0], 0.0f, fArray[2] + f9 * tempV2[2]};
        return GluVector3f.distanceSquared(fArray3, fArray4);
    }

    public static void debug(String string, float[] fArray) {
        System.out.println(string + " = " + GluFloat.value(fArray[0]) + ", " + GluFloat.value(fArray[1]) + ", " + GluFloat.value(fArray[2]));
    }
}

