/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public class S3dCamera {
    public static final int GENERIC = 48;
    final float[] cameraLookAt = new float[3];
    final float[] cameraUpVector = new float[3];
    final float[] cameraXForm = new float[16];
    private static final float[] forward = new float[3];
    private static final float[] side = new float[3];
    private static final float[] up = new float[3];
    public boolean matrixDirty;
    public boolean cameraDirty;
    float cameraVisibleAngle;
    float cameraNearPlane;
    float cameraFarPlane;
    Transform cameraTransform;
    Camera camera;
    Transform projectionTransform = new Transform();
    public static final int AROUND_AXIS_X = 0;
    public static final int AROUND_AXIS_Y = 2;
    public static final int AROUND_AXIS_Z = 1;
    public static final int MOVE_RELATIVE = 1;
    public static final int MOVE_ABSOLUTE = 0;
    protected static final float[] axisList = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    public S3dCamera() {
        this.camera = new Camera();
        this.cameraTransform = new Transform();
        this.cameraLookAt[0] = 0.0f;
        this.cameraLookAt[1] = 0.0f;
        this.cameraLookAt[2] = -1.0f;
        this.cameraUpVector[0] = 0.0f;
        this.cameraUpVector[1] = 1.0f;
        this.cameraUpVector[2] = 0.0f;
        GluMatrix44f.setIdentity(this.cameraXForm);
        this.matrixDirty = true;
        this.setPerspective(45.0f, 1.0f, 1000.0f);
    }

    public void setPerspective(float f, float f2, float f3) {
        this.cameraVisibleAngle = f;
        this.cameraNearPlane = f2;
        this.cameraFarPlane = f3;
        this.validateCamera();
    }

    public void setParallel(float f, float f2, float f3) {
        this.cameraVisibleAngle = f;
        this.cameraNearPlane = f2;
        this.cameraFarPlane = f3;
        float f4 = (float)S3dEngine.viewport_width / (float)S3dEngine.viewport_height;
        this.camera.setParallel(this.cameraVisibleAngle, f4, this.cameraNearPlane, this.cameraFarPlane);
    }

    public void validateCamera() {
        float f = 1.0f * (float)S3dEngine.viewport_width / (float)S3dEngine.viewport_height;
        this.camera.setPerspective(this.cameraVisibleAngle, f, this.cameraNearPlane, this.cameraFarPlane);
    }

    public void applyCamera(Graphics3D graphics3D) {
        if (this.cameraDirty) {
            graphics3D.setCamera(this.camera, this.cameraTransform);
            this.cameraDirty = false;
        } else if (this.matrixDirty) {
            this.updateCameraTransform();
            this.cameraTransform.set(this.cameraXForm);
            graphics3D.setCamera(this.camera, this.cameraTransform);
            this.matrixDirty = false;
        }
    }

    public void transformToScreen(float[] fArray) {
        if (this.matrixDirty) {
            this.updateCameraTransform();
            this.matrixDirty = false;
        }
        fArray[0] = fArray[0] - this.cameraXForm[3];
        fArray[1] = fArray[1] - this.cameraXForm[7];
        fArray[2] = fArray[2] - this.cameraXForm[11];
        this.cameraTransform.set(this.cameraXForm);
        this.cameraTransform.transpose();
        this.cameraTransform.transform(fArray);
        this.camera.getProjection(this.projectionTransform);
        this.projectionTransform.transform(fArray);
        fArray[0] = fArray[0] / fArray[3];
        fArray[1] = fArray[1] / fArray[3];
        fArray[2] = fArray[2] / fArray[3];
        fArray[0] = fArray[0] * (float)(S3dEngine.viewport_width / 2);
        fArray[0] = fArray[0] + (float)(S3dEngine.viewport_width / 2 + S3dEngine.viewport_x);
        fArray[1] = fArray[1] * (float)(-S3dEngine.viewport_height / 2);
        fArray[1] = fArray[1] + (float)(S3dEngine.viewport_height / 2 + S3dEngine.viewport_y);
    }

    public void moveCameraPosition(float f, float f2, float f3, int n) {
        this.cameraXForm[3] = this.cameraXForm[3] * (float)n + f;
        this.cameraXForm[7] = this.cameraXForm[7] * (float)n + f2;
        this.cameraXForm[11] = this.cameraXForm[11] * (float)n + f3;
        this.matrixDirty = true;
    }

    public void getCameraPosition(float[] fArray) {
        fArray[0] = this.cameraXForm[3];
        fArray[1] = this.cameraXForm[7];
        fArray[2] = this.cameraXForm[11];
    }

    public int getProjection(float[] fArray) {
        return this.camera.getProjection(fArray);
    }

    public int getProjection(Transform transform) {
        return this.camera.getProjection(transform);
    }

    public int getProjection(S3dTransform s3dTransform) {
        return this.camera.getProjection(s3dTransform.xform);
    }

    public void setCameraLookAt(float f, float f2, float f3) {
        this.cameraLookAt[0] = f;
        this.cameraLookAt[1] = f2;
        this.cameraLookAt[2] = f3;
        this.matrixDirty = true;
    }

    public void setCameraLookAt(float[] fArray) {
        this.cameraLookAt[0] = fArray[0];
        this.cameraLookAt[1] = fArray[1];
        this.cameraLookAt[2] = fArray[2];
        this.matrixDirty = true;
    }

    public void translate(float f, float f2, float f3) {
        this.moveCameraPosition(f, f2, f3, 0);
        this.setCameraLookAt(forward[0] + f, forward[1] + f2, forward[2] + f3);
    }

    public void getCameraLookAt(float[] fArray) {
        fArray[0] = this.cameraLookAt[0];
        fArray[1] = this.cameraLookAt[1];
        fArray[2] = this.cameraLookAt[2];
    }

    public void setCameraUpVector(float f, float f2, float f3) {
        this.cameraUpVector[0] = f;
        this.cameraUpVector[1] = f2;
        this.cameraUpVector[2] = f3;
        this.matrixDirty = true;
    }

    public void setCameraTransform(float[] fArray) {
        System.arraycopy(fArray, 0, this.cameraXForm, 0, 16);
        this.cameraUpVector[0] = fArray[1];
        this.cameraUpVector[1] = fArray[5];
        this.cameraUpVector[2] = fArray[9];
        this.cameraLookAt[0] = fArray[3] - fArray[2];
        this.cameraLookAt[1] = fArray[7] - fArray[6];
        this.cameraLookAt[2] = fArray[11] - fArray[10];
        this.matrixDirty = true;
    }

    protected void updateCameraTransform() {
        S3dCamera.forward[0] = this.cameraLookAt[0] - this.cameraXForm[3];
        S3dCamera.forward[1] = this.cameraLookAt[1] - this.cameraXForm[7];
        S3dCamera.forward[2] = this.cameraLookAt[2] - this.cameraXForm[11];
        GluVector3f.normalize(forward);
        GluVector3f.cross(forward, this.cameraUpVector, side);
        GluVector3f.normalize(side);
        GluVector3f.cross(side, forward, up);
        this.cameraXForm[0] = side[0];
        this.cameraXForm[4] = side[1];
        this.cameraXForm[8] = side[2];
        this.cameraXForm[1] = up[0];
        this.cameraXForm[5] = up[1];
        this.cameraXForm[9] = up[2];
        this.cameraXForm[2] = -forward[0];
        this.cameraXForm[6] = -forward[1];
        this.cameraXForm[10] = -forward[2];
    }

    public int getCameraAngleXZ() {
        float f = this.cameraXForm[3] - this.cameraLookAt[0];
        float f2 = this.cameraXForm[11] - this.cameraLookAt[2];
        return (int)(GluFloat.atan2(f, f2) * 57.29578f);
    }

    public int getCameraAngleRY() {
        float f = this.cameraXForm[3] - this.cameraLookAt[0];
        float f2 = this.cameraXForm[7] - this.cameraLookAt[1];
        float f3 = this.cameraXForm[11] - this.cameraLookAt[2];
        float f4 = GluFloat.sqrt(f * f + f3 * f3);
        return (int)(GluFloat.atan2(f2, f4) * 57.29578f);
    }

    public void rotateCamera(int n, int n2) {
        this.cameraLookAt[0] = this.cameraLookAt[0] + (float)n * axisList[n2 + 0];
        this.cameraLookAt[1] = this.cameraLookAt[1] + (float)n * axisList[n2 + 1];
        this.cameraLookAt[2] = this.cameraLookAt[2] + (float)n * axisList[n2 + 2];
        this.matrixDirty = true;
    }
}

