/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LlamaSong
extends Visual {
    private Image m_fireImg;
    Graphics g;
    Random rand;
    int centerX;
    int centerY;
    int count;
    int[][] palette;
    int thickness = 1;
    int[] xPoints;
    int[] yPoints;
    int[] simp1;
    int numClrs = 256;
    int curClr = 0;
    int clrIncr = 1;
    int clrLimit = this.numClrs - this.clrIncr;
    int numSamples;
    int numCircuits;
    int total;
    int frequency;
    int offset;
    int offsetLimit;
    int offsetIncr;
    boolean drawOut = true;
    boolean screenDone = true;
    boolean lineEffect;
    boolean pointEffect;
    int effectType = 0;
    int[] polysX;
    int[] polysY;
    int numPolys = 150;
    int colour;

    public void init(String args) {
        if (s_screenWidth >= 220) {
            AstralEffects.setloopDelay(20);
        } else if (s_screenWidth < 220 && s_screenWidth >= 160) {
            AstralEffects.setloopDelay(40);
        } else {
            AstralEffects.setloopDelay(60);
        }
        this.m_fireImg = Image.createImage((int)s_screenWidth, (int)s_screenHeight);
        this.g = this.m_fireImg.getGraphics();
        this.rand = new Random(System.currentTimeMillis());
        this.simp1 = new int[3];
        this.centerX = s_screenWidth / 2;
        this.centerY = s_screenHeight / 2;
        this.SetUpPalette();
        this.polysX = new int[this.numPolys];
        this.polysY = new int[this.numPolys];
    }

    private void reset() {
        if (this.screenDone) {
            this.screenDone = false;
            this.offset = 10 * (RandomLibrary.Intervall(this.rand, 0, 21) - 10);
            if (RandomLibrary.Intervall(this.rand, 0, 10) > 5) {
                this.drawOut = true;
            } else {
                this.drawOut = false;
                this.offsetLimit = 0;
            }
            if (this.count < 2) {
                this.g.setColor(0, 0, 0);
                this.g.fillRect(0, 0, s_screenWidth, s_screenHeight);
            }
            this.frequency = 5 + RandomLibrary.Intervall(this.rand, 0, 100);
            this.thickness = 1 + RandomLibrary.Intervall(this.rand, 0, 20) / 10;
            this.numSamples = 25;
            this.numCircuits = RandomLibrary.Intervall(this.rand, 0, 26) + 10;
            this.offsetIncr = 3 + RandomLibrary.Intervall(this.rand, 0, 8);
            this.effectType = RandomLibrary.Intervall(this.rand, 0, 30) / 10;
            if (RandomLibrary.Intervall(this.rand, 0, 10) > 5) {
                this.lineEffect = true;
                this.pointEffect = RandomLibrary.Intervall(this.rand, 0, 10) > 7;
                this.g.setColor(0, 0, 0);
                this.g.fillRect(0, 0, s_screenWidth, s_screenHeight);
            } else {
                this.lineEffect = true;
                this.numPolys = this.numCircuits / 35;
                if (this.numPolys == 0) {
                    this.numPolys = 1;
                }
            }
            this.clrLimit = this.numClrs - this.clrIncr;
        }
    }

    protected void paint() {
        ++this.count;
        this.reset();
        int incr = 360 / (this.numSamples * this.thickness);
        int angle = 0;
        int limit = this.numSamples * this.numCircuits + 1;
        int oldx = 0;
        int oldy = 0;
        int Moffset = this.offset < 0 ? 0 - this.offset : this.offset;
        int tempVal = 1 + Moffset / 10;
        int xScale = this.centerX / tempVal;
        int yScale = this.centerY / tempVal;
        int tempVal2 = 0;
        for (int i = 0; i < limit; ++i) {
            if (this.lineEffect && i % this.numCircuits == 0) {
                this.g.setColor(this.palette[this.curClr][0], this.palette[this.curClr][1], this.palette[this.curClr][2]);
                this.curClr += this.clrIncr;
                if (this.curClr >= this.clrLimit) {
                    this.curClr -= this.clrLimit;
                }
            }
            switch (this.effectType) {
                case 0: {
                    tempVal2 = 10000 * this.offset + TrigLookupTable.getSinus(angle * this.frequency);
                    break;
                }
                case 1: {
                    tempVal2 = 10000 * this.offset + TrigLookupTable.getCosinus(angle * this.frequency);
                    break;
                }
                case 2: {
                    tempVal2 = i % 2 == 0 ? 10000 * this.offset + TrigLookupTable.getSinus(angle * this.frequency) : 10000 * this.offset + TrigLookupTable.getCosinus(angle * this.frequency);
                }
            }
            int xRadius = (int)((long)xScale * (long)tempVal2 / 100000L);
            int yRadius = (int)((long)yScale * (long)tempVal2 / 100000L);
            int x = this.centerX + (int)((long)xRadius * (long)TrigLookupTable.getCosinus(angle) / 100000L);
            int y = this.centerY + (int)((long)yRadius * (long)TrigLookupTable.getSinus(angle) / 100000L);
            if (this.lineEffect) {
                if (this.pointEffect) {
                    this.g.fillArc(x - 3, y - 3, 4, 4, 0, 360);
                } else {
                    if (i > 0) {
                        this.g.drawLine(oldx, oldy, x, y);
                    }
                    oldx = x;
                    oldy = y;
                }
            } else {
                this.polysX[i] = x;
                this.polysY[i] = y;
            }
            angle += incr;
        }
        if (this.drawOut) {
            this.offset += this.offsetIncr;
            if (this.offset >= this.offsetLimit) {
                this.screenDone = true;
            }
        } else {
            this.offset -= this.offsetIncr;
            if (this.offset <= this.offsetLimit) {
                this.screenDone = true;
            }
        }
        this.paintCommands(this.g);
    }

    private void SetUpPalette() {
        int i;
        this.palette = new int[this.numClrs][3];
        int r = 255;
        int g = 0;
        int b = 0;
        for (i = 0; i <= 50; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            g += 5;
        }
        r = 255;
        g = 255;
        b = 0;
        for (i = 51; i <= 101; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            r -= 5;
        }
        r = 0;
        g = 255;
        b = 0;
        for (i = 102; i <= 152; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            g -= 5;
            b += 5;
        }
        r = 0;
        g = 0;
        b = 255;
        for (i = 153; i <= 203; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            r += 5;
        }
        r = 255;
        g = 0;
        b = 255;
        for (i = 204; i <= 255; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            b -= 5;
        }
    }

    public void garbageCollect() {
        this.m_fireImg = null;
        this.rand = null;
        this.simp1 = null;
        this.polysX = null;
        this.polysY = null;
        this.palette = null;
    }

    public void manageKeyPress(int keyCode) {
        boolean handled = true;
    }

    public void paintVisual() {
        this.paint();
    }

    public Image getImage() {
        return this.m_fireImg;
    }
}

