/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Settings {
    private static final String RS_SETTINGS = "settings";
    public static boolean bMusic;
    public static int iMusicVol;
    public static boolean bSounds;
    public static int iSoundsVol;
    public static boolean bVibration;
    private static RecordStore rsobj_settings;

    private static void defaultSettings() {
        bMusic = true;
        iMusicVol = 100;
    }

    private static void createSettings() {
        try {
            rsobj_settings = RecordStore.openRecordStore((String)RS_SETTINGS, (boolean)true);
            if (rsobj_settings.getNumRecords() == 0) {
                ByteArrayOutputStream array = new ByteArrayOutputStream();
                DataOutputStream data = new DataOutputStream(array);
                data.writeBoolean(bMusic);
                data.writeByte(iMusicVol);
                rsobj_settings.addRecord(array.toByteArray(), 0, array.toByteArray().length);
            }
            rsobj_settings.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadSettings() {
        boolean loaded = true;
        try {
            rsobj_settings = RecordStore.openRecordStore((String)RS_SETTINGS, (boolean)false);
            RecordEnumeration enumeration = rsobj_settings.enumerateRecords(null, null, false);
            int i = enumeration.nextRecordId();
            byte[] record = rsobj_settings.getRecord(i);
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(record));
            bMusic = data.readBoolean();
            iMusicVol = data.readByte();
            rsobj_settings.closeRecordStore();
        }
        catch (Exception e) {
            loaded = false;
        }
        if (!loaded) {
            Settings.defaultSettings();
            Settings.createSettings();
        }
    }

    public static void saveSettings() {
        try {
            rsobj_settings = RecordStore.openRecordStore((String)RS_SETTINGS, (boolean)false);
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            data.writeBoolean(bMusic);
            data.writeByte(iMusicVol);
            rsobj_settings.setRecord(1, array.toByteArray(), 0, array.toByteArray().length);
            rsobj_settings.closeRecordStore();
            array = null;
            Object var1_2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

