/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import org.jpc.emulator.memory.CodeBlockMemory;
import org.jpc.emulator.memory.LazyMemory;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.MemoryManager;
import org.jpc.emulator.memory.codeblock.BlankCodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;

public class LazyCodeBlockMemory
extends LazyMemory
implements CodeBlockMemory {
    private static final CodeBlock PLACEHOLDER = new BlankCodeBlock(0, 0);
    protected CodeBlock[] codeBuffer;

    public LazyCodeBlockMemory(Memory memory) {
        super((int)memory.getSize());
        if (memory.getSize() > 0x2000000L) {
            throw new IllegalStateException("Cannot create code block of size " + memory.getSize());
        }
        this.constructCodeBlocksArray();
        byte[] byArray = new byte[(int)memory.getSize()];
        memory.copyContentsInto(0, byArray, 0, byArray.length);
        this.copyContentsFrom(0, byArray, 0, byArray.length);
    }

    public LazyCodeBlockMemory(byte[] byArray) {
        super(byArray);
        this.constructCodeBlocksArray();
    }

    public LazyCodeBlockMemory(int n) {
        super(n);
        this.constructCodeBlocksArray();
    }

    protected void constructCodeBlocksArray() {
        this.codeBuffer = MemoryManager.getInstance().getCodeBlockCacheArray(this);
    }

    public void relinquishCache() {
        this.codeBuffer = null;
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        try {
            return (RealModeCodeBlock)this.codeBuffer[n];
        }
        catch (ClassCastException classCastException) {
            return MemoryManager.getInstance().getRealModeCodeBlockAt(this, n);
        }
        catch (NullPointerException nullPointerException) {
            this.constructCodeBlocksArray();
            return MemoryManager.getInstance().getRealModeCodeBlockAt(this, n);
        }
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        try {
            return (ProtectedModeCodeBlock)this.codeBuffer[n];
        }
        catch (ClassCastException classCastException) {
            return MemoryManager.getInstance().getProtectedModeCodeBlockAt(this, n);
        }
        catch (NullPointerException nullPointerException) {
            this.constructCodeBlocksArray();
            return MemoryManager.getInstance().getProtectedModeCodeBlockAt(this, n);
        }
    }

    private void removeCodeBlockAt(int n) {
        int n2;
        CodeBlock codeBlock = this.codeBuffer[n];
        if (codeBlock == null || codeBlock == PLACEHOLDER) {
            return;
        }
        this.codeBuffer[n] = null;
        int n3 = codeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.codeBuffer.length; ++n2) {
            if (this.codeBuffer[n2] != PLACEHOLDER) continue;
            this.codeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.codeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.codeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.codeBuffer[n2] == PLACEHOLDER) continue;
            CodeBlock codeBlock2 = this.codeBuffer[n2];
            n3 = codeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.codeBuffer.length; ++i) {
                if (this.codeBuffer[i] != null) continue;
                this.codeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    public void setCodeBlockAt(int n, CodeBlock codeBlock) {
        if (this.codeBuffer == null) {
            return;
        }
        this.removeCodeBlockAt(n);
        if (codeBlock == null) {
            return;
        }
        this.codeBuffer[n] = codeBlock;
        int n2 = codeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.codeBuffer.length; ++i) {
            if (this.codeBuffer[i] != null) continue;
            this.codeBuffer[i] = PLACEHOLDER;
        }
    }

    protected void regionAltered(int n, int n2) {
        if (this.codeBuffer == null) {
            return;
        }
        for (int i = n2; i >= 0; --i) {
            CodeBlock codeBlock = this.codeBuffer[i];
            if (codeBlock == null) {
                if (i >= n) continue;
                break;
            }
            if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
            this.removeCodeBlockAt(i);
        }
    }

    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        super.copyContentsFrom(n, byArray, n2, n3);
        this.regionAltered(n, n + n3 - 1);
    }

    public void setByte(int n, byte by) {
        if (super.getByte(n) == by) {
            return;
        }
        super.setByte(n, by);
        this.regionAltered(n, n);
    }

    public void setWord(int n, short s) {
        if (super.getWord(n) == s) {
            return;
        }
        super.setWord(n, s);
        this.regionAltered(n, n + 1);
    }

    public void setDoubleWord(int n, int n2) {
        if (super.getDoubleWord(n) == n2) {
            return;
        }
        super.setDoubleWord(n, n2);
        this.regionAltered(n, n + 3);
    }

    public void clear() {
        this.constructCodeBlocksArray();
        super.clear();
    }

    public String toString() {
        return "LazyCodeBlockMemory[" + this.getSize() + "]";
    }
}

