/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import org.jpc.emulator.memory.AbstractMemory;
import org.jpc.emulator.memory.MemoryManager;
import org.jpc.emulator.memory.codeblock.CodeBlockTrigger;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;

public class LazyMemory
extends AbstractMemory {
    private int size;
    private byte[] buffer;
    private CodeBlockTrigger trigger;

    public LazyMemory(int n) {
        this.size = n;
        this.buffer = null;
        this.trigger = null;
    }

    public LazyMemory(byte[] byArray) {
        this.size = byArray.length;
        this.buffer = byArray;
    }

    public boolean isCacheable() {
        return true;
    }

    private final void allocateBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.size];
        }
    }

    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }
    }

    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
    }

    public long getSize() {
        return this.size;
    }

    public byte getByte(int n) {
        try {
            return this.buffer[n];
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            return this.buffer[n];
        }
    }

    public void setByte(int n, byte by) {
        try {
            this.buffer[n] = by;
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = by;
        }
    }

    public short getWord(int n) {
        try {
            int n2 = 0xFF & this.buffer[n];
            return (short)(n2 |= this.buffer[++n] << 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            int n3 = 0xFF & this.buffer[n];
            return (short)(n3 |= this.buffer[++n] << 8);
        }
    }

    public int getDoubleWord(int n) {
        try {
            int n2 = 0xFF & this.buffer[n];
            n2 |= (0xFF & this.buffer[++n]) << 8;
            n2 |= (0xFF & this.buffer[++n]) << 16;
            return n2 |= this.buffer[++n] << 24;
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            int n3 = 0xFF & this.buffer[n];
            n3 |= (0xFF & this.buffer[++n]) << 8;
            n3 |= (0xFF & this.buffer[++n]) << 16;
            return n3 |= this.buffer[++n] << 24;
        }
    }

    public void setWord(int n, short s) {
        try {
            this.buffer[n] = (byte)s;
            this.buffer[++n] = (byte)(s >> 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = (byte)s;
            this.buffer[++n] = (byte)(s >> 8);
        }
    }

    public void setDoubleWord(int n, int n2) {
        try {
            this.buffer[n] = (byte)n2;
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = (byte)n2;
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
        }
    }

    public void clear() {
        this.buffer = null;
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        if (this.trigger == null) {
            this.trigger = new CodeBlockTrigger(MemoryManager.getInstance().convertMemory(this));
        }
        return this.trigger;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        if (this.trigger == null) {
            this.trigger = new CodeBlockTrigger(MemoryManager.getInstance().convertMemory(this));
        }
        return this.trigger;
    }

    public String toString() {
        return "LazyMemory[" + this.getSize() + "] {Allocated=" + (this.buffer != null) + "}";
    }
}

