/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.MemoryManager;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;

public final class PhysicalAddressSpace
extends AddressSpace
implements HardwareComponent {
    private static final int GATEA20_MASK = -1048577;
    private static final int QUICK_INDEX_SIZE = 1024;
    private static final int TOP_INDEX_BITS = 10;
    private static final int BOTTOM_INDEX_BITS = 10;
    private static final int TOP_INDEX_SHIFT = 22;
    private static final int TOP_INDEX_SIZE = 1024;
    private static final int TOP_INDEX_MASK = 1023;
    private static final int BOTTOM_INDEX_SHIFT = 12;
    private static final int BOTTOM_INDEX_SIZE = 1024;
    private static final int BOTTOM_INDEX_MASK = 1023;
    private boolean gateA20Masked;
    private int mappedRegionCount = 0;
    private Memory[] quickNonA20MaskedIndex = new Memory[1024];
    private Memory[] quickA20MaskedIndex;
    private Memory[] quickIndex;
    private Memory[][] nonA20MaskedIndex;
    private Memory[][] a20MaskedIndex;
    private Memory[][] index;
    public static final Memory UNCONNECTED = new UnconnectedMemoryBlock();
    private LinearAddressSpace linearAddr;
    private MemoryManager memoryManager;

    public PhysicalAddressSpace() {
        PhysicalAddressSpace.clearArray(this.quickNonA20MaskedIndex, UNCONNECTED);
        this.quickA20MaskedIndex = new Memory[1024];
        PhysicalAddressSpace.clearArray(this.quickA20MaskedIndex, UNCONNECTED);
        this.nonA20MaskedIndex = new Memory[1024][];
        this.a20MaskedIndex = new Memory[1024][];
        this.setGateA20State(false);
    }

    public void setGateA20State(boolean bl) {
        this.gateA20Masked = bl;
        if (bl) {
            this.quickIndex = this.quickNonA20MaskedIndex;
            this.index = this.nonA20MaskedIndex;
        } else {
            this.quickIndex = this.quickA20MaskedIndex;
            this.index = this.a20MaskedIndex;
        }
        if (this.linearAddr != null && !this.linearAddr.pagingDisabled()) {
            this.linearAddr.flush();
        }
    }

    public boolean getGateA20State() {
        return this.gateA20Masked;
    }

    public int getAllocatedBufferSize() {
        return this.mappedRegionCount * 4096;
    }

    public Memory getReadMemoryBlockAt(int n) {
        return this.getMemoryBlockAt(n);
    }

    public Memory getWriteMemoryBlockAt(int n) {
        return this.getMemoryBlockAt(n);
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        Memory memory = this.getReadMemoryBlockAt(n);
        return memory.getRealModeCodeBlockAt(n & 0xFFF);
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    void replaceBlocks(Memory memory, Memory memory2) {
        Memory[] memoryArray;
        int n;
        for (n = 0; n < this.quickA20MaskedIndex.length; ++n) {
            if (this.quickA20MaskedIndex[n] != memory) continue;
            this.quickA20MaskedIndex[n] = memory2;
        }
        for (n = 0; n < this.quickNonA20MaskedIndex.length; ++n) {
            if (this.quickNonA20MaskedIndex[n] != memory) continue;
            this.quickNonA20MaskedIndex[n] = memory2;
        }
        for (n = 0; n < this.a20MaskedIndex.length; ++n) {
            memoryArray = this.a20MaskedIndex[n];
            try {
                for (int i = 0; i < memoryArray.length; ++i) {
                    if (memoryArray[i] != memory) continue;
                    memoryArray[i] = memory2;
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.nonA20MaskedIndex.length; ++n) {
            memoryArray = this.nonA20MaskedIndex[n];
            try {
                for (int i = 0; i < memoryArray.length; ++i) {
                    if (memoryArray[i] != memory) continue;
                    memoryArray[i] = memory2;
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void clear() {
        int n;
        for (n = 0; n < this.quickNonA20MaskedIndex.length; ++n) {
            this.quickNonA20MaskedIndex[n].clear();
        }
        for (n = 0; n < this.nonA20MaskedIndex.length; ++n) {
            Memory[] memoryArray = this.nonA20MaskedIndex[n];
            try {
                for (int i = 0; i < memoryArray.length; ++i) {
                    try {
                        memoryArray[i].clear();
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void unmap(int n, int n2) {
        if (n % 4096 != 0) {
            throw new IllegalStateException("Cannot deallocate memory starting at " + Integer.toHexString(n) + "; this is not block aligned at " + 4096 + " boundaries");
        }
        if (n2 % 4096 != 0) {
            throw new IllegalStateException("Cannot deallocate memory in partial blocks. " + n2 + " is not a multiple of " + 4096);
        }
        for (int i = n; i < n + n2; i += 4096) {
            if (this.getMemoryBlockAt(i) != UNCONNECTED) {
                --this.mappedRegionCount;
            }
            this.setMemoryBlockAt(i, UNCONNECTED);
        }
    }

    public void mapMemoryRegion(Memory memory, int n, int n2) {
        if (memory.getSize() < (long)n2) {
            throw new IllegalStateException("Underlying memory (length=" + memory.getSize() + ") is too short for mapping into region " + n2 + " bytes long");
        }
        if (n % 4096 != 0) {
            throw new IllegalStateException("Cannot map memory starting at " + Integer.toHexString(n) + "; this is not aligned to " + 4096 + " blocks");
        }
        if (n2 % 4096 != 0) {
            throw new IllegalStateException("Cannot map memory in partial blocks: " + n2 + " is not a multiple of " + 4096);
        }
        this.unmap(n, n2);
        long l = 0xFFFFFFFFL & (long)n;
        int n3 = n2 / 4096;
        for (long i = l; i < l + (long)n2; i += 4096L) {
            MapWrapper mapWrapper = new MapWrapper(memory, (int)(i - l));
            this.setMemoryBlockAt((int)i, mapWrapper);
            ++this.mappedRegionCount;
        }
    }

    public void allocateMemory(int n, Memory memory) {
        if (n % 4096 != 0) {
            throw new IllegalStateException("Cannot allocate memory starting at " + Integer.toHexString(n) + "; this is not aligned to " + 4096 + " blocks");
        }
        if (memory.getSize() != 4096L) {
            throw new IllegalStateException("Can only allocate memory in blocks of 4096");
        }
        this.unmap(n, 4096);
        long l = 0xFFFFFFFFL & (long)n;
        this.setMemoryBlockAt((int)l, memory);
        ++this.mappedRegionCount;
    }

    public void reset() {
        this.clear();
        this.setGateA20State(false);
        this.linearAddr = null;
        this.memoryManager = null;
    }

    public boolean initialised() {
        return this.linearAddr != null && this.memoryManager != null;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddr = (LinearAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof MemoryManager) {
            this.memoryManager = (MemoryManager)hardwareComponent;
        }
    }

    public String toString() {
        return "Physical Address Bus";
    }

    private Memory getMemoryBlockAt(int n) {
        try {
            return this.quickIndex[n >>> 12];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                return this.index[n >>> 22][n >>> 12 & 0x3FF];
            }
            catch (NullPointerException nullPointerException) {
                return UNCONNECTED;
            }
        }
    }

    private void setMemoryBlockAt(int n, Memory memory) {
        block9: {
            try {
                int n2 = n >>> 12;
                this.quickNonA20MaskedIndex[n2] = memory;
                if ((n2 & 0xFFEFF) == n2) {
                    this.quickA20MaskedIndex[n2] = memory;
                    this.quickA20MaskedIndex[n2 | 0x100] = memory;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    this.nonA20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.nonA20MaskedIndex[n >>> 22] = new Memory[1024];
                    this.nonA20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                if ((n & 0xFFEFFFFF) != n) break block9;
                try {
                    this.a20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.a20MaskedIndex[n >>> 22] = new Memory[1024];
                    this.a20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                int n3 = n | 0x100000;
                try {
                    this.a20MaskedIndex[n3 >>> 22][n3 >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.a20MaskedIndex[n3 >>> 22] = new Memory[1024];
                    this.a20MaskedIndex[n3 >>> 22][n3 >>> 12 & 0x3FF] = memory;
                }
            }
        }
    }

    public static final class UnconnectedMemoryBlock
    implements Memory {
        public void clear() {
        }

        public void clear(int n, int n2) {
        }

        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        }

        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            n3 = Math.min(4096 - n, Math.min(byArray.length - n2, n3));
            for (int i = n2; i < n3; ++i) {
                byArray[i] = this.getByte(0);
            }
        }

        public long getSize() {
            return 4096L;
        }

        public byte getByte(int n) {
            return -1;
        }

        public short getWord(int n) {
            return -1;
        }

        public int getDoubleWord(int n) {
            return -1;
        }

        public long getQuadWord(int n) {
            return -1L;
        }

        public long getLowerDoubleQuadWord(int n) {
            return -1L;
        }

        public long getUpperDoubleQuadWord(int n) {
            return -1L;
        }

        public void setByte(int n, byte by) {
        }

        public void setWord(int n, short s) {
        }

        public void setDoubleWord(int n, int n2) {
        }

        public void setQuadWord(int n, long l) {
        }

        public void setLowerDoubleQuadWord(int n, long l) {
        }

        public void setUpperDoubleQuadWord(int n, long l) {
        }

        public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
            throw new IllegalStateException("Trying to decode in Unconnected Block");
        }

        public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
            throw new IllegalStateException("Trying to decode in Unconnected Block");
        }
    }

    public class MapWrapper
    implements Memory {
        private Memory memory;
        private int baseAddress;

        MapWrapper(Memory memory, int n) {
            this.baseAddress = n;
            this.memory = memory;
        }

        public long getSize() {
            return 4096L;
        }

        public void clear() {
            this.memory.clear(this.baseAddress, (int)this.getSize());
        }

        public void clear(int n, int n2) {
            if ((long)(n + n2) > this.getSize()) {
                throw new ArrayIndexOutOfBoundsException("Attempt to clear outside of memory bounds");
            }
            n = this.baseAddress | n;
            this.memory.clear(n, n2);
        }

        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
            n = this.baseAddress | n;
            this.memory.copyContentsInto(n, byArray, n2, n3);
        }

        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            n = this.baseAddress | n;
            this.memory.copyContentsFrom(n, byArray, n2, n3);
        }

        public byte getByte(int n) {
            n = this.baseAddress | n;
            return this.memory.getByte(n);
        }

        public short getWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getWord(n);
        }

        public int getDoubleWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getDoubleWord(n);
        }

        public long getQuadWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        public long getLowerDoubleQuadWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        public long getUpperDoubleQuadWord(int n) {
            n += 8;
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        public void setByte(int n, byte by) {
            n = this.baseAddress | n;
            this.memory.setByte(n, by);
        }

        public void setWord(int n, short s) {
            n = this.baseAddress | n;
            this.memory.setWord(n, s);
        }

        public void setDoubleWord(int n, int n2) {
            n = this.baseAddress | n;
            this.memory.setDoubleWord(n, n2);
        }

        public void setQuadWord(int n, long l) {
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        public void setLowerDoubleQuadWord(int n, long l) {
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        public void setUpperDoubleQuadWord(int n, long l) {
            n += 8;
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
            n = this.baseAddress | n;
            return this.memory.getProtectedModeCodeBlockAt(n);
        }

        public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
            n = this.baseAddress | n;
            return this.memory.getRealModeCodeBlockAt(n);
        }
    }
}

