/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockReplacementException;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.processor.Processor;

public class CombiningRealCodeBlock
implements RealModeCodeBlock {
    private CodeBlock block0;
    private CodeBlock block1;
    private CodeBlock block2;
    private int x86Length = 0;
    private int block1Start;
    private int jumpSize;
    private boolean selfModified = false;

    public CombiningRealCodeBlock(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3, int n, int n2) {
        this.block0 = codeBlock;
        this.block1 = codeBlock2;
        this.block2 = codeBlock3;
        this.x86Length = n2 < codeBlock2.getX86Length() ? codeBlock.getX86Length() + codeBlock2.getX86Length() : codeBlock.getX86Length() + n2 + codeBlock3.getX86Length();
        this.block1Start = n + codeBlock.getX86Length();
        this.jumpSize = n2;
    }

    public int getX86Length() {
        return this.x86Length;
    }

    public int getX86Count() {
        return this.block0.getX86Count() + this.block1.getX86Count() + this.block2.getX86Count();
    }

    public void invalidate() {
        this.selfModified = true;
    }

    public synchronized int execute(Processor processor) {
        int n = 0;
        try {
            n += this.block0.execute(processor);
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            this.block0 = codeBlockReplacementException.getReplacement();
            n += this.block0.execute(processor);
        }
        if (this.selfModified) {
            return n;
        }
        int n2 = processor.getInstructionPointer() & 0xFFF;
        if (n2 == this.block1Start) {
            try {
                n += this.block1.execute(processor);
            }
            catch (CodeBlockReplacementException codeBlockReplacementException) {
                this.block1 = codeBlockReplacementException.getReplacement();
                n += this.block1.execute(processor);
            }
        } else if (n2 == this.block1Start + this.jumpSize) {
            try {
                n += this.block2.execute(processor);
            }
            catch (CodeBlockReplacementException codeBlockReplacementException) {
                this.block2 = codeBlockReplacementException.getReplacement();
                n += this.block2.execute(processor);
            }
        }
        return n;
    }

    public boolean handleMemoryRegionChange(int n, int n2) {
        this.invalidate();
        return false;
    }

    public String getDisplayString() {
        return "\nBlock0:\n" + this.block0.getDisplayString() + "\nBlock1:\n" + this.block1.getDisplayString() + "\nBlock2:\n" + this.block2.getDisplayString();
    }
}

