/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningCodeBlock;
import org.jpc.emulator.processor.Processor;

public class SpanningProtectedModeCodeBlock
extends SpanningCodeBlock
implements ProtectedModeCodeBlock {
    private static final ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningProtectedModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    protected CodeBlock decode(Processor processor) {
        ProtectedModeCodeBlock protectedModeCodeBlock = null;
        LinearAddressSpace linearAddressSpace = processor.linearMemory;
        int n = processor.getInstructionPointer();
        boolean bl = processor.cs.getDefaultSizeFlag();
        for (int i = 0; i < this.factories.length && protectedModeCodeBlock == null; ++i) {
            try {
                byteSource.set(linearAddressSpace, n);
                protectedModeCodeBlock = this.factories[i].getProtectedModeCodeBlock(byteSource, bl);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return protectedModeCodeBlock;
    }

    public String getDisplayString() {
        return "Spanning Protected Mode CodeBlock";
    }
}

