/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.basic;

import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.basic.FirstStageCodeBlock;
import org.jpc.emulator.memory.codeblock.basic.ProtectedModeDecoder;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.SegmentFactory;

public class ProtectedModeFirstStageCodeBlock
extends FirstStageCodeBlock
implements ProtectedModeCodeBlock {
    private static final ProcessorException exceptionBP = new ProcessorException(3, false);
    private static final ProcessorException exceptionOF = new ProcessorException(4, false);
    private static final ProcessorException exceptionBR = new ProcessorException(5, true);
    private static final ProcessorException exceptionDF = new ProcessorException(8, 0, true);
    private static final ProcessorException exceptionMF10 = new ProcessorException(16, true);
    private static final ProcessorException exceptionAC = new ProcessorException(17, 0, true);
    private static final ProcessorException exceptionMC = new ProcessorException(18, true);
    private static final ProcessorException exceptionXF = new ProcessorException(19, true);
    private boolean eipUpdated;

    public ProtectedModeFirstStageCodeBlock() {
    }

    public ProtectedModeFirstStageCodeBlock(int[] nArray, int[] nArray2) {
        super(nArray, nArray2);
    }

    public String toString() {
        return "ProtectedModeFirstStageCodeBlock";
    }

    public synchronized int execute(Processor processor) {
        this.cpu = processor;
        this.fpu = processor.fpu;
        int n = 0;
        this.executeCount = this.getX86Count();
        this.eipUpdated = false;
        try {
            this.microcodesPosition = 0;
            while (this.microcodesPosition < this.microcodes.length) {
                this.dispatchOpcode();
                n = this.microcodesPosition;
            }
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == -1) {
                throw new IllegalStateException("Execute Failed");
            }
            if (this.eipUpdated) {
                if (processorException.pointsToSelf()) {
                    processor.eip -= this.cumulativeX86Length[n];
                }
                if (n >= 2) {
                    processor.eip += this.cumulativeX86Length[n - 2];
                }
            } else {
                if (processorException.pointsToSelf()) {
                    this.microcodesPosition = n;
                }
                if (this.microcodesPosition > 0) {
                    this.eipUpdate();
                }
            }
            if (processorException.getVector() != 14) {
                System.out.println();
                System.out.println("EIP: 0x" + Integer.toHexString(processor.eip));
                processorException.printStackTrace();
            }
            processor.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
        return Math.max(this.executeCount, 0);
    }

    private final void dispatchOpcode() throws ProcessorException {
        switch (this.getMicrocode()) {
            case 262: {
                this.eipUpdate();
                return;
            }
            case 23: {
                this.aaa();
                return;
            }
            case 144: {
                this.aad();
                return;
            }
            case 143: {
                this.aam();
                return;
            }
            case 27: {
                this.aas();
                return;
            }
            case 6: {
                this.adc_o8();
                return;
            }
            case 8: {
                this.adc_o16();
                return;
            }
            case 7: {
                this.adc_o32();
                return;
            }
            case 0: {
                this.add_o8();
                return;
            }
            case 2: {
                this.add_o16();
                return;
            }
            case 1: {
                this.add_o32();
                return;
            }
            case 12: {
                this.and_o8();
                return;
            }
            case 14: {
                this.and_o16();
                return;
            }
            case 13: {
                this.and_o32();
                return;
            }
            case 631: {
                this.arpl();
                return;
            }
            case 51: {
                this.bound_o32_a32();
                return;
            }
            case 482: {
                this.bsf_o16();
                return;
            }
            case 483: {
                this.bsf_o32();
                return;
            }
            case 484: {
                this.bsr_o16();
                return;
            }
            case 485: {
                this.bsr_o32();
                return;
            }
            case 496: {
                this.bswap();
                return;
            }
            case 469: {
                this.bt_o16();
                return;
            }
            case 470: {
                this.bt_o32();
                return;
            }
            case 477: {
                this.bt_o16_o8();
                return;
            }
            case 478: {
                this.bt_o32_o8();
                return;
            }
            case 471: {
                this.btc_o16();
                return;
            }
            case 472: {
                this.btc_o32();
                return;
            }
            case 480: {
                this.btc_o32_o8();
                return;
            }
            case 465: {
                this.btr_o16();
                return;
            }
            case 466: {
                this.btr_o32();
                return;
            }
            case 474: {
                this.btr_o32_o8();
                return;
            }
            case 467: {
                this.bts_o16();
                return;
            }
            case 468: {
                this.bts_o32();
                return;
            }
            case 476: {
                this.bts_o32_o8();
                return;
            }
            case 201: 
            case 203: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.call_o32_a32();
                    return;
                }
                this.call_o32_a16();
                return;
            }
            case 200: 
            case 202: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.call_o16_a32();
                    return;
                }
                this.call_o16_a16();
                return;
            }
            case 89: 
            case 91: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.callf_o32_a32();
                return;
            }
            case 88: 
            case 90: {
                if (this.cpu.ss.getDefaultSizeFlag()) break;
                this.callf_o16_a16();
                return;
            }
            case 318: 
            case 320: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.calln_o32_a32();
                    return;
                }
                this.calln_o32_a16();
                return;
            }
            case 85: {
                this.cbw();
                return;
            }
            case 86: {
                this.cdq();
                return;
            }
            case 179: {
                this.clc();
                return;
            }
            case 183: {
                this.cld();
                return;
            }
            case 181: {
                this.cli();
                return;
            }
            case 178: {
                this.cmc();
                return;
            }
            case 449: {
                this.clts();
                return;
            }
            case 87: {
                this.cwd();
                return;
            }
            case 418: {
                this.cmovb_o32();
                return;
            }
            case 419: {
                this.cmovnb_o32();
                return;
            }
            case 422: {
                this.cmovbe_o32();
                return;
            }
            case 423: {
                this.cmovnbe_o32();
                return;
            }
            case 428: {
                this.cmovl_o32();
                return;
            }
            case 429: {
                this.cmovnl_o32();
                return;
            }
            case 430: {
                this.cmovle_o32();
                return;
            }
            case 431: {
                this.cmovnle_o32();
                return;
            }
            case 416: {
                this.cmovo_o32();
                return;
            }
            case 417: {
                this.cmovno_o32();
                return;
            }
            case 426: {
                this.cmovp_o32();
                return;
            }
            case 427: {
                this.cmovnp_o32();
                return;
            }
            case 424: {
                this.cmovs_o32();
                return;
            }
            case 425: {
                this.cmovns_o32();
                return;
            }
            case 420: {
                this.cmovz_o32();
                return;
            }
            case 421: {
                this.cmovnz_o32();
                return;
            }
            case 24: {
                this.cmp_o8();
                return;
            }
            case 26: {
                this.cmp_o16();
                return;
            }
            case 25: {
                this.cmp_o32();
                return;
            }
            case 191: {
                this.cmps_o8_a16();
                return;
            }
            case 192: {
                this.cmps_o16_a16();
                return;
            }
            case 193: {
                this.cmps_o32_a16();
                return;
            }
            case 359: {
                this.cmps_o8_a32();
                return;
            }
            case 360: {
                this.cmps_o16_a32();
                return;
            }
            case 361: {
                this.cmps_o32_a32();
                return;
            }
            case 492: {
                this.cmpxchg_o8();
                return;
            }
            case 493: {
                this.cmpxchg_o16();
                return;
            }
            case 494: {
                this.cmpxchg_o32();
                return;
            }
            case 495: {
                this.cmpxchg8b();
                return;
            }
            case 448: {
                this.cpuid();
                return;
            }
            case 84: {
                this.cwde();
                return;
            }
            case 15: {
                this.daa();
                return;
            }
            case 19: {
                this.das();
                return;
            }
            case 231: {
                this.dec_o8();
                return;
            }
            case 31: {
                this.dec_o16();
                return;
            }
            case 30: {
                this.dec_o32();
                return;
            }
            case 243: {
                this.div_o8();
                return;
            }
            case 233: {
                this.div_o16();
                return;
            }
            case 238: {
                this.div_o32();
                return;
            }
            case 112: 
            case 114: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.enter_o32_a32();
                return;
            }
            case 111: 
            case 113: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.enter_o16_a32();
                return;
            }
            case 602: {
                this.f2xm1();
                return;
            }
            case 592: {
                break;
            }
            case 557: {
                this.fadd();
                return;
            }
            case 497: {
                this.fadd_sr();
                return;
            }
            case 526: {
                this.fadd_dr();
                return;
            }
            case 582: {
                this.faddp();
                return;
            }
            case 553: {
                break;
            }
            case 555: {
                break;
            }
            case 591: {
                this.fchs();
                return;
            }
            case 619: {
                this.fclex();
                return;
            }
            case 567: {
                break;
            }
            case 571: {
                break;
            }
            case 569: {
                break;
            }
            case 573: {
                break;
            }
            case 568: {
                break;
            }
            case 572: {
                break;
            }
            case 570: {
                break;
            }
            case 574: {
                break;
            }
            case 559: {
                this.fcom();
                return;
            }
            case 499: {
                this.fcom_sr();
                return;
            }
            case 528: {
                this.fcom_dr();
                return;
            }
            case 576: {
                break;
            }
            case 589: {
                break;
            }
            case 560: {
                this.fcomp();
                return;
            }
            case 500: {
                this.fcomp_sr();
                return;
            }
            case 529: {
                this.fcomp_dr();
                return;
            }
            case 621: {
                this.fcompp();
                return;
            }
            case 617: {
                break;
            }
            case 608: {
                break;
            }
            case 563: {
                this.fdiv();
                return;
            }
            case 503: {
                this.fdiv_sr();
                return;
            }
            case 532: {
                this.fdiv_dr();
                return;
            }
            case 587: {
                this.fdivp();
                return;
            }
            case 564: {
                this.fdivr();
                return;
            }
            case 504: {
                this.fdivr_sr();
                return;
            }
            case 533: {
                this.fdivr_dr();
                return;
            }
            case 586: {
                this.fdivrp();
                return;
            }
            case 577: {
                break;
            }
            case 541: {
                break;
            }
            case 512: {
                break;
            }
            case 543: {
                break;
            }
            case 514: {
                break;
            }
            case 544: {
                break;
            }
            case 515: {
                break;
            }
            case 547: {
                break;
            }
            case 518: {
                break;
            }
            case 548: {
                this.fidivr_wi();
                return;
            }
            case 519: {
                this.fidivr_di();
                return;
            }
            case 549: {
                this.fild_wi();
                return;
            }
            case 520: {
                this.fild_di();
                return;
            }
            case 554: {
                this.fild_qi();
                return;
            }
            case 542: {
                break;
            }
            case 513: {
                break;
            }
            case 609: {
                break;
            }
            case 551: {
                this.fist_wi();
                return;
            }
            case 522: {
                this.fist_di();
                return;
            }
            case 552: {
                this.fistp_wi();
                return;
            }
            case 523: {
                this.fistp_di();
                return;
            }
            case 556: {
                this.fistp_qi();
                return;
            }
            case 550: {
                break;
            }
            case 521: {
                break;
            }
            case 535: {
                break;
            }
            case 545: {
                break;
            }
            case 516: {
                break;
            }
            case 546: {
                break;
            }
            case 517: {
                break;
            }
            case 565: {
                this.fld();
                return;
            }
            case 505: {
                this.fld_sr();
                return;
            }
            case 534: {
                this.fld_dr();
                return;
            }
            case 524: {
                break;
            }
            case 595: {
                this.fld1();
                return;
            }
            case 597: {
                break;
            }
            case 596: {
                break;
            }
            case 599: {
                break;
            }
            case 600: {
                break;
            }
            case 598: {
                break;
            }
            case 601: {
                this.fldz();
                return;
            }
            case 509: {
                this.fldcw();
                return;
            }
            case 558: {
                this.fmul();
                return;
            }
            case 498: {
                this.fmul_sr();
                return;
            }
            case 527: {
                this.fmul_dr();
                return;
            }
            case 583: {
                this.fmulp();
                return;
            }
            case 620: {
                this.fninit();
                return;
            }
            case 590: {
                break;
            }
            case 605: {
                break;
            }
            case 610: {
                this.fprem();
                return;
            }
            case 607: {
                this.fprem1();
                return;
            }
            case 604: {
                break;
            }
            case 614: {
                this.frndint();
                return;
            }
            case 615: {
                this.fscale();
                return;
            }
            case 616: {
                break;
            }
            case 613: {
                this.fsincos();
                return;
            }
            case 612: {
                this.fsqrt();
                return;
            }
            case 578: {
                break;
            }
            case 506: {
                break;
            }
            case 536: {
                this.fst_dr();
                return;
            }
            case 579: {
                this.fstp();
                return;
            }
            case 507: {
                this.fstp_sr();
                return;
            }
            case 537: {
                this.fstp_dr();
                return;
            }
            case 525: {
                break;
            }
            case 511: {
                this.fstcw();
                return;
            }
            case 540: {
                this.fstsw();
                return;
            }
            case 561: {
                this.fsub();
                return;
            }
            case 501: {
                this.fsub_sr();
                return;
            }
            case 530: {
                this.fsub_dr();
                return;
            }
            case 585: {
                this.fsubp();
                return;
            }
            case 562: {
                this.fsubr();
                return;
            }
            case 502: {
                this.fsubr_sr();
                return;
            }
            case 531: {
                this.fsubr_dr();
                return;
            }
            case 584: {
                this.fsubrp();
                return;
            }
            case 593: {
                this.ftst();
                return;
            }
            case 580: {
                this.fucom();
                return;
            }
            case 575: {
                break;
            }
            case 588: {
                break;
            }
            case 581: {
                this.fucomp();
                return;
            }
            case 618: {
                this.fucompp();
                return;
            }
            case 594: {
                break;
            }
            case 566: {
                this.fxch();
                return;
            }
            case 606: {
                break;
            }
            case 603: {
                this.fyl2x();
                return;
            }
            case 611: {
                this.fyl2xp1();
                return;
            }
            case 177: {
                this.hlt();
                return;
            }
            case 261: {
                this.idiv_o8();
                return;
            }
            case 232: {
                this.idiv_o16();
                return;
            }
            case 237: {
                this.idiv_o32();
                return;
            }
            case 53: {
                this.imul_o16();
                return;
            }
            case 52: {
                this.imul_o32();
                return;
            }
            case 376: {
                this.imul_rega_o8();
                return;
            }
            case 377: {
                this.imul_rega_o16();
                return;
            }
            case 378: {
                this.imul_rega_o32();
                return;
            }
            case 160: {
                this.in_o8_o8();
                return;
            }
            case 163: {
                this.in_o8_o16();
                return;
            }
            case 165: {
                this.in_o16_o16();
                return;
            }
            case 164: {
                this.in_o32_o16();
                return;
            }
            case 230: {
                this.inc_o8();
                return;
            }
            case 29: {
                this.inc_o16();
                return;
            }
            case 28: {
                this.inc_o32();
                return;
            }
            case 353: {
                this.ins_o8_a32();
                return;
            }
            case 354: {
                this.ins_o16_a32();
                return;
            }
            case 355: {
                this.ins_o32_a32();
                return;
            }
            case 134: {
                this.int_o32_a32();
                return;
            }
            case 632: {
                this.invd();
                return;
            }
            case 389: {
                this.invlpg();
                return;
            }
            case 140: 
            case 142: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.iret_o32_a32();
                return;
            }
            case 139: 
            case 141: {
                if (this.cpu.ss.getDefaultSizeFlag()) break;
                this.iret_o16_a16();
                return;
            }
            case 159: {
                this.jcxz_a32();
                return;
            }
            case 56: {
                this.jb_o8();
                return;
            }
            case 323: {
                this.jb_o16();
                return;
            }
            case 339: {
                this.jb_o32();
                return;
            }
            case 57: {
                this.jnb_o8();
                return;
            }
            case 324: {
                this.jnb_o16();
                return;
            }
            case 340: {
                this.jnb_o32();
                return;
            }
            case 60: {
                this.jbe_o8();
                return;
            }
            case 327: {
                this.jbe_o16();
                return;
            }
            case 343: {
                this.jbe_o32();
                return;
            }
            case 61: {
                this.jnbe_o8();
                return;
            }
            case 328: {
                this.jnbe_o16();
                return;
            }
            case 344: {
                this.jnbe_o32();
                return;
            }
            case 66: {
                this.jl_o8();
                return;
            }
            case 333: {
                this.jl_o16();
                return;
            }
            case 349: {
                this.jl_o32();
                return;
            }
            case 67: {
                this.jnl_o8();
                return;
            }
            case 334: {
                this.jnl_o16();
                return;
            }
            case 350: {
                this.jnl_o32();
                return;
            }
            case 68: {
                this.jle_o8();
                return;
            }
            case 335: {
                this.jle_o16();
                return;
            }
            case 351: {
                this.jle_o32();
                return;
            }
            case 69: {
                this.jnle_o8();
                return;
            }
            case 336: {
                this.jnle_o16();
                return;
            }
            case 352: {
                this.jnle_o32();
                return;
            }
            case 54: {
                this.jo_o8();
                return;
            }
            case 321: {
                this.jo_o16();
                return;
            }
            case 337: {
                this.jo_o32();
                return;
            }
            case 55: {
                this.jno_o8();
                return;
            }
            case 322: {
                this.jno_o16();
                return;
            }
            case 338: {
                this.jno_o32();
                return;
            }
            case 64: {
                this.jp_o8();
                return;
            }
            case 331: {
                this.jp_o16();
                return;
            }
            case 347: {
                this.jp_o32();
                return;
            }
            case 65: {
                this.jnp_o8();
                return;
            }
            case 332: {
                this.jnp_o16();
                return;
            }
            case 348: {
                this.jnp_o32();
                return;
            }
            case 62: {
                this.js_o8();
                return;
            }
            case 329: {
                this.js_o16();
                return;
            }
            case 345: {
                this.js_o32();
                return;
            }
            case 63: {
                this.jns_o8();
                return;
            }
            case 330: {
                this.jns_o16();
                return;
            }
            case 346: {
                this.jns_o32();
                return;
            }
            case 58: {
                this.jz_o8();
                return;
            }
            case 325: {
                this.jz_o16();
                return;
            }
            case 341: {
                this.jz_o32();
                return;
            }
            case 59: {
                this.jnz_o8();
                return;
            }
            case 326: {
                this.jnz_o16();
                return;
            }
            case 342: {
                this.jnz_o32();
                return;
            }
            case 172: {
                this.jmp_o8_short();
                return;
            }
            case 205: {
                this.jmp_o16_near_relative();
                return;
            }
            case 204: {
                this.jmp_o32_near_relative();
                return;
            }
            case 375: {
                this.jmp_o16_near_absolute();
                return;
            }
            case 374: {
                this.jmp_o32_near_absolute();
                return;
            }
            case 207: {
                this.jmp_o16_far();
                return;
            }
            case 206: {
                this.jmp_o32_far();
                return;
            }
            case 154: {
                this.loop_o16_a16();
                return;
            }
            case 157: {
                this.loop_o32_a32();
                return;
            }
            case 149: {
                this.loopnz_o32_a32();
                return;
            }
            case 77: {
                this.lea_o16_a16();
                return;
            }
            case 80: {
                this.lea_o32_a32();
                return;
            }
            case 116: 
            case 118: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.leave_o32_a32();
                    return;
                }
                this.leave_o32_a16();
                return;
            }
            case 115: 
            case 117: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.leave_o16_a32();
                    return;
                }
                this.leave_o16_a16();
                return;
            }
            case 381: {
                this.lgdt_o16();
                return;
            }
            case 382: {
                this.lgdt_o32();
                return;
            }
            case 385: {
                this.lidt_o16();
                return;
            }
            case 386: {
                this.lidt_o32();
                return;
            }
            case 453: {
                this.lldt();
                return;
            }
            case 388: {
                this.lmsw();
                return;
            }
            case 258: {
                this.lods_o8_a16();
                return;
            }
            case 259: {
                this.lods_o16_a16();
                return;
            }
            case 260: {
                this.lods_o32_a16();
                return;
            }
            case 371: {
                this.lods_o8_a32();
                return;
            }
            case 372: {
                this.lods_o16_a32();
                return;
            }
            case 373: {
                this.lods_o32_a32();
                return;
            }
            case 454: {
                this.ltr();
                return;
            }
            case 399: {
                this.lss_o32_a32();
                return;
            }
            case 74: {
                this.mov_o8();
                return;
            }
            case 76: {
                this.mov_o16();
                return;
            }
            case 75: {
                this.mov_o32();
                return;
            }
            case 188: {
                this.movs_o8_a16();
                return;
            }
            case 189: {
                this.movs_o16_a16();
                return;
            }
            case 356: {
                this.movs_o8_a32();
                return;
            }
            case 357: {
                this.movs_o16_a32();
                return;
            }
            case 358: {
                this.movs_o32_a32();
                return;
            }
            case 190: {
                this.movs_o32_a16();
                return;
            }
            case 457: {
                this.movsx_o16_o8();
                return;
            }
            case 458: {
                this.movsx_o32_o8();
                return;
            }
            case 459: {
                this.movsx_o16_o16();
                return;
            }
            case 460: {
                this.movsx_o32_o16();
                return;
            }
            case 392: {
                this.movzx_o16_o8();
                return;
            }
            case 393: {
                this.movzx_o32_o8();
                return;
            }
            case 394: {
                this.movzx_o16_o16();
                return;
            }
            case 395: {
                this.movzx_o32_o16();
                return;
            }
            case 390: {
                this.mov_to_cr_o32();
                return;
            }
            case 486: {
                this.mov_to_dr_o32();
                return;
            }
            case 391: {
                this.mov_to_seg();
                return;
            }
            case 244: {
                this.mul_o8();
                return;
            }
            case 234: {
                this.mul_o16();
                return;
            }
            case 239: {
                this.mul_o32();
                return;
            }
            case 245: {
                this.neg_o8();
                return;
            }
            case 235: {
                this.neg_o16();
                return;
            }
            case 240: {
                this.neg_o32();
                return;
            }
            case 81: {
                return;
            }
            case 246: {
                this.not_o8();
                return;
            }
            case 236: {
                this.not_o16();
                return;
            }
            case 241: {
                this.not_o32();
                return;
            }
            case 3: {
                this.or_o8();
                return;
            }
            case 5: {
                this.or_o16();
                return;
            }
            case 4: {
                this.or_o32();
                return;
            }
            case 166: {
                this.out_o8_o8();
                return;
            }
            case 169: {
                this.out_o16_o8();
                return;
            }
            case 171: {
                this.out_o16_o16();
                return;
            }
            case 170: {
                this.out_o16_o32();
                return;
            }
            case 368: {
                this.outs_o8_a32();
                return;
            }
            case 369: {
                this.outs_o16_a32();
                return;
            }
            case 370: {
                this.outs_o32_a32();
                return;
            }
            case 37: 
            case 39: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.pop_o32_a32();
                    return;
                }
                this.pop_o32_a16();
                return;
            }
            case 36: 
            case 38: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.pop_o16_a32();
                    return;
                }
                this.pop_o16_a16();
                return;
            }
            case 45: 
            case 47: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.popa_o32_a32();
                return;
            }
            case 44: 
            case 46: {
                if (this.cpu.ss.getDefaultSizeFlag()) break;
                this.popa_o16_a16();
                return;
            }
            case 98: 
            case 100: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.popf_o32_a32();
                    return;
                }
                this.popf_o32_a16();
                return;
            }
            case 97: 
            case 99: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.popf_o16_a32();
                return;
            }
            case 32: 
            case 34: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.push_o16_a32();
                    return;
                }
                this.push_o16_a16();
                return;
            }
            case 33: 
            case 35: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.push_o32_a32();
                    return;
                }
                this.push_o32_a16();
                return;
            }
            case 41: 
            case 43: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.pusha_o32_a32();
                return;
            }
            case 94: 
            case 96: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.pushf_o32_a32();
                    return;
                }
                this.pushf_o32_a16();
                return;
            }
            case 93: 
            case 95: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.pushf_o16_a32();
                    return;
                }
                this.pushf_o16_a16();
                return;
            }
            case 488: {
                this.rdmsr();
                return;
            }
            case 487: {
                this.rdtsc();
                return;
            }
            case 269: {
                this.repe_cmps_o8_a16();
                return;
            }
            case 270: {
                this.repe_cmps_o16_a16();
                return;
            }
            case 296: {
                this.repe_cmps_o8_a32();
                return;
            }
            case 297: {
                this.repe_cmps_o16_a32();
                return;
            }
            case 298: {
                this.repe_cmps_o32_a32();
                return;
            }
            case 299: {
                this.repne_cmps_o8_a32();
                return;
            }
            case 300: {
                this.repne_cmps_o16_a32();
                return;
            }
            case 301: {
                this.repne_cmps_o32_a32();
                return;
            }
            case 290: {
                this.rep_ins_o8_a32();
                return;
            }
            case 291: {
                this.rep_ins_o16_a32();
                return;
            }
            case 292: {
                this.rep_ins_o32_a32();
                return;
            }
            case 314: {
                this.rep_lods_o8_a32();
                return;
            }
            case 315: {
                this.rep_lods_o16_a32();
                return;
            }
            case 316: {
                this.rep_lods_o32_a32();
                return;
            }
            case 266: {
                this.rep_movs_o8_a16();
                return;
            }
            case 267: {
                this.rep_movs_o16_a16();
                return;
            }
            case 268: {
                this.rep_movs_o32_a16();
                return;
            }
            case 293: {
                this.rep_movs_o8_a32();
                return;
            }
            case 294: {
                this.rep_movs_o16_a32();
                return;
            }
            case 295: {
                this.rep_movs_o32_a32();
                return;
            }
            case 311: {
                this.rep_outs_o8_a32();
                return;
            }
            case 312: {
                this.rep_outs_o16_a32();
                return;
            }
            case 313: {
                this.rep_outs_o32_a32();
                return;
            }
            case 278: {
                this.repe_scas_o8_a16();
                return;
            }
            case 279: {
                this.repe_scas_o16_a16();
                return;
            }
            case 280: {
                this.repe_scas_o32_a16();
                return;
            }
            case 305: {
                this.repe_scas_o8_a32();
                return;
            }
            case 306: {
                this.repe_scas_o16_a32();
                return;
            }
            case 307: {
                this.repe_scas_o32_a32();
                return;
            }
            case 281: {
                this.repne_scas_o8_a16();
                return;
            }
            case 282: {
                this.repne_scas_o16_a16();
                return;
            }
            case 283: {
                this.repne_scas_o32_a16();
                return;
            }
            case 308: {
                this.repne_scas_o8_a32();
                return;
            }
            case 309: {
                this.repne_scas_o16_a32();
                return;
            }
            case 310: {
                this.repne_scas_o32_a32();
                return;
            }
            case 275: {
                this.rep_stos_o8_a16();
                return;
            }
            case 276: {
                this.rep_stos_o16_a16();
                return;
            }
            case 277: {
                this.rep_stos_o32_a16();
                return;
            }
            case 302: {
                this.rep_stos_o8_a32();
                return;
            }
            case 303: {
                this.rep_stos_o16_a32();
                return;
            }
            case 304: {
                this.rep_stos_o32_a32();
                return;
            }
            case 107: 
            case 109: {
                if (this.cpu.ss.getDefaultSizeFlag()) break;
                this.ret_o16_a16();
                return;
            }
            case 108: 
            case 110: {
                if (this.cpu.ss.getDefaultSizeFlag()) {
                    this.ret_o32_a32();
                    return;
                }
                this.ret_o32_a16();
                return;
            }
            case 124: 
            case 126: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.retf_o32_a32();
                return;
            }
            case 123: 
            case 125: {
                if (this.cpu.ss.getDefaultSizeFlag()) break;
                this.retf_o16_a16();
                return;
            }
            case 104: 
            case 106: {
                if (!this.cpu.ss.getDefaultSizeFlag()) break;
                this.ret_iw_o32_a32();
                return;
            }
            case 119: 
            case 121: {
                if (this.cpu.ss.getDefaultSizeFlag()) break;
                this.retf_iw_o16_a16();
                return;
            }
            case 210: {
                this.rcl_o8();
                return;
            }
            case 217: {
                this.rcl_o16();
                return;
            }
            case 224: {
                this.rcl_o32();
                return;
            }
            case 211: {
                this.rcr_o8();
                return;
            }
            case 218: {
                this.rcr_o16();
                return;
            }
            case 225: {
                this.rcr_o32();
                return;
            }
            case 208: {
                this.rol_o8();
                return;
            }
            case 215: {
                this.rol_o16();
                return;
            }
            case 222: {
                this.rol_o32();
                return;
            }
            case 209: {
                this.ror_o8();
                return;
            }
            case 216: {
                this.ror_o16();
                return;
            }
            case 223: {
                this.ror_o32();
                return;
            }
            case 101: {
                this.sahf();
                return;
            }
            case 214: {
                this.sar_o8();
                return;
            }
            case 221: {
                this.sar_o16();
                return;
            }
            case 228: {
                this.sar_o32();
                return;
            }
            case 9: {
                this.sbb_o8();
                return;
            }
            case 11: {
                this.sbb_o16();
                return;
            }
            case 10: {
                this.sbb_o32();
                return;
            }
            case 197: {
                this.scas_o8_a16();
                return;
            }
            case 198: {
                this.scas_o16_a16();
                return;
            }
            case 199: {
                this.scas_o32_a16();
                return;
            }
            case 365: {
                this.scas_o8_a32();
                return;
            }
            case 366: {
                this.scas_o16_a32();
                return;
            }
            case 367: {
                this.scas_o32_a32();
                return;
            }
            case 434: {
                this.setb();
                return;
            }
            case 435: {
                this.setnb();
                return;
            }
            case 438: {
                this.setbe();
                return;
            }
            case 439: {
                this.setnbe();
                return;
            }
            case 444: {
                this.setl();
                return;
            }
            case 445: {
                this.setnl();
                return;
            }
            case 446: {
                this.setle();
                return;
            }
            case 447: {
                this.setnle();
                return;
            }
            case 432: {
                this.seto();
                return;
            }
            case 433: {
                this.setno();
                return;
            }
            case 442: {
                this.setp();
                return;
            }
            case 443: {
                this.setnp();
                return;
            }
            case 440: {
                this.sets();
                return;
            }
            case 441: {
                this.setns();
                return;
            }
            case 436: {
                this.setz();
                return;
            }
            case 437: {
                this.setnz();
                return;
            }
            case 380: {
                this.sgdt_o32();
                return;
            }
            case 212: {
                this.shl_o8();
                return;
            }
            case 219: {
                this.shl_o16();
                return;
            }
            case 226: {
                this.shl_o32();
                return;
            }
            case 464: {
                this.shld_o32();
                return;
            }
            case 463: {
                this.shld_o16();
                return;
            }
            case 213: {
                this.shr_o8();
                return;
            }
            case 220: {
                this.shr_o16();
                return;
            }
            case 227: {
                this.shr_o32();
                return;
            }
            case 462: {
                this.shrd_o32();
                return;
            }
            case 461: {
                this.shrd_o16();
                return;
            }
            case 450: {
                this.sldt();
                return;
            }
            case 387: {
                this.smsw();
                return;
            }
            case 180: {
                this.stc();
                return;
            }
            case 184: {
                this.std();
                return;
            }
            case 182: {
                this.sti();
                return;
            }
            case 194: {
                this.stos_o8_a16();
                return;
            }
            case 195: {
                this.stos_o16_a16();
                return;
            }
            case 196: {
                this.stos_o32_a16();
                return;
            }
            case 362: {
                this.stos_o8_a32();
                return;
            }
            case 363: {
                this.stos_o16_a32();
                return;
            }
            case 364: {
                this.stos_o32_a32();
                return;
            }
            case 16: {
                this.sub_o8();
                return;
            }
            case 18: {
                this.sub_o16();
                return;
            }
            case 17: {
                this.sub_o32();
                return;
            }
            case 70: {
                this.test_o8();
                return;
            }
            case 72: {
                this.test_o16();
                return;
            }
            case 71: {
                this.test_o32();
                return;
            }
            case 481: {
                this.ud2();
                return;
            }
            case 92: {
                this.waitOp();
                return;
            }
            case 633: {
                this.wbinvd();
                return;
            }
            case 630: {
                this.wrmsr();
                return;
            }
            case 489: {
                this.xadd_o8();
                return;
            }
            case 490: {
                this.xadd_o16();
                return;
            }
            case 491: {
                this.xadd_o32();
                return;
            }
            case 73: {
                this.xchg_o8();
                return;
            }
            case 83: {
                this.xchg_o16();
                return;
            }
            case 82: {
                this.xchg_o32();
                return;
            }
            case 229: {
                this.xlat();
                return;
            }
            case 20: {
                this.xor_o8();
                return;
            }
            case 22: {
                this.xor_o16();
                return;
            }
            case 21: {
                this.xor_o32();
                return;
            }
        }
        System.err.println("Protected Mode: Unimplemented Opcode: " + this.microcodes[this.microcodesPosition - 1]);
        throw new ProcessorException(-1, true);
    }

    private final void eipUpdate() {
        if (!this.eipUpdated) {
            this.eipUpdated = true;
            this.cpu.eip += this.cumulativeX86Length[this.microcodesPosition - 1];
        }
    }

    private final void arpl() {
        int n = this.getShortOperand() & 0xFFFF;
        int n2 = this.getShortOperand() & 0xFFFF;
        if ((n2 & 3) < (n & 3)) {
            this.cpu.eflagsZero = true;
            this.setShortOperand((short)(n2 & 0xFFFFFFFC | n & 3));
        } else {
            this.cpu.eflagsZero = false;
            this.skipOperand();
        }
    }

    private final void bound_o32_a32() {
        long l = this.getLongOperand();
        int n = (int)l;
        int n2 = (int)(l >> 32);
        int n3 = this.getIntOperand();
        if (n3 < n || n3 > n2) {
            throw exceptionBR;
        }
    }

    private final void call_o32_a32() {
        int n = this.cpu.eip + this.getIntOperand();
        this.cpu.cs.checkAddress(n);
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n;
    }

    private final void call_o32_a16() {
        int n = this.cpu.eip + this.getIntOperand();
        this.cpu.cs.checkAddress(n);
        if ((0xFFFF & this.cpu.esp) < 4 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void call_o16_a32() {
        int n = this.cpu.eip + this.getShortOperand() & 0xFFFF;
        this.cpu.cs.checkAddress(n);
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, (short)this.cpu.eip);
        this.cpu.esp -= 2;
        this.cpu.eip = n;
    }

    private final void call_o16_a16() {
        int n = this.cpu.eip + this.getShortOperand() & 0xFFFF;
        this.cpu.cs.checkAddress(n);
        if ((0xFFFF & this.cpu.esp) < 2 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, (short)this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void callf_o32_a32() {
        long l = this.getLongOperand();
        int n = (int)(l >> 32 & 0xFFFFL);
        int n2 = (int)l;
        Segment segment = this.cpu.getSegment(n);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("CALL -> Invalid Segment Type");
                throw new ProcessorException(13, n, true);
            }
            case 5: {
                System.err.println("CALL -> Task Gate");
                throw new ProcessorException(-1, true);
            }
            case 9: 
            case 11: {
                System.err.println("CALL -> TSS (Task-State Segment)");
                throw new ProcessorException(-1, true);
            }
            case 12: {
                System.err.println("CALL -> Call Gate");
                throw new ProcessorException(-1, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
                    throw new ProcessorException(13, n, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n, true);
                }
                if (this.cpu.esp < 8 && this.cpu.esp > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                segment.checkAddress(n2);
                this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.cs.getSelector());
                this.cpu.ss.setDoubleWord(this.cpu.esp - 8, this.cpu.eip);
                this.cpu.esp -= 8;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n2;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        System.err.println("CALL -> Conforming Code Segment");
        throw new ProcessorException(-1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callf_o16_a16() {
        int n = this.getIntOperand();
        int n2 = n >>> 16 & 0xFFFF;
        int n3 = n & 0xFFFF;
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        block3 : switch (segment.getType()) {
            default: {
                System.err.println("CALL -> Invalid Segment Type");
                throw new ProcessorException(13, n2, true);
            }
            case 1: 
            case 3: {
                System.err.println("CALL -> 16bit TSS (Task-State Segment)");
                throw new ProcessorException(-1, true);
            }
            case 4: {
                Segment segment2;
                if (segment.getDPL() < this.cpu.getCPL() | segment.getRPL() > segment.getDPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                int n4 = ((SegmentFactory.GateSegment)segment).getTargetSegment();
                try {
                    segment2 = this.cpu.getSegment(n4);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(13, n4, true);
                }
                if (segment2.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(13, n4, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(13, n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(11, n4, true);
                        }
                        if (segment2.getDPL() < this.cpu.getCPL()) {
                            int n5;
                            int n6;
                            int n7 = 0;
                            int n8 = 0;
                            if ((this.cpu.tss.getType() & 8) != 0) {
                                n6 = segment2.getDPL() * 8 + 4;
                                if (n6 + 7 > this.cpu.tss.getLimit()) {
                                    throw new ProcessorException(10, this.cpu.tss.getSelector(), true);
                                }
                                n5 = this.cpu.linearMemory.isSupervisor();
                                try {
                                    this.cpu.linearMemory.setSupervisor(true);
                                    n7 = 0xFFFF & this.cpu.tss.getWord(n6 + 4);
                                    n8 = this.cpu.tss.getDoubleWord(n6);
                                }
                                finally {
                                    this.cpu.linearMemory.setSupervisor(n5 != 0);
                                }
                            } else {
                                n6 = segment2.getDPL() * 4 + 2;
                                if (n6 + 4 > this.cpu.tss.getLimit()) {
                                    throw new ProcessorException(10, this.cpu.tss.getSelector(), true);
                                }
                                n7 = 0xFFFF & this.cpu.tss.getWord(n6 + 2);
                                n8 = 0xFFFF & this.cpu.tss.getWord(n6);
                            }
                            Segment segment3 = null;
                            try {
                                segment3 = this.cpu.getSegment(n7);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment3.getRPL() != segment2.getDPL()) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment3.getDPL() != segment2.getDPL() || (segment3.getType() & 0x1A) != 18) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (!segment3.isPresent()) {
                                throw new ProcessorException(12, n7, true);
                            }
                            n5 = ((SegmentFactory.CallGate16Bit)segment).getParameterCount() & 0x1F;
                            if (segment3.getDefaultSizeFlag() && this.cpu.esp < 8 + n5 && this.cpu.esp > 0 || !segment3.getDefaultSizeFlag() && (this.cpu.esp & 0xFFFF) < 8 + n5 && (this.cpu.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n9 = ((SegmentFactory.GateSegment)segment).getTargetOffset();
                            segment2.checkAddress(n9);
                            int n10 = this.cpu.ss.getSelector();
                            Segment segment4 = this.cpu.ss;
                            int n11 = this.cpu.esp;
                            int n12 = this.cpu.cs.getSelector();
                            int n13 = this.cpu.eip;
                            this.cpu.ss = segment3;
                            this.cpu.esp = n8;
                            this.cpu.cs = segment2;
                            this.cpu.eip = n9;
                            this.cpu.setCPL(this.cpu.cs.getDPL());
                            if (this.cpu.ss.getDefaultSizeFlag()) {
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n10);
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n11);
                                n11 += 2 * n5;
                                for (int i = 0; i < n5; ++i) {
                                    this.cpu.esp -= 2;
                                    this.cpu.ss.setWord(this.cpu.esp, segment4.getWord(n11 & 0xFFFF));
                                    n11 -= 2;
                                }
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n12);
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n13);
                                break block3;
                            }
                            this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                            this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n10);
                            this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                            this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n11);
                            n11 += 2 * n5;
                            for (int i = 0; i < n5; ++i) {
                                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                                this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, segment4.getWord(n11 & 0xFFFF));
                                n11 -= 2;
                            }
                            this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                            this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n12);
                            this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                            this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n13);
                            break block3;
                        }
                        System.err.println("CALL -> 32bit Call Gate SAME-PRIVILEGE");
                        throw new ProcessorException(-1, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(11, n4, true);
                }
                System.err.println("CALL -> 32bit Call Gate SAME-PRIVILEGE");
                throw new ProcessorException(-1, true);
            }
            case 5: {
                System.err.println("CALL -> Task Gate");
                throw new ProcessorException(-1, true);
            }
            case 9: 
            case 11: {
                System.err.println("CALL -> 32bit TSS (Task-State Segment)");
                throw new ProcessorException(-1, true);
            }
            case 12: {
                System.err.println("CALL -> 32bit Call Gate");
                throw new ProcessorException(-1, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (this.cpu.esp < 4 && this.cpu.esp > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                segment.checkAddress(n3);
                this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, (short)this.cpu.cs.getSelector());
                this.cpu.ss.setWord(this.cpu.esp - 4 & 0xFFFF, (short)this.cpu.eip);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n3;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                System.err.println("CALL -> Conforming Code Segment");
                throw new ProcessorException(-1, true);
            }
        }
    }

    private final void calln_o32_a32() {
        int n = this.getIntOperand();
        this.cpu.cs.checkAddress(n);
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n;
    }

    private final void calln_o32_a16() {
        int n = this.getIntOperand();
        this.cpu.cs.checkAddress(n);
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void clts() {
        if (this.cpu.getCPL() != 0) {
            throw new ProcessorException(13, 0, true);
        }
        int n = this.cpu.getCR3();
        this.cpu.setCR3(n &= 0xFFFFFFFB);
    }

    private final void cpuid() {
        switch (this.cpu.eax) {
            case 0: {
                this.cpu.eax = 2;
                this.cpu.ebx = 1970169159;
                this.cpu.edx = 1231384169;
                this.cpu.ecx = 1818588270;
                return;
            }
            case 1: {
                this.cpu.eax = 1587;
                this.cpu.ebx = 2048;
                this.cpu.ecx = 0;
                int n = 0;
                n |= 1;
                n |= 0x100;
                n |= 0x10;
                n |= 0x20;
                n |= 0x8000;
                n |= 8;
                n |= 0x2000;
                this.cpu.edx = n |= 0x800;
                return;
            }
        }
        this.cpu.eax = 4261377;
        this.cpu.ebx = 0;
        this.cpu.ecx = 0;
        this.cpu.edx = 0;
    }

    private final void enter_o16_a32() {
        int n = this.getIntOperand();
        int n2 = (0xFF & n) % 32;
        int n3 = 0xFFFF & n >> 16;
        int n4 = this.cpu.esp;
        int n5 = this.cpu.ebp;
        if (n2 == 0 ? n4 < 2 + n3 && n4 > 0 : n4 < 2 + n3 + 2 * n2 && n4 > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(n4 -= 2, (short)n5);
        int n6 = n4;
        if (n2 > 0) {
            while (--n2 != 0) {
                this.cpu.ss.setWord(n4 -= 2, this.cpu.ss.getWord(n5 -= 2));
            }
            this.cpu.ss.setWord(n4 -= 2, (short)n6);
        }
        this.cpu.ebp = n6;
        this.cpu.esp = n4 - n3;
    }

    private final void enter_o32_a32() {
        int n = this.getIntOperand();
        int n2 = (0xFF & n) % 32;
        int n3 = n >>> 16;
        int n4 = this.cpu.esp;
        int n5 = this.cpu.ebp;
        if (n2 == 0 ? n4 < 4 + n3 && n4 > 0 : n4 < 4 + n3 + 4 * n2 && n4 > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(n4 -= 4, n5);
        int n6 = n4;
        if (n2 != 0) {
            while (--n2 != 0) {
                this.cpu.ss.setDoubleWord(n4 -= 4, this.cpu.ss.getDoubleWord(n5 -= 4));
            }
            this.cpu.ss.setDoubleWord(n4 -= 4, n6);
        }
        this.cpu.ebp = n6;
        this.cpu.esp = n4 - n3;
    }

    private final void hlt() {
        while ((this.cpu.getInterruptFlags() & 1) == 0 || !this.cpu.eflagsInterruptEnable) {
            this.cpu.waitForInterrupt(50L);
            this.cpu.processClock();
        }
        return;
    }

    private final void in_o8_o8() {
        int n = 0xFF & this.getByteOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("IN_O8_O8: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.setByteOperand((byte)this.cpu.ioports.ioPortReadByte(n));
    }

    private final void in_o8_o16() {
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("IN_O8_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.setByteOperand((byte)this.cpu.ioports.ioPortReadByte(n));
    }

    private final void in_o16_o16() {
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("IN_O16_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.setShortOperand((short)this.cpu.ioports.ioPortReadWord(n));
    }

    private final void in_o32_o16() {
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("IN_O32_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.setIntOperand(this.cpu.ioports.ioPortReadLong(n));
    }

    protected final void ins_o8_a32() {
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("INS_O8_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        byte by = (byte)this.cpu.ioports.ioPortReadByte(n);
        this.setByteOperand(by);
        this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
    }

    protected final void ins_o16_a32() {
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("INS_O16_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        short s = (short)this.cpu.ioports.ioPortReadWord(n);
        this.setShortOperand(s);
        this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
    }

    protected final void ins_o32_a32() {
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("INS_O32_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.cpu.ioports.ioPortReadLong(n);
        this.setIntOperand(n2);
        this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
    }

    private final void int_o32_a32() {
        this.cpu.handleSoftProtectedModeInterrupt(0xFF & this.getByteOperand());
    }

    private final void invd() {
        System.err.println("INVD: currently empty");
    }

    private final void invlpg() {
        if (this.cpu.getCPL() != 0) {
            throw new ProcessorException(13, 0, true);
        }
        Segment segment = this.getSegmentOperand();
        int n = this.getAddressOperand();
        n = segment.translateAddressRead(n);
        this.cpu.linearMemory.invalidateTLBEntry(n);
    }

    private final void iret_o32_a32() {
        Segment segment;
        if (this.cpu.eflagsNestedTask) {
            System.err.println("IRET: Task Return");
            throw new ProcessorException(-1, true);
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 12);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        int n3 = this.cpu.ss.getDoubleWord(this.cpu.esp + 8);
        if ((n3 & 0x20000) != 0) {
            System.err.println("About to enable virtual8086 mode");
        }
        if ((segment = this.cpu.getSegment(n2)) == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Bad Segment Type For IRET");
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 20);
                    }
                    catch (ProcessorException processorException) {
                        throw new ProcessorException(12, 0, true);
                    }
                    int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp + 12);
                    int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 16);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(13, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(13, n5, true);
                    }
                    segment.checkAddress(n);
                    this.cpu.eip = n;
                    this.cpu.cs = segment;
                    this.cpu.esp = n4;
                    this.cpu.ss = segment2;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFDAB22A;
                    n6 |= 0x254DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFE5CFFF;
                        n6 |= 0x1A3000 & n3;
                    }
                    this.cpu.setEFlags(n3);
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x10) != 0 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x10) != 0 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x10) != 0 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                        // empty catch block
                    }
                    try {
                        if ((this.cpu.gs.getType() & 0x10) == 0 && (this.cpu.gs.getType() & 0x1C) != 24 || this.cpu.getCPL() <= this.cpu.gs.getDPL()) break;
                        this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {}
                    break;
                }
                segment.checkAddress(n);
                this.cpu.esp += 12;
                this.cpu.cs = segment;
                this.cpu.eip = n;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFDAB22A;
                n7 |= 0x254DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFE5CFFF;
                    n7 |= 0x1A3000 & n3;
                }
                this.cpu.setEFlags(n3);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                System.err.println("Conforming: SAME PRIVILEGE-LEVEL");
                throw new ProcessorException(-1, true);
            }
        }
    }

    private final void iret_o16_a16() {
        Segment segment;
        if (this.cpu.eflagsNestedTask) {
            System.err.println("IRET: Task Return");
            throw new ProcessorException(-1, true);
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 6 & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        int n2 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF);
        int n3 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 4 & 0xFFFF);
        if ((n3 & 0x20000) != 0) {
            System.err.println("About to enable virtual8086 mode");
        }
        if ((segment = this.cpu.getSegment(n2)) == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Bad Segment Type For IRET");
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 10 & 0xFFFF);
                    }
                    catch (ProcessorException processorException) {
                        throw new ProcessorException(12, 0, true);
                    }
                    int n4 = this.cpu.ss.getWord(this.cpu.esp + 6 & 0xFFFF) & 0xFFFF;
                    int n5 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 8 & 0xFFFF);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(13, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(13, n5, true);
                    }
                    segment.checkAddress(n);
                    this.cpu.eip = n;
                    this.cpu.cs = segment;
                    this.cpu.esp = n4;
                    this.cpu.ss = segment2;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFFFB22A;
                    n6 |= 0x4DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFFFCFFF;
                        n6 |= 0x3000 & n3;
                    }
                    this.cpu.setEFlags(n3);
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x10) != 0 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                        System.err.println("ES is a Real Mode Segment, cannot assign null");
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x10) != 0 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                        System.err.println("DS is a Real Mode Segment, cannot assign null");
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x10) != 0 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                        System.err.println("FS is a Real Mode Segment, cannot assign null");
                    }
                    try {
                        if ((this.cpu.gs.getType() & 0x10) == 0 && (this.cpu.gs.getType() & 0x1C) != 24 || this.cpu.getCPL() <= this.cpu.gs.getDPL()) break;
                        this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                        System.err.println("GS is a Real Mode Segment, cannot assign null");
                    }
                    break;
                }
                segment.checkAddress(n);
                this.cpu.esp += 6;
                this.cpu.cs = segment;
                this.cpu.eip = n;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFFFB22A;
                n7 |= 0x4DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFFFCFFF;
                    n7 |= 0x3000 & n3;
                }
                this.cpu.setEFlags(n3);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                System.err.println("Conforming: SAME PRIVILEGE-LEVEL");
                throw new ProcessorException(-1, true);
            }
        }
    }

    private final void jcxz_a32() {
        byte by = this.getByteOperand();
        if (this.cpu.ecx == 0) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jb_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsCarry) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jb_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsCarry) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jb_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsCarry) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnb_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsCarry) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnb_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsCarry) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnb_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsCarry) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jbe_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jbe_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jbe_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnbe_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnbe_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnbe_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jl_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jl_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jl_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnl_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnl_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnl_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jle_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jle_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jle_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnle_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnle_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnle_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jo_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jo_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jo_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsOverflow) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jno_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jno_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsOverflow) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jno_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsOverflow) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jp_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsParity) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jp_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsParity) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jp_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsParity) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnp_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsParity) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnp_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsParity) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnp_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsParity) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void js_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsSign) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void js_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsSign) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void js_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsSign) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jns_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsSign) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jns_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsSign) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jns_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsSign) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jz_o8() {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsZero) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jz_o16() {
        short s = this.getShortOperand();
        if (this.cpu.eflagsZero) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jz_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eflagsZero) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnz_o8() {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsZero) {
            int n = this.cpu.eip + by;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnz_o16() {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsZero) {
            int n = this.cpu.eip + s;
            this.cpu.cs.checkAddress(n);
            this.cpu.eip = n;
        }
    }

    private final void jnz_o32() {
        int n = this.getIntOperand();
        if (!this.cpu.eflagsZero) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jmp_o8_short() {
        int n = this.cpu.eip + this.getByteOperand();
        if (n == this.cpu.eip) {
            return;
        }
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jmp_o16_near_absolute() {
        int n = this.getShortOperand() & 0xFFFF;
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jmp_o32_near_absolute() {
        int n = this.getIntOperand();
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jmp_o16_near_relative() {
        int n = this.cpu.eip + this.getShortOperand() & 0xFFFF;
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jmp_o32_near_relative() {
        int n = this.cpu.eip + this.getIntOperand();
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jmp_o16_far() {
        int n = this.getIntOperand();
        int n2 = n >>> 16 & 0xFFFF;
        int n3 = n & 0xFFFF;
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("JMP -> Invalid Segment Type");
                throw new ProcessorException(13, n2, true);
            }
            case 5: {
                System.err.println("JMP -> Task Gate");
                throw new ProcessorException(-1, true);
            }
            case 9: 
            case 11: {
                System.err.println("JMP -> TSS");
                throw new ProcessorException(-1, true);
            }
            case 12: {
                System.err.println("JMP -> Call Gate");
                throw new ProcessorException(-1, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() != this.cpu.getCPL() || segment.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                segment.checkAddress(n3);
                segment.setRPL(this.cpu.getCPL());
                this.cpu.cs = segment;
                this.cpu.eip = n3;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getDPL() > this.cpu.getCPL()) {
            throw new ProcessorException(13, n2, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(11, n2, true);
        }
        segment.checkAddress(n3);
        segment.setRPL(this.cpu.getCPL());
        this.cpu.cs = segment;
        this.cpu.eip = n3;
    }

    private final void jmp_o32_far() {
        long l = this.getLongOperand();
        int n = (int)(l >> 32 & 0xFFFFL);
        int n2 = (int)l;
        Segment segment = this.cpu.getSegment(n);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("JMP -> Invalid Segment Type");
                throw new ProcessorException(13, n, true);
            }
            case 5: {
                System.err.println("JMP -> Task Gate");
                throw new ProcessorException(-1, true);
            }
            case 9: 
            case 11: {
                System.err.println("JMP -> TSS (Task-State Segment)");
                throw new ProcessorException(-1, true);
            }
            case 12: {
                System.err.println("JMP -> Call Gate");
                throw new ProcessorException(-1, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() != this.cpu.getCPL() || segment.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(13, n, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n, true);
                }
                segment.checkAddress(n2);
                segment.setRPL(this.cpu.getCPL());
                this.cpu.cs = segment;
                this.cpu.eip = n2;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getDPL() > this.cpu.getCPL()) {
            throw new ProcessorException(13, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(11, n, true);
        }
        segment.checkAddress(n2);
        segment.setRPL(this.cpu.getCPL());
        this.cpu.cs = segment;
        this.cpu.eip = n2;
    }

    private final void loop_o16_a16() {
        byte by = this.getByteOperand();
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | --this.cpu.ecx & 0xFFFF;
        if ((this.cpu.ecx & 0xFFFF) != 0) {
            this.cpu.cs.checkAddress(this.cpu.eip + by & 0xFFFF);
            this.cpu.eip += by;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void loop_o32_a32() {
        byte by = this.getByteOperand();
        --this.cpu.ecx;
        if (this.cpu.ecx != 0) {
            this.cpu.cs.checkAddress(this.cpu.eip + by);
            this.cpu.eip += by;
        }
    }

    private final void loopnz_o32_a32() {
        byte by = this.getByteOperand();
        --this.cpu.ecx;
        if (this.cpu.ecx != 0 && !this.cpu.eflagsZero) {
            this.cpu.cs.checkAddress(this.cpu.eip + by);
            this.cpu.eip += by;
        }
    }

    private final void leave_o32_a16() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = this.cpu.ss.getDoubleWord(n & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n + 4 & 0xFFFF;
        this.cpu.ebp = n2;
    }

    private final void leave_o32_a32() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        this.cpu.esp = n + 4;
        this.cpu.ebp = n2;
    }

    private final void leave_o16_a16() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        short s = this.cpu.ss.getWord(n & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n + 2 & 0xFFFF;
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | s & 0xFFFF;
    }

    private final void leave_o16_a32() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        short s = this.cpu.ss.getWord(n);
        this.cpu.esp = n + 2;
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | s & 0xFFFF;
    }

    private final void lgdt_o16() {
        long l = this.getLongOperand();
        this.cpu.gdtr = this.cpu.createDescriptorTableSegment((int)(l >> 16 & 0xFFFFFFL), (int)(l & 0xFFFFL));
    }

    private final void lgdt_o32() {
        long l = this.getLongOperand();
        this.cpu.gdtr = this.cpu.createDescriptorTableSegment((int)(l >> 16), (int)(l & 0xFFFFL));
    }

    private final void lidt_o16() {
        long l = this.getLongOperand();
        this.cpu.idtr = this.cpu.createDescriptorTableSegment((int)(l >> 16 & 0xFFFFFFL), (int)(l & 0xFFFFL));
    }

    private final void lidt_o32() {
        long l = this.getLongOperand();
        this.cpu.idtr = this.cpu.createDescriptorTableSegment((int)(l >> 16), (int)(l & 0xFFFFL));
    }

    private final void lldt() {
        int n = 0xFFFF & this.getShortOperand();
        if (n == 0) {
            this.cpu.ldtr = SegmentFactory.NULL_SEGMENT;
            return;
        }
        Segment segment = this.cpu.getSegment(n & 0xFFFFFFFB);
        if (segment.getType() != 2) {
            throw new ProcessorException(13, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(13, n, true);
        }
        this.cpu.ldtr = segment;
    }

    private final void lmsw() {
        short s = this.getShortOperand();
        this.cpu.setCR0(this.cpu.getCR0() & 0xFFFFFFF1 | s & 0xE);
    }

    private final void ltr() {
        int n = 0xFFFF & this.getShortOperand();
        if ((n & 4) != 0) {
            throw new ProcessorException(13, n, true);
        }
        Segment segment = this.cpu.getSegment(n);
        if (segment.getType() != 1 && segment.getType() != 9) {
            throw new ProcessorException(13, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(13, n, true);
        }
        long l = this.cpu.gdtr.getQuadWord(n & 0xFFF8) | 0x20000000000L;
        this.cpu.gdtr.setQuadWord(n & 0xFFF8, l);
        this.cpu.tss = this.cpu.getSegment(n);
    }

    private final void lss_o32_a32() {
        long l = this.getLongOperand();
        int n = (int)l;
        int n2 = (int)(l >> 32 & 0xFFFFL);
        long l2 = 0L;
        if (n2 < 4) {
            this.skipOperand();
            throw new ProcessorException(13, 0, true);
        }
        Segment segment = null;
        try {
            segment = this.cpu.getSegment(n2);
        }
        catch (ProcessorException processorException) {
            throw new IllegalStateException(processorException.toString());
        }
        if (segment.getRPL() != this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
            throw new ProcessorException(13, n2, true);
        }
        this.cpu.ss = segment;
        this.cpu.eflagsInterruptEnable = false;
        this.setIntOperand(n);
    }

    private final void mov_to_cr_o32() {
        int n = this.getIntOperand();
        switch (this.microcodes[this.microcodesPosition++]) {
            case 30: {
                this.cpu.setCR0(n);
                break;
            }
            case 32: {
                this.cpu.setCR2(n);
                break;
            }
            case 33: {
                this.cpu.setCR3(n);
                break;
            }
            case 34: {
                this.cpu.setCR4(n);
                break;
            }
            default: {
                throw new ProcessorException(-1, true);
            }
        }
    }

    private final void mov_to_dr_o32() {
        int n = this.getIntOperand();
        this.setIntOperand(n);
    }

    private final void mov_to_seg() {
        int n = 0xFFFF & this.getShortOperand();
        long l = 0L;
        if (n < 4) {
            switch (this.microcodes[this.microcodesPosition]) {
                case 26: {
                    this.skipOperand();
                    throw new ProcessorException(13, 0, true);
                }
                case 27: {
                    this.skipOperand();
                    this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                    return;
                }
                case 24: {
                    this.skipOperand();
                    this.cpu.es = SegmentFactory.NULL_SEGMENT;
                    return;
                }
                case 28: {
                    this.skipOperand();
                    this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                    return;
                }
                case 29: {
                    this.skipOperand();
                    this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                    return;
                }
            }
            this.skipOperand();
            return;
        }
        Segment segment = null;
        try {
            segment = this.cpu.getSegment(n);
        }
        catch (ProcessorException processorException) {
            throw new IllegalStateException(processorException.toString());
        }
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.skipOperand();
            this.cpu.ss = segment;
            this.cpu.eflagsInterruptEnable = false;
        } else {
            this.setSegment(segment);
        }
    }

    private final void out_o8_o8() {
        byte by = this.getByteOperand();
        int n = 0xFF & this.getByteOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("OUT_O8_O8: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & by);
    }

    private final void out_o16_o8() {
        byte by = this.getByteOperand();
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("OUT_O16_O8: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & by);
    }

    private final void out_o16_o16() {
        short s = this.getShortOperand();
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("OUT_O16_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & s);
    }

    private final void out_o16_o32() {
        int n = this.getIntOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsInt(n2)) {
            System.err.println("OUT_O16_O32: Denied IO Port Access [port:0x" + Integer.toHexString(n2) + " cpl:" + this.cpu.getCPL() + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteLong(n2, n);
    }

    protected final void outs_o8_a32() {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.getByteOperand() & 0xFF;
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("OUTS_O8_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteByte(n, n2);
        this.cpu.esi = this.cpu.eflagsDirection ? --this.cpu.esi : ++this.cpu.esi;
    }

    protected final void outs_o16_a32() {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.getShortOperand() & 0xFFFF;
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("OUTS_O16_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteWord(n, n2);
        this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 2) : (this.cpu.esi += 2);
    }

    protected final void outs_o32_a32() {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.getIntOperand();
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("OUTS_O32_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ioports.ioPortWriteLong(n, n2);
        this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 4) : (this.cpu.esi += 4);
    }

    private final void pop_o32_a32() {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp += 4;
        try {
            this.setIntOperand(n);
        }
        catch (ProcessorException processorException) {
            this.cpu.esp -= 4;
            throw processorException;
        }
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.cpu.eflagsInterruptEnable = false;
        }
    }

    private final void pop_o32_a16() {
        int n = this.cpu.ss.getDoubleWord(0xFFFF & this.cpu.esp);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
        try {
            this.setIntOperand(n);
        }
        catch (ProcessorException processorException) {
            this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
            throw processorException;
        }
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.cpu.eflagsInterruptEnable = false;
        }
    }

    private final void pop_o16_a32() {
        short s = this.cpu.ss.getWord(this.cpu.esp);
        this.cpu.esp += 2;
        try {
            this.setShortOperand(s);
        }
        catch (ProcessorException processorException) {
            this.cpu.esp -= 2;
            throw processorException;
        }
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.cpu.eflagsInterruptEnable = false;
        }
    }

    private final void pop_o16_a16() {
        short s = this.cpu.ss.getWord(0xFFFF & this.cpu.esp);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        try {
            this.setShortOperand(s);
        }
        catch (ProcessorException processorException) {
            this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
            throw processorException;
        }
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.cpu.eflagsInterruptEnable = false;
        }
    }

    private final void popa_o16_a16() {
        int n = 0xFFFF & this.cpu.esp;
        int n2 = this.cpu.edi & 0xFFFF0000;
        int n3 = this.cpu.esi & 0xFFFF0000;
        int n4 = this.cpu.ebp & 0xFFFF0000;
        int n5 = this.cpu.ebx & 0xFFFF0000;
        int n6 = this.cpu.edx & 0xFFFF0000;
        int n7 = this.cpu.ecx & 0xFFFF0000;
        int n8 = this.cpu.eax & 0xFFFF0000;
        n2 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & n);
        n3 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n4 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n += 2;
        n5 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n6 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n7 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n8 |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n += 2;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp &= 0xFFFF0000;
        this.cpu.esp |= (n &= 0xFFFF);
    }

    private final void popa_o32_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        int n3 = this.cpu.ss.getDoubleWord(n += 4);
        int n4 = this.cpu.ss.getDoubleWord(n += 4);
        int n5 = this.cpu.ss.getDoubleWord(n += 8);
        int n6 = this.cpu.ss.getDoubleWord(n += 4);
        int n7 = this.cpu.ss.getDoubleWord(n += 4);
        int n8 = this.cpu.ss.getDoubleWord(n += 4);
        n += 4;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = n;
    }

    private final void popf_o32_a32() {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp += 4;
        boolean bl = this.cpu.eflagsVirtual8086Mode;
        int n2 = this.cpu.eflagsIOPrivilegeLevel;
        boolean bl2 = this.cpu.eflagsInterruptEnable;
        boolean bl3 = this.cpu.eflagsInterruptEnableSoon;
        this.cpu.setEFlags(n);
        this.cpu.eflagsVirtual8086Mode = bl;
        this.cpu.eflagsVirtualInterrupt = false;
        this.cpu.eflagsVirtualInterruptPending = false;
        if (this.cpu.getCPL() != 0) {
            if (this.cpu.getCPL() > n2) {
                this.cpu.eflagsIOPrivilegeLevel = n2;
                this.cpu.eflagsInterruptEnable = bl2;
                this.cpu.eflagsInterruptEnableSoon = bl3;
            } else {
                this.cpu.eflagsIOPrivilegeLevel = n2;
            }
        }
    }

    private final void popf_o32_a16() {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
        boolean bl = this.cpu.eflagsVirtual8086Mode;
        int n2 = this.cpu.eflagsIOPrivilegeLevel;
        boolean bl2 = this.cpu.eflagsInterruptEnable;
        boolean bl3 = this.cpu.eflagsInterruptEnableSoon;
        this.cpu.setEFlags(n);
        this.cpu.eflagsVirtual8086Mode = bl;
        this.cpu.eflagsVirtualInterrupt = false;
        this.cpu.eflagsVirtualInterruptPending = false;
        if (this.cpu.getCPL() != 0) {
            if (this.cpu.getCPL() > n2) {
                this.cpu.eflagsIOPrivilegeLevel = n2;
                this.cpu.eflagsInterruptEnable = bl2;
                this.cpu.eflagsInterruptEnableSoon = bl3;
            } else {
                this.cpu.eflagsIOPrivilegeLevel = n2;
            }
        }
    }

    private final void popf_o16_a32() {
        int n = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp);
        this.cpu.esp += 2;
        int n2 = this.cpu.getEFlags();
        n &= 0xFFFF;
        int n3 = this.cpu.eflagsIOPrivilegeLevel;
        this.cpu.setEFlags(n |= 0xFFFF & n2);
        if (this.cpu.getCPL() != 0) {
            this.cpu.eflagsIOPrivilegeLevel = n3;
        }
    }

    private final void push_o16_a32() {
        short s = this.getShortOperand();
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, s);
        this.cpu.esp -= 2;
    }

    private final void push_o16_a16() {
        short s = this.getShortOperand();
        if ((0xFFFF & this.cpu.esp) < 2 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, s);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
    }

    private final void push_o32_a32() {
        int n;
        switch (this.microcodes[this.microcodesPosition]) {
            case 28: 
            case 29: {
                n = this.getIntOperand() & 0xFFFF;
                break;
            }
            default: {
                n = this.getIntOperand();
            }
        }
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, n);
        this.cpu.esp -= 4;
    }

    private final void push_o32_a16() {
        int n;
        switch (this.microcodes[this.microcodesPosition]) {
            case 28: 
            case 29: {
                n = this.getIntOperand() & 0xFFFF;
                break;
            }
            default: {
                n = this.getIntOperand();
            }
        }
        if ((0xFFFF & this.cpu.esp) < 4 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
    }

    private final void pusha_o32_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.esp;
        if (n < 32 && n > 0) {
            throw new ProcessorException(13, 0, true);
        }
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.eax);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ecx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebx);
        this.cpu.ss.setDoubleWord(n -= 4, n2);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebp);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.esi);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edi);
        this.cpu.esp = n;
    }

    private final void pushf_o32_a32() {
        int n = 0xFCFFFF & this.cpu.getEFlags();
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, n);
        this.cpu.esp -= 4;
    }

    private final void pushf_o32_a16() {
        int n = 0xFCFFFF & this.cpu.getEFlags();
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
    }

    private final void pushf_o16_a32() {
        short s = (short)this.cpu.getEFlags();
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, s);
        this.cpu.esp -= 2;
    }

    private final void pushf_o16_a16() {
        short s = (short)this.cpu.getEFlags();
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, s);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
    }

    private final void rdmsr() {
        if (this.cpu.getCPL() == 0) {
            switch (this.cpu.ecx) {
                case 27: {
                    this.cpu.eax = 16;
                    this.cpu.edx = 0;
                    return;
                }
            }
        } else {
            throw new ProcessorException(13, 0, true);
        }
        System.err.println("Unknown MSR: ECX:0x" + Integer.toHexString(this.cpu.ecx));
    }

    private final void rdtsc() {
        if ((this.cpu.getCR4() & 4) != 0 && this.cpu.getCPL() != 0) {
            throw new ProcessorException(13, 0, true);
        }
        long l = this.cpu.getClockCount();
        this.cpu.eax = (int)l;
        this.cpu.edx = (int)(l >>> 32);
    }

    protected final void rep_ins_o8_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("REP_INS_O8_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            byte by = (byte)this.cpu.ioports.ioPortReadByte(n);
            this.setByteOperand(by);
            this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
            --this.cpu.ecx;
        }
    }

    protected final void rep_ins_o16_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("REP_INS_O16_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            short s = (short)this.cpu.ioports.ioPortReadWord(n);
            this.setShortOperand(s);
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
            --this.cpu.ecx;
        }
    }

    protected final void rep_ins_o32_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("REP_INS_O32_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.ioports.ioPortReadLong(n);
            this.setIntOperand(n3);
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
            --this.cpu.ecx;
        }
    }

    protected final void rep_outs_o8_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("REP_OUTS_O8_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            int n3 = this.getByteOperand() & 0xFF;
            this.cpu.ioports.ioPortWriteByte(n, n3);
            this.cpu.esi = this.cpu.eflagsDirection ? --this.cpu.esi : ++this.cpu.esi;
            --this.cpu.ecx;
        }
    }

    protected final void rep_outs_o16_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("REP_OUTS_O16_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            int n3 = this.getShortOperand() & 0xFFFF;
            this.cpu.ioports.ioPortWriteWord(n, n3);
            this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 2) : (this.cpu.esi += 2);
            --this.cpu.ecx;
        }
    }

    protected final void rep_outs_o32_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0xFFFF & this.getShortOperand();
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("REP_OUTS_O32_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw new ProcessorException(13, 0, true);
        }
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            int n3 = this.getIntOperand();
            this.cpu.ioports.ioPortWriteLong(n, n3);
            this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 4) : (this.cpu.esi += 4);
            --this.cpu.ecx;
        }
    }

    private final void ret_o16_a16() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
    }

    private final void ret_o32_a16() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(0xFFFF & this.cpu.esp);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
    }

    private final void ret_o32_a32() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp += 4;
    }

    private final void ret_iw_o32_a32() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp = this.cpu.esp + 4 + this.getShortOperand();
    }

    private final void retf_o32_a32() {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 8);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Non-Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp += 8;
                this.cpu.eip = n;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp += 8;
                this.cpu.eip = n;
                this.cpu.cs = segment;
            }
        }
    }

    private final void retf_o16_a16() {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 4);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = 0xFFFF & this.cpu.ss.getWord(0xFFFF & this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getWord(0xFFFF & this.cpu.esp + 2);
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Non-Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
                this.cpu.eip = n;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
                this.cpu.eip = n;
                this.cpu.cs = segment;
            }
        }
    }

    private final void retf_iw_o16_a16() {
        short s = this.getShortOperand();
        try {
            this.cpu.ss.checkAddress(0xFFFF & this.cpu.esp + 4 + s);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = 0xFFFF & this.cpu.ss.getWord(0xFFFF & this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getWord(0xFFFF & this.cpu.esp + 2);
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(13, 0, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Non-Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 + s & 0xFFFF;
                this.cpu.eip = n;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 + s & 0xFFFF;
                this.cpu.eip = n;
                this.cpu.cs = segment;
            }
        }
    }

    private final void sahf() {
        int n = this.cpu.getEFlags();
        n &= 0xFFFFFF00;
        n |= 2;
        this.cpu.setEFlags(n |= this.cpu.eax & 0xD5);
    }

    private final void sgdt_o32() {
        Segment segment = this.getSegmentOperand();
        int n = this.getAddressOperand();
        segment.setWord(n, (short)this.cpu.gdtr.getLimit());
        segment.setDoubleWord(n + 2, this.cpu.gdtr.getBase());
    }

    private final void sldt() {
        this.setShortOperand((short)this.cpu.ldtr.getSelector());
    }

    private final void smsw() {
        this.setShortOperand((short)this.cpu.getCR0());
    }

    private final int ud2() {
        throw exceptionUD;
    }

    private final void wbinvd() {
        System.err.println("WBINVD: currently empty");
    }

    private final void wrmsr() {
        if (this.cpu.getCPL() == 0) {
            switch (this.cpu.ecx) {
                case 27: {
                    return;
                }
            }
        } else {
            throw new ProcessorException(13, 0, true);
        }
        System.err.println("Unknown MSR: ECX:0x" + Integer.toHexString(this.cpu.ecx));
    }

    private final void setSegment(Segment segment) {
        switch (this.getMicrocode()) {
            case 25: {
                this.cpu.cs = segment;
                return;
            }
            case 24: {
                this.cpu.es = segment;
                return;
            }
            case 26: {
                this.cpu.ss = segment;
                return;
            }
            case 27: {
                this.cpu.ds = segment;
                return;
            }
            case 28: {
                this.cpu.fs = segment;
                return;
            }
            case 29: {
                this.cpu.gs = segment;
                return;
            }
        }
    }

    protected final void loadSegment(int n, int n2) {
        long l = 0L;
        if ((n2 &= 0xFFFF) < 4) {
            switch (n) {
                case 26: {
                    throw new ProcessorException(13, 0, true);
                }
                case 27: {
                    this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                    return;
                }
                case 24: {
                    this.cpu.es = SegmentFactory.NULL_SEGMENT;
                    return;
                }
                case 28: {
                    this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                    return;
                }
                case 29: {
                    this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                    return;
                }
            }
            return;
        }
        Segment segment = null;
        try {
            segment = this.cpu.getSegment(n2);
        }
        catch (ProcessorException processorException) {
            throw new IllegalStateException(processorException.toString());
        }
        switch (n) {
            case 25: {
                this.cpu.cs = segment;
                return;
            }
            case 24: {
                this.cpu.es = segment;
                return;
            }
            case 26: {
                this.cpu.ss = segment;
                this.cpu.eflagsInterruptEnable = false;
                return;
            }
            case 27: {
                this.cpu.ds = segment;
                return;
            }
            case 28: {
                this.cpu.fs = segment;
                return;
            }
            case 29: {
                this.cpu.gs = segment;
                return;
            }
        }
    }

    public final int immediateCount(int n) {
        return ProtectedModeDecoder.immediateCount(n);
    }

    public final int operandCount(int n) {
        return ProtectedModeDecoder.operandCount(n);
    }

    private final boolean checkIOPermissionsByte(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            byte by = this.cpu.tss.getByte(n2 + (n & 0xFFFFFFF8));
            return (by & 1 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private final boolean checkIOPermissionsShort(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            short s = this.cpu.tss.getWord(n2 + (n & 0xFFFFFFF8));
            return (s & 3 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private final boolean checkIOPermissionsInt(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            short s = this.cpu.tss.getWord(n2 + (n & 0xFFFFFFF8));
            return (s & 7 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }
}

