/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.optimised;

import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.optimised.MicrocodeSet;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.SegmentFactory;
import org.jpc.emulator.processor.fpu64.FpuState;

public class ProtectedModeUBlock
implements ProtectedModeCodeBlock,
MicrocodeSet {
    private static final ProcessorException exceptionDE = new ProcessorException(0, true);
    private static final ProcessorException exceptionGP = new ProcessorException(13, 0, true);
    private static final ProcessorException exceptionSS = new ProcessorException(12, true);
    private static final ProcessorException exceptionUD = new ProcessorException(6, true);
    private static final boolean[] parityMap = new boolean[256];
    private Processor cpu;
    private FpuState fpu;
    private int x86Count;
    protected int[] microcodes;
    protected int[] cumulativeX86Length;
    private int executeCount;

    public ProtectedModeUBlock() {
    }

    public ProtectedModeUBlock(int[] nArray, int[] nArray2) {
        this.microcodes = nArray;
        this.cumulativeX86Length = nArray2;
        if (this.cumulativeX86Length.length == 0) {
            this.x86Count = 0;
        } else {
            int n = 1;
            for (int i = 1; i < this.cumulativeX86Length.length; ++i) {
                if (this.cumulativeX86Length[i] <= this.cumulativeX86Length[i - 1]) continue;
                ++n;
            }
            this.x86Count = n;
        }
    }

    public int getX86Length() {
        if (this.microcodes.length == 0) {
            return 0;
        }
        return this.cumulativeX86Length[this.microcodes.length - 1];
    }

    public int getX86Count() {
        return this.x86Count;
    }

    public boolean handleMemoryRegionChange(int n, int n2) {
        return false;
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.microcodes.length; ++i) {
            stringBuffer.append(i + ": " + this.microcodes[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "OptimisedProtectedFirstStageCodeBlock";
    }

    public int[] getMicrocodes() {
        int[] nArray = new int[this.microcodes.length];
        System.arraycopy(this.microcodes, 0, nArray, 0, nArray.length);
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int execute(Processor processor) {
        this.fpu = processor.fpu;
        this.cpu = processor;
        Segment segment = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        this.executeCount = this.getX86Count();
        boolean bl = false;
        int n5 = 0;
        try {
            block552: while (n5 < this.microcodes.length) {
                switch (this.microcodes[n5++]) {
                    case 2: {
                        if (bl) continue block552;
                        bl = true;
                        processor.eip += this.cumulativeX86Length[n5 - 1];
                        continue block552;
                    }
                    case 648: {
                        System.err.println("Undefined Opcode");
                        throw exceptionUD;
                    }
                    case 0: {
                        n = 0;
                        segment = null;
                        continue block552;
                    }
                    case 150: {
                        n2 = processor.eax;
                        continue block552;
                    }
                    case 201: {
                        n2 = processor.ecx;
                        continue block552;
                    }
                    case 218: {
                        n2 = processor.edx;
                        continue block552;
                    }
                    case 197: {
                        n2 = processor.ebx;
                        continue block552;
                    }
                    case 235: {
                        n2 = processor.esp;
                        continue block552;
                    }
                    case 236: {
                        n2 = processor.ebp;
                        continue block552;
                    }
                    case 202: {
                        n2 = processor.esi;
                        continue block552;
                    }
                    case 206: {
                        n2 = processor.edi;
                        continue block552;
                    }
                    case 153: {
                        processor.eax = n2;
                        continue block552;
                    }
                    case 203: {
                        processor.ecx = n2;
                        continue block552;
                    }
                    case 207: {
                        processor.edx = n2;
                        continue block552;
                    }
                    case 198: {
                        processor.ebx = n2;
                        continue block552;
                    }
                    case 250: {
                        processor.esp = n2;
                        continue block552;
                    }
                    case 251: {
                        processor.ebp = n2;
                        continue block552;
                    }
                    case 205: {
                        processor.esi = n2;
                        continue block552;
                    }
                    case 204: {
                        processor.edi = n2;
                        continue block552;
                    }
                    case 190: {
                        n3 = processor.eax;
                        continue block552;
                    }
                    case 217: {
                        n3 = processor.ecx;
                        continue block552;
                    }
                    case 215: {
                        n3 = processor.edx;
                        continue block552;
                    }
                    case 220: {
                        n3 = processor.ebx;
                        continue block552;
                    }
                    case 264: {
                        n3 = processor.esp;
                        continue block552;
                    }
                    case 265: {
                        n3 = processor.ebp;
                        continue block552;
                    }
                    case 266: {
                        n3 = processor.esi;
                        continue block552;
                    }
                    case 221: {
                        n3 = processor.edi;
                        continue block552;
                    }
                    case 267: {
                        processor.eax = n3;
                        continue block552;
                    }
                    case 268: {
                        processor.ecx = n3;
                        continue block552;
                    }
                    case 269: {
                        processor.edx = n3;
                        continue block552;
                    }
                    case 270: {
                        processor.ebx = n3;
                        continue block552;
                    }
                    case 10: {
                        processor.esp = n3;
                        continue block552;
                    }
                    case 271: {
                        processor.ebp = n3;
                        continue block552;
                    }
                    case 272: {
                        processor.esi = n3;
                        continue block552;
                    }
                    case 273: {
                        processor.edi = n3;
                        continue block552;
                    }
                    case 6: {
                        n2 = processor.eax & 0xFFFF;
                        continue block552;
                    }
                    case 30: {
                        n2 = processor.ecx & 0xFFFF;
                        continue block552;
                    }
                    case 38: {
                        n2 = processor.edx & 0xFFFF;
                        continue block552;
                    }
                    case 25: {
                        n2 = processor.ebx & 0xFFFF;
                        continue block552;
                    }
                    case 19: {
                        n2 = processor.esp & 0xFFFF;
                        continue block552;
                    }
                    case 31: {
                        n2 = processor.ebp & 0xFFFF;
                        continue block552;
                    }
                    case 48: {
                        n2 = processor.esi & 0xFFFF;
                        continue block552;
                    }
                    case 53: {
                        n2 = processor.edi & 0xFFFF;
                        continue block552;
                    }
                    case 12: {
                        processor.eax = processor.eax & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 29: {
                        processor.ecx = processor.ecx & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 42: {
                        processor.edx = processor.edx & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 15: {
                        processor.ebx = processor.ebx & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 33: {
                        processor.esp = processor.esp & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 17: {
                        processor.ebp = processor.ebp & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 40: {
                        processor.esi = processor.esi & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 47: {
                        processor.edi = processor.edi & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block552;
                    }
                    case 86: {
                        processor.eax = processor.eax & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 274: {
                        processor.ecx = processor.ecx & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 275: {
                        processor.edx = processor.edx & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 276: {
                        processor.ebx = processor.ebx & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 277: {
                        processor.esp = processor.esp & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 278: {
                        processor.ebp = processor.ebp & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 231: {
                        processor.esi = processor.esi & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 170: {
                        processor.edi = processor.edi & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block552;
                    }
                    case 63: {
                        n3 = processor.eax & 0xFFFF;
                        continue block552;
                    }
                    case 61: {
                        n3 = processor.ecx & 0xFFFF;
                        continue block552;
                    }
                    case 109: {
                        n3 = processor.edx & 0xFFFF;
                        continue block552;
                    }
                    case 83: {
                        n3 = processor.ebx & 0xFFFF;
                        continue block552;
                    }
                    case 187: {
                        n3 = processor.esp & 0xFFFF;
                        continue block552;
                    }
                    case 127: {
                        n3 = processor.ebp & 0xFFFF;
                        continue block552;
                    }
                    case 90: {
                        n3 = processor.esi & 0xFFFF;
                        continue block552;
                    }
                    case 87: {
                        n3 = processor.edi & 0xFFFF;
                        continue block552;
                    }
                    case 34: {
                        n2 = processor.eax & 0xFF;
                        continue block552;
                    }
                    case 135: {
                        n2 = processor.ecx & 0xFF;
                        continue block552;
                    }
                    case 111: {
                        n2 = processor.edx & 0xFF;
                        continue block552;
                    }
                    case 129: {
                        n2 = processor.ebx & 0xFF;
                        continue block552;
                    }
                    case 46: {
                        n2 = processor.eax >> 8 & 0xFF;
                        continue block552;
                    }
                    case 144: {
                        n2 = processor.ecx >> 8 & 0xFF;
                        continue block552;
                    }
                    case 173: {
                        n2 = processor.edx >> 8 & 0xFF;
                        continue block552;
                    }
                    case 65: {
                        n2 = processor.ebx >> 8 & 0xFF;
                        continue block552;
                    }
                    case 24: {
                        processor.eax = processor.eax & 0xFFFFFF00 | n2 & 0xFF;
                        continue block552;
                    }
                    case 94: {
                        processor.ecx = processor.ecx & 0xFFFFFF00 | n2 & 0xFF;
                        continue block552;
                    }
                    case 116: {
                        processor.edx = processor.edx & 0xFFFFFF00 | n2 & 0xFF;
                        continue block552;
                    }
                    case 81: {
                        processor.ebx = processor.ebx & 0xFFFFFF00 | n2 & 0xFF;
                        continue block552;
                    }
                    case 60: {
                        processor.eax = processor.eax & 0xFFFF00FF | n2 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 142: {
                        processor.ecx = processor.ecx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 172: {
                        processor.edx = processor.edx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 58: {
                        processor.ebx = processor.ebx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 73: {
                        n3 = processor.eax & 0xFF;
                        continue block552;
                    }
                    case 92: {
                        n3 = processor.ecx & 0xFF;
                        continue block552;
                    }
                    case 124: {
                        n3 = processor.edx & 0xFF;
                        continue block552;
                    }
                    case 152: {
                        n3 = processor.ebx & 0xFF;
                        continue block552;
                    }
                    case 68: {
                        n3 = processor.eax >> 8 & 0xFF;
                        continue block552;
                    }
                    case 143: {
                        n3 = processor.ecx >> 8 & 0xFF;
                        continue block552;
                    }
                    case 174: {
                        n3 = processor.edx >> 8 & 0xFF;
                        continue block552;
                    }
                    case 64: {
                        n3 = processor.ebx >> 8 & 0xFF;
                        continue block552;
                    }
                    case 216: {
                        processor.eax = processor.eax & 0xFFFFFF00 | n3 & 0xFF;
                        continue block552;
                    }
                    case 178: {
                        processor.ecx = processor.ecx & 0xFFFFFF00 | n3 & 0xFF;
                        continue block552;
                    }
                    case 279: {
                        processor.edx = processor.edx & 0xFFFFFF00 | n3 & 0xFF;
                        continue block552;
                    }
                    case 280: {
                        processor.ebx = processor.ebx & 0xFFFFFF00 | n3 & 0xFF;
                        continue block552;
                    }
                    case 281: {
                        processor.eax = processor.eax & 0xFFFF00FF | n3 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 282: {
                        processor.ecx = processor.ecx & 0xFFFF00FF | n3 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 283: {
                        processor.edx = processor.edx & 0xFFFF00FF | n3 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 284: {
                        processor.ebx = processor.ebx & 0xFFFF00FF | n3 << 8 & 0xFF00;
                        continue block552;
                    }
                    case 222: {
                        n2 = processor.getCR0();
                        continue block552;
                    }
                    case 239: {
                        n2 = processor.getCR2();
                        continue block552;
                    }
                    case 240: {
                        n2 = processor.getCR3();
                        continue block552;
                    }
                    case 241: {
                        n2 = processor.getCR4();
                        continue block552;
                    }
                    case 223: {
                        processor.setCR0(n2);
                        continue block552;
                    }
                    case 255: {
                        processor.setCR2(n2);
                        continue block552;
                    }
                    case 256: {
                        processor.setCR3(n2);
                        continue block552;
                    }
                    case 257: {
                        processor.setCR4(n2);
                        continue block552;
                    }
                    case 242: {
                        n2 = processor.getDR0();
                        continue block552;
                    }
                    case 243: {
                        n2 = processor.getDR1();
                        continue block552;
                    }
                    case 244: {
                        n2 = processor.getDR2();
                        continue block552;
                    }
                    case 245: {
                        n2 = processor.getDR3();
                        continue block552;
                    }
                    case 246: {
                        n2 = processor.getDR6();
                        continue block552;
                    }
                    case 247: {
                        n2 = processor.getDR7();
                        continue block552;
                    }
                    case 258: {
                        processor.setDR0(n2);
                        continue block552;
                    }
                    case 259: {
                        processor.setDR1(n2);
                        continue block552;
                    }
                    case 260: {
                        processor.setDR2(n2);
                        continue block552;
                    }
                    case 261: {
                        processor.setDR3(n2);
                        continue block552;
                    }
                    case 262: {
                        processor.setDR6(n2);
                        continue block552;
                    }
                    case 263: {
                        processor.setDR7(n2);
                        continue block552;
                    }
                    case 67: {
                        n2 = 0xFFFF & processor.es.getSelector();
                        continue block552;
                    }
                    case 169: {
                        n2 = 0xFFFF & processor.cs.getSelector();
                        continue block552;
                    }
                    case 132: {
                        n2 = 0xFFFF & processor.ss.getSelector();
                        continue block552;
                    }
                    case 51: {
                        n2 = 0xFFFF & processor.ds.getSelector();
                        continue block552;
                    }
                    case 237: {
                        n2 = 0xFFFF & processor.fs.getSelector();
                        continue block552;
                    }
                    case 238: {
                        n2 = 0xFFFF & processor.gs.getSelector();
                        continue block552;
                    }
                    case 55: {
                        processor.es = this.loadSegment(n2);
                        continue block552;
                    }
                    case 139: {
                        Segment segment2 = this.loadSegment(n2);
                        if (segment2 == SegmentFactory.NULL_SEGMENT) {
                            throw exceptionGP;
                        }
                        processor.ss = segment2;
                        processor.eflagsInterruptEnable = false;
                        continue block552;
                    }
                    case 37: {
                        processor.ds = this.loadSegment(n2);
                        continue block552;
                    }
                    case 253: {
                        processor.fs = this.loadSegment(n2);
                        continue block552;
                    }
                    case 254: {
                        processor.gs = this.loadSegment(n2);
                        continue block552;
                    }
                    case 85: {
                        processor.es = this.loadSegment(n3);
                        continue block552;
                    }
                    case 286: {
                        Segment segment3 = this.loadSegment(n3);
                        if (segment3 == SegmentFactory.NULL_SEGMENT) {
                            throw exceptionGP;
                        }
                        processor.ss = segment3;
                        processor.eflagsInterruptEnable = false;
                        continue block552;
                    }
                    case 91: {
                        processor.ds = this.loadSegment(n3);
                        continue block552;
                    }
                    case 287: {
                        processor.fs = this.loadSegment(n3);
                        continue block552;
                    }
                    case 288: {
                        processor.gs = this.loadSegment(n3);
                        continue block552;
                    }
                    case 8: {
                        n2 = this.microcodes[n5++] & 0xFF;
                        continue block552;
                    }
                    case 13: {
                        n2 = this.microcodes[n5++] & 0xFFFF;
                        continue block552;
                    }
                    case 249: {
                        n2 = this.microcodes[n5++];
                        continue block552;
                    }
                    case 26: {
                        n3 = this.microcodes[n5++] & 0xFF;
                        continue block552;
                    }
                    case 27: {
                        n3 = this.microcodes[n5++] & 0xFFFF;
                        continue block552;
                    }
                    case 166: {
                        n3 = this.microcodes[n5++];
                        continue block552;
                    }
                    case 290: {
                        n4 = processor.eax;
                        continue block552;
                    }
                    case 291: {
                        n4 = processor.eax & 0xFFFF;
                        continue block552;
                    }
                    case 292: {
                        n4 = processor.eax & 0xFF;
                        continue block552;
                    }
                    case 293: {
                        n4 = processor.ecx & 0xFFFF;
                        continue block552;
                    }
                    case 294: {
                        n4 = this.microcodes[n5++] & 0xFF;
                        continue block552;
                    }
                    case 59: {
                        segment = processor.es;
                        continue block552;
                    }
                    case 76: {
                        segment = processor.cs;
                        continue block552;
                    }
                    case 5: {
                        segment = processor.ss;
                        continue block552;
                    }
                    case 14: {
                        segment = processor.ds;
                        continue block552;
                    }
                    case 295: {
                        segment = processor.fs;
                        continue block552;
                    }
                    case 296: {
                        segment = processor.gs;
                        continue block552;
                    }
                    case 297: {
                        n += n3;
                        continue block552;
                    }
                    case 298: {
                        n += n3 << 1;
                        continue block552;
                    }
                    case 299: {
                        n += n3 << 2;
                        continue block552;
                    }
                    case 300: {
                        n += n3 << 3;
                        continue block552;
                    }
                    case 301: {
                        n += processor.eax;
                        continue block552;
                    }
                    case 302: {
                        n += processor.ecx;
                        continue block552;
                    }
                    case 303: {
                        n += processor.edx;
                        continue block552;
                    }
                    case 304: {
                        n += processor.ebx;
                        continue block552;
                    }
                    case 305: {
                        n += processor.esp;
                        continue block552;
                    }
                    case 306: {
                        n += processor.ebp;
                        continue block552;
                    }
                    case 307: {
                        n += processor.esi;
                        continue block552;
                    }
                    case 308: {
                        n += processor.edi;
                        continue block552;
                    }
                    case 309: {
                        n += (short)processor.eax;
                        continue block552;
                    }
                    case 310: {
                        n += (short)processor.ecx;
                        continue block552;
                    }
                    case 311: {
                        n += (short)processor.edx;
                        continue block552;
                    }
                    case 18: {
                        n += (short)processor.ebx;
                        continue block552;
                    }
                    case 312: {
                        n += (short)processor.esp;
                        continue block552;
                    }
                    case 7: {
                        n += (short)processor.ebp;
                        continue block552;
                    }
                    case 43: {
                        n += (short)processor.esi;
                        continue block552;
                    }
                    case 95: {
                        n += (short)processor.edi;
                        continue block552;
                    }
                    case 313: {
                        n += processor.eax << 1;
                        continue block552;
                    }
                    case 314: {
                        n += processor.ecx << 1;
                        continue block552;
                    }
                    case 315: {
                        n += processor.edx << 1;
                        continue block552;
                    }
                    case 316: {
                        n += processor.ebx << 1;
                        continue block552;
                    }
                    case 317: {
                        n += processor.esp << 1;
                        continue block552;
                    }
                    case 318: {
                        n += processor.ebp << 1;
                        continue block552;
                    }
                    case 319: {
                        n += processor.esi << 1;
                        continue block552;
                    }
                    case 320: {
                        n += processor.edi << 1;
                        continue block552;
                    }
                    case 321: {
                        n += processor.eax << 2;
                        continue block552;
                    }
                    case 322: {
                        n += processor.ecx << 2;
                        continue block552;
                    }
                    case 323: {
                        n += processor.edx << 2;
                        continue block552;
                    }
                    case 324: {
                        n += processor.ebx << 2;
                        continue block552;
                    }
                    case 325: {
                        n += processor.esp << 2;
                        continue block552;
                    }
                    case 326: {
                        n += processor.ebp << 2;
                        continue block552;
                    }
                    case 327: {
                        n += processor.esi << 2;
                        continue block552;
                    }
                    case 328: {
                        n += processor.edi << 2;
                        continue block552;
                    }
                    case 329: {
                        n += processor.eax << 3;
                        continue block552;
                    }
                    case 330: {
                        n += processor.ecx << 3;
                        continue block552;
                    }
                    case 331: {
                        n += processor.edx << 3;
                        continue block552;
                    }
                    case 332: {
                        n += processor.ebx << 3;
                        continue block552;
                    }
                    case 333: {
                        n += processor.esp << 3;
                        continue block552;
                    }
                    case 334: {
                        n += processor.ebp << 3;
                        continue block552;
                    }
                    case 335: {
                        n += processor.esi << 3;
                        continue block552;
                    }
                    case 336: {
                        n += processor.edi << 3;
                        continue block552;
                    }
                    case 3: {
                        n += (byte)this.microcodes[n5++];
                        continue block552;
                    }
                    case 49: {
                        n += (short)this.microcodes[n5++];
                        continue block552;
                    }
                    case 227: {
                        n += this.microcodes[n5++];
                        continue block552;
                    }
                    case 1: {
                        n &= 0xFFFF;
                        continue block552;
                    }
                    case 337: {
                        n += 0xFF & processor.eax;
                        continue block552;
                    }
                    case 79: {
                        n2 = n;
                        continue block552;
                    }
                    case 22: {
                        n2 = 0xFF & segment.getByte(n);
                        continue block552;
                    }
                    case 9: {
                        n2 = 0xFFFF & segment.getWord(n);
                        continue block552;
                    }
                    case 167: {
                        n2 = segment.getDoubleWord(n);
                        continue block552;
                    }
                    case 88: {
                        n3 = 0xFF & segment.getByte(n);
                        continue block552;
                    }
                    case 52: {
                        n3 = 0xFFFF & segment.getWord(n);
                        continue block552;
                    }
                    case 213: {
                        n3 = segment.getDoubleWord(n);
                        continue block552;
                    }
                    case 66: {
                        segment.setByte(n, (byte)n2);
                        continue block552;
                    }
                    case 21: {
                        segment.setWord(n, (short)n2);
                        continue block552;
                    }
                    case 159: {
                        segment.setDoubleWord(n, n2);
                        continue block552;
                    }
                    case 232: {
                        segment.setByte(n, (byte)n3);
                        continue block552;
                    }
                    case 188: {
                        segment.setWord(n, (short)n3);
                        continue block552;
                    }
                    case 289: {
                        segment.setDoubleWord(n, n3);
                        continue block552;
                    }
                    case 41: {
                        n2 ^= n3;
                        continue block552;
                    }
                    case 57: {
                        n2 &= n3;
                        continue block552;
                    }
                    case 84: {
                        n2 |= n3;
                        continue block552;
                    }
                    case 126: {
                        n2 ^= 0xFFFFFFFF;
                        continue block552;
                    }
                    case 16: {
                        n4 = n2;
                        n2 = n4 - n3;
                        continue block552;
                    }
                    case 118: {
                        n4 = n2;
                        n2 = n4 - (n3 + (processor.getCarryFlag() ? 1 : 0));
                        continue block552;
                    }
                    case 20: {
                        n4 = n2;
                        n2 = n4 + n3;
                        continue block552;
                    }
                    case 69: {
                        n4 = n2;
                        n2 = n4 + n3 + (processor.getCarryFlag() ? 1 : 0);
                        continue block552;
                    }
                    case 180: {
                        n2 = -n2;
                        continue block552;
                    }
                    case 185: {
                        this.mul_o8(n2);
                        continue block552;
                    }
                    case 131: {
                        this.mul_o16(n2);
                        continue block552;
                    }
                    case 233: {
                        this.mul_o32(n2);
                        continue block552;
                    }
                    case 348: {
                        this.imula_o8((byte)n2);
                        continue block552;
                    }
                    case 108: {
                        this.imula_o16((short)n2);
                        continue block552;
                    }
                    case 349: {
                        this.imula_o32(n2);
                        continue block552;
                    }
                    case 346: {
                        n2 = this.imul_o16((short)n2, (short)n3);
                        continue block552;
                    }
                    case 347: {
                        n2 = this.imul_o32(n2, n3);
                        continue block552;
                    }
                    case 186: {
                        this.div_o8(n2);
                        continue block552;
                    }
                    case 130: {
                        this.div_o16(n2);
                        continue block552;
                    }
                    case 350: {
                        this.div_o32(n2);
                        continue block552;
                    }
                    case 351: {
                        this.idiv_o8((byte)n2);
                        continue block552;
                    }
                    case 145: {
                        this.idiv_o16((short)n2);
                        continue block552;
                    }
                    case 352: {
                        this.idiv_o32(n2);
                        continue block552;
                    }
                    case 381: {
                        n2 = this.bsf(n3, n2);
                        continue block552;
                    }
                    case 382: {
                        n2 = this.bsr(n3, n2);
                        continue block552;
                    }
                    case 369: {
                        this.bt_mem(n3, segment, n);
                        continue block552;
                    }
                    case 372: {
                        this.bts_mem(n3, segment, n);
                        continue block552;
                    }
                    case 375: {
                        this.btr_mem(n3, segment, n);
                        continue block552;
                    }
                    case 378: {
                        this.btc_mem(n3, segment, n);
                        continue block552;
                    }
                    case 371: {
                        processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                        continue block552;
                    }
                    case 370: {
                        processor.setCarryFlag(n2, n3 &= 0xF, 7);
                        continue block552;
                    }
                    case 374: {
                        processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                        n2 |= 1 << n3;
                        continue block552;
                    }
                    case 373: {
                        processor.setCarryFlag(n2, n3 &= 0xF, 7);
                        n2 |= 1 << n3;
                        continue block552;
                    }
                    case 377: {
                        processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                        n2 &= ~(1 << n3);
                        continue block552;
                    }
                    case 376: {
                        processor.setCarryFlag(n2, n3 &= 0xF, 7);
                        n2 &= ~(1 << n3);
                        continue block552;
                    }
                    case 380: {
                        processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                        n2 ^= 1 << n3;
                        continue block552;
                    }
                    case 379: {
                        processor.setCarryFlag(n2, n3 &= 0xF, 7);
                        n2 ^= 1 << n3;
                        continue block552;
                    }
                    case 355: {
                        n2 = n2 << (n3 &= 7) | n2 >>> 8 - n3;
                        continue block552;
                    }
                    case 356: {
                        n2 = n2 << (n3 &= 0xF) | n2 >>> 16 - n3;
                        continue block552;
                    }
                    case 357: {
                        n2 = n2 << (n3 &= 0x1F) | n2 >>> 32 - n3;
                        continue block552;
                    }
                    case 161: {
                        n2 = n2 >>> (n3 &= 7) | n2 << 8 - n3;
                        continue block552;
                    }
                    case 358: {
                        n2 = n2 >>> (n3 &= 0xF) | n2 << 16 - n3;
                        continue block552;
                    }
                    case 359: {
                        n2 = n2 >>> (n3 &= 0x1F) | n2 << 32 - n3;
                        continue block552;
                    }
                    case 360: {
                        n3 &= 0x1F;
                        n2 |= processor.getCarryFlag() ? 256 : 0;
                        n2 = n2 << (n3 %= 9) | n2 >>> 9 - n3;
                        continue block552;
                    }
                    case 211: {
                        n3 &= 0x1F;
                        n2 |= processor.getCarryFlag() ? 65536 : 0;
                        n2 = n2 << (n3 %= 17) | n2 >>> 17 - n3;
                        continue block552;
                    }
                    case 361: {
                        l = 0xFFFFFFFFL & (long)n2 | (processor.getCarryFlag() ? 0x100000000L : 0L);
                        l = l << (n3 &= 0x1F) | l >>> 33 - n3;
                        n2 = (int)l;
                        continue block552;
                    }
                    case 362: {
                        n3 &= 0x1F;
                        n2 |= processor.getCarryFlag() ? 256 : 0;
                        n2 = n2 >>> (n3 %= 9) | n2 << 9 - n3;
                        continue block552;
                    }
                    case 363: {
                        n3 &= 0x1F;
                        n2 |= processor.getCarryFlag() ? 65536 : 0;
                        n2 = n2 >>> (n3 %= 17) | n2 << 17 - n3;
                        continue block552;
                    }
                    case 364: {
                        l = 0xFFFFFFFFL & (long)n2 | (processor.getCarryFlag() ? 0x100000000L : 0L);
                        l = l >>> (n3 &= 0x1F) | l << 33 - n3;
                        n2 = (int)l;
                        continue block552;
                    }
                    case 80: {
                        n4 = n2;
                        n2 <<= n3;
                        continue block552;
                    }
                    case 96: {
                        n4 = n2;
                        n2 >>>= n3;
                        continue block552;
                    }
                    case 353: {
                        n4 = n2;
                        n2 = (byte)n2 >> n3;
                        continue block552;
                    }
                    case 196: {
                        n4 = n2;
                        n2 = (short)n2 >> n3;
                        continue block552;
                    }
                    case 354: {
                        n4 = n2;
                        n2 >>= n3;
                        continue block552;
                    }
                    case 365: {
                        int n6 = n2;
                        n2 = n2 << (n4 &= 0x1F) | n3 >>> 16 - n4;
                        n3 = n4;
                        n4 = n6;
                        continue block552;
                    }
                    case 366: {
                        int n7 = n2;
                        if ((n4 &= 0x1F) != 0) {
                            n2 = n2 << n4 | n3 >>> 32 - n4;
                        }
                        n3 = n4;
                        n4 = n7;
                        continue block552;
                    }
                    case 367: {
                        int n8 = n2;
                        n2 = n2 >>> (n4 &= 0x1F) | n3 << 16 - n4;
                        n3 = n4;
                        n4 = n8;
                        continue block552;
                    }
                    case 368: {
                        int n9 = n2;
                        if ((n4 &= 0x1F) != 0) {
                            n2 = n2 >>> n4 | n3 << 32 - n4;
                        }
                        n3 = n4;
                        n4 = n9;
                        continue block552;
                    }
                    case 141: {
                        if ((processor.eax & 0x8000) == 0) {
                            processor.edx &= 0xFFFF0000;
                            continue block552;
                        }
                        processor.edx |= 0xFFFF;
                        continue block552;
                    }
                    case 383: {
                        if ((processor.eax & Integer.MIN_VALUE) == 0) {
                            processor.edx = 0;
                            continue block552;
                        }
                        processor.edx = -1;
                        continue block552;
                    }
                    case 457: {
                        this.aaa();
                        continue block552;
                    }
                    case 458: {
                        this.aad(n2);
                        continue block552;
                    }
                    case 459: {
                        this.aam(n2);
                        continue block552;
                    }
                    case 460: {
                        this.aas();
                        continue block552;
                    }
                    case 461: {
                        this.daa();
                        continue block552;
                    }
                    case 462: {
                        this.das();
                        continue block552;
                    }
                    case 171: {
                        this.lahf();
                        continue block552;
                    }
                    case 193: {
                        processor.setCarryFlag(false);
                        continue block552;
                    }
                    case 192: {
                        processor.setCarryFlag(true);
                        continue block552;
                    }
                    case 133: {
                        processor.eflagsInterruptEnableSoon = false;
                        processor.eflagsInterruptEnable = false;
                        continue block552;
                    }
                    case 101: {
                        processor.eflagsInterruptEnableSoon = true;
                        processor.eflagsInterruptEnable = true;
                        continue block552;
                    }
                    case 110: {
                        processor.eflagsDirection = false;
                        continue block552;
                    }
                    case 455: {
                        processor.eflagsDirection = true;
                        continue block552;
                    }
                    case 456: {
                        processor.setCarryFlag(processor.getCarryFlag() ^ true);
                        continue block552;
                    }
                    case 112: {
                        n2 = 0xFFFF & (byte)n2;
                        continue block552;
                    }
                    case 520: {
                        n2 = (byte)n2;
                        continue block552;
                    }
                    case 521: {
                        n2 = (short)n2;
                        continue block552;
                    }
                    case 54: {
                        ++n2;
                        continue block552;
                    }
                    case 77: {
                        --n2;
                        continue block552;
                    }
                    case 498: {
                        this.halt();
                        continue block552;
                    }
                    case 390: {
                        this.jo_o8((byte)n2);
                        continue block552;
                    }
                    case 391: {
                        this.jno_o8((byte)n2);
                        continue block552;
                    }
                    case 72: {
                        this.jc_o8((byte)n2);
                        continue block552;
                    }
                    case 71: {
                        this.jnc_o8((byte)n2);
                        continue block552;
                    }
                    case 45: {
                        this.jz_o8((byte)n2);
                        continue block552;
                    }
                    case 23: {
                        this.jnz_o8((byte)n2);
                        continue block552;
                    }
                    case 99: {
                        this.jna_o8((byte)n2);
                        continue block552;
                    }
                    case 98: {
                        this.ja_o8((byte)n2);
                        continue block552;
                    }
                    case 392: {
                        this.js_o8((byte)n2);
                        continue block552;
                    }
                    case 199: {
                        this.jns_o8((byte)n2);
                        continue block552;
                    }
                    case 393: {
                        this.jp_o8((byte)n2);
                        continue block552;
                    }
                    case 394: {
                        this.jnp_o8((byte)n2);
                        continue block552;
                    }
                    case 105: {
                        this.jl_o8((byte)n2);
                        continue block552;
                    }
                    case 147: {
                        this.jnl_o8((byte)n2);
                        continue block552;
                    }
                    case 154: {
                        this.jng_o8((byte)n2);
                        continue block552;
                    }
                    case 136: {
                        this.jg_o8((byte)n2);
                        continue block552;
                    }
                    case 395: {
                        this.jo_o16((short)n2);
                        continue block552;
                    }
                    case 396: {
                        this.jno_o16((short)n2);
                        continue block552;
                    }
                    case 176: {
                        this.jc_o16((short)n2);
                        continue block552;
                    }
                    case 183: {
                        this.jnc_o16((short)n2);
                        continue block552;
                    }
                    case 104: {
                        this.jz_o16((short)n2);
                        continue block552;
                    }
                    case 134: {
                        this.jnz_o16((short)n2);
                        continue block552;
                    }
                    case 397: {
                        this.jna_o16((short)n2);
                        continue block552;
                    }
                    case 212: {
                        this.ja_o16((short)n2);
                        continue block552;
                    }
                    case 398: {
                        this.js_o16((short)n2);
                        continue block552;
                    }
                    case 399: {
                        this.jns_o16((short)n2);
                        continue block552;
                    }
                    case 400: {
                        this.jp_o16((short)n2);
                        continue block552;
                    }
                    case 401: {
                        this.jnp_o16((short)n2);
                        continue block552;
                    }
                    case 402: {
                        this.jl_o16((short)n2);
                        continue block552;
                    }
                    case 403: {
                        this.jnl_o16((short)n2);
                        continue block552;
                    }
                    case 404: {
                        this.jng_o16((short)n2);
                        continue block552;
                    }
                    case 405: {
                        this.jg_o16((short)n2);
                        continue block552;
                    }
                    case 406: {
                        this.jo_o32(n2);
                        continue block552;
                    }
                    case 407: {
                        this.jno_o32(n2);
                        continue block552;
                    }
                    case 408: {
                        this.jc_o32(n2);
                        continue block552;
                    }
                    case 409: {
                        this.jnc_o32(n2);
                        continue block552;
                    }
                    case 410: {
                        this.jz_o32(n2);
                        continue block552;
                    }
                    case 411: {
                        this.jnz_o32(n2);
                        continue block552;
                    }
                    case 412: {
                        this.jna_o32(n2);
                        continue block552;
                    }
                    case 413: {
                        this.ja_o32(n2);
                        continue block552;
                    }
                    case 414: {
                        this.js_o32(n2);
                        continue block552;
                    }
                    case 415: {
                        this.jns_o32(n2);
                        continue block552;
                    }
                    case 416: {
                        this.jp_o32(n2);
                        continue block552;
                    }
                    case 417: {
                        this.jnp_o32(n2);
                        continue block552;
                    }
                    case 418: {
                        this.jl_o32(n2);
                        continue block552;
                    }
                    case 419: {
                        this.jnl_o32(n2);
                        continue block552;
                    }
                    case 420: {
                        this.jng_o32(n2);
                        continue block552;
                    }
                    case 421: {
                        this.jg_o32(n2);
                        continue block552;
                    }
                    case 89: {
                        this.jcxz((byte)n2);
                        continue block552;
                    }
                    case 422: {
                        this.jecxz((byte)n2);
                        continue block552;
                    }
                    case 502: {
                        this.loop_ecx((byte)n2);
                        continue block552;
                    }
                    case 503: {
                        this.loopz_ecx((byte)n2);
                        continue block552;
                    }
                    case 504: {
                        this.loopnz_ecx((byte)n2);
                        continue block552;
                    }
                    case 70: {
                        this.jump_o8((byte)n2);
                        continue block552;
                    }
                    case 75: {
                        this.jump_o16((short)n2);
                        continue block552;
                    }
                    case 423: {
                        this.jump_o32(n2);
                        continue block552;
                    }
                    case 93: {
                        this.jump_abs(n2);
                        continue block552;
                    }
                    case 339: {
                        this.jump_abs(n2);
                        continue block552;
                    }
                    case 140: {
                        this.jump_far(n2, n3);
                        continue block552;
                    }
                    case 338: {
                        this.jump_far(n2, n3);
                        continue block552;
                    }
                    case 463: 
                    case 465: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.call_o32_a32(n2);
                            continue block552;
                        }
                        this.call_o32_a16(n2);
                        continue block552;
                    }
                    case 343: 
                    case 345: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.call_abs_o32_a32(n2);
                            continue block552;
                        }
                        this.call_abs_o32_a16(n2);
                        continue block552;
                    }
                    case 340: 
                    case 342: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need call_far_o32_a16");
                        this.call_far_o32_a32(n2, n3);
                        continue block552;
                    }
                    case 32: 
                    case 467: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.ret_o16_a32();
                            continue block552;
                        }
                        this.ret_o16_a16();
                        continue block552;
                    }
                    case 466: 
                    case 468: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.ret_o32_a32();
                            continue block552;
                        }
                        this.ret_o32_a16();
                        continue block552;
                    }
                    case 469: 
                    case 471: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.ret_iw_o32_a32((short)n2);
                            continue block552;
                        }
                        this.ret_iw_o32_a16((short)n2);
                        continue block552;
                    }
                    case 472: 
                    case 474: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need ret_far_o32_a16");
                        this.ret_far_o32_a32();
                        continue block552;
                    }
                    case 484: 
                    case 486: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need int_o32_a16?");
                        processor.handleSoftProtectedModeInterrupt(n2);
                        continue block552;
                    }
                    case 495: 
                    case 497: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need iret_o32_a16");
                        this.iret_o32_a32();
                        continue block552;
                    }
                    case 611: {
                        this.sysenter();
                        continue block552;
                    }
                    case 612: {
                        this.sysexit(n2, n3);
                        continue block552;
                    }
                    case 117: {
                        n2 = this.in_o8(n2);
                        continue block552;
                    }
                    case 386: {
                        n2 = this.in_o16(n2);
                        continue block552;
                    }
                    case 387: {
                        n2 = this.in_o32(n2);
                        continue block552;
                    }
                    case 103: {
                        this.out_o8(n2, n3);
                        continue block552;
                    }
                    case 228: {
                        this.out_o16(n2, n3);
                        continue block552;
                    }
                    case 385: {
                        this.out_o32(n2, n3);
                        continue block552;
                    }
                    case 439: {
                        if (!processor.getOverflowFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 440: {
                        if (processor.getOverflowFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 441: {
                        if (!processor.getCarryFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 442: {
                        if (processor.getCarryFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 443: {
                        if (!processor.getZeroFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 444: {
                        if (processor.getZeroFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 445: {
                        if (!processor.getCarryFlag() && !processor.getZeroFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 446: {
                        if (processor.getCarryFlag() || processor.getZeroFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 447: {
                        if (!processor.getSignFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 448: {
                        if (processor.getSignFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 449: {
                        if (!processor.getParityFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 450: {
                        if (processor.getParityFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 451: {
                        if (processor.getSignFlag() == processor.getOverflowFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 452: {
                        if (processor.getSignFlag() != processor.getOverflowFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 453: {
                        if (!processor.getZeroFlag() && processor.getSignFlag() == processor.getOverflowFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 454: {
                        if (processor.getZeroFlag() || processor.getSignFlag() != processor.getOverflowFlag()) continue block552;
                        n2 = n3;
                        continue block552;
                    }
                    case 424: {
                        n2 = processor.getOverflowFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 425: {
                        n2 = processor.getOverflowFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 234: {
                        n2 = processor.getCarryFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 426: {
                        n2 = processor.getCarryFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 427: {
                        n2 = processor.getZeroFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 428: {
                        n2 = processor.getZeroFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 429: {
                        n2 = processor.getCarryFlag() || processor.getZeroFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 430: {
                        n2 = processor.getCarryFlag() || processor.getZeroFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 431: {
                        n2 = processor.getSignFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 432: {
                        n2 = processor.getSignFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 433: {
                        n2 = processor.getParityFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 434: {
                        n2 = processor.getParityFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 435: {
                        n2 = processor.getSignFlag() != processor.getOverflowFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 436: {
                        n2 = processor.getSignFlag() != processor.getOverflowFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 437: {
                        n2 = processor.getZeroFlag() || processor.getSignFlag() != processor.getOverflowFlag() ? 1 : 0;
                        continue block552;
                    }
                    case 438: {
                        n2 = processor.getZeroFlag() || processor.getSignFlag() != processor.getOverflowFlag() ? 0 : 1;
                        continue block552;
                    }
                    case 226: {
                        n2 = processor.getCR0() & 0xFFFF;
                        continue block552;
                    }
                    case 625: {
                        if (processor.getCPL() != 0) {
                            throw exceptionGP;
                        }
                        processor.setCR0(processor.getCR0() & 0xFFFFFFF0 | n2 & 0xF);
                        continue block552;
                    }
                    case 388: {
                        if (n4 == n2) {
                            n2 = n3;
                            n3 = n4;
                            continue block552;
                        }
                        n3 = n2;
                        continue block552;
                    }
                    case 389: {
                        n2 = ProtectedModeUBlock.reverseBytes(n2);
                        continue block552;
                    }
                    case 478: 
                    case 480: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need enter_o32_a16");
                        this.enter_o32_a32(n2, n3);
                        continue block552;
                    }
                    case 157: 
                    case 479: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need enter_o16_a16");
                        this.enter_o16_a32(n2, n3);
                        continue block552;
                    }
                    case 481: 
                    case 483: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.leave_o32_a32();
                            continue block552;
                        }
                        this.leave_o32_a16();
                        continue block552;
                    }
                    case 158: 
                    case 482: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.leave_o16_a32();
                            continue block552;
                        }
                        this.leave_o16_a16();
                        continue block552;
                    }
                    case 163: 
                    case 507: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.push_o32_a32(n2);
                            continue block552;
                        }
                        this.push_o32_a16(n2);
                        continue block552;
                    }
                    case 4: 
                    case 506: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.push_o16_a32((short)n2);
                            continue block552;
                        }
                        this.push_o16_a16((short)n2);
                        continue block552;
                    }
                    case 162: 
                    case 509: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            n3 = processor.esp + 4;
                            if (this.microcodes[n5] == 139) {
                                processor.eflagsInterruptEnable = false;
                            }
                            n2 = processor.ss.getDoubleWord(processor.esp);
                            continue block552;
                        }
                        n3 = processor.esp & 0xFFFF0000 | processor.esp + 4 & 0xFFFF;
                        if (this.microcodes[n5] == 139) {
                            processor.eflagsInterruptEnable = false;
                        }
                        n2 = processor.ss.getDoubleWord(0xFFFF & processor.esp);
                        continue block552;
                    }
                    case 11: 
                    case 508: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            n3 = processor.esp + 2;
                            if (this.microcodes[n5] == 139) {
                                processor.eflagsInterruptEnable = false;
                            }
                            n2 = 0xFFFF & processor.ss.getWord(processor.esp);
                            continue block552;
                        }
                        n3 = processor.esp & 0xFFFF0000 | processor.esp + 2 & 0xFFFF;
                        if (this.microcodes[n5] == 139) {
                            processor.eflagsInterruptEnable = false;
                        }
                        n2 = 0xFFFF & processor.ss.getWord(0xFFFF & processor.esp);
                        continue block552;
                    }
                    case 510: 
                    case 512: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.pushf_o32_a32();
                            continue block552;
                        }
                        this.pushf_o32_a16();
                        continue block552;
                    }
                    case 107: 
                    case 511: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.pushf_o16_a32();
                            continue block552;
                        }
                        this.pushf_o16_a16();
                        continue block552;
                    }
                    case 513: 
                    case 515: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.popf_o32_a32();
                            continue block552;
                        }
                        this.popf_o32_a16();
                        continue block552;
                    }
                    case 119: 
                    case 514: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            this.popf_o16_a32();
                            continue block552;
                        }
                        this.popf_o16_a16();
                        continue block552;
                    }
                    case 230: 
                    case 517: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need pushad_a16");
                        this.pushad_a32();
                        continue block552;
                    }
                    case 122: 
                    case 518: {
                        if (processor.ss.getDefaultSizeFlag()) {
                            throw new IllegalStateException("need popa_a32");
                        }
                        this.popa_a16();
                        continue block552;
                    }
                    case 229: 
                    case 519: {
                        if (!processor.ss.getDefaultSizeFlag()) throw new IllegalStateException("need popad_a16");
                        this.popad_a32();
                        continue block552;
                    }
                    case 523: {
                        this.cmpsb_a32(segment);
                        continue block552;
                    }
                    case 525: {
                        this.cmpsw_a32(segment);
                        continue block552;
                    }
                    case 527: {
                        this.cmpsd_a32(segment);
                        continue block552;
                    }
                    case 528: {
                        this.repe_cmpsb_a32(segment);
                        continue block552;
                    }
                    case 530: {
                        this.repe_cmpsw_a32(segment);
                        continue block552;
                    }
                    case 532: {
                        this.repe_cmpsd_a32(segment);
                        continue block552;
                    }
                    case 534: {
                        this.repne_cmpsb_a32(segment);
                        continue block552;
                    }
                    case 536: {
                        this.repne_cmpsw_a32(segment);
                        continue block552;
                    }
                    case 538: {
                        this.repne_cmpsd_a32(segment);
                        continue block552;
                    }
                    case 540: {
                        this.insb_a32(n2);
                        continue block552;
                    }
                    case 542: {
                        this.insw_a32(n2);
                        continue block552;
                    }
                    case 544: {
                        this.insd_a32(n2);
                        continue block552;
                    }
                    case 546: {
                        this.rep_insb_a32(n2);
                        continue block552;
                    }
                    case 548: {
                        this.rep_insw_a32(n2);
                        continue block552;
                    }
                    case 550: {
                        this.rep_insd_a32(n2);
                        continue block552;
                    }
                    case 551: {
                        this.lodsb_a32(segment);
                        continue block552;
                    }
                    case 552: {
                        this.lodsw_a32(segment);
                        continue block552;
                    }
                    case 554: {
                        this.lodsd_a32(segment);
                        continue block552;
                    }
                    case 556: {
                        this.rep_lodsb_a32(segment);
                        continue block552;
                    }
                    case 558: {
                        this.rep_lodsw_a32(segment);
                        continue block552;
                    }
                    case 560: {
                        this.rep_lodsd_a32(segment);
                        continue block552;
                    }
                    case 113: {
                        this.movsb_a16(segment);
                        continue block552;
                    }
                    case 219: {
                        this.movsw_a16(segment);
                        continue block552;
                    }
                    case 563: {
                        this.movsd_a16(segment);
                        continue block552;
                    }
                    case 125: {
                        this.rep_movsb_a16(segment);
                        continue block552;
                    }
                    case 128: {
                        this.rep_movsw_a16(segment);
                        continue block552;
                    }
                    case 567: {
                        this.rep_movsd_a16(segment);
                        continue block552;
                    }
                    case 561: {
                        this.movsb_a32(segment);
                        continue block552;
                    }
                    case 562: {
                        this.movsw_a32(segment);
                        continue block552;
                    }
                    case 564: {
                        this.movsd_a32(segment);
                        continue block552;
                    }
                    case 565: {
                        this.rep_movsb_a32(segment);
                        continue block552;
                    }
                    case 566: {
                        this.rep_movsw_a32(segment);
                        continue block552;
                    }
                    case 568: {
                        this.rep_movsd_a32(segment);
                        continue block552;
                    }
                    case 569: {
                        this.outsb_a16(n2, segment);
                        continue block552;
                    }
                    case 571: {
                        this.outsw_a16(n2, segment);
                        continue block552;
                    }
                    case 573: {
                        this.outsd_a16(n2, segment);
                        continue block552;
                    }
                    case 575: {
                        this.rep_outsb_a16(n2, segment);
                        continue block552;
                    }
                    case 577: {
                        this.rep_outsw_a16(n2, segment);
                        continue block552;
                    }
                    case 579: {
                        this.rep_outsd_a16(n2, segment);
                        continue block552;
                    }
                    case 570: {
                        this.outsb_a32(n2, segment);
                        continue block552;
                    }
                    case 572: {
                        this.outsw_a32(n2, segment);
                        continue block552;
                    }
                    case 574: {
                        this.outsd_a32(n2, segment);
                        continue block552;
                    }
                    case 576: {
                        this.rep_outsb_a32(n2, segment);
                        continue block552;
                    }
                    case 578: {
                        this.rep_outsw_a32(n2, segment);
                        continue block552;
                    }
                    case 580: {
                        this.rep_outsd_a32(n2, segment);
                        continue block552;
                    }
                    case 582: {
                        this.scasb_a32(n2);
                        continue block552;
                    }
                    case 584: {
                        this.scasw_a32(n2);
                        continue block552;
                    }
                    case 586: {
                        this.scasd_a32(n2);
                        continue block552;
                    }
                    case 588: {
                        this.repe_scasb_a32(n2);
                        continue block552;
                    }
                    case 590: {
                        this.repe_scasw_a32(n2);
                        continue block552;
                    }
                    case 592: {
                        this.repe_scasd_a32(n2);
                        continue block552;
                    }
                    case 593: {
                        this.repne_scasb_a32(n2);
                        continue block552;
                    }
                    case 595: {
                        this.repne_scasw_a32(n2);
                        continue block552;
                    }
                    case 597: {
                        this.repne_scasd_a32(n2);
                        continue block552;
                    }
                    case 598: {
                        this.stosb_a32(n2);
                        continue block552;
                    }
                    case 599: {
                        this.stosw_a32(n2);
                        continue block552;
                    }
                    case 601: {
                        this.stosd_a32(n2);
                        continue block552;
                    }
                    case 603: {
                        this.rep_stosb_a32(n2);
                        continue block552;
                    }
                    case 604: {
                        this.rep_stosw_a32(n2);
                        continue block552;
                    }
                    case 606: {
                        this.rep_stosd_a32(n2);
                        continue block552;
                    }
                    case 225: {
                        processor.gdtr = processor.createDescriptorTableSegment(n3 & 0xFFFFFF, n2);
                        continue block552;
                    }
                    case 622: {
                        processor.gdtr = processor.createDescriptorTableSegment(n3, n2);
                        continue block552;
                    }
                    case 619: {
                        n3 = processor.gdtr.getBase() & 0xFFFFFF;
                        n2 = processor.gdtr.getLimit();
                        continue block552;
                    }
                    case 618: {
                        n3 = processor.gdtr.getBase();
                        n2 = processor.gdtr.getLimit();
                        continue block552;
                    }
                    case 624: {
                        processor.idtr = processor.createDescriptorTableSegment(n3 & 0xFFFFFF, n2);
                        continue block552;
                    }
                    case 623: {
                        processor.idtr = processor.createDescriptorTableSegment(n3, n2);
                        continue block552;
                    }
                    case 621: {
                        n3 = processor.idtr.getBase() & 0xFFFFFF;
                        n2 = processor.idtr.getLimit();
                        continue block552;
                    }
                    case 620: {
                        n3 = processor.idtr.getBase();
                        n2 = processor.idtr.getLimit();
                        continue block552;
                    }
                    case 617: {
                        processor.ldtr = this.lldt(n2);
                        continue block552;
                    }
                    case 616: {
                        n2 = 0xFFFF & processor.ldtr.getSelector();
                        continue block552;
                    }
                    case 615: {
                        processor.tss = this.ltr(n2);
                        continue block552;
                    }
                    case 614: {
                        n2 = 0xFFFF & processor.tss.getSelector();
                        continue block552;
                    }
                    case 613: {
                        if (processor.getCPL() != 0) {
                            throw exceptionGP;
                        }
                        processor.setCR3(processor.getCR3() & 0xFFFFFFFB);
                        continue block552;
                    }
                    case 628: {
                        if (processor.getCPL() != 0) {
                            throw exceptionGP;
                        }
                        processor.linearMemory.invalidateTLBEntry(segment.translateAddressRead(n));
                        continue block552;
                    }
                    case 607: {
                        this.cpuid();
                        continue block552;
                    }
                    case 608: {
                        if (processor.getCPL() != 0) {
                            throw exceptionGP;
                        }
                        processor.setMSR(n2, (long)n4 & 0xFFFFFFFFL | ((long)n3 & 0xFFFFFFFFL) << 32);
                        continue block552;
                    }
                    case 609: {
                        if (processor.getCPL() != 0) {
                            throw exceptionGP;
                        }
                        long l2 = processor.getMSR(n2);
                        n2 = (int)l2;
                        n3 = (int)(l2 >>> 32);
                        continue block552;
                    }
                    case 610: {
                        long l3 = this.rdtsc();
                        n2 = (int)l3;
                        n3 = (int)(l3 >>> 32);
                        continue block552;
                    }
                    case 645: {
                        this.sub_o8_flags(n4 - n3, n4, n3);
                        continue block552;
                    }
                    case 646: {
                        this.sub_o16_flags(n4 - n3, n4, n3);
                        continue block552;
                    }
                    case 647: {
                        this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n3), n4, n3);
                        continue block552;
                    }
                    case 39: {
                        this.bitwise_flags((byte)n2);
                        continue block552;
                    }
                    case 50: {
                        this.bitwise_flags((short)n2);
                        continue block552;
                    }
                    case 189: {
                        this.bitwise_flags(n2);
                        continue block552;
                    }
                    case 44: {
                        this.sub_o8_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 36: {
                        this.sub_o16_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 165: {
                        this.sub_o32_flags(l, n4, n3);
                        continue block552;
                    }
                    case 62: {
                        this.add_o8_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 35: {
                        this.add_o16_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 200: {
                        this.add_o32_flags(l, n4, n3);
                        continue block552;
                    }
                    case 102: {
                        this.adc_o8_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 74: {
                        this.adc_o16_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 630: {
                        this.adc_o32_flags(l, n4, n3);
                        continue block552;
                    }
                    case 179: {
                        this.sbb_o8_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 120: {
                        this.sbb_o16_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 631: {
                        this.sbb_o32_flags(l, n4, n3);
                        continue block552;
                    }
                    case 149: {
                        this.inc_flags((byte)n2);
                        continue block552;
                    }
                    case 56: {
                        this.inc_flags((short)n2);
                        continue block552;
                    }
                    case 168: {
                        this.inc_flags(n2);
                        continue block552;
                    }
                    case 148: {
                        this.dec_flags((byte)n2);
                        continue block552;
                    }
                    case 78: {
                        this.dec_flags((short)n2);
                        continue block552;
                    }
                    case 629: {
                        this.dec_flags(n2);
                        continue block552;
                    }
                    case 182: {
                        this.shl_flags((byte)n2, (byte)n4, n3);
                        continue block552;
                    }
                    case 82: {
                        this.shl_flags((short)n2, (short)n4, n3);
                        continue block552;
                    }
                    case 214: {
                        this.shl_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 209: {
                        this.shr_flags((byte)n2, n4, n3);
                        continue block552;
                    }
                    case 97: {
                        this.shr_flags((short)n2, n4, n3);
                        continue block552;
                    }
                    case 208: {
                        this.shr_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 632: {
                        this.sar_flags((byte)n2, (byte)n4, n3);
                        continue block552;
                    }
                    case 195: {
                        this.sar_flags((short)n2, (short)n4, n3);
                        continue block552;
                    }
                    case 633: {
                        this.sar_flags(n2, n4, n3);
                        continue block552;
                    }
                    case 634: {
                        this.rcl_o8_flags(n2, n3);
                        continue block552;
                    }
                    case 210: {
                        this.rcl_o16_flags(n2, n3);
                        continue block552;
                    }
                    case 635: {
                        this.rcl_o32_flags(l, n3);
                        continue block552;
                    }
                    case 636: {
                        this.rcr_o8_flags(n2, n3);
                        continue block552;
                    }
                    case 637: {
                        this.rcr_o16_flags(n2, n3);
                        continue block552;
                    }
                    case 638: {
                        this.rcr_o32_flags(l, n3);
                        continue block552;
                    }
                    case 639: {
                        this.rol_flags((byte)n2, n3);
                        continue block552;
                    }
                    case 640: {
                        this.rol_flags((short)n2, n3);
                        continue block552;
                    }
                    case 641: {
                        this.rol_flags(n2, n3);
                        continue block552;
                    }
                    case 160: {
                        this.ror_flags((byte)n2, n3);
                        continue block552;
                    }
                    case 642: {
                        this.ror_flags((short)n2, n3);
                        continue block552;
                    }
                    case 643: {
                        this.ror_flags(n2, n3);
                        continue block552;
                    }
                    case 224: {
                        this.neg_flags((byte)n2);
                        continue block552;
                    }
                    case 181: {
                        this.neg_flags((short)n2);
                        continue block552;
                    }
                    case 644: {
                        this.neg_flags(n2);
                        continue block552;
                    }
                }
            }
            return Math.max(this.executeCount, 0);
            throw new IllegalStateException("Unknown uCode " + this.microcodes[n5 - 1]);
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == -1) {
                throw new IllegalStateException("Execute Failed");
            }
            int n10 = n5 - 1;
            if (bl) {
                processor.eip -= this.cumulativeX86Length[n10];
            }
            if (!processorException.pointsToSelf()) {
                processor.eip += this.cumulativeX86Length[n10];
            } else {
                for (int i = n10; i >= 0; --i) {
                    if (this.cumulativeX86Length[i] == this.cumulativeX86Length[n10]) continue;
                    processor.eip += this.cumulativeX86Length[i];
                    break;
                }
            }
            if (processorException.getVector() != 14) {
                System.out.println();
                System.out.println("Location: 0x" + Integer.toHexString(processor.getInstructionPointer()));
                processorException.printStackTrace();
            }
            processor.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
        return Math.max(this.executeCount, 0);
    }

    private final void cmpsb_a32(Segment segment) {
        int n = this.cpu.esi;
        int n2 = this.cpu.edi;
        int n3 = 0xFF & segment.getByte(n);
        int n4 = 0xFF & this.cpu.es.getByte(n2);
        if (this.cpu.eflagsDirection) {
            --n;
            --n2;
        } else {
            ++n;
            ++n2;
        }
        this.cpu.esi = n;
        this.cpu.edi = n2;
        this.sub_o8_flags(n3 - n4, n3, n4);
    }

    private final void cmpsw_a32(Segment segment) {
        int n = this.cpu.esi;
        int n2 = this.cpu.edi;
        int n3 = 0xFFFF & segment.getWord(n);
        int n4 = 0xFFFF & this.cpu.es.getWord(n2);
        if (this.cpu.eflagsDirection) {
            n -= 2;
            n2 -= 2;
        } else {
            n += 2;
            n2 += 2;
        }
        this.cpu.esi = n;
        this.cpu.edi = n2;
        this.sub_o16_flags(n3 - n4, n3, n4);
    }

    private final void cmpsd_a32(Segment segment) {
        int n = this.cpu.esi;
        int n2 = this.cpu.edi;
        int n3 = segment.getDoubleWord(n);
        int n4 = this.cpu.es.getDoubleWord(n2);
        if (this.cpu.eflagsDirection) {
            n -= 4;
            n2 -= 4;
        } else {
            n += 4;
            n2 += 4;
        }
        this.cpu.esi = n;
        this.cpu.edi = n2;
        this.sub_o32_flags((0xFFFFFFFFL & (long)n3) - (0xFFFFFFFFL & (long)n4), n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsb_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFF & segment.getByte(n2);
                        n5 = 0xFF & this.cpu.es.getByte(n3);
                        --n;
                        --n2;
                        --n3;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsw_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFFFF & segment.getWord(n2);
                        n5 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n;
                        n2 -= 2;
                        n3 -= 2;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsd_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = segment.getDoubleWord(n2);
                        n5 = this.cpu.es.getDoubleWord(n3);
                        --n;
                        n2 -= 4;
                        n3 -= 4;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = segment.getDoubleWord(n2);
                    n5 = this.cpu.es.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n5), n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsb_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFF & segment.getByte(n2);
                        n5 = 0xFF & this.cpu.es.getByte(n3);
                        --n;
                        --n2;
                        --n3;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsw_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFFFF & segment.getWord(n2);
                        n5 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n;
                        n2 -= 2;
                        n3 -= 2;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsd_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = segment.getDoubleWord(n2);
                        n5 = this.cpu.es.getDoubleWord(n3);
                        --n;
                        n2 -= 4;
                        n3 -= 4;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = this.cpu.es.getDoubleWord(n2);
                    n5 = segment.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n5), n4, n5);
                }
            }
        }
    }

    private final void insb_a32(int n) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("INSB_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.edi;
        this.cpu.es.setByte(n2, (byte)this.cpu.ioports.ioPortReadByte(n));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
    }

    private final void insw_a32(int n) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("INSW_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.edi;
        this.cpu.es.setWord(n2, (short)this.cpu.ioports.ioPortReadWord(n));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
    }

    private final void insd_a32(int n) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("INSD_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.edi;
        this.cpu.es.setDoubleWord(n2, this.cpu.ioports.ioPortReadLong(n));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insb_a32(int n) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("REP_INSB_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)this.cpu.ioports.ioPortReadByte(n));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)this.cpu.ioports.ioPortReadByte(n));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insw_a32(int n) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("REP_INSW_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)this.cpu.ioports.ioPortReadWord(n));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)this.cpu.ioports.ioPortReadWord(n));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insd_a32(int n) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("REP_INSD_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, this.cpu.ioports.ioPortReadLong(n));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, this.cpu.ioports.ioPortReadLong(n));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    private final void lodsb_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & segment.getByte(n);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi = n;
    }

    private final void lodsw_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & segment.getWord(n);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi = n;
    }

    private final void lodsd_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = segment.getDoubleWord(n);
        n = this.cpu.eflagsDirection ? (n -= 4) : (n += 4);
        this.cpu.esi = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsb_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax & 0xFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2);
                    --n;
                    --n2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2);
                    --n;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsw_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2);
                    --n;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2);
                    --n;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsd_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2);
                    --n;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2);
                    --n;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.eax = n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    private final void movsb_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setByte(n, segment.getByte(n2));
        if (this.cpu.eflagsDirection) {
            --n2;
            --n;
        } else {
            ++n2;
            ++n;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void movsw_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setWord(n, segment.getWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 2;
            n -= 2;
        } else {
            n2 += 2;
            n += 2;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void movsd_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setDoubleWord(n, segment.getDoubleWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 4;
            n -= 4;
        } else {
            n2 += 4;
            n += 4;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsb_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setByte(n2 & 0xFFFF, segment.getByte(n3 & 0xFFFF));
                    --n;
                    --n3;
                    --n2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setByte(n2 & 0xFFFF, segment.getByte(n3 & 0xFFFF));
                    --n;
                    ++n3;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsw_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setWord(n2 & 0xFFFF, segment.getWord(n3 & 0xFFFF));
                    --n;
                    n3 -= 2;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setWord(n2 & 0xFFFF, segment.getWord(n3 & 0xFFFF));
                    --n;
                    n3 += 2;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsd_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2 & 0xFFFF, segment.getDoubleWord(n3 & 0xFFFF));
                    --n;
                    n3 -= 4;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2 & 0xFFFF, segment.getDoubleWord(n3 & 0xFFFF));
                    --n;
                    n3 += 4;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void movsb_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setByte(n, segment.getByte(n2));
        if (this.cpu.eflagsDirection) {
            --n2;
            --n;
        } else {
            ++n2;
            ++n;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    private final void movsw_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setWord(n, segment.getWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 2;
            n -= 2;
        } else {
            n2 += 2;
            n += 2;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    private final void movsd_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setDoubleWord(n, segment.getDoubleWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 4;
            n -= 4;
        } else {
            n2 += 4;
            n += 4;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsb_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setByte(n2, segment.getByte(n3));
                    --n;
                    --n3;
                    --n2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setByte(n2, segment.getByte(n3));
                    --n;
                    ++n3;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsw_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setWord(n2, segment.getWord(n3));
                    --n;
                    n3 -= 2;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setWord(n2, segment.getWord(n3));
                    --n;
                    n3 += 2;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsd_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2, segment.getDoubleWord(n3));
                    --n;
                    n3 -= 4;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2, segment.getDoubleWord(n3));
                    --n;
                    n3 += 4;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    private final void outsb_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("OUTSB_A16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & segment.getByte(n2));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void outsw_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("OUTSW_A16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void outsd_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("OUTSD_A16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsb_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("REP_OUTSB_A16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3 & 0xFFFF));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3 & 0xFFFF));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsw_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("REP_OUTSW_A16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3 & 0xFFFF));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3 & 0xFFFF));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsd_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("OUTSD_A16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3 & 0xFFFF));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3 & 0xFFFF));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void outsb_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("OUTSB_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.esi;
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & segment.getByte(n2));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.esi = n2;
    }

    private final void outsw_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("OUTSW_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.esi;
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.esi = n2;
    }

    private final void outsd_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("OUTSB_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.esi;
        this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.esi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsb_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("REP_OUTSB_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.esi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsw_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("REP_OUTSW_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.esi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsd_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("OUTSD_A32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.esi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.esi = n3;
        }
    }

    private final void scasb_a32(int n) {
        int n2 = this.cpu.edi;
        int n3 = 0xFF & this.cpu.es.getByte(n2);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
        this.sub_o8_flags(n - n3, n, n3);
    }

    private final void scasw_a32(int n) {
        int n2 = this.cpu.edi;
        int n3 = 0xFFFF & this.cpu.es.getWord(n2);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
        this.sub_o16_flags(n - n3, n, n3);
    }

    private final void scasd_a32(int n) {
        int n2 = this.cpu.edi;
        int n3 = this.cpu.es.getDoubleWord(n2);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
        this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n3), n, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasb_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFF & this.cpu.es.getByte(n3);
                        --n2;
                        --n3;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasw_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasd_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = this.cpu.es.getDoubleWord(n3);
                        --n2;
                        n3 -= 4;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n4), n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasb_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFF & this.cpu.es.getByte(n3);
                        --n2;
                        --n3;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasw_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasd_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = this.cpu.es.getDoubleWord(n3);
                        --n2;
                        n3 -= 4;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n4), n, n4);
                }
            }
        }
    }

    private final void stosb_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setByte(n2, (byte)n);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
    }

    private final void stosw_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setWord(n2, (short)n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
    }

    private final void stosd_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setDoubleWord(n2, n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosb_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosw_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosd_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    private final void mul_o8(int n) {
        int n2 = this.cpu.eax & 0xFF;
        int n3 = n2 * n;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n3 & 0xFFFF;
        this.cpu.setOverflowFlag(n3, 6);
        this.cpu.setCarryFlag(n3, 6);
    }

    private final void mul_o16(int n) {
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 * n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n3;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | (n3 >>>= 16);
        this.cpu.setOverflowFlag(n3, 1);
        this.cpu.setCarryFlag(n3, 1);
    }

    private final void mul_o32(int n) {
        long l = (long)this.cpu.eax & 0xFFFFFFFFL;
        long l2 = 0xFFFFFFFFL & (long)n;
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>>= 32);
        this.cpu.setOverflowFlag(l3, 1);
        this.cpu.setCarryFlag(l3, 1);
    }

    private final void imula_o8(byte by) {
        byte by2 = (byte)this.cpu.eax;
        int n = by2 * by;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.setOverflowFlag(n, 2);
        this.cpu.setCarryFlag(n, 2);
    }

    private final void imula_o16(short s) {
        short s2 = (short)this.cpu.eax;
        int n = s2 * s;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | n >>> 16;
        this.cpu.setOverflowFlag(n, 3);
        this.cpu.setCarryFlag(n, 3);
    }

    private final void imula_o32(int n) {
        long l = this.cpu.eax;
        long l2 = n;
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>> 32);
        this.cpu.setOverflowFlag(l3, 4);
        this.cpu.setCarryFlag(l3, 4);
    }

    private final int imul_o16(short s, short s2) {
        int n = s * s2;
        this.cpu.setOverflowFlag(n, 3);
        this.cpu.setCarryFlag(n, 3);
        return n;
    }

    private final int imul_o32(int n, int n2) {
        long l = n;
        long l2 = n2;
        long l3 = l * l2;
        this.cpu.setOverflowFlag(l3, 4);
        this.cpu.setCarryFlag(l3, 4);
        return (int)l3;
    }

    private final void div_o8(int n) {
        if (n == 0) {
            throw exceptionDE;
        }
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 / n;
        if (n3 > 255) {
            throw exceptionDE;
        }
        int n4 = n2 % n << 8;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n3 | 0xFF00 & n4;
    }

    private final void div_o16(int n) {
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (long)this.cpu.edx & 0xFFFFL;
        l <<= 16;
        long l2 = (l |= (long)this.cpu.eax & 0xFFFFL) / (long)n;
        if (l2 > 65535L) {
            throw exceptionDE;
        }
        long l3 = l % (long)n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | (int)(l2 & 0xFFFFL);
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | (int)(l3 & 0xFFFFL);
    }

    private final void div_o32(int n) {
        long l = 0xFFFFFFFFL & (long)n;
        if (l == 0L) {
            throw exceptionDE;
        }
        long l2 = this.cpu.edx;
        l2 <<= 32;
        long l3 = (l2 |= 0xFFFFFFFFL & (long)this.cpu.eax) & 1L;
        long l4 = l2 >>> 1;
        long l5 = l4 / l;
        long l6 = l4 % l;
        long l7 = l5 << 1;
        long l8 = (l6 << 1) + l3;
        l7 += l8 / l;
        l8 %= l;
        if (l7 > 0xFFFFFFFFL) {
            throw exceptionDE;
        }
        this.cpu.eax = (int)l7;
        this.cpu.edx = (int)l8;
    }

    private final void idiv_o8(byte by) {
        if (by == 0) {
            throw exceptionDE;
        }
        short s = (short)this.cpu.eax;
        int n = s / by;
        int n2 = s % by;
        if (n > 127 || n < -128) {
            throw exceptionDE;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n | (0xFF & n2) << 8;
    }

    private final void idiv_o16(short s) {
        if (s == 0) {
            throw exceptionDE;
        }
        int n = this.cpu.edx << 16 | this.cpu.eax & 0xFFFF;
        int n2 = n / s;
        int n3 = n % s;
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw exceptionDE;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n2;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & n3;
    }

    private final void idiv_o32(int n) {
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (0xFFFFFFFFL & (long)this.cpu.edx) << 32;
        long l2 = (l |= 0xFFFFFFFFL & (long)this.cpu.eax) / (long)n;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw exceptionDE;
        }
        long l3 = l % (long)n;
        this.cpu.eax = (int)l2;
        this.cpu.edx = (int)l3;
    }

    private final void btc_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += (n & 0xFFFFFFF8) / 8;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by ^ 1 << (n &= 7)));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void bts_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += (n & 0xFFFFFFF8) / 8;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by | 1 << (n &= 7)));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void btr_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += (n & 0xFFFFFFF8) / 8;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by & ~(1 << (n &= 7))));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void bt_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += (n & 0xFFFFFFF8) / 8;
        this.cpu.setCarryFlag(segment.getByte(n2), n &= 7, 7);
    }

    private final int bsf(int n, int n2) throws ProcessorException {
        if (n == 0) {
            this.cpu.setZeroFlag(true);
            return n2;
        }
        this.cpu.setZeroFlag(false);
        return ProtectedModeUBlock.numberOfTrailingZeros(n);
    }

    private final int bsr(int n, int n2) throws ProcessorException {
        if (n == 0) {
            this.cpu.setZeroFlag(true);
            return n2;
        }
        this.cpu.setZeroFlag(false);
        return 31 - ProtectedModeUBlock.numberOfLeadingZeros(n);
    }

    private final void aaa() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            int n = (this.cpu.eax & 0xFF) > 249 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax + 6 | 0xFF00 & this.cpu.eax + 256 + n;
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
            this.cpu.setCarryFlag(false);
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    private final void aad(int n) throws ProcessorException {
        int n2 = this.cpu.eax & 0xFF;
        int n3 = this.cpu.eax >> 8 & 0xFF;
        int n4 = n3 * n;
        int n5 = n4 + n2;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n5 & 0xFF;
        this.bitwise_flags((byte)n5);
        this.cpu.setAuxiliaryCarryFlag(n4, n5, 2);
        this.cpu.setCarryFlag(n5, 8);
        this.cpu.setOverflowFlag(n5, n2, 16);
    }

    private final void aam(int n) throws ProcessorException {
        int n2 = 0xFF & this.cpu.eax;
        if (n == 0) {
            throw exceptionDE;
        }
        int n3 = 0xFF & n2 / n;
        int n4 = 0xFF & n2 % n;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n4 | n3 << 8;
        this.cpu.setAuxiliaryCarryFlag(false);
        this.bitwise_flags((byte)n4);
    }

    private final void aas() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            int n = (this.cpu.eax & 0xFF) < 6 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax - 6 | 0xFF00 & this.cpu.eax - 256 - n;
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
            this.cpu.setCarryFlag(false);
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    private final void daa() {
        boolean bl;
        int n = this.cpu.eax & 0xFF;
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            n += 6;
            this.cpu.setAuxiliaryCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
        }
        if ((n & 0xFF) > 159 || this.cpu.getCarryFlag()) {
            n += 96;
            bl = true;
        } else {
            bl = false;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & n;
        this.bitwise_flags((byte)n);
        this.cpu.setCarryFlag(bl);
    }

    private final void das() {
        boolean bl = false;
        int n = 0xFF & this.cpu.eax;
        if ((n & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 6 & 0xFF;
            boolean bl2 = bl = n < 6 || this.cpu.getCarryFlag();
        }
        if (n > 153 || this.cpu.getCarryFlag()) {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 96 & 0xFF;
            bl = true;
        }
        this.bitwise_flags((byte)this.cpu.eax);
        this.cpu.setCarryFlag(bl);
    }

    private final void lahf() {
        int n = 512;
        if (this.cpu.getSignFlag()) {
            n |= 0x8000;
        }
        if (this.cpu.getZeroFlag()) {
            n |= 0x4000;
        }
        if (this.cpu.getAuxiliaryCarryFlag()) {
            n |= 0x1000;
        }
        if (this.cpu.getParityFlag()) {
            n |= 0x400;
        }
        if (this.cpu.getCarryFlag()) {
            n |= 0x100;
        }
        this.cpu.eax &= 0xFFFF00FF;
        this.cpu.eax |= n;
    }

    private final void halt() {
        while ((this.cpu.getInterruptFlags() & 1) == 0 || !this.cpu.eflagsInterruptEnable) {
            this.cpu.waitForInterrupt(50L);
            this.cpu.processClock();
        }
        return;
    }

    private final void jo_o8(byte by) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jno_o8(byte by) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jc_o8(byte by) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnc_o8(byte by) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jz_o8(byte by) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnz_o8(byte by) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jna_o8(byte by) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void ja_o8(byte by) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void js_o8(byte by) {
        if (this.cpu.getSignFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jns_o8(byte by) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jp_o8(byte by) {
        if (this.cpu.getParityFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnp_o8(byte by) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jl_o8(byte by) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnl_o8(byte by) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jng_o8(byte by) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jg_o8(byte by) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jo_o16(short s) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jno_o16(short s) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jc_o16(short s) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnc_o16(short s) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jz_o16(short s) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnz_o16(short s) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jna_o16(short s) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void ja_o16(short s) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void js_o16(short s) {
        if (this.cpu.getSignFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jns_o16(short s) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jp_o16(short s) {
        if (this.cpu.getParityFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnp_o16(short s) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jl_o16(short s) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnl_o16(short s) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jng_o16(short s) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jg_o16(short s) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jo_o32(int n) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jno_o32(int n) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jc_o32(int n) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnc_o32(int n) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jz_o32(int n) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnz_o32(int n) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jna_o32(int n) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void ja_o32(int n) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void js_o32(int n) {
        if (this.cpu.getSignFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jns_o32(int n) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jp_o32(int n) {
        if (this.cpu.getParityFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnp_o32(int n) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jl_o32(int n) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnl_o32(int n) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jng_o32(int n) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jg_o32(int n) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jcxz(byte by) {
        if ((this.cpu.ecx & 0xFFFF) == 0) {
            this.jump_o8(by);
        }
    }

    private final void jecxz(byte by) {
        if (this.cpu.ecx == 0) {
            this.jump_o8(by);
        }
    }

    private final void loop_ecx(byte by) {
        --this.cpu.ecx;
        if (this.cpu.ecx != 0) {
            this.jump_o8(by);
        }
    }

    private final void loopz_ecx(byte by) {
        --this.cpu.ecx;
        if (this.cpu.getZeroFlag() && this.cpu.ecx != 0) {
            this.jump_o8(by);
        }
    }

    private final void loopnz_ecx(byte by) {
        --this.cpu.ecx;
        if (!this.cpu.getZeroFlag() && this.cpu.ecx != 0) {
            this.jump_o8(by);
        }
    }

    private final void jump_o8(byte by) {
        if (by == 0) {
            return;
        }
        int n = this.cpu.eip + by;
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jump_o16(short s) {
        int n = this.cpu.eip + s & 0xFFFF;
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jump_o32(int n) {
        int n2 = this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        this.cpu.eip = n2;
    }

    private final void jump_abs(int n) {
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jump_far(int n, int n2) {
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw exceptionGP;
        }
        switch (segment.getType()) {
            default: {
                System.err.println("JMP -> Invalid Segment Type");
                throw new ProcessorException(13, n2, true);
            }
            case 5: {
                System.err.println("JMP -> Task Gate");
                throw new ProcessorException(-1, true);
            }
            case 9: 
            case 11: {
                System.err.println("JMP -> TSS (Task-State Segment)");
                throw new ProcessorException(-1, true);
            }
            case 12: {
                System.err.println("JMP -> Call Gate");
                throw new ProcessorException(-1, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() != this.cpu.getCPL() || segment.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                segment.checkAddress(n);
                segment.setRPL(this.cpu.getCPL());
                this.cpu.cs = segment;
                this.cpu.eip = n;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getDPL() > this.cpu.getCPL()) {
            throw new ProcessorException(13, n2, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(11, n2, true);
        }
        segment.checkAddress(n);
        segment.setRPL(this.cpu.getCPL());
        this.cpu.cs = segment;
        this.cpu.eip = n;
    }

    private final void call_o32_a32(int n) {
        int n2 = this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n2;
    }

    private final void call_o32_a16(int n) {
        int n2 = this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        if ((0xFFFF & this.cpu.esp) < 4 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n2;
    }

    private final void call_abs_o32_a32(int n) {
        this.cpu.cs.checkAddress(n);
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n;
    }

    private final void call_abs_o32_a16(int n) {
        this.cpu.cs.checkAddress(n);
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void call_far_o32_a32(int n, int n2) {
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw exceptionGP;
        }
        switch (segment.getType()) {
            default: {
                System.err.println("CALL -> Invalid Segment Type");
                throw new ProcessorException(13, n2, true);
            }
            case 5: {
                System.err.println("CALL -> Task Gate");
                throw new ProcessorException(-1, true);
            }
            case 9: 
            case 11: {
                System.err.println("CALL -> TSS (Task-State Segment)");
                throw new ProcessorException(-1, true);
            }
            case 12: {
                System.err.println("CALL -> Call Gate");
                throw new ProcessorException(-1, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (this.cpu.esp < 8 && this.cpu.esp > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                segment.checkAddress(n);
                this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.cs.getSelector());
                this.cpu.ss.setDoubleWord(this.cpu.esp - 8, this.cpu.eip);
                this.cpu.esp -= 8;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        System.err.println("CALL -> Conforming Code Segment");
        throw new ProcessorException(-1, true);
    }

    private final void ret_o16_a32() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp) & 0xFFFF;
        this.cpu.esp += 2;
    }

    private final void ret_o16_a16() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
    }

    private final void ret_o32_a32() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp += 4;
    }

    private final void ret_o32_a16() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(0xFFFF & this.cpu.esp);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
    }

    private final void ret_iw_o32_a32(short s) {
        this.ret_o32_a32();
        this.cpu.esp += s;
    }

    private final void ret_iw_o32_a16(short s) {
        this.ret_o32_a16();
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + s & 0xFFFF;
    }

    private final void ret_far_o32_a32() {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 8);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw exceptionGP;
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Non-Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp += 8;
                this.cpu.eip = n;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                segment.checkAddress(n);
                this.cpu.esp += 8;
                this.cpu.eip = n;
                this.cpu.cs = segment;
            }
        }
    }

    private final void iret_o32_a32() {
        Segment segment;
        if (this.cpu.eflagsNestedTask) {
            System.err.println("IRET: Task Return");
            throw new ProcessorException(-1, true);
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 12);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(12, 0, true);
        }
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        int n3 = this.cpu.ss.getDoubleWord(this.cpu.esp + 8);
        if ((n3 & 0x20000) != 0) {
            System.err.println("About to enable virtual8086 mode");
        }
        if ((segment = this.cpu.getSegment(n2)) == SegmentFactory.NULL_SEGMENT) {
            throw exceptionGP;
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Bad Segment Type For IRET");
                throw new ProcessorException(13, n2, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 20);
                    }
                    catch (ProcessorException processorException) {
                        throw new ProcessorException(12, 0, true);
                    }
                    int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp + 12);
                    int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 16);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(13, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(13, n5, true);
                    }
                    segment.checkAddress(n);
                    this.cpu.eip = n;
                    this.cpu.cs = segment;
                    this.cpu.esp = n4;
                    this.cpu.ss = segment2;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFDAB22A;
                    n6 |= 0x254DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFE5CFFF;
                        n6 |= 0x1A3000 & n3;
                    }
                    this.cpu.setEFlags(n3);
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x10) != 0 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x10) != 0 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x10) != 0 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                        // empty catch block
                    }
                    try {
                        if ((this.cpu.gs.getType() & 0x10) == 0 && (this.cpu.gs.getType() & 0x1C) != 24 || this.cpu.getCPL() <= this.cpu.gs.getDPL()) break;
                        this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {}
                    break;
                }
                segment.checkAddress(n);
                this.cpu.esp += 12;
                this.cpu.cs = segment;
                this.cpu.eip = n;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFDAB22A;
                n7 |= 0x254DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFE5CFFF;
                    n7 |= 0x1A3000 & n3;
                }
                this.cpu.setEFlags(n3);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(13, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n2, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Conforming: OUTER PRIVILEGE-LEVEL");
                    throw new ProcessorException(-1, true);
                }
                System.err.println("Conforming: SAME PRIVILEGE-LEVEL");
                throw new ProcessorException(-1, true);
            }
        }
    }

    private final void sysenter() {
        int n = (int)this.cpu.getMSR(372);
        if (n == 0) {
            throw exceptionGP;
        }
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsResume = false;
        this.cpu.cs = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n & 0xFFFC, 58435744481476607L);
        this.cpu.setCPL(0);
        this.cpu.ss = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n + 8 & 0xFFFC, 58426948388454399L);
        this.cpu.esp = (int)this.cpu.getMSR(373);
        this.cpu.eip = (int)this.cpu.getMSR(374);
    }

    private final void sysexit(int n, int n2) {
        int n3 = (int)this.cpu.getMSR(372);
        if (n3 == 0) {
            throw exceptionGP;
        }
        if (this.cpu.getCPL() != 0) {
            throw exceptionGP;
        }
        this.cpu.cs = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n3 + 16 | 3, 58541297597743103L);
        this.cpu.setCPL(3);
        this.cpu.ss = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n3 + 24 | 3, 58532501504720895L);
        this.cpu.correctAlignmentChecking(this.cpu.ss);
        this.cpu.esp = n;
        this.cpu.eip = n2;
    }

    private final int in_o8(int n) {
        if (this.checkIOPermissionsByte(n)) {
            return 0xFF & this.cpu.ioports.ioPortReadByte(n);
        }
        System.err.println("IN_O8_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
        throw exceptionGP;
    }

    private final int in_o16(int n) {
        if (this.checkIOPermissionsShort(n)) {
            return 0xFFFF & this.cpu.ioports.ioPortReadWord(n);
        }
        System.err.println("IN_O16_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
        throw exceptionGP;
    }

    private final int in_o32(int n) {
        if (this.checkIOPermissionsInt(n)) {
            return this.cpu.ioports.ioPortReadLong(n);
        }
        System.err.println("IN_O32_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
        throw exceptionGP;
    }

    private final void out_o8(int n, int n2) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("OUT_O16_O8: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & n2);
    }

    private final void out_o16(int n, int n2) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("OUT_O16_O16: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & n2);
    }

    private final void out_o32(int n, int n2) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("OUT_O16_O32: Denied IO Port Access [port:0x" + Integer.toHexString(n) + " cpl:" + this.cpu.getCPL() + "]");
            throw exceptionGP;
        }
        this.cpu.ioports.ioPortWriteLong(n, n2);
    }

    private final void enter_o16_a32(int n, int n2) {
        int n3 = this.cpu.esp;
        int n4 = this.cpu.ebp;
        if ((n2 %= 32) == 0 ? n3 < 2 + n && n3 > 0 : n3 < 2 + n + 2 * n2 && n3 > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(n3 -= 2, (short)n4);
        int n5 = n3;
        if (n2 > 0) {
            while (--n2 != 0) {
                this.cpu.ss.setWord(n3 -= 2, this.cpu.ss.getWord(n4 -= 2));
            }
            this.cpu.ss.setWord(n3 -= 2, (short)n5);
        }
        this.cpu.ebp = n5;
        this.cpu.esp = n3 - n;
    }

    private final void enter_o32_a32(int n, int n2) {
        int n3 = this.cpu.esp;
        int n4 = this.cpu.ebp;
        if ((n2 %= 32) == 0 ? n3 < 4 + n && n3 > 0 : n3 < 4 + n + 4 * n2 && n3 > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(n3 -= 4, n4);
        int n5 = n3;
        if (n2 != 0) {
            while (--n2 != 0) {
                this.cpu.ss.setDoubleWord(n3 -= 4, this.cpu.ss.getDoubleWord(n4 -= 4));
            }
            this.cpu.ss.setDoubleWord(n3 -= 4, n5);
        }
        this.cpu.ebp = n5;
        this.cpu.esp = n3 - n;
    }

    private final void leave_o32_a16() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = this.cpu.ss.getDoubleWord(n & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n + 4 & 0xFFFF;
        this.cpu.ebp = n2;
    }

    private final void leave_o32_a32() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        this.cpu.esp = n + 4;
        this.cpu.ebp = n2;
    }

    private final void leave_o16_a16() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = 0xFFFF & this.cpu.ss.getWord(n & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n + 2 & 0xFFFF;
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | n2;
    }

    private final void leave_o16_a32() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = 0xFFFF & this.cpu.ss.getWord(n);
        this.cpu.esp = n + 2;
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | n2;
    }

    private final void push_o32_a32(int n) {
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, n);
        this.cpu.esp -= 4;
    }

    private final void push_o32_a16(int n) {
        if ((0xFFFF & this.cpu.esp) < 4 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
    }

    private final void push_o16_a32(short s) {
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, s);
        this.cpu.esp -= 2;
    }

    private final void push_o16_a16(short s) {
        if ((0xFFFF & this.cpu.esp) < 2 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, s);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
    }

    private final void pushf_o32_a32() {
        int n = 0xFCFFFF & this.cpu.getEFlags();
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, n);
        this.cpu.esp -= 4;
    }

    private final void pushf_o16_a32() {
        short s = (short)this.cpu.getEFlags();
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, s);
        this.cpu.esp -= 2;
    }

    private final void pushf_o32_a16() {
        int n = 0xFCFFFF & this.cpu.getEFlags();
        if ((0xFFFF & this.cpu.esp) < 4 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
    }

    private final void pushf_o16_a16() {
        short s = (short)this.cpu.getEFlags();
        if ((0xFFFF & this.cpu.esp) < 2 && (0xFFFF & this.cpu.esp) > 0) {
            throw new ProcessorException(12, 0, true);
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, s);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
    }

    private final void popf_o32_a32() {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp += 4;
        boolean bl = this.cpu.eflagsVirtual8086Mode;
        int n2 = this.cpu.eflagsIOPrivilegeLevel;
        boolean bl2 = this.cpu.eflagsInterruptEnable;
        boolean bl3 = this.cpu.eflagsInterruptEnableSoon;
        this.cpu.setEFlags(n);
        this.cpu.eflagsVirtual8086Mode = bl;
        this.cpu.eflagsVirtualInterrupt = false;
        this.cpu.eflagsVirtualInterruptPending = false;
        if (this.cpu.getCPL() != 0) {
            if (this.cpu.getCPL() > n2) {
                this.cpu.eflagsIOPrivilegeLevel = n2;
                this.cpu.eflagsInterruptEnable = bl2;
                this.cpu.eflagsInterruptEnableSoon = bl3;
            } else {
                this.cpu.eflagsIOPrivilegeLevel = n2;
            }
        }
    }

    private final void popf_o16_a32() {
        int n = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp);
        this.cpu.esp += 2;
        int n2 = this.cpu.getEFlags();
        n &= 0xFFFF;
        int n3 = this.cpu.eflagsIOPrivilegeLevel;
        this.cpu.setEFlags(n |= 0xFFFF & n2);
        if (this.cpu.getCPL() != 0) {
            this.cpu.eflagsIOPrivilegeLevel = n3;
        }
    }

    private final void popf_o32_a16() {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
        boolean bl = this.cpu.eflagsVirtual8086Mode;
        int n2 = this.cpu.eflagsIOPrivilegeLevel;
        boolean bl2 = this.cpu.eflagsInterruptEnable;
        boolean bl3 = this.cpu.eflagsInterruptEnableSoon;
        this.cpu.setEFlags(n);
        this.cpu.eflagsVirtual8086Mode = bl;
        this.cpu.eflagsVirtualInterrupt = false;
        this.cpu.eflagsVirtualInterruptPending = false;
        if (this.cpu.getCPL() != 0) {
            if (this.cpu.getCPL() > n2) {
                this.cpu.eflagsIOPrivilegeLevel = n2;
                this.cpu.eflagsInterruptEnable = bl2;
                this.cpu.eflagsInterruptEnableSoon = bl3;
            } else {
                this.cpu.eflagsIOPrivilegeLevel = n2;
            }
        }
    }

    private final void popf_o16_a16() {
        int n = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        int n2 = this.cpu.getEFlags();
        n &= 0xFFFF;
        int n3 = this.cpu.eflagsIOPrivilegeLevel;
        this.cpu.setEFlags(n |= 0xFFFF & n2);
        if (this.cpu.getCPL() != 0) {
            this.cpu.eflagsIOPrivilegeLevel = n3;
        }
    }

    private final void pushad_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.esp;
        if (n < 32 && n > 0) {
            throw exceptionGP;
        }
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.eax);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ecx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebx);
        this.cpu.ss.setDoubleWord(n -= 4, n2);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebp);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.esi);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edi);
        this.cpu.esp = n;
    }

    private final void popa_a16() {
        int n = 0xFFFF & this.cpu.esp;
        int n2 = this.cpu.edi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & n);
        int n3 = this.cpu.esi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        int n4 = this.cpu.ebp & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        int n5 = this.cpu.ebx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 4));
        int n6 = this.cpu.edx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        int n7 = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        int n8 = this.cpu.eax & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n += 2;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void popad_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        int n3 = this.cpu.ss.getDoubleWord(n += 4);
        int n4 = this.cpu.ss.getDoubleWord(n += 4);
        int n5 = this.cpu.ss.getDoubleWord(n += 8);
        int n6 = this.cpu.ss.getDoubleWord(n += 4);
        int n7 = this.cpu.ss.getDoubleWord(n += 4);
        int n8 = this.cpu.ss.getDoubleWord(n += 4);
        n += 4;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = n;
    }

    private final Segment lldt(int n) {
        if ((n &= 0xFFFF) == 0) {
            return SegmentFactory.NULL_SEGMENT;
        }
        Segment segment = this.cpu.getSegment(n & 0xFFFFFFFB);
        if (segment.getType() != 2) {
            throw new ProcessorException(13, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(13, n, true);
        }
        return segment;
    }

    private final Segment ltr(int n) {
        if ((n & 4) != 0) {
            throw new ProcessorException(13, n, true);
        }
        Segment segment = this.cpu.getSegment(n);
        if (segment.getType() != 1 && segment.getType() != 9) {
            throw new ProcessorException(13, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(13, n, true);
        }
        long l = this.cpu.gdtr.getQuadWord(n & 0xFFF8) | 0x20000000000L;
        this.cpu.gdtr.setQuadWord(n & 0xFFF8, l);
        return this.cpu.getSegment(n);
    }

    private final void cpuid() {
        switch (this.cpu.eax) {
            case 0: {
                this.cpu.eax = 2;
                this.cpu.ebx = 1970169159;
                this.cpu.edx = 1231384169;
                this.cpu.ecx = 1818588270;
                return;
            }
            case 1: {
                this.cpu.eax = 1587;
                this.cpu.ebx = 2048;
                this.cpu.ecx = 0;
                int n = 0;
                n |= 1;
                n |= 0x100;
                n |= 0x10;
                n |= 0x20;
                n |= 0x8000;
                n |= 8;
                n |= 0x2000;
                this.cpu.edx = n |= 0x800;
                return;
            }
        }
        this.cpu.eax = 4261377;
        this.cpu.ebx = 0;
        this.cpu.ecx = 0;
        this.cpu.edx = 0;
    }

    private final long rdtsc() {
        if (this.cpu.getCPL() == 0 || (this.cpu.getCR4() & 4) == 0) {
            return this.cpu.getClockCount();
        }
        throw exceptionGP;
    }

    private final void bitwise_flags(byte by) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
    }

    private final void bitwise_flags(short s) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
    }

    private final void bitwise_flags(int n) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
    }

    private final void arithmetic_flags_o8(int n, int n2, int n3) {
        this.cpu.setZeroFlag((byte)n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag((byte)n);
        this.cpu.setCarryFlag(n, 9);
        this.cpu.setAuxiliaryCarryFlag(n2, n3, n, 1);
    }

    private final void arithmetic_flags_o16(int n, int n2, int n3) {
        this.cpu.setZeroFlag((short)n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag((short)n);
        this.cpu.setCarryFlag(n, 10);
        this.cpu.setAuxiliaryCarryFlag(n2, n3, n, 1);
    }

    private final void arithmetic_flags_o32(long l, int n, int n2) {
        this.cpu.setZeroFlag((int)l);
        this.cpu.setParityFlag((int)l);
        this.cpu.setSignFlag((int)l);
        this.cpu.setCarryFlag(l, 11);
        this.cpu.setAuxiliaryCarryFlag(n, n2, (int)l, 1);
    }

    private final void add_o32_flags(long l, int n, int n2) {
        l = (0xFFFFFFFFL & (long)n) + (0xFFFFFFFFL & (long)n2);
        this.arithmetic_flags_o32(l, n, n2);
        this.cpu.setOverflowFlag((int)l, n, n2, 27);
    }

    private final void add_o16_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o16(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 26);
    }

    private final void add_o8_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o8(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 25);
    }

    private final void adc_o32_flags(long l, int n, int n2) {
        int n3 = this.cpu.getCarryFlag() ? 1 : 0;
        l = (0xFFFFFFFFL & (long)n) + (0xFFFFFFFFL & (long)n2) + (long)n3;
        if (this.cpu.getCarryFlag() && n2 == -1) {
            this.arithmetic_flags_o32(l, n, n2);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag((int)l, n, n2 + n3, 27);
            this.arithmetic_flags_o32(l, n, n2);
        }
    }

    private final void adc_o16_flags(int n, int n2, int n3) {
        if (this.cpu.getCarryFlag() && n3 == 65535) {
            this.arithmetic_flags_o16(n, n2, n3);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag(n, n2, n3 + (this.cpu.getCarryFlag() ? 1 : 0), 26);
            this.arithmetic_flags_o16(n, n2, n3);
        }
    }

    private final void adc_o8_flags(int n, int n2, int n3) {
        if (this.cpu.getCarryFlag() && n3 == 255) {
            this.arithmetic_flags_o8(n, n2, n3);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag(n, n2, n3 + (this.cpu.getCarryFlag() ? 1 : 0), 25);
            this.arithmetic_flags_o8(n, n2, n3);
        }
    }

    private final void sub_o32_flags(long l, int n, int n2) {
        l = (0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n2);
        this.arithmetic_flags_o32(l, n, n2);
        this.cpu.setOverflowFlag(n, (int)l, n2, 27);
    }

    private final void sub_o16_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o16(n, n2, n3);
        this.cpu.setOverflowFlag(n2, n, n3, 26);
    }

    private final void sub_o8_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o8(n, n2, n3);
        this.cpu.setOverflowFlag(n2, n, n3, 25);
    }

    private final void sbb_o32_flags(long l, int n, int n2) {
        int n3 = this.cpu.getCarryFlag() ? 1 : 0;
        l = (0xFFFFFFFFL & (long)n) - ((0xFFFFFFFFL & (long)n2) + (long)n3);
        this.cpu.setOverflowFlag(n, (int)l, n2 + n3, 27);
        this.arithmetic_flags_o32(l, n, n2);
    }

    private final void sbb_o16_flags(int n, int n2, int n3) {
        this.cpu.setOverflowFlag(n2, n, n3 + (this.cpu.getCarryFlag() ? 1 : 0), 26);
        this.arithmetic_flags_o16(n, n2, n3);
    }

    private final void sbb_o8_flags(int n, int n2, int n3) {
        this.cpu.setOverflowFlag(n2, n, n3 + (this.cpu.getCarryFlag() ? 1 : 0), 25);
        this.arithmetic_flags_o8(n, n2, n3);
    }

    private final void dec_flags(int n) {
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
        this.cpu.setOverflowFlag(n, 21);
        this.cpu.setAuxiliaryCarryFlag(n, 3);
    }

    private final void dec_flags(short s) {
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
        this.cpu.setOverflowFlag(s, 20);
        this.cpu.setAuxiliaryCarryFlag(s, 3);
    }

    private final void dec_flags(byte by) {
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
        this.cpu.setOverflowFlag(by, 19);
        this.cpu.setAuxiliaryCarryFlag(by, 3);
    }

    private final void inc_flags(int n) {
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
        this.cpu.setOverflowFlag(n, 21);
        this.cpu.setAuxiliaryCarryFlag(n, 4);
    }

    private final void inc_flags(short s) {
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
        this.cpu.setOverflowFlag(s, 20);
        this.cpu.setAuxiliaryCarryFlag(s, 4);
    }

    private final void inc_flags(byte by) {
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
        this.cpu.setOverflowFlag(by, 19);
        this.cpu.setAuxiliaryCarryFlag(by, 4);
    }

    private final void shl_flags(byte by, byte by2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by2, n, 12);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 8);
            }
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
            this.cpu.setSignFlag(by);
        }
    }

    private final void shl_flags(short s, short s2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s2, n, 13);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 10);
            }
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
            this.cpu.setSignFlag(s);
        }
    }

    private final void shl_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 14);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(n, 12);
            }
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
            this.cpu.setSignFlag(n);
        }
    }

    private final void shr_flags(byte by, int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, n2, 15);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(by, n, 16);
            }
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
            this.cpu.setSignFlag(by);
        }
    }

    private final void shr_flags(short s, int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, n2, 15);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(s, n, 17);
            }
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
            this.cpu.setSignFlag(s);
        }
    }

    private final void shr_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 15);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(n, n2, 18);
            }
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
            this.cpu.setSignFlag(n);
        }
    }

    private final void sar_flags(byte by, byte by2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by2, n, 15);
            if (n == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(by);
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
        }
    }

    private final void sar_flags(short s, short s2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s2, n, 15);
            if (n == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(s);
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
        }
    }

    private final void sar_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 15);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(n);
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
        }
    }

    private final void rol_flags(byte by, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by, 16);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 8);
            }
        }
    }

    private final void rol_flags(short s, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s, 16);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 10);
            }
        }
    }

    private final void rol_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 16);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 12);
            }
        }
    }

    private final void ror_flags(byte by, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by, 17);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 7);
            }
        }
    }

    private final void ror_flags(short s, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s, 18);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 9);
            }
        }
    }

    private final void ror_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 19);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 11);
            }
        }
    }

    private final void rcl_o8_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 20);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 8);
            }
        }
    }

    private final void rcl_o16_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 21);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 10);
            }
        }
    }

    private final void rcl_o32_flags(long l, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(l, 22);
            if (n == 1) {
                this.cpu.setOverflowFlag(l, 12);
            }
        }
    }

    private final void rcr_o8_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 20);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 13);
            }
        }
    }

    private final void rcr_o16_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 21);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 14);
            }
        }
    }

    private final void rcr_o32_flags(long l, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(l, 22);
            if (n == 1) {
                this.cpu.setOverflowFlag(l, 15);
            }
        }
    }

    private final void neg_flags(byte by) {
        this.cpu.setCarryFlag(by, 1);
        this.cpu.setOverflowFlag(by, 22);
        this.cpu.setAuxiliaryCarryFlag(by, 5);
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
    }

    private final void neg_flags(short s) {
        this.cpu.setCarryFlag(s, 1);
        this.cpu.setOverflowFlag(s, 23);
        this.cpu.setAuxiliaryCarryFlag(s, 5);
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
    }

    private final void neg_flags(int n) {
        this.cpu.setCarryFlag(n, 1);
        this.cpu.setOverflowFlag(n, 24);
        this.cpu.setAuxiliaryCarryFlag(n, 5);
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
    }

    private final Segment loadSegment(int n) {
        if ((n &= 0xFFFF) < 4) {
            return SegmentFactory.NULL_SEGMENT;
        }
        try {
            return this.cpu.getSegment(n);
        }
        catch (ProcessorException processorException) {
            throw new IllegalStateException(processorException.toString());
        }
    }

    private final boolean checkIOPermissionsByte(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            byte by = this.cpu.tss.getByte(n2 + (n & 0xFFFFFFF8));
            return (by & 1 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private final boolean checkIOPermissionsShort(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            short s = this.cpu.tss.getWord(n2 + (n & 0xFFFFFFF8));
            return (s & 3 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private final boolean checkIOPermissionsInt(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            short s = this.cpu.tss.getWord(n2 + (n & 0xFFFFFFF8));
            return (s & 7 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private static int numberOfTrailingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 31;
        int n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    private static int numberOfLeadingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if (n >>> 16 == 0) {
            n2 += 16;
            n <<= 16;
        }
        if (n >>> 24 == 0) {
            n2 += 8;
            n <<= 8;
        }
        if (n >>> 28 == 0) {
            n2 += 4;
            n <<= 4;
        }
        if (n >>> 30 == 0) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    private static int reverseBytes(int n) {
        return n >>> 24 | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            boolean bl = true;
            for (int j = 0; j < 8; ++j) {
                if ((1 & i >> j) != 1) continue;
                bl = !bl;
            }
            ProtectedModeUBlock.parityMap[i] = bl;
        }
    }
}

