/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.processor.Processor;

public class InterruptController
implements IOPortCapable,
HardwareComponent {
    private InterruptControllerElement master = new InterruptControllerElement(true);
    private InterruptControllerElement slave = new InterruptControllerElement(false);
    private Processor connectedCPU;
    private boolean ioportRegistered = false;

    private void updateIRQ() {
        int n;
        int n2 = this.slave.getIRQ();
        if (n2 >= 0) {
            this.master.setIRQ(2, 1);
            this.master.setIRQ(2, 0);
        }
        if ((n = this.master.getIRQ()) >= 0) {
            this.connectedCPU.raiseInterrupt();
        }
    }

    public void setIRQ(int n, int n2) {
        switch (n >> 3) {
            case 0: {
                this.master.setIRQ(n & 7, n2);
                this.updateIRQ();
                break;
            }
            case 1: {
                this.slave.setIRQ(n & 7, n2);
                this.updateIRQ();
                break;
            }
        }
    }

    public int cpuGetInterrupt() {
        int n = this.master.getIRQ();
        if (n >= 0) {
            this.master.intAck(n);
            if (n == 2) {
                int n2 = this.slave.getIRQ();
                if (n2 >= 0) {
                    this.slave.intAck(n2);
                } else {
                    n2 = 7;
                }
                this.updateIRQ();
                return (0xFF & this.slave.getIRQBase()) + n2;
            }
            this.updateIRQ();
            return (0xFF & this.master.getIRQBase()) + n;
        }
        n = 7;
        this.updateIRQ();
        return (0xFF & this.master.getIRQBase()) + n;
    }

    private int intAckRead() {
        int n = this.master.pollRead(0);
        if (n == 2) {
            n = this.slave.pollRead(128) + 8;
        }
        this.master.setReadRegisterSelect((byte)1);
        return n;
    }

    public int[] ioPortsRequested() {
        int[] nArray = this.master.ioPortsRequested();
        int[] nArray2 = this.slave.ioPortsRequested();
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public int ioPortReadByte(int n) {
        switch (n) {
            case 32: 
            case 33: {
                return 0xFF & this.master.ioPortRead(n);
            }
            case 160: 
            case 161: {
                return 0xFF & this.slave.ioPortRead(n);
            }
            case 1232: {
                return 0xFF & this.master.elcrRead();
            }
            case 1233: {
                return 0xFF & this.slave.elcrRead();
            }
        }
        return 0;
    }

    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 32: 
            case 33: {
                if (!this.master.ioPortWrite(n, (byte)n2)) break;
                this.updateIRQ();
                break;
            }
            case 160: 
            case 161: {
                if (!this.slave.ioPortWrite(n, (byte)n2)) break;
                this.updateIRQ();
                break;
            }
            case 1232: {
                this.master.elcrWrite((byte)n2);
                break;
            }
            case 1233: {
                this.slave.elcrWrite((byte)n2);
                break;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    private void masterPollCode() {
        this.master.andInterruptServiceRegister((byte)-5);
        this.master.andInterruptRequestRegister((byte)-5);
    }

    public void reset() {
        this.master.reset();
        this.slave.reset();
        this.ioportRegistered = false;
        this.connectedCPU = null;
    }

    public boolean initialised() {
        return this.connectedCPU != null && this.ioportRegistered;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Processor) {
            this.connectedCPU = (Processor)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public String toString() {
        return "Intel i8259 Programmable Interrupt Controller";
    }

    private class InterruptControllerElement {
        private byte lastInterruptRequestRegister;
        private byte interruptRequestRegister;
        private byte interruptMaskRegister;
        private byte interruptServiceRegister;
        private byte priorityAdd;
        private byte irqBase;
        private byte readRegisterSelect;
        private byte poll;
        private byte specialMask;
        private byte initState;
        private byte autoEOI;
        private byte rotateOnAutoEOI;
        private byte specialFullyNestedMode;
        private byte init4;
        private byte elcr;
        private byte elcrMask;
        private int[] ioPorts;

        public InterruptControllerElement(boolean bl) {
            if (bl) {
                this.ioPorts = new int[]{32, 33, 1232};
                this.elcrMask = (byte)-8;
            } else {
                this.ioPorts = new int[]{160, 161, 1233};
                this.elcrMask = (byte)-34;
            }
        }

        public int[] ioPortsRequested() {
            return this.ioPorts;
        }

        public byte ioPortRead(int n) {
            byte by;
            int n2 = n;
            n2 &= 1;
            if (0 != this.getPoll()) {
                by = (byte)this.pollRead(n);
                this.setPoll((byte)0);
            } else {
                by = n2 == 0 ? (0 != this.getReadRegisterSelect() ? this.getInterruptServiceRegister() : this.getInterruptRequestRegister()) : this.getInterruptMaskRegister();
            }
            return by;
        }

        public byte elcrRead() {
            return this.getELCR();
        }

        public boolean ioPortWrite(int n, byte by) {
            block23: {
                block21: {
                    block24: {
                        block22: {
                            if ((n &= 1) != 0) break block21;
                            if (0 == (by & 0x10)) break block22;
                            this.reset();
                            InterruptController.this.connectedCPU.clearInterrupt();
                            this.setInitState((byte)1);
                            this.setInit4((byte)(by & 1));
                            if (0 != (by & 2)) {
                                System.err.println("single mode not supported");
                            }
                            if (0 != (by & 8)) {
                                System.err.println("level sensitive irq not supported");
                            }
                            break block23;
                        }
                        if (0 == (by & 8)) break block24;
                        if (0 != (by & 4)) {
                            this.setPoll((byte)1);
                        }
                        if (0 != (by & 2)) {
                            this.setReadRegisterSelect((byte)(by & 1));
                        }
                        if (0 != (by & 0x40)) {
                            this.setSpecialMask((byte)(by >> 5 & 1));
                        }
                        break block23;
                    }
                    int n2 = by >> 5;
                    switch (n2) {
                        case 0: 
                        case 4: {
                            this.setRotateOnAutoEOI((byte)(n2 >> 2));
                            break;
                        }
                        case 1: 
                        case 5: {
                            int n3 = this.getPriority(this.getInterruptServiceRegister());
                            if (n3 != 8) {
                                int n4 = n3 + this.getPriorityAdd() & 7;
                                this.andInterruptServiceRegister((byte)(~(1 << n4)));
                                if (n2 == 5) {
                                    this.setPriorityAdd((byte)(n4 + 1 & 7));
                                }
                                return true;
                            }
                            break block23;
                        }
                        case 3: {
                            int n5 = by & 7;
                            this.andInterruptServiceRegister((byte)(~(1 << n5)));
                            return true;
                        }
                        case 6: {
                            this.setPriorityAdd((byte)(by + 1 & 7));
                            return true;
                        }
                        case 7: {
                            int n6 = by & 7;
                            this.andInterruptServiceRegister((byte)(~(1 << n6)));
                            this.setPriorityAdd((byte)(n6 + 1 & 7));
                            return true;
                        }
                    }
                    break block23;
                }
                switch (this.getInitState()) {
                    case 0: {
                        this.setInterruptMaskRegister(by);
                        return true;
                    }
                    case 1: {
                        this.setIRQBase((byte)(by & 0xF8));
                        this.setInitState((byte)2);
                        break;
                    }
                    case 2: {
                        if (0 != this.getInit4()) {
                            this.setInitState((byte)3);
                            break;
                        }
                        this.setInitState((byte)0);
                        break;
                    }
                    case 3: {
                        this.setSpecialFullyNestedMode((byte)(by >> 4 & 1));
                        this.setAutoEOI((byte)(by >> 1 & 1));
                        this.setInitState((byte)0);
                    }
                }
            }
            return false;
        }

        public void elcrWrite(byte by) {
            this.setELCR((byte)(by & this.getELCRMask()));
        }

        private int pollRead(int n) {
            int n2 = this.getIRQ();
            if (n2 < 0) {
                InterruptController.this.updateIRQ();
                return 7;
            }
            if (0 != n >> 7) {
                InterruptController.this.masterPollCode();
            }
            this.andInterruptRequestRegister((byte)(~(1 << n2)));
            this.andInterruptServiceRegister((byte)(~(1 << n2)));
            if (0 != n >> 7 || n2 != 2) {
                InterruptController.this.updateIRQ();
            }
            return n2;
        }

        public void setIRQ(int n, int n2) {
            int n3 = 1 << n;
            if (0 != (this.getELCR() & n3)) {
                if (0 != n2) {
                    this.orInterruptRequestRegister((byte)n3);
                    this.orLastInterruptRequestRegister((byte)n3);
                } else {
                    this.andInterruptRequestRegister((byte)(~n3));
                    this.andLastInterruptRequestRegister((byte)(~n3));
                }
            } else if (0 != n2) {
                if ((this.getLastInterruptRequestRegister() & n3) == 0) {
                    this.orInterruptRequestRegister((byte)n3);
                }
                this.orLastInterruptRequestRegister((byte)n3);
            } else {
                this.andLastInterruptRequestRegister((byte)(~n3));
            }
        }

        private int getPriority(int n) {
            if ((0xFF & n) == 0) {
                return 8;
            }
            int n2 = 0;
            while ((n & 1 << (n2 + this.getPriorityAdd() & 7)) == 0) {
                ++n2;
            }
            return n2;
        }

        public int getIRQ() {
            int n;
            int n2 = this.getInterruptRequestRegister() & ~this.getInterruptMaskRegister();
            int n3 = this.getPriority(n2);
            if (n3 == 8) {
                return -1;
            }
            n2 = this.getInterruptServiceRegister();
            if (0 != this.getSpecialFullyNestedMode() && this.isMaster()) {
                n2 &= 0xFFFFFFFB;
            }
            if (n3 < (n = this.getPriority(n2))) {
                return n3 + this.getPriorityAdd() & 7;
            }
            return -1;
        }

        private void intAck(int n) {
            if (0 != this.getAutoEOI()) {
                if (0 != this.getRotateOnAutoEOI()) {
                    this.setPriorityAdd((byte)(n + 1 & 7));
                }
            } else {
                this.orInterruptServiceRegister((byte)(1 << n));
            }
            if (0 == (this.getELCR() & 1 << n)) {
                this.andInterruptRequestRegister((byte)(~(1 << n)));
            }
        }

        private boolean isMaster() {
            return InterruptController.this.master == this;
        }

        private void reset() {
            this.lastInterruptRequestRegister = 0;
            this.interruptRequestRegister = 0;
            this.interruptMaskRegister = 0;
            this.interruptServiceRegister = 0;
            this.priorityAdd = 0;
            this.irqBase = 0;
            this.readRegisterSelect = 0;
            this.poll = 0;
            this.specialMask = 0;
            this.initState = 0;
            this.autoEOI = 0;
            this.rotateOnAutoEOI = 0;
            this.specialFullyNestedMode = 0;
            this.init4 = 0;
            this.elcr = 0;
        }

        public byte getLastInterruptRequestRegister() {
            return this.lastInterruptRequestRegister;
        }

        public void setLastInterruptRequestRegister(byte by) {
            this.lastInterruptRequestRegister = by;
        }

        public void andLastInterruptRequestRegister(byte by) {
            this.setLastInterruptRequestRegister((byte)(this.getLastInterruptRequestRegister() & by));
        }

        public void orLastInterruptRequestRegister(byte by) {
            this.setLastInterruptRequestRegister((byte)(this.getLastInterruptRequestRegister() | by));
        }

        public byte getInterruptRequestRegister() {
            return this.interruptRequestRegister;
        }

        public void setInterruptRequestRegister(byte by) {
            this.interruptRequestRegister = by;
        }

        public void andInterruptRequestRegister(byte by) {
            this.setInterruptRequestRegister((byte)(this.getInterruptRequestRegister() & by));
        }

        public void orInterruptRequestRegister(byte by) {
            this.setInterruptRequestRegister((byte)(this.getInterruptRequestRegister() | by));
        }

        public byte getInterruptMaskRegister() {
            return this.interruptMaskRegister;
        }

        public void setInterruptMaskRegister(byte by) {
            this.interruptMaskRegister = by;
        }

        public void andInterruptMaskRegister(byte by) {
            this.setInterruptMaskRegister((byte)(this.getInterruptMaskRegister() & by));
        }

        public void orInterruptMaskRegister(byte by) {
            this.setInterruptMaskRegister((byte)(this.getInterruptMaskRegister() | by));
        }

        public byte getInterruptServiceRegister() {
            return this.interruptServiceRegister;
        }

        public void setInterruptServiceRegister(byte by) {
            this.interruptServiceRegister = by;
        }

        public void andInterruptServiceRegister(byte by) {
            this.setInterruptServiceRegister((byte)(this.getInterruptServiceRegister() & by));
        }

        public void orInterruptServiceRegister(byte by) {
            this.setInterruptServiceRegister((byte)(this.getInterruptServiceRegister() | by));
        }

        public byte getReadRegisterSelect() {
            return this.readRegisterSelect;
        }

        public void setReadRegisterSelect(byte by) {
            this.readRegisterSelect = by;
        }

        public void andReadRegisterSelect(byte by) {
            this.setReadRegisterSelect((byte)(this.getReadRegisterSelect() & by));
        }

        public void orReadRegisterSelect(byte by) {
            this.setReadRegisterSelect((byte)(this.getReadRegisterSelect() | by));
        }

        public byte getPriorityAdd() {
            return this.priorityAdd;
        }

        public void setPriorityAdd(byte by) {
            this.priorityAdd = by;
        }

        public byte getIRQBase() {
            return this.irqBase;
        }

        public void setIRQBase(byte by) {
            this.irqBase = by;
        }

        public byte getPoll() {
            return this.poll;
        }

        public void setPoll(byte by) {
            this.poll = by;
        }

        public void setSpecialMask(byte by) {
            this.specialMask = by;
        }

        public byte getInitState() {
            return this.initState;
        }

        public void setInitState(byte by) {
            this.initState = by;
        }

        public byte getAutoEOI() {
            return this.autoEOI;
        }

        public void setAutoEOI(byte by) {
            this.autoEOI = by;
        }

        public byte getRotateOnAutoEOI() {
            return this.rotateOnAutoEOI;
        }

        public void setRotateOnAutoEOI(byte by) {
            this.rotateOnAutoEOI = by;
        }

        public byte getSpecialFullyNestedMode() {
            return this.specialFullyNestedMode;
        }

        public void setSpecialFullyNestedMode(byte by) {
            this.specialFullyNestedMode = by;
        }

        public byte getInit4() {
            return this.init4;
        }

        public void setInit4(byte by) {
            this.init4 = by;
        }

        public byte getELCR() {
            return this.elcr;
        }

        public void setELCR(byte by) {
            this.elcr = by;
        }

        public byte getELCRMask() {
            return this.elcrMask;
        }

        public String toString() {
            if (this.isMaster()) {
                return InterruptController.this.toString() + ": [Master Element]";
            }
            return InterruptController.this.toString() + ": [Slave  Element]";
        }
    }
}

