/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

public class ByteBuffer {
    private byte[] buffer;

    public ByteBuffer(int n) {
        this.buffer = new byte[n];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = 0;
        }
    }

    public byte get(int n) {
        return this.buffer[n];
    }

    public void set(int n, byte by) {
        this.buffer[n] = by;
    }

    public short getShort(int n) {
        int n2 = 0;
        n2 |= 0xFF & this.buffer[n++];
        return (short)(n2 |= 0xFF00 & this.buffer[n++] << 8);
    }

    public void setShort(int n, short s) {
        this.buffer[n++] = (byte)s;
        this.buffer[n] = (byte)(s >>> 8);
    }

    public int getInt(int n) {
        int n2 = 0;
        n2 |= 0xFF & this.buffer[n++];
        n2 |= 0xFF00 & this.buffer[n++] << 8;
        n2 |= 0xFF0000 & this.buffer[n++] << 16;
        return n2 |= 0xFF000000 & this.buffer[n++] << 24;
    }

    public void setInt(int n, int n2) {
        this.buffer[n++] = (byte)n2;
        this.buffer[n++] = (byte)(n2 >>> 8);
        this.buffer[n++] = (byte)(n2 >>> 16);
        this.buffer[n++] = (byte)(n2 >>> 24);
    }

    public long getLong(int n) {
        long l = 0L;
        l |= (long)(0xFF & this.buffer[n++]);
        l |= (long)(0xFF00 & this.buffer[n++] << 8);
        l |= (long)(0xFF0000 & this.buffer[n++] << 16);
        l |= 0xFF000000L & (long)this.buffer[n++] << 24;
        l |= 0xFF00000000L & (long)this.buffer[n++] << 32;
        l |= 0xFF0000000000L & (long)this.buffer[n++] << 40;
        l |= 0xFF000000000000L & (long)this.buffer[n++] << 48;
        return l |= 0xFF00000000000000L & (long)this.buffer[n++] << 56;
    }

    public void setLong(int n, long l) {
        this.buffer[n++] = (byte)l;
        this.buffer[n++] = (byte)(l >>> 8);
        this.buffer[n++] = (byte)(l >>> 16);
        this.buffer[n++] = (byte)(l >>> 24);
        this.buffer[n++] = (byte)(l >>> 32);
        this.buffer[n++] = (byte)(l >>> 40);
        this.buffer[n++] = (byte)(l >>> 48);
        this.buffer[n++] = (byte)(l >>> 56);
    }

    public int get(int n, byte[] byArray, int n2, int n3) {
        n3 = Math.min(n3, this.buffer.length - n);
        n3 = Math.min(n3, byArray.length - n2);
        System.arraycopy(this.buffer, n, byArray, n2, n3);
        return n3;
    }

    public int set(byte[] byArray, int n, int n2, int n3) {
        n3 = Math.min(n3, this.buffer.length - n2);
        n3 = Math.min(n3, byArray.length - n);
        System.arraycopy(byArray, n, this.buffer, n2, n3);
        return n3;
    }

    public static void fillIntArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static void fillByteArray(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = by;
        }
    }

    public static void fillShortArray(short[] sArray, short s) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = s;
        }
    }

    public static void fillLongArray(long[] lArray, long l) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = l;
        }
    }
}

