/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.AbstractMemory;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.ByteBuffer;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.MemoryMappedIORegion;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.support.GraphicsDisplay;

public class VGACard
extends AbstractPCIDevice
implements IOPortCapable,
Memory,
HardwareComponent {
    private static final int VGA_RAM_SIZE = 0x400000;
    private static final int INIT_VGA_RAM_SIZE = 65536;
    private static final int PAGE_SHIFT = 12;
    private final int[] expand4 = new int[256];
    private final int[] expand2 = new int[256];
    private final int[] expand4to8 = new int[16];
    private static final int MOR_COLOR_EMULATION = 1;
    private static final int ST01_V_RETRACE = 8;
    private static final int ST01_DISP_ENABLE = 1;
    private static final int VBE_DISPI_MAX_XRES = 1024;
    private static final int VBE_DISPI_MAX_YRES = 768;
    private static final int VBE_DISPI_INDEX_ID = 0;
    private static final int VBE_DISPI_INDEX_XRES = 1;
    private static final int VBE_DISPI_INDEX_YRES = 2;
    private static final int VBE_DISPI_INDEX_BPP = 3;
    private static final int VBE_DISPI_INDEX_ENABLE = 4;
    private static final int VBE_DISPI_INDEX_BANK = 5;
    private static final int VBE_DISPI_INDEX_VIRT_WIDTH = 6;
    private static final int VBE_DISPI_INDEX_VIRT_HEIGHT = 7;
    private static final int VBE_DISPI_INDEX_X_OFFSET = 8;
    private static final int VBE_DISPI_INDEX_Y_OFFSET = 9;
    private static final int VBE_DISPI_INDEX_NB = 10;
    private static final int VBE_DISPI_ID0 = 45248;
    private static final int VBE_DISPI_ID1 = 45249;
    private static final int VBE_DISPI_ID2 = 45250;
    private static final int VBE_DISPI_DISABLED = 0;
    private static final int VBE_DISPI_ENABLED = 1;
    private static final int VBE_DISPI_LFB_ENABLED = 64;
    private static final int VBE_DISPI_NOCLEARMEM = 128;
    private static final int VBE_DISPI_LFB_PHYSICAL_ADDRESS = -536870912;
    private static final int GMODE_TEXT = 0;
    private static final int GMODE_GRAPH = 1;
    private static final int GMODE_BLANK = 2;
    private static final int CH_ATTR_SIZE = 16000;
    private static final int VGA_MAX_HEIGHT = 1024;
    private static final int GR_INDEX_SETRESET = 0;
    private static final int GR_INDEX_ENABLE_SETRESET = 1;
    private static final int GR_INDEX_COLOR_COMPARE = 2;
    private static final int GR_INDEX_DATA_ROTATE = 3;
    private static final int GR_INDEX_READ_MAP_SELECT = 4;
    private static final int GR_INDEX_GRAPHICS_MODE = 5;
    private static final int GR_INDEX_MISC = 6;
    private static final int GR_INDEX_COLOR_DONT_CARE = 7;
    private static final int GR_INDEX_BITMASK = 8;
    private static final int SR_INDEX_RESET = 0;
    private static final int SR_INDEX_CLOCKING_MODE = 1;
    private static final int SR_INDEX_MAP_MASK = 2;
    private static final int SR_INDEX_CHAR_MAP_SELECT = 3;
    private static final int SR_INDEX_SEQ_MEMORY_MODE = 4;
    private static final int AR_INDEX_PALLETE_MIN = 0;
    private static final int AR_INDEX_PALLETE_MAX = 15;
    private static final int AR_INDEX_ATTR_MODE_CONTROL = 16;
    private static final int AR_INDEX_OVERSCAN_COLOR = 17;
    private static final int AR_INDEX_COLOR_PLANE_ENABLE = 18;
    private static final int AR_INDEX_HORIZ_PIXEL_PANNING = 19;
    private static final int AR_INDEX_COLOR_SELECT = 20;
    private static final int CR_INDEX_HORZ_DISPLAY_END = 1;
    private static final int CR_INDEX_VERT_TOTAL = 6;
    private static final int CR_INDEX_OVERFLOW = 7;
    private static final int CR_INDEX_MAX_SCANLINE = 9;
    private static final int CR_INDEX_CURSOR_START = 10;
    private static final int CR_INDEX_CURSOR_END = 11;
    private static final int CR_INDEX_START_ADDR_HIGH = 12;
    private static final int CR_INDEX_START_ADDR_LOW = 13;
    private static final int CR_INDEX_CURSOR_LOC_HIGH = 14;
    private static final int CR_INDEX_CURSOR_LOC_LOW = 15;
    private static final int CR_INDEX_VERT_RETRACE_END = 17;
    private static final int CR_INDEX_VERT_DISPLAY_END = 18;
    private static final int CR_INDEX_OFFSET = 19;
    private static final int CR_INDEX_CRTC_MODE_CONTROL = 23;
    private static final int CR_INDEX_LINE_COMPARE = 24;
    private static final int[] sequencerRegisterMask = new int[]{3, 61, 15, 63, 14, 0, 0, 255};
    private static final int[] graphicsRegisterMask = new int[]{15, 15, 15, 31, 3, 123, 15, 15, 255, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] mask16 = new int[]{0, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF, -16777216, -16776961, -16711936, -16711681, -65536, -65281, -256, -1};
    private static final int[] dmask16 = new int[]{0, -16777216, 0xFF0000, -65536, 65280, -16711936, 0xFFFF00, -256, 255, -16776961, 0xFF00FF, -65281, 65535, -16711681, 0xFFFFFF, -1};
    private static final int[] dmask4 = new int[]{0, -65536, 65535, -1};
    private static final int[] cursorGlyph = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private GraphicsUpdater VGA_DRAW_LINE2;
    private GraphicsUpdater VGA_DRAW_LINE2D2;
    private GraphicsUpdater VGA_DRAW_LINE4;
    private GraphicsUpdater VGA_DRAW_LINE4D2;
    private GraphicsUpdater VGA_DRAW_LINE8D2;
    private GraphicsUpdater VGA_DRAW_LINE8;
    private GraphicsUpdater VGA_DRAW_LINE15;
    private GraphicsUpdater VGA_DRAW_LINE16;
    private GraphicsUpdater VGA_DRAW_LINE24;
    private GraphicsUpdater VGA_DRAW_LINE32;
    private int latch;
    private int sequencerRegisterIndex;
    private int graphicsRegisterIndex;
    private int attributeRegisterIndex;
    private int crtRegisterIndex;
    private int[] sequencerRegister;
    private int[] graphicsRegister;
    private int[] attributeRegister;
    private int[] crtRegister;
    private boolean attributeRegisterFlipFlop;
    private int miscellaneousOutputRegister;
    private int featureControlRegister;
    private int st00;
    private int st01;
    private int dacReadIndex;
    private int dacWriteIndex;
    private int dacSubIndex;
    private int dacState;
    private int shiftControl;
    private int doubleScan;
    private int[] dacCache;
    private int[] palette;
    private int bankOffset;
    private int vbeIndex;
    private int[] vbeRegs;
    private int vbeStartAddress;
    private int vbeLineOffset;
    private int vbeBankMask;
    private int[] fontOffset;
    private int graphicMode;
    private int lineOffset;
    private int lineCompare;
    private int startAddress;
    private int planeUpdated;
    private int lastCW;
    private int lastCH;
    private int lastWidth;
    private int lastHeight;
    private int lastScreenWidth;
    private int lastScreenHeight;
    private int cursorStart;
    private int cursorEnd;
    private int cursorOffset;
    private final int[] lastPalette;
    private int[] lastChar;
    private boolean updatingScreen;
    private VGARAMIORegion ioRegion;
    private long lastPaletteWrite;
    private boolean ioportRegistered = false;
    private boolean pciRegistered = false;
    private boolean memoryRegistered = false;

    public VGACard() {
        this.setupArrays();
        this.setupGraphicsModes();
        this.assignDevFN(-1);
        this.setIRQIndex(16);
        this.putConfigByte(0, (byte)52);
        this.putConfigByte(1, (byte)18);
        this.putConfigByte(2, (byte)17);
        this.putConfigByte(3, (byte)17);
        this.putConfigByte(10, (byte)0);
        this.putConfigByte(11, (byte)3);
        this.putConfigByte(14, (byte)0);
        this.sequencerRegister = new int[256];
        this.graphicsRegister = new int[256];
        this.attributeRegister = new int[256];
        this.crtRegister = new int[256];
        this.dacCache = new int[3];
        this.palette = new int[768];
        this.ioRegion = new VGARAMIORegion();
        this.vbeRegs = new int[10];
        this.fontOffset = new int[2];
        this.lastPalette = new int[256];
        this.lastChar = new int[16000];
        this.internalReset();
        this.bankOffset = 0;
        this.vbeRegs[0] = 45248;
        this.vbeBankMask = 63;
    }

    private void setupArrays() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < 256; ++n3) {
            n2 = 0;
            for (n = 0; n < 8; ++n) {
                n2 |= (n3 >>> n & 1) << n * 4;
            }
            this.expand4[n3] = n2;
            n2 = 0;
            for (n = 0; n < 4; ++n) {
                n2 |= (n3 >>> 2 * n & 3) << n * 4;
            }
            this.expand2[n3] = n2;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            n2 = 0;
            for (n = 0; n < 4; ++n) {
                int n4 = n3 >>> n & 1;
                n2 |= n4 << 2 * n;
                n2 |= n4 << 2 * n + 1;
            }
            this.expand4to8[n3] = n2;
        }
    }

    private void setupGraphicsModes() {
        this.VGA_DRAW_LINE2 = new DrawLine2();
        this.VGA_DRAW_LINE2D2 = new DrawLine2d2();
        this.VGA_DRAW_LINE4 = new DrawLine4();
        this.VGA_DRAW_LINE4D2 = new DrawLine4d2();
        this.VGA_DRAW_LINE8D2 = new DrawLine8d2();
        this.VGA_DRAW_LINE8 = new DrawLine8();
        this.VGA_DRAW_LINE15 = new DrawLine15();
        this.VGA_DRAW_LINE16 = new DrawLine16();
        this.VGA_DRAW_LINE24 = new DrawLine24();
        this.VGA_DRAW_LINE32 = new DrawLine32();
    }

    public IORegion[] getIORegions() {
        return new IORegion[]{this.ioRegion};
    }

    public IORegion getIORegion(int n) {
        if (n == 0) {
            return this.ioRegion;
        }
        return null;
    }

    public void ioPortWriteByte(int n, int n2) {
        this.vgaIOPortWriteByte(n, n2);
    }

    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 462: 
            case 65408: {
                this.vbeIOPortWriteIndex(n2);
                break;
            }
            case 463: 
            case 65409: {
                this.vbeIOPortWriteData(n2);
                break;
            }
            default: {
                this.ioPortWriteByte(n, 0xFF & n2);
                this.ioPortWriteByte(n + 1, 0xFF & n2 >>> 8);
            }
        }
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, 0xFFFF & n2);
        this.ioPortWriteWord(n + 2, n2 >>> 16);
    }

    public int ioPortReadByte(int n) {
        return this.vgaIOPortReadByte(n);
    }

    public int ioPortReadWord(int n) {
        switch (n) {
            case 462: 
            case 65408: {
                return this.vbeIOPortReadIndex();
            }
            case 463: 
            case 65409: {
                return this.vbeIOPortReadData();
            }
        }
        int n2 = 0xFF & this.ioPortReadByte(n);
        int n3 = 0xFF & this.ioPortReadByte(n + 1);
        return n2 | n3 << 8;
    }

    public int ioPortReadLong(int n) {
        int n2 = 0xFFFF & this.ioPortReadWord(n);
        int n3 = 0xFFFF & this.ioPortReadWord(n + 2);
        return n2 | n3 << 16;
    }

    public int[] ioPortsRequested() {
        return new int[]{948, 949, 954, 980, 981, 986, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 462, 463, 65408, 65409};
    }

    private final void vgaIOPortWriteByte(int n, int n2) {
        if (n >= 944 && n <= 959 && (this.miscellaneousOutputRegister & 1) != 0 || n >= 976 && n <= 991 && (this.miscellaneousOutputRegister & 1) == 0) {
            return;
        }
        if ((n2 & 0xFFFFFF00) != 0) {
            System.err.println("Possible Bug With New INT Register");
        }
        switch (n) {
            case 948: 
            case 980: {
                this.crtRegisterIndex = n2;
                break;
            }
            case 949: 
            case 981: {
                if (this.crtRegisterIndex <= 7 && (this.crtRegister[17] & 0x80) != 0) {
                    if (this.crtRegisterIndex == 7) {
                        this.crtRegister[7] = this.crtRegister[7] & 0xFFFFFFEF | n2 & 0x10;
                    }
                    return;
                }
                this.crtRegister[this.crtRegisterIndex] = n2;
                break;
            }
            case 954: 
            case 986: {
                this.featureControlRegister = n2 & 0x10;
                break;
            }
            case 960: {
                if (!this.attributeRegisterFlipFlop) {
                    this.attributeRegisterIndex = n2 &= 0x3F;
                } else {
                    int n3 = this.attributeRegisterIndex & 0x1F;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            this.attributeRegister[n3] = n2 & 0x3F;
                            break;
                        }
                        case 16: {
                            this.attributeRegister[16] = n2 & 0xFFFFFFEF;
                            break;
                        }
                        case 17: {
                            this.attributeRegister[17] = n2;
                            break;
                        }
                        case 18: {
                            this.attributeRegister[18] = n2 & 0xFFFFFF3F;
                            break;
                        }
                        case 19: {
                            this.attributeRegister[19] = n2 & 0xFFFFFF0F;
                            break;
                        }
                        case 20: {
                            this.attributeRegister[20] = n2 & 0xFFFFFF0F;
                            break;
                        }
                    }
                }
                this.attributeRegisterFlipFlop = !this.attributeRegisterFlipFlop;
                break;
            }
            case 962: {
                this.miscellaneousOutputRegister = n2 & 0xFFFFFFEF;
                break;
            }
            case 964: {
                this.sequencerRegisterIndex = n2 & 7;
                break;
            }
            case 965: {
                this.sequencerRegister[this.sequencerRegisterIndex] = n2 & sequencerRegisterMask[this.sequencerRegisterIndex];
                break;
            }
            case 967: {
                this.dacReadIndex = n2;
                this.dacSubIndex = 0;
                this.dacState = 3;
                break;
            }
            case 968: {
                this.dacWriteIndex = n2;
                this.dacSubIndex = 0;
                this.dacState = 0;
                break;
            }
            case 969: {
                this.dacCache[this.dacSubIndex] = n2;
                if (++this.dacSubIndex != 3) break;
                for (int i = 0; i < 3; ++i) {
                    this.palette[(0xFF & this.dacWriteIndex) * 3 + i] = this.dacCache[i];
                }
                this.dacSubIndex = 0;
                ++this.dacWriteIndex;
                break;
            }
            case 974: {
                this.graphicsRegisterIndex = n2 & 0xF;
                break;
            }
            case 975: {
                this.graphicsRegister[this.graphicsRegisterIndex] = n2 & graphicsRegisterMask[this.graphicsRegisterIndex];
            }
        }
    }

    private final int vgaIOPortReadByte(int n) {
        if (n >= 944 && n <= 959 && (this.miscellaneousOutputRegister & 1) != 0 || n >= 976 && n <= 991 && (this.miscellaneousOutputRegister & 1) == 0) {
            return 255;
        }
        switch (n) {
            case 960: {
                if (!this.attributeRegisterFlipFlop) {
                    return this.attributeRegisterIndex;
                }
                return 0;
            }
            case 961: {
                int n2 = this.attributeRegisterIndex & 0x1F;
                if (n2 < 21) {
                    return this.attributeRegister[n2];
                }
                return 0;
            }
            case 962: {
                return this.st00;
            }
            case 964: {
                return this.sequencerRegisterIndex;
            }
            case 965: {
                return this.sequencerRegister[this.sequencerRegisterIndex];
            }
            case 967: {
                return this.dacState;
            }
            case 968: {
                return this.dacWriteIndex;
            }
            case 969: {
                int n3 = this.palette[this.dacReadIndex * 3 + this.dacSubIndex];
                if (++this.dacSubIndex == 3) {
                    this.dacSubIndex = 0;
                    ++this.dacReadIndex;
                }
                return n3;
            }
            case 970: {
                return this.featureControlRegister;
            }
            case 972: {
                return this.miscellaneousOutputRegister;
            }
            case 974: {
                return this.graphicsRegisterIndex;
            }
            case 975: {
                return this.graphicsRegister[this.graphicsRegisterIndex];
            }
            case 948: 
            case 980: {
                return this.crtRegisterIndex;
            }
            case 949: 
            case 981: {
                return this.crtRegister[this.crtRegisterIndex];
            }
            case 954: 
            case 986: {
                this.attributeRegisterFlipFlop = false;
                if (this.updatingScreen) {
                    this.st01 &= 0xFFFFFFF7;
                    this.st01 &= 0xFFFFFFFE;
                } else {
                    this.st01 ^= 9;
                }
                return this.st01;
            }
        }
        return 0;
    }

    private final void vbeIOPortWriteIndex(int n) {
        this.vbeIndex = n;
    }

    private final void vbeIOPortWriteData(int n) {
        if (this.vbeIndex <= 10) {
            switch (this.vbeIndex) {
                case 0: {
                    if (n != 45248 && n != 45249 && n != 45250) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 1: {
                    if (n > 1024 || (n & 7) != 0) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 2: {
                    if (n > 768) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 3: {
                    if (n == 0) {
                        n = 8;
                    }
                    if (n != 4 && n != 8 && n != 15 && n != 16 && n != 24 && n != 32) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 5: {
                    this.vbeRegs[this.vbeIndex] = n &= this.vbeBankMask;
                    this.bankOffset = n << 16;
                    break;
                }
                case 4: {
                    if ((n & 1) != 0) {
                        int n2;
                        int n3;
                        this.vbeRegs[6] = this.vbeRegs[1];
                        this.vbeRegs[7] = this.vbeRegs[2];
                        this.vbeRegs[8] = 0;
                        this.vbeRegs[9] = 0;
                        this.vbeLineOffset = this.vbeRegs[3] == 4 ? this.vbeRegs[1] >>> 1 : this.vbeRegs[1] * (this.vbeRegs[3] + 7 >>> 3);
                        this.vbeStartAddress = 0;
                        if ((n & 0x80) == 0) {
                            n3 = this.vbeRegs[2] * this.vbeLineOffset;
                            for (n2 = 0; n2 < n3; ++n2) {
                                this.ioRegion.setByte(n2, (byte)0);
                            }
                        }
                        this.graphicsRegister[6] = this.graphicsRegister[6] & 0xFFFFFFF3 | 5;
                        this.crtRegister[23] = this.crtRegister[23] | 3;
                        this.crtRegister[19] = this.vbeLineOffset >>> 3;
                        this.crtRegister[1] = (this.vbeRegs[1] >>> 3) - 1;
                        this.crtRegister[18] = n3 = this.vbeRegs[2] - 1;
                        this.crtRegister[7] = this.crtRegister[7] & 0xFFFFFFBD | n3 >>> 7 & 2 | n3 >>> 3 & 0x40;
                        this.crtRegister[24] = 255;
                        this.crtRegister[7] = this.crtRegister[7] | 0x10;
                        this.crtRegister[9] = this.crtRegister[9] | 0x40;
                        if (this.vbeRegs[3] == 4) {
                            n2 = 0;
                            this.sequencerRegister[1] = this.sequencerRegister[1] & 0xFFFFFFF7;
                        } else {
                            n2 = 2;
                            this.sequencerRegister[4] = this.sequencerRegister[4] | 8;
                            this.sequencerRegister[2] = this.sequencerRegister[2] | 0xF;
                        }
                        this.graphicsRegister[5] = this.graphicsRegister[5] & 0xFFFFFF9F | n2 << 5;
                        this.crtRegister[9] = this.crtRegister[9] & 0xFFFFFF60;
                    } else {
                        this.bankOffset = 0;
                    }
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 6: {
                    if (n < this.vbeRegs[1]) {
                        return;
                    }
                    int n4 = n;
                    int n5 = this.vbeRegs[3] == 4 ? n >>> 1 : n * (this.vbeRegs[3] + 7 >>> 3);
                    int n6 = 0x400000 / n5;
                    if (n6 < this.vbeRegs[2]) {
                        return;
                    }
                    this.vbeRegs[6] = n4;
                    this.vbeRegs[7] = n6;
                    this.vbeLineOffset = n5;
                    break;
                }
                case 8: 
                case 9: {
                    this.vbeRegs[this.vbeIndex] = n;
                    this.vbeStartAddress = this.vbeLineOffset * this.vbeRegs[9];
                    int n7 = this.vbeRegs[8];
                    this.vbeStartAddress = this.vbeRegs[3] == 4 ? (this.vbeStartAddress += n7 >>> 1) : (this.vbeStartAddress += n7 * (this.vbeRegs[3] + 7 >>> 3));
                    this.vbeStartAddress >>>= 2;
                    break;
                }
            }
        }
    }

    private final int vbeIOPortReadIndex() {
        return this.vbeIndex;
    }

    private final int vbeIOPortReadData() {
        if (this.vbeIndex <= 10) {
            return this.vbeRegs[this.vbeIndex];
        }
        return 0;
    }

    private final void internalReset() {
        this.latch = 0;
        this.crtRegisterIndex = 0;
        this.attributeRegisterIndex = 0;
        this.graphicsRegisterIndex = 0;
        this.sequencerRegisterIndex = 0;
        this.attributeRegisterFlipFlop = false;
        this.miscellaneousOutputRegister = 0;
        this.featureControlRegister = 0;
        this.st01 = 0;
        this.st00 = 0;
        this.dacWriteIndex = 0;
        this.dacReadIndex = 0;
        this.dacSubIndex = 0;
        this.dacState = 0;
        this.doubleScan = 0;
        this.shiftControl = 0;
        this.bankOffset = 0;
        this.vbeIndex = 0;
        this.vbeStartAddress = 0;
        this.vbeLineOffset = 0;
        this.vbeBankMask = 0;
        this.graphicMode = 0;
        this.lineOffset = 0;
        this.lineCompare = 0;
        this.startAddress = 0;
        this.planeUpdated = 0;
        this.lastCH = 0;
        this.lastCW = 0;
        this.lastHeight = 0;
        this.lastWidth = 0;
        this.lastScreenHeight = 0;
        this.lastScreenWidth = 0;
        this.cursorEnd = 0;
        this.cursorStart = 0;
        this.cursorOffset = 0;
        ByteBuffer.fillIntArray(this.lastChar, 0);
        ByteBuffer.fillIntArray(this.fontOffset, 0);
        ByteBuffer.fillIntArray(this.vbeRegs, 0);
        ByteBuffer.fillIntArray(this.dacCache, 0);
        ByteBuffer.fillIntArray(this.palette, 0);
        ByteBuffer.fillIntArray(this.sequencerRegister, 0);
        ByteBuffer.fillIntArray(this.graphicsRegister, 0);
        ByteBuffer.fillIntArray(this.attributeRegister, 0);
        ByteBuffer.fillIntArray(this.crtRegister, 0);
        this.graphicMode = -1;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isVolatile() {
        return true;
    }

    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        throw new IllegalStateException("copyContentsInto: Invalid Operation for VGA Card");
    }

    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        throw new IllegalStateException("copyContentsFrom: Invalid Operation for VGA Card");
    }

    public long getSize() {
        return 131072L;
    }

    public byte getByte(int n) {
        int n2 = this.graphicsRegister[6] >>> 2 & 3;
        n &= 0x1FFFF;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (n >= 65536) {
                    return -1;
                }
                n += this.bankOffset;
                break;
            }
            case 2: {
                if ((n -= 65536) < 32768 && n >= 0) break;
                return -1;
            }
            default: {
                if ((n -= 98304) >= 0) break;
                return -1;
            }
        }
        if ((this.sequencerRegister[4] & 8) != 0) {
            return this.ioRegion.getByte(n);
        }
        if ((this.graphicsRegister[5] & 0x10) != 0) {
            int n3 = this.graphicsRegister[4] & 2 | n & 1;
            return this.ioRegion.getByte((n & 0xFFFFFFFE) << 1 | n3);
        }
        this.latch = this.ioRegion.getDoubleWord(4 * n);
        if ((this.graphicsRegister[5] & 8) == 0) {
            return (byte)(this.latch >>> this.graphicsRegister[4] * 8);
        }
        int n4 = (this.latch ^ mask16[this.graphicsRegister[2]]) & mask16[this.graphicsRegister[7]];
        n4 |= n4 >>> 16;
        n4 |= n4 >>> 8;
        return (byte)(~n4);
    }

    public short getWord(int n) {
        int n2 = 0xFF & this.getByte(n);
        return (short)(n2 |= this.getByte(n + 1) << 8);
    }

    public int getDoubleWord(int n) {
        int n2 = 0xFF & this.getByte(n);
        n2 |= (0xFF & this.getByte(n + 1)) << 8;
        n2 |= (0xFF & this.getByte(n + 2)) << 16;
        return n2 |= (0xFF & this.getByte(n + 3)) << 24;
    }

    public long getQuadWord(int n) {
        long l = 0xFFL & (long)this.getByte(n);
        l |= (0xFFL & (long)this.getByte(n + 1)) << 8;
        l |= (0xFFL & (long)this.getByte(n + 2)) << 16;
        l |= (0xFFL & (long)this.getByte(n + 3)) << 24;
        l |= (0xFFL & (long)this.getByte(n + 4)) << 32;
        l |= (0xFFL & (long)this.getByte(n + 5)) << 40;
        l |= (0xFFL & (long)this.getByte(n + 6)) << 48;
        return l |= (0xFFL & (long)this.getByte(n + 7)) << 56;
    }

    public long getLowerDoubleQuadWord(int n) {
        return this.getQuadWord(n);
    }

    public long getUpperDoubleQuadWord(int n) {
        return this.getQuadWord(n + 8);
    }

    public void setByte(int n, byte by) {
        int n2 = this.graphicsRegister[6] >>> 2 & 3;
        n &= 0x1FFFF;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (n >= 65536) {
                    return;
                }
                n += this.bankOffset;
                break;
            }
            case 2: {
                if ((n -= 65536) < 32768 && n >= 0) break;
                return;
            }
            default: {
                if ((n -= 98304) >= 0) break;
                return;
            }
        }
        if ((this.sequencerRegister[4] & 8) != 0) {
            int n3 = n & 3;
            int n4 = 1 << n3;
            if ((this.sequencerRegister[2] & n4) != 0) {
                this.ioRegion.setByte(n, by);
                this.planeUpdated |= n4;
            }
        } else if ((this.graphicsRegister[5] & 0x10) != 0) {
            int n5 = this.graphicsRegister[4] & 2 | n & 1;
            int n6 = 1 << n5;
            if ((this.sequencerRegister[2] & n6) != 0) {
                this.ioRegion.setByte((n & 0xFFFFFFFE) << 1 | n5, by);
                this.planeUpdated |= n6;
            }
        } else {
            int n7;
            int n8;
            int n9 = 0;
            int n10 = this.graphicsRegister[5] & 3;
            int n11 = 0xFF & by;
            switch (n10) {
                default: {
                    n8 = this.graphicsRegister[3] & 7;
                    n11 |= n11 << 8;
                    n11 |= n11 << 16;
                    n11 = n11 >>> n8 | n11 << -n8;
                    n7 = mask16[this.graphicsRegister[1]];
                    n11 = n11 & ~n7 | mask16[this.graphicsRegister[0]] & n7;
                    n9 = this.graphicsRegister[8];
                    break;
                }
                case 1: {
                    n11 = this.latch;
                    int n12 = this.sequencerRegister[2];
                    this.planeUpdated |= n12;
                    int n13 = mask16[n12];
                    this.ioRegion.setDoubleWord(n <<= 2, this.ioRegion.getDoubleWord(n) & ~n13 | n11 & n13);
                    return;
                }
                case 2: {
                    n11 = mask16[n11 & 0xF];
                    n9 = this.graphicsRegister[8];
                    break;
                }
                case 3: {
                    n8 = this.graphicsRegister[3] & 7;
                    n11 = n11 >>> n8 | n11 << 8 - n8;
                    n9 = this.graphicsRegister[8] & n11;
                    n11 = mask16[this.graphicsRegister[0]];
                }
            }
            n8 = this.graphicsRegister[3] >>> 3;
            switch (n8) {
                default: {
                    break;
                }
                case 1: {
                    n11 &= this.latch;
                    break;
                }
                case 2: {
                    n11 |= this.latch;
                    break;
                }
                case 3: {
                    n11 ^= this.latch;
                }
            }
            n9 |= n9 << 8;
            n9 |= n9 << 16;
            n11 = n11 & n9 | this.latch & ~n9;
            n7 = this.sequencerRegister[2];
            this.planeUpdated |= n7;
            int n14 = mask16[n7];
            this.ioRegion.setDoubleWord(n <<= 2, this.ioRegion.getDoubleWord(n) & ~n14 | n11 & n14);
        }
    }

    public void setWord(int n, short s) {
        this.setByte(n++, (byte)s);
        s = (short)(s >>> 8);
        this.setByte(n, (byte)s);
    }

    public void setDoubleWord(int n, int n2) {
        this.setByte(n++, (byte)n2);
        this.setByte(n++, (byte)(n2 >>>= 8));
        this.setByte(n++, (byte)(n2 >>>= 8));
        this.setByte(n, (byte)(n2 >>>= 8));
    }

    public void setQuadWord(int n, long l) {
        this.setDoubleWord(n, (int)l);
        this.setDoubleWord(n + 4, (int)(l >> 32));
    }

    public void setLowerDoubleQuadWord(int n, long l) {
        this.setDoubleWord(n, (int)l);
        this.setDoubleWord(n + 4, (int)(l >> 32));
    }

    public void setUpperDoubleQuadWord(int n, long l) {
        this.setDoubleWord(n += 8, (int)l);
        this.setDoubleWord(n + 4, (int)(l >> 32));
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    public void clear() {
        this.internalReset();
    }

    public void clear(int n, int n2) {
        this.clear();
    }

    public final void updateDisplay(GraphicsDisplay graphicsDisplay) {
        if (graphicsDisplay == null) {
            return;
        }
        this.updatingScreen = true;
        boolean bl = false;
        int n = (this.attributeRegisterIndex & 0x20) == 0 ? 2 : this.graphicsRegister[6] & 1;
        if (n != this.graphicMode) {
            this.graphicMode = n;
            bl = true;
        }
        switch (this.graphicMode) {
            case 0: {
                this.drawText(bl, graphicsDisplay);
                break;
            }
            case 1: {
                this.drawGraphic(bl, graphicsDisplay);
                break;
            }
            default: {
                this.drawBlank(bl, graphicsDisplay);
            }
        }
        this.updatingScreen = false;
    }

    private final void drawText(boolean bl, GraphicsDisplay graphicsDisplay) {
        int n;
        int n2;
        boolean bl2 = this.updatePalette16(graphicsDisplay);
        bl |= bl2;
        int[] nArray = this.lastPalette;
        int n3 = this.sequencerRegister[3];
        int n4 = (n3 >>> 4 & 1 | n3 << 1 & 6) * 8192 * 4 + 2;
        if (n4 != this.fontOffset[0]) {
            this.fontOffset[0] = n4;
            bl = true;
        }
        if ((n4 = (n3 >>> 5 & 1 | n3 >>> 1 & 6) * 8192 * 4 + 2) != this.fontOffset[1]) {
            this.fontOffset[1] = n4;
            bl = true;
        }
        if ((this.planeUpdated & 4) != 0) {
            this.planeUpdated = 0;
            bl = true;
        }
        bl2 = this.updateBasicParameters();
        bl |= bl2;
        int n5 = this.startAddress * 4;
        int n6 = (this.crtRegister[9] & 0x1F) + 1;
        int n7 = 8;
        if ((this.sequencerRegister[1] & 1) == 0) {
            n7 = 9;
        }
        if ((this.sequencerRegister[1] & 8) != 0) {
            n7 = 16;
        }
        int n8 = this.crtRegister[1] + 1;
        if (this.crtRegister[6] == 100) {
            n2 = 100;
        } else {
            n2 = this.crtRegister[18] | (this.crtRegister[7] & 2) << 7 | (this.crtRegister[7] & 0x40) << 3;
            n2 = (n2 + 1) / n6;
        }
        if (n2 * n8 > 16000) {
            return;
        }
        if (n8 != this.lastWidth || n2 != this.lastHeight || n7 != this.lastCW || n6 != this.lastCH) {
            this.lastScreenWidth = n8 * n7;
            this.lastScreenHeight = n2 * n6;
            graphicsDisplay.resizeDisplay(this.lastScreenWidth, this.lastScreenHeight);
            this.lastWidth = n8;
            this.lastHeight = n2;
            this.lastCH = n6;
            this.lastCW = n7;
            bl = true;
        }
        if ((n = (this.crtRegister[14] << 8 | this.crtRegister[15]) - this.startAddress) != this.cursorOffset || this.crtRegister[10] != this.cursorStart || this.crtRegister[11] != this.cursorEnd) {
            if (this.cursorOffset < 16000 && this.cursorOffset >= 0) {
                this.lastChar[this.cursorOffset] = -1;
            }
            if (n < 16000 && n >= 0) {
                this.lastChar[n] = -1;
            }
            this.cursorOffset = n;
            this.cursorStart = this.crtRegister[10];
            this.cursorEnd = this.crtRegister[11];
        }
        int n9 = (this.startAddress + this.cursorOffset) * 4;
        int n10 = 0;
        switch (n7) {
            case 8: {
                for (int i = 0; i < n2; ++i) {
                    int n11 = n5;
                    for (int j = 0; j < n8; ++j) {
                        int n12 = 0xFFFF & this.ioRegion.getWord(n11);
                        if (bl || n12 != this.lastChar[n10]) {
                            this.lastChar[n10] = n12;
                            int n13 = 0xFF & n12;
                            int n14 = n12 >>> 8;
                            int n15 = this.fontOffset[n14 >>> 3 & 1] + 128 * n13;
                            int n16 = nArray[n14 >>> 4];
                            int n17 = nArray[n14 & 0xF];
                            this.drawGlyph8(graphicsDisplay.getDisplayBuffer(), i * n6 * this.lastScreenWidth + j * 8, this.lastScreenWidth, n15, n6, n17, n16);
                            graphicsDisplay.dirtyDisplayRegion(j * 8, i * n6, 8, n6);
                            if (n11 == n9 && (this.crtRegister[10] & 0x20) == 0) {
                                int n18 = this.crtRegister[10] & 0x1F;
                                int n19 = this.crtRegister[11] & 0x1F;
                                if (n19 > n6 - 1) {
                                    n19 = n6 - 1;
                                }
                                if (n19 >= n18 && n18 < n6) {
                                    int n20 = n19 - n18 + 1;
                                    this.drawCursorGlyph8(graphicsDisplay.getDisplayBuffer(), (i * n6 + n18) * this.lastScreenWidth + j * 8, this.lastScreenWidth, n20, n17, n16);
                                    graphicsDisplay.dirtyDisplayRegion(j * 8, i * n6 + n18, 8, n20);
                                }
                            }
                        }
                        n11 += 4;
                        ++n10;
                    }
                    n5 += this.lineOffset;
                }
                return;
            }
            case 9: {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n5;
                    for (int j = 0; j < n8; ++j) {
                        int n22 = 0xFFFF & this.ioRegion.getWord(n21);
                        if (bl || n22 != this.lastChar[n10]) {
                            this.lastChar[n10] = n22;
                            int n23 = 0xFF & n22;
                            int n24 = n22 >>> 8;
                            int n25 = this.fontOffset[n24 >>> 3 & 1] + 128 * n23;
                            int n26 = nArray[n24 >>> 4];
                            int n27 = nArray[n24 & 0xF];
                            boolean bl3 = n23 >= 176 && n23 <= 223 && (this.attributeRegister[16] & 4) != 0;
                            this.drawGlyph9(graphicsDisplay.getDisplayBuffer(), i * n6 * this.lastScreenWidth + j * 9, this.lastScreenWidth, n25, n6, n27, n26, bl3);
                            graphicsDisplay.dirtyDisplayRegion(j * 9, i * n6, 9, n6);
                            if (n21 == n9 && (this.crtRegister[10] & 0x20) == 0) {
                                int n28 = this.crtRegister[10] & 0x1F;
                                int n29 = this.crtRegister[11] & 0x1F;
                                if (n29 > n6 - 1) {
                                    n29 = n6 - 1;
                                }
                                if (n29 >= n28 && n28 < n6) {
                                    int n30 = n29 - n28 + 1;
                                    this.drawCursorGlyph9(graphicsDisplay.getDisplayBuffer(), (i * n6 + n28) * this.lastScreenWidth + j * 9, this.lastScreenWidth, n30, n27, n26);
                                    graphicsDisplay.dirtyDisplayRegion(j * 9, i * n6 + n28, 9, n30);
                                }
                            }
                        }
                        n21 += 4;
                        ++n10;
                    }
                    n5 += this.lineOffset;
                }
                return;
            }
            case 16: {
                for (int i = 0; i < n2; ++i) {
                    int n31 = n5;
                    for (int j = 0; j < n8; ++j) {
                        int n32 = 0xFFFF & this.ioRegion.getWord(n31);
                        if (bl || n32 != this.lastChar[n10]) {
                            this.lastChar[n10] = n32;
                            int n33 = 0xFF & n32;
                            int n34 = n32 >>> 8;
                            int n35 = this.fontOffset[n34 >>> 3 & 1] + 128 * n33;
                            int n36 = nArray[n34 >>> 4];
                            int n37 = nArray[n34 & 0xF];
                            this.drawGlyph16(graphicsDisplay.getDisplayBuffer(), i * n6 * this.lastScreenWidth + j * 16, this.lastScreenWidth, n35, n6, n37, n36);
                            graphicsDisplay.dirtyDisplayRegion(j * 16, i * n6, 16, n6);
                            if (n31 == n9 && (this.crtRegister[10] & 0x20) == 0) {
                                int n38 = this.crtRegister[10] & 0x1F;
                                int n39 = this.crtRegister[11] & 0x1F;
                                if (n39 > n6 - 1) {
                                    n39 = n6 - 1;
                                }
                                if (n39 >= n38 && n38 < n6) {
                                    int n40 = n39 - n38 + 1;
                                    this.drawCursorGlyph16(graphicsDisplay.getDisplayBuffer(), (i * n6 + n38) * this.lastScreenWidth + j * 16, this.lastScreenWidth, n40, n37, n36);
                                    graphicsDisplay.dirtyDisplayRegion(j * 16, i * n6 + n38, 16, n40);
                                }
                            }
                        }
                        n31 += 4;
                        ++n10;
                    }
                    n5 += this.lineOffset;
                }
                return;
            }
        }
        System.err.println("Unknown Character Width: " + n7);
    }

    private final void drawGraphic(boolean bl, GraphicsDisplay graphicsDisplay) {
        boolean bl2 = this.updateBasicParameters();
        bl |= bl2;
        int n = (this.crtRegister[1] + 1) * 8;
        int n2 = (this.crtRegister[18] | (this.crtRegister[7] & 2) << 7 | (this.crtRegister[7] & 0x40) << 3) + 1;
        int n3 = n;
        int n4 = this.graphicsRegister[5] >>> 5 & 3;
        int n5 = this.crtRegister[9] >>> 7;
        int n6 = n4 != 1 ? ((this.crtRegister[9] & 0x1F) + 1 << n5) - 1 : n5;
        if (n4 != this.shiftControl || n5 != this.doubleScan) {
            bl = true;
            this.shiftControl = n4;
            this.doubleScan = n5;
        }
        GraphicsUpdater graphicsUpdater = null;
        if (this.shiftControl == 0) {
            bl2 = this.updatePalette16(graphicsDisplay);
            bl |= bl2;
            if ((this.sequencerRegister[1] & 8) != 0) {
                graphicsUpdater = this.VGA_DRAW_LINE4D2;
                n3 <<= 1;
            } else {
                graphicsUpdater = this.VGA_DRAW_LINE4;
            }
        } else if (this.shiftControl == 1) {
            bl2 = this.updatePalette16(graphicsDisplay);
            bl |= bl2;
            if ((this.sequencerRegister[1] & 8) != 0) {
                graphicsUpdater = this.VGA_DRAW_LINE2D2;
                n3 <<= 1;
            } else {
                graphicsUpdater = this.VGA_DRAW_LINE2;
            }
        } else {
            int n7 = 0;
            if ((this.vbeRegs[4] & 1) != 0) {
                n7 = this.vbeRegs[3];
            }
            switch (n7) {
                default: {
                    bl2 = this.updatePalette256(graphicsDisplay);
                    bl |= bl2;
                    graphicsUpdater = this.VGA_DRAW_LINE8D2;
                    break;
                }
                case 8: {
                    bl2 = this.updatePalette256(graphicsDisplay);
                    bl |= bl2;
                    graphicsUpdater = this.VGA_DRAW_LINE8;
                    break;
                }
                case 15: {
                    graphicsUpdater = this.VGA_DRAW_LINE15;
                    break;
                }
                case 16: {
                    graphicsUpdater = this.VGA_DRAW_LINE16;
                    break;
                }
                case 24: {
                    graphicsUpdater = this.VGA_DRAW_LINE24;
                    break;
                }
                case 32: {
                    graphicsUpdater = this.VGA_DRAW_LINE32;
                }
            }
        }
        if (n3 != this.lastWidth || n2 != this.lastHeight) {
            bl = true;
            this.lastScreenWidth = this.lastWidth = n3;
            this.lastScreenHeight = this.lastHeight = n2;
            graphicsDisplay.resizeDisplay(this.lastScreenWidth, this.lastScreenHeight);
        }
        graphicsUpdater.updateDisplay(graphicsDisplay, n, n2, n3, bl, n6);
    }

    private final void drawBlank(boolean bl, GraphicsDisplay graphicsDisplay) {
        if (!bl) {
            return;
        }
        if (this.lastScreenWidth <= 0 || this.lastScreenHeight <= 0) {
            return;
        }
        int[] nArray = graphicsDisplay.getDisplayBuffer();
        int n = graphicsDisplay.rgbToPixel(0, 0, 0);
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = n;
        }
        graphicsDisplay.dirtyDisplayRegion(0, 0, this.lastScreenWidth, this.lastScreenHeight);
    }

    private final boolean updatePalette16(GraphicsDisplay graphicsDisplay) {
        boolean bl = false;
        int[] nArray = this.lastPalette;
        for (int i = 0; i <= 15; ++i) {
            int n;
            int n2 = this.attributeRegister[i];
            n2 = (this.attributeRegister[16] & 0x80) != 0 ? (this.attributeRegister[20] & 0xF) << 4 | n2 & 0xF : (this.attributeRegister[20] & 0xC) << 4 | n2 & 0x3F;
            if ((n = graphicsDisplay.rgbToPixel(VGACard.c6to8(this.palette[n2 *= 3]), VGACard.c6to8(this.palette[n2 + 1]), VGACard.c6to8(this.palette[n2 + 2]))) == nArray[i]) continue;
            bl = true;
            nArray[i] = n;
        }
        return bl;
    }

    private final boolean updatePalette256(GraphicsDisplay graphicsDisplay) {
        boolean bl = false;
        int[] nArray = this.lastPalette;
        int n = 0;
        int n2 = 0;
        while (n < 256) {
            int n3 = graphicsDisplay.rgbToPixel(VGACard.c6to8(this.palette[n2]), VGACard.c6to8(this.palette[n2 + 1]), VGACard.c6to8(this.palette[n2 + 2]));
            if (n3 != nArray[n]) {
                bl = true;
                nArray[n] = n3;
            }
            ++n;
            n2 += 3;
        }
        return bl;
    }

    private final boolean updateBasicParameters() {
        int n;
        int n2;
        if ((this.vbeRegs[4] & 1) != 0) {
            n2 = this.vbeLineOffset;
            n = this.vbeStartAddress;
        } else {
            n2 = this.crtRegister[19];
            n2 <<= 3;
            n = this.crtRegister[13] | this.crtRegister[12] << 8;
        }
        int n3 = this.crtRegister[24] | (this.crtRegister[7] & 0x10) << 4 | (this.crtRegister[9] & 0x40) << 3;
        if (n2 != this.lineOffset || n != this.startAddress || n3 != this.lineCompare) {
            this.lineOffset = n2;
            this.startAddress = n;
            this.lineCompare = n3;
            return true;
        }
        return false;
    }

    private static final int c6to8(int n) {
        int n2 = (n &= 0x3F) & 1;
        return n << 2 | n2 << 1 | n2;
    }

    private final void drawGlyph8(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 ^ n5;
        n2 -= 8;
        do {
            byte by = this.ioRegion.getByte(n3);
            for (int i = 7; i >= 0; --i) {
                int n8 = -(by >>> i & 1) & n7 ^ n6;
                nArray[n++] = n8;
            }
            n3 += 4;
            n += n2;
        } while (--n4 != 0);
    }

    private final void drawGlyph16(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 ^ n5;
        n2 -= 16;
        do {
            int n8;
            int n9;
            byte by = this.ioRegion.getByte(n3);
            int n10 = this.expand4to8[by >>> 4 & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n10 >>> n9 & 1) & n7 ^ n6;
                nArray[n++] = n8;
            }
            n10 = this.expand4to8[by & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n10 >>> n9 & 1) & n7 ^ n6;
                nArray[n++] = n8;
            }
            n3 += 4;
            n += n2;
        } while (--n4 != 0);
    }

    private final void drawGlyph9(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n6 ^ n5;
        n2 -= 9;
        if (bl) {
            do {
                byte by = this.ioRegion.getByte(n3);
                for (int i = 7; i >= 0; --i) {
                    int n8 = -(by >>> i & 1) & n7 ^ n6;
                    nArray[n++] = n8;
                }
                nArray[n++] = nArray[n - 2];
                n3 += 4;
                n += n2;
            } while (--n4 != 0);
        } else {
            do {
                byte by = this.ioRegion.getByte(n3);
                for (int i = 7; i >= 0; --i) {
                    int n9 = -(by >>> i & 1) & n7 ^ n6;
                    nArray[n++] = n9;
                }
                nArray[n++] = n6;
                n3 += 4;
                n += n2;
            } while (--n4 != 0);
        }
    }

    private final void drawCursorGlyph8(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 ^ n4;
        int n7 = 0;
        n2 -= 8;
        do {
            int n8 = cursorGlyph[n7];
            for (int i = 7; i >= 0; --i) {
                int n9 = -(n8 >>> i & 1) & n6 ^ n5;
                nArray[n++] = n9;
            }
            n7 += 4;
            n += n2;
        } while (--n3 != 0);
    }

    private final void drawCursorGlyph16(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n5 ^ n4;
        n2 -= 16;
        do {
            int n8;
            int n9;
            int n10 = cursorGlyph[n6];
            int n11 = this.expand4to8[n10 >>> 4 & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n11 >>> n9 & 1) & n7 ^ n5;
                nArray[n++] = n8;
            }
            n11 = this.expand4to8[n10 & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n11 >>> n9 & 1) & n7 ^ n5;
                nArray[n++] = n8;
            }
            n6 += 4;
            n += n2;
        } while (--n3 != 0);
    }

    private final void drawCursorGlyph9(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n5 ^ n4;
        n2 -= 9;
        do {
            int n8 = cursorGlyph[n6];
            for (int i = 7; i >= 0; --i) {
                int n9 = -(n8 >>> i & 1) & n7 ^ n5;
                nArray[n++] = n9;
            }
            nArray[n++] = nArray[n - 2];
            ++n6;
            n += n2;
        } while (--n3 != 0);
    }

    public boolean initialised() {
        return this.ioportRegistered && this.pciRegistered && this.memoryRegistered;
    }

    public void reset() {
        this.ioportRegistered = false;
        this.memoryRegistered = false;
        this.pciRegistered = false;
        this.assignDevFN(-1);
        this.setIRQIndex(16);
        this.putConfigByte(0, (byte)52);
        this.putConfigByte(1, (byte)18);
        this.putConfigByte(2, (byte)17);
        this.putConfigByte(3, (byte)17);
        this.putConfigByte(10, (byte)0);
        this.putConfigByte(11, (byte)3);
        this.putConfigByte(14, (byte)0);
        this.sequencerRegister = new int[256];
        this.graphicsRegister = new int[256];
        this.attributeRegister = new int[256];
        this.crtRegister = new int[256];
        this.dacCache = new int[3];
        this.palette = new int[768];
        this.ioRegion = new VGARAMIORegion();
        this.vbeRegs = new int[10];
        this.fontOffset = new int[2];
        this.lastChar = new int[16000];
        this.internalReset();
        this.bankOffset = 0;
        this.vbeRegs[0] = 45248;
        this.vbeBankMask = 63;
        super.reset();
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised()) {
            ((PCIBus)hardwareComponent).registerDevice(this);
            this.pciRegistered = true;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            ((PhysicalAddressSpace)hardwareComponent).mapMemoryRegion(this, 655360, 131072);
            this.memoryRegistered = true;
        }
    }

    public String toString() {
        return "VGA Card [Mode: " + this.lastScreenWidth + " x " + this.lastScreenHeight + "]";
    }

    class DrawLine32
    extends GraphicsUpdater {
        DrawLine32() {
        }

        int byteWidth(int n) {
            return n * 4;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFF & VGACard.this.ioRegion.getByte(n++);
                int n7 = 0xFF & VGACard.this.ioRegion.getByte(n++);
                int n8 = 0xFF & VGACard.this.ioRegion.getByte(n++);
                ++n;
                nArray[n5++] = graphicsDisplay.rgbToPixel(n8, n7, n6);
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine24
    extends GraphicsUpdater {
        DrawLine24() {
        }

        int byteWidth(int n) {
            return n * 3;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFF & VGACard.this.ioRegion.getByte(n++);
                int n7 = 0xFF & VGACard.this.ioRegion.getByte(n++);
                int n8 = 0xFF & VGACard.this.ioRegion.getByte(n++);
                nArray[n5++] = graphicsDisplay.rgbToPixel(n8, n7, n6);
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine16
    extends GraphicsUpdater {
        DrawLine16() {
        }

        int byteWidth(int n) {
            return n * 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFFFF & VGACard.this.ioRegion.getWord(n);
                int n7 = n6 >>> 8 & 0xF8;
                int n8 = n6 >>> 3 & 0xFC;
                int n9 = n6 << 3 & 0xF8;
                nArray[n5] = graphicsDisplay.rgbToPixel(n7, n8, n9);
                n += 2;
                ++n5;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine15
    extends GraphicsUpdater {
        DrawLine15() {
        }

        int byteWidth(int n) {
            return n * 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFFFF & VGACard.this.ioRegion.getWord(n);
                int n7 = n6 >>> 7 & 0xF8;
                int n8 = n6 >>> 2 & 0xF8;
                int n9 = n6 << 3 & 0xF8;
                nArray[n5] = graphicsDisplay.rgbToPixel(n7, n8, n9);
                n += 2;
                ++n5;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine8
    extends GraphicsUpdater {
        DrawLine8() {
        }

        int byteWidth(int n) {
            return n;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            int[] nArray2 = VGACard.this.lastPalette;
            do {
                nArray[n5] = nArray2[0xFF & VGACard.this.ioRegion.getByte(n++)];
                ++n5;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine8d2
    extends GraphicsUpdater {
        DrawLine8d2() {
        }

        int byteWidth(int n) {
            return n / 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            int[] nArray2 = VGACard.this.lastPalette;
            n2 >>>= 1;
            do {
                int n6 = nArray2[0xFF & VGACard.this.ioRegion.getByte(n++)];
                nArray[n5++] = n6;
                nArray[n5++] = n6;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine4d2
    extends GraphicsUpdater {
        DrawLine4d2() {
        }

        int byteWidth(int n) {
            return n / 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            int[] nArray2 = VGACard.this.lastPalette;
            int n6 = mask16[VGACard.this.attributeRegister[18] & 0xF];
            n2 >>>= 3;
            do {
                int n7 = VGACard.this.ioRegion.getDoubleWord(n);
                int n8 = this.ex4[(n7 &= n6) & 0xFF];
                n8 |= this.ex4[n7 >>> 8 & 0xFF] << 1;
                n8 |= this.ex4[n7 >>> 16 & 0xFF] << 2;
                int n9 = n5++;
                int n10 = n5++;
                int n11 = nArray2[(n8 |= this.ex4[n7 >>> 24 & 0xFF] << 3) >>> 28];
                nArray[n10] = n11;
                nArray[n9] = n11;
                int n12 = n5++;
                int n13 = n5++;
                int n14 = nArray2[n8 >>> 24 & 0xF];
                nArray[n13] = n14;
                nArray[n12] = n14;
                int n15 = n5++;
                int n16 = n5++;
                int n17 = nArray2[n8 >>> 20 & 0xF];
                nArray[n16] = n17;
                nArray[n15] = n17;
                int n18 = n5++;
                int n19 = n5++;
                int n20 = nArray2[n8 >>> 16 & 0xF];
                nArray[n19] = n20;
                nArray[n18] = n20;
                int n21 = n5++;
                int n22 = n5++;
                int n23 = nArray2[n8 >>> 12 & 0xF];
                nArray[n22] = n23;
                nArray[n21] = n23;
                int n24 = n5++;
                int n25 = n5++;
                int n26 = nArray2[n8 >>> 8 & 0xF];
                nArray[n25] = n26;
                nArray[n24] = n26;
                int n27 = n5++;
                int n28 = n5++;
                int n29 = nArray2[n8 >>> 4 & 0xF];
                nArray[n28] = n29;
                nArray[n27] = n29;
                int n30 = n5++;
                int n31 = n5++;
                int n32 = nArray2[n8 >>> 0 & 0xF];
                nArray[n31] = n32;
                nArray[n30] = n32;
                n += 4;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine4
    extends GraphicsUpdater {
        DrawLine4() {
        }

        int byteWidth(int n) {
            return n / 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            int[] nArray2 = VGACard.this.lastPalette;
            int n6 = mask16[VGACard.this.attributeRegister[18] & 0xF];
            n2 >>>= 3;
            do {
                int n7 = VGACard.this.ioRegion.getDoubleWord(n) & n6;
                int n8 = this.ex4[n7 & 0xFF];
                n8 |= this.ex4[(n7 >>>= 8) & 0xFF] << 1;
                n8 |= this.ex4[(n7 >>>= 8) & 0xFF] << 2;
                nArray[n5++] = nArray2[(n8 |= this.ex4[(n7 >>>= 8) & 0xFF] << 3) >>> 28];
                nArray[n5++] = nArray2[n8 >>> 24 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 20 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 16 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 12 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 8 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 4 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 0 & 0xF];
                n += 4;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine2d2
    extends GraphicsUpdater {
        DrawLine2d2() {
        }

        int byteWidth(int n) {
            return n / 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            int[] nArray2 = VGACard.this.lastPalette;
            int n6 = mask16[VGACard.this.attributeRegister[18] & 0xF];
            n2 >>>= 3;
            do {
                int n7 = VGACard.this.ioRegion.getDoubleWord(n);
                int n8 = this.ex2[(n7 &= n6) & 0xFF];
                int n9 = n5++;
                int n10 = n5++;
                int n11 = nArray2[(n8 |= this.ex2[n7 >>> 16 & 0xFF] << 2) >>> 12];
                nArray[n10] = n11;
                nArray[n9] = n11;
                int n12 = n5++;
                int n13 = n5++;
                int n14 = nArray2[n8 >>> 8 & 0xF];
                nArray[n13] = n14;
                nArray[n12] = n14;
                int n15 = n5++;
                int n16 = n5++;
                int n17 = nArray2[n8 >>> 4 & 0xF];
                nArray[n16] = n17;
                nArray[n15] = n17;
                int n18 = n5++;
                int n19 = n5++;
                int n20 = nArray2[n8 >>> 0 & 0xF];
                nArray[n19] = n20;
                nArray[n18] = n20;
                n8 = this.ex2[n7 >>> 8 & 0xFF];
                int n21 = n5++;
                int n22 = n5++;
                int n23 = nArray2[(n8 |= this.ex2[n7 >>> 24 & 0xFF] << 2) >>> 12];
                nArray[n22] = n23;
                nArray[n21] = n23;
                int n24 = n5++;
                int n25 = n5++;
                int n26 = nArray2[n8 >>> 8 & 0xF];
                nArray[n25] = n26;
                nArray[n24] = n26;
                int n27 = n5++;
                int n28 = n5++;
                int n29 = nArray2[n8 >>> 4 & 0xF];
                nArray[n28] = n29;
                nArray[n27] = n29;
                int n30 = n5++;
                int n31 = n5++;
                int n32 = nArray2[n8 >>> 0 & 0xF];
                nArray[n31] = n32;
                nArray[n30] = n32;
                n += 4;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    class DrawLine2
    extends GraphicsUpdater {
        DrawLine2() {
        }

        int byteWidth(int n) {
            return n / 2;
        }

        void drawLine(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, int n4) {
            int[] nArray = graphicsDisplay.getDisplayBuffer();
            int n5 = n3 * n4;
            int[] nArray2 = VGACard.this.lastPalette;
            int n6 = mask16[VGACard.this.attributeRegister[18] & 0xF];
            n2 >>>= 3;
            do {
                int n7 = VGACard.this.ioRegion.getDoubleWord(n);
                int n8 = this.ex2[(n7 &= n6) & 0xFF];
                nArray[n5++] = nArray2[(n8 |= this.ex2[n7 >>> 16 & 0xFF] << 2) >>> 12];
                nArray[n5++] = nArray2[n8 >>> 8 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 4 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 0 & 0xF];
                n8 = this.ex2[n7 >>> 8 & 0xFF];
                nArray[n5++] = nArray2[(n8 |= this.ex2[n7 >>> 24 & 0xFF] << 2) >>> 12];
                nArray[n5++] = nArray2[n8 >>> 8 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 4 & 0xF];
                nArray[n5++] = nArray2[n8 >>> 0 & 0xF];
                n += 4;
            } while (--n2 != 0);
            graphicsDisplay.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    abstract class GraphicsUpdater {
        int[] ex4;
        int[] ex2;

        GraphicsUpdater() {
            this.ex2 = new int[VGACard.this.expand2.length];
            System.arraycopy(VGACard.this.expand2, 0, this.ex2, 0, this.ex2.length);
            this.ex4 = new int[VGACard.this.expand4.length];
            System.arraycopy(VGACard.this.expand4, 0, this.ex4, 0, this.ex4.length);
        }

        abstract int byteWidth(int var1);

        abstract void drawLine(GraphicsDisplay var1, int var2, int var3, int var4, int var5);

        void updateDisplay(GraphicsDisplay graphicsDisplay, int n, int n2, int n3, boolean bl, int n4) {
            int n5;
            int n6 = n4;
            int n7 = 4 * VGACard.this.startAddress;
            int n8 = 0;
            boolean bl2 = (VGACard.this.crtRegister[23] & 1) == 0;
            boolean bl3 = (VGACard.this.crtRegister[23] & 2) == 0;
            boolean bl4 = bl2 || bl3;
            int n9 = VGACard.this.crtRegister[23] & 3 ^ 3;
            int n10 = Integer.MAX_VALUE;
            int n11 = Integer.MIN_VALUE;
            for (n5 = 0; n5 < n2; ++n5) {
                int n12;
                boolean bl5 = bl;
                int n13 = n7;
                if (bl4) {
                    if (bl2) {
                        n12 = 14 + (VGACard.this.crtRegister[23] >>> 6 & 1);
                        n13 = n13 & ~(1 << n12) | (n8 & 1) << n12;
                    }
                    if (bl3) {
                        n13 = n13 & 0xFFFF7FFF | (n8 & 2) << 14;
                    }
                }
                n12 = n13 >>> 12;
                int n14 = n13 + this.byteWidth(n) - 1 >>> 12;
                for (int i = n12; i <= n14; ++i) {
                    if (!(bl5 |= VGACard.this.ioRegion.pageIsDirty(i))) continue;
                    n10 = Math.min(n10, n12);
                    n11 = Math.max(n11, n14);
                    this.drawLine(graphicsDisplay, n13, n, n5, n3);
                    break;
                }
                if (n6 == 0) {
                    if ((n8 & n9) == n9) {
                        n7 += VGACard.this.lineOffset;
                    }
                    ++n8;
                    n6 = n4;
                } else {
                    --n6;
                }
                if (n5 != VGACard.this.lineCompare) continue;
                n7 = 0;
            }
            for (n5 = n10; n5 <= n11; ++n5) {
                VGACard.this.ioRegion.cleanPage(n5);
            }
        }
    }

    public class VGARAMIORegion
    extends AbstractMemory
    implements MemoryMappedIORegion {
        private byte[] buffer = new byte[65536];
        private int startAddress;
        private boolean[] dirtyPages = new boolean[1025];

        public VGARAMIORegion() {
            for (int i = 0; i < this.dirtyPages.length; ++i) {
                this.dirtyPages[i] = false;
            }
            this.startAddress = -1;
        }

        private void increaseVGARAMSize(int n) {
            int n2;
            if (n < 0 || n >= 0x400000) {
                throw new ArrayIndexOutOfBoundsException("tried to access outside of memeory bounds");
            }
            for (n2 = this.buffer.length; n2 <= n; n2 <<= 1) {
            }
            if (n2 >= 0x400000) {
                n2 >>= 1;
            }
            byte[] byArray = new byte[n2];
            for (int i = 0; i < this.buffer.length; ++i) {
                byArray[i] = this.buffer[i];
            }
            this.buffer = byArray;
        }

        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }

        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }

        public void clear() {
            int n;
            for (n = 0; n < this.buffer.length; ++n) {
                this.buffer[n] = 0;
            }
            for (n = 0; n < this.dirtyPages.length; ++n) {
                this.dirtyPages[n] = false;
            }
        }

        public void clear(int n, int n2) {
            int n3;
            int n4 = n + n2;
            if ((long)n4 > this.getSize()) {
                throw new ArrayIndexOutOfBoundsException("Attempt to clear outside of memory bounds");
            }
            try {
                for (n3 = n; n3 < n4; ++n3) {
                    this.buffer[n3] = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n3 = n >>> 12;
            int n5 = n4 - 1 >>> 12;
            for (int i = n3; i <= n5; ++i) {
                this.dirtyPages[i] = true;
            }
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean isVolatile() {
            return false;
        }

        public boolean pageIsDirty(int n) {
            return this.dirtyPages[n];
        }

        public void cleanPage(int n) {
            this.dirtyPages[n] = false;
        }

        public int getAddress() {
            return this.startAddress;
        }

        public long getSize() {
            return 0x400000L;
        }

        public int getType() {
            return 8;
        }

        public int getRegionNumber() {
            return 0;
        }

        public void setAddress(int n) {
            this.startAddress = n;
        }

        public void setByte(int n, byte by) {
            try {
                this.dirtyPages[n >>> 12] = true;
                this.buffer[n] = by;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                this.setByte(n, by);
            }
        }

        public byte getByte(int n) {
            try {
                return this.buffer[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                return this.getByte(n);
            }
        }

        public void setWord(int n, short s) {
            try {
                this.buffer[n] = (byte)s;
                this.dirtyPages[n >>> 12] = true;
                this.buffer[++n] = (byte)(s >> 8);
                this.dirtyPages[n >>> 12] = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                this.setWord(n, s);
            }
        }

        public short getWord(int n) {
            try {
                int n2 = 0xFF & this.buffer[n];
                return (short)(n2 |= this.buffer[++n] << 8);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                return this.getWord(n);
            }
        }

        public void setDoubleWord(int n, int n2) {
            try {
                this.dirtyPages[n >>> 12] = true;
                this.buffer[n] = (byte)n2;
                this.buffer[++n] = (byte)(n2 >>= 8);
                this.buffer[++n] = (byte)(n2 >>= 8);
                this.buffer[++n] = (byte)(n2 >>= 8);
                this.dirtyPages[n >>> 12] = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                this.setDoubleWord(n, n2);
            }
        }

        public int getDoubleWord(int n) {
            try {
                int n2 = 0xFF & this.buffer[n];
                n2 |= (0xFF & this.buffer[++n]) << 8;
                n2 |= (0xFF & this.buffer[++n]) << 16;
                return n2 |= this.buffer[++n] << 24;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                return this.getDoubleWord(n);
            }
        }

        public String toString() {
            return "VGA RAM ByteArray[" + this.getSize() + "]";
        }

        public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
            throw new IllegalStateException("Invalid Operation");
        }

        public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
            throw new IllegalStateException("Invalid Operation");
        }
    }
}

