/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.DMAController;
import org.jpc.emulator.motherboard.DMATransferCapable;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.peripheral.FloppyFormat;
import org.jpc.support.BlockDevice;
import org.jpc.support.Clock;
import org.jpc.support.DriveSet;

public class FloppyController
implements IOPortCapable,
DMATransferCapable,
TimerResponsive,
HardwareComponent {
    private static final int FDRIVE_SECTOR_LEN = 512;
    private static final int FDRIVE_SECTOR_SC = 2;
    public static final int FDRIVE_DISK_288 = 1;
    public static final int FDRIVE_DISK_144 = 2;
    public static final int FDRIVE_DISK_720 = 3;
    public static final int FDRIVE_DISK_USER = 4;
    public static final int FDRIVE_DISK_NONE = 5;
    public static final int FDRIVE_DRV_144 = 0;
    public static final int FDRIVE_DRV_288 = 1;
    public static final int FDRIVE_DRV_120 = 2;
    public static final int FDRIVE_DRV_NONE = 3;
    private static final int FDRIVE_MOTOR_ON = 1;
    private static final int FDRIVE_REVALIDATE = 2;
    private static final int FDISK_DBL_SIDES = 1;
    private static final int FDRIVE_CTRL_ACTIVE = 1;
    private static final int FDRIVE_CTRL_RESET = 2;
    private static final int FDRIVE_CTRL_SLEEP = 4;
    private static final int FDRIVE_CTRL_BUSY = 8;
    private static final int FDRIVE_CTRL_INTR = 16;
    private static final int FDRIVE_DIRECTION_WRITE = 0;
    private static final int FDRIVE_DIRECTION_READ = 1;
    private static final int FDRIVE_DIRECTION_SCANE = 2;
    private static final int FDRIVE_DIRECTION_SCANL = 3;
    private static final int FDRIVE_DIRECTION_SCANH = 4;
    private static final int FDRIVE_STATE_CMD = 0;
    private static final int FDRIVE_STATE_STATUS = 1;
    private static final int FDRIVE_STATE_DATA = 2;
    private static final int FDRIVE_STATE_STATE = 3;
    private static final int FDRIVE_STATE_MULTI = 16;
    private static final int FDRIVE_STATE_SEEK = 32;
    private static final int FDRIVE_STATE_FORMAT = 64;
    private byte version;
    private int irqLevel = 6;
    private int dmaChannel = 2;
    private int ioBase = 1008;
    private Timer resultTimer;
    private Clock clock;
    private byte state = 1;
    private boolean dmaEnabled;
    private byte currentDrive;
    private byte bootSelect;
    private byte[] fifo = new byte[512];
    private int dataOffset;
    private int dataLength;
    private byte dataState;
    private byte dataDirection;
    private byte intStatus;
    private byte eot;
    private byte timer0;
    private byte timer1;
    private byte preCompensationTrack;
    private byte config;
    private byte lock;
    private byte pwrd;
    FloppyDrive[] drives;
    InterruptController irqDevice;
    DMAController dma;
    private boolean ioportRegistered = false;

    public FloppyController() {
        this.version = (byte)-112;
        this.config = (byte)96;
        this.drives = new FloppyDrive[2];
    }

    public void timerCallback() {
        this.stopTransfer((byte)0, (byte)0, (byte)0);
    }

    public int getDriveType(int n) {
        return this.drives[n].drive;
    }

    public int[] ioPortsRequested() {
        return new int[]{this.ioBase + 1, this.ioBase + 2, this.ioBase + 3, this.ioBase + 4, this.ioBase + 5, this.ioBase + 7};
    }

    public int ioPortReadByte(int n) {
        switch (n & 7) {
            case 1: {
                return this.readStatusB();
            }
            case 2: {
                return this.readDOR();
            }
            case 3: {
                return this.readTape();
            }
            case 4: {
                return this.readMainStatus();
            }
            case 5: {
                return this.readData();
            }
            case 7: {
                return this.readDirection();
            }
        }
        return 255;
    }

    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) & 0xFF | this.ioPortReadByte(n + 1) << 8 & 0xFF00;
    }

    public int ioPortReadLong(int n) {
        return this.ioPortReadWord(n) & 0xFFFF | this.ioPortReadWord(n + 2) << 16 & 0xFFFF0000;
    }

    public void ioPortWriteByte(int n, int n2) {
        switch (n & 7) {
            case 2: {
                this.writeDOR(n2);
                break;
            }
            case 3: {
                this.writeTape(n2);
                break;
            }
            case 4: {
                this.writeRate(n2);
                break;
            }
            case 5: {
                this.writeData(n2);
                break;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2 & 0xFFFF);
        this.ioPortWriteWord(n + 2, n2 >>> 16 & 0xFFFF);
    }

    private void reset(boolean bl) {
        this.resetIRQ();
        this.currentDrive = 0;
        this.dataOffset = 0;
        this.dataLength = 0;
        this.dataState = 0;
        this.dataDirection = 0;
        for (int i = 0; i < 2; ++i) {
            this.drives[i].reset();
        }
        this.resetFIFO();
        if (bl) {
            this.raiseIRQ((byte)-64);
        }
    }

    private void raiseIRQ(byte by) {
        if (~(this.state & 0x10) != 0) {
            this.irqDevice.setIRQ(this.irqLevel, 1);
            this.state = (byte)(this.state | 0x10);
        }
        this.intStatus = by;
    }

    private void resetFIFO() {
        this.dataDirection = 0;
        this.dataOffset = 0;
        this.dataState = (byte)(this.dataState & 0xFFFFFFFC | 0);
    }

    private void resetIRQ() {
        this.irqDevice.setIRQ(this.irqLevel, 0);
        this.state = (byte)(this.state & 0xFFFFFFEF);
    }

    private int readStatusB() {
        return 0;
    }

    private int readDOR() {
        int n = 0;
        if ((this.getDrive((int)0).driveFlags & 1) != 0) {
            n |= 0x20;
        }
        if ((this.getDrive((int)1).driveFlags & 1) != 0) {
            n |= 0x10;
        }
        n |= this.dmaEnabled ? 8 : 0;
        n |= (this.state & 2) == 0 ? 4 : 0;
        return n |= this.currentDrive;
    }

    private int readTape() {
        return this.bootSelect << 2;
    }

    private int readMainStatus() {
        int n = 0;
        this.state = (byte)(this.state & 0xFFFFFFF9);
        if ((this.state & 8) == 0) {
            n |= 0x80;
            if (this.dataDirection == 1) {
                n |= 0x40;
            }
        }
        if ((this.dataState & 3) == 2 || (this.dataState & 3) == 1) {
            n |= 0x10;
        }
        return n;
    }

    private int readData() {
        FloppyDrive floppyDrive = this.getCurrentDrive();
        this.state = (byte)(this.state & 0xFFFFFFFB);
        if ((this.dataState & 3) == 0) {
            System.err.println("fdc >> can't read data in CMD state");
            return 0;
        }
        int n = this.dataOffset;
        if ((this.dataState & 3) == 2 && (n %= 512) == 0) {
            int n2 = this.dataLength - this.dataOffset;
            if (n2 > 512) {
                n2 = 512;
            }
            floppyDrive.read(floppyDrive.currentSector(), this.fifo, n2);
        }
        byte by = this.fifo[n];
        if (++this.dataOffset == this.dataLength) {
            this.dataOffset = 0;
            if ((this.dataState & 3) == 2) {
                this.stopTransfer((byte)32, (byte)0, (byte)0);
            } else {
                this.resetFIFO();
                this.resetIRQ();
            }
        }
        return by;
    }

    private int readDirection() {
        int n = 0;
        if ((this.getDrive((int)0).driveFlags & 2) != 0 || (this.getDrive((int)1).driveFlags & 2) != 0) {
            n |= 0x80;
        }
        this.getDrive((int)0).driveFlags &= 0xFFFFFFFD;
        this.getDrive((int)1).driveFlags &= 0xFFFFFFFD;
        return n;
    }

    private void writeDOR(int n) {
        if ((this.state & 2) != 0 && (n & 4) == 0) {
            return;
        }
        if ((n & 0x20) != 0) {
            this.getDrive(1).start();
        } else {
            this.getDrive(1).stop();
        }
        if ((n & 0x10) != 0) {
            this.getDrive(0).start();
        } else {
            this.getDrive(0).stop();
        }
        if ((n & 4) == 0) {
            if ((this.state & 2) == 0) {
                this.state = (byte)(this.state | 2);
            }
        } else if ((this.state & 2) != 0) {
            this.reset(true);
            this.state = (byte)(this.state & 0xFFFFFFF9);
        }
        this.currentDrive = (byte)(n & 1);
    }

    private void writeTape(int n) {
        if ((this.state & 2) != 0) {
            return;
        }
        this.bootSelect = (byte)(n >>> 2 & 1);
    }

    private void writeRate(int n) {
        if ((this.state & 2) != 0) {
            return;
        }
        if ((n & 0x80) != 0) {
            this.state = (byte)(this.state | 2);
            this.reset(true);
            this.state = (byte)(this.state & 0xFFFFFFFD);
        }
        if ((n & 0x40) != 0) {
            this.state = (byte)(this.state | 4);
            this.reset(true);
        }
    }

    private void writeData(int n) {
        FloppyDrive floppyDrive = this.getCurrentDrive();
        if ((this.state & 2) != 0) {
            System.err.println("fdc >> floppy controller in RESET state!");
            return;
        }
        this.state = (byte)(this.state & 0xFFFFFFFB);
        if ((this.dataState & 3) == 1) {
            System.err.println("fdc >> can't write data in status mode");
            return;
        }
        if ((this.dataState & 3) == 2) {
            this.fifo[this.dataOffset++] = (byte)n;
            if (this.dataOffset % 512 == 511 || this.dataOffset == this.dataLength) {
                floppyDrive.write(floppyDrive.currentSector(), this.fifo, 512);
            }
            if ((this.dataState & 3) == 2) {
                this.stopTransfer((byte)32, (byte)0, (byte)0);
            }
            return;
        }
        if (this.dataOffset == 0) {
            switch (n & 0x5F) {
                case 70: 
                case 76: 
                case 80: 
                case 86: 
                case 89: 
                case 93: {
                    this.dataLength = 9;
                    this.enqueue(n);
                    return;
                }
            }
            switch (n & 0x7F) {
                case 69: 
                case 73: {
                    this.dataLength = 9;
                    this.enqueue(n);
                    return;
                }
            }
            switch (n) {
                case 3: 
                case 15: {
                    this.dataLength = 3;
                    this.enqueue(n);
                    return;
                }
                case 4: 
                case 7: 
                case 18: 
                case 51: 
                case 74: {
                    this.dataLength = 2;
                    this.enqueue(n);
                    return;
                }
                case 8: {
                    this.fifo[0] = (byte)(0x20 | floppyDrive.head << 2 | this.currentDrive);
                    this.fifo[1] = floppyDrive.track;
                    this.setFIFO(2, false);
                    this.resetIRQ();
                    this.intStatus = (byte)-64;
                    return;
                }
                case 14: {
                    this.fifo[0] = this.getDrive((int)0).track;
                    this.fifo[1] = this.getDrive((int)1).track;
                    this.fifo[2] = 0;
                    this.fifo[3] = 0;
                    this.fifo[4] = this.timer0;
                    this.fifo[5] = this.dmaEnabled ? (byte)(this.timer1 << 1) : (byte)0;
                    this.fifo[6] = floppyDrive.lastSector;
                    this.fifo[7] = (byte)(this.lock << 7 | floppyDrive.perpendicular << 2);
                    this.fifo[8] = this.config;
                    this.fifo[9] = this.preCompensationTrack;
                    this.setFIFO(10, false);
                    return;
                }
                case 16: {
                    this.fifo[0] = this.version;
                    this.setFIFO(1, true);
                    return;
                }
                case 19: {
                    this.dataLength = 4;
                    this.enqueue(n);
                    return;
                }
                case 20: {
                    this.lock = 0;
                    this.fifo[0] = 0;
                    this.setFIFO(1, false);
                    return;
                }
                case 23: 
                case 143: 
                case 207: {
                    this.dataLength = 3;
                    this.enqueue(n);
                    return;
                }
                case 24: {
                    this.fifo[0] = 65;
                    this.setFIFO(1, false);
                    return;
                }
                case 44: {
                    this.fifo[0] = 0;
                    this.fifo[1] = 0;
                    this.fifo[2] = this.getDrive((int)0).track;
                    this.fifo[3] = this.getDrive((int)1).track;
                    this.fifo[4] = 0;
                    this.fifo[5] = 0;
                    this.fifo[6] = this.timer0;
                    this.fifo[7] = this.timer1;
                    this.fifo[8] = floppyDrive.lastSector;
                    this.fifo[9] = (byte)(this.lock << 7 | floppyDrive.perpendicular << 2);
                    this.fifo[10] = this.config;
                    this.fifo[11] = this.preCompensationTrack;
                    this.fifo[12] = this.pwrd;
                    this.fifo[13] = 0;
                    this.fifo[14] = 0;
                    this.setFIFO(15, true);
                    return;
                }
                case 66: {
                    this.dataLength = 9;
                    this.enqueue(n);
                    return;
                }
                case 76: {
                    this.dataLength = 18;
                    this.enqueue(n);
                    return;
                }
                case 77: 
                case 142: {
                    this.dataLength = 6;
                    this.enqueue(n);
                    return;
                }
                case 148: {
                    this.lock = 1;
                    this.fifo[0] = 16;
                    this.setFIFO(1, true);
                    return;
                }
                case 205: {
                    this.dataLength = 11;
                    this.enqueue(n);
                    return;
                }
            }
            this.unimplemented();
            return;
        }
        this.enqueue(n);
    }

    private void enqueue(int n) {
        FloppyDrive floppyDrive = null;
        this.fifo[this.dataOffset] = (byte)n;
        if (++this.dataOffset == this.dataLength) {
            if ((this.dataState & 0x40) != 0) {
                this.formatSector();
                return;
            }
            switch (this.fifo[0] & 0x1F) {
                case 6: {
                    this.startTransfer(1);
                    return;
                }
                case 12: {
                    this.startTransferDelete(1);
                    return;
                }
                case 22: {
                    this.stopTransfer((byte)32, (byte)0, (byte)0);
                    return;
                }
                case 16: {
                    this.startTransfer(2);
                    return;
                }
                case 25: {
                    this.startTransfer(3);
                    return;
                }
                case 29: {
                    this.startTransfer(4);
                    return;
                }
            }
            switch (this.fifo[0] & 0x3F) {
                case 5: {
                    this.startTransfer(0);
                    return;
                }
                case 9: {
                    this.startTransferDelete(0);
                    return;
                }
            }
            switch (this.fifo[0]) {
                case 3: {
                    this.timer0 = (byte)(this.fifo[1] >>> 4 & 0xF);
                    this.timer1 = (byte)(this.fifo[2] >>> 1);
                    this.dmaEnabled = (this.fifo[2] & 1) != 1;
                    this.resetFIFO();
                    break;
                }
                case 4: {
                    this.currentDrive = (byte)(this.fifo[1] & 1);
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.head = (byte)(this.fifo[1] >>> 2 & 1);
                    this.fifo[0] = (byte)(floppyDrive.readOnly << 6 | (floppyDrive.track == 0 ? 16 : 0) | floppyDrive.head << 2 | this.currentDrive | 0x28);
                    this.setFIFO(1, false);
                    break;
                }
                case 7: {
                    this.currentDrive = (byte)(this.fifo[1] & 1);
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.recalibrate();
                    this.resetFIFO();
                    this.raiseIRQ((byte)32);
                    break;
                }
                case 15: {
                    this.currentDrive = (byte)(this.fifo[1] & 1);
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.start();
                    floppyDrive.direction = this.fifo[2] <= floppyDrive.track ? (byte)1 : 0;
                    this.resetFIFO();
                    if (this.fifo[2] > floppyDrive.maxTrack) {
                        this.raiseIRQ((byte)96);
                        break;
                    }
                    floppyDrive.track = this.fifo[2];
                    this.raiseIRQ((byte)32);
                    break;
                }
                case 18: {
                    if ((this.fifo[1] & 0x80) != 0) {
                        floppyDrive.perpendicular = (byte)(this.fifo[1] & 7);
                    }
                    this.resetFIFO();
                    break;
                }
                case 19: {
                    this.config = this.fifo[2];
                    this.preCompensationTrack = this.fifo[3];
                    this.resetFIFO();
                    break;
                }
                case 23: {
                    this.pwrd = this.fifo[1];
                    this.fifo[0] = this.fifo[1];
                    this.setFIFO(1, true);
                    break;
                }
                case 51: {
                    this.resetFIFO();
                    break;
                }
                case 66: {
                    System.err.println("fdc >> treat READ_TRACK command");
                    this.startTransfer(1);
                    break;
                }
                case 74: {
                    floppyDrive.head = (byte)(this.fifo[1] >>> 2 & 1);
                    this.resultTimer.setExpiry(this.clock.getTime() + this.clock.getTickRate() / 50L);
                    break;
                }
                case 76: {
                    this.getDrive((int)0).track = this.fifo[3];
                    this.getDrive((int)1).track = this.fifo[4];
                    this.timer0 = this.fifo[7];
                    this.timer1 = this.fifo[8];
                    floppyDrive.lastSector = this.fifo[9];
                    this.lock = (byte)(this.fifo[10] >>> 7);
                    floppyDrive.perpendicular = (byte)(this.fifo[10] >>> 2 & 0xF);
                    this.config = this.fifo[11];
                    this.preCompensationTrack = this.fifo[12];
                    this.pwrd = this.fifo[13];
                    this.resetFIFO();
                    break;
                }
                case 77: {
                    this.currentDrive = (byte)(this.fifo[1] & 1);
                    floppyDrive = this.getCurrentDrive();
                    this.dataState = (byte)(this.dataState | 0x40);
                    this.dataState = (this.fifo[0] & 0x80) != 0 ? (byte)(this.dataState | 0x10) : (byte)(this.dataState & 0xFFFFFFEF);
                    this.dataState = (byte)(this.dataState & 0xFFFFFFDF);
                    floppyDrive.bps = (short)(this.fifo[2] > 7 ? 16384 : (short)(128 << this.fifo[2]));
                    floppyDrive.lastSector = this.fifo[3];
                    this.dataState = (byte)(this.dataState & 0xFFFFFFBF);
                    this.stopTransfer((byte)0, (byte)0, (byte)0);
                    break;
                }
                case -114: {
                    if ((this.fifo[this.dataOffset - 1] & 0x80) != 0) {
                        if ((this.fifo[this.dataOffset - 1] & 0x40) != 0) {
                            this.fifo[0] = this.fifo[1];
                            this.fifo[2] = 0;
                            this.fifo[3] = 0;
                            this.setFIFO(4, true);
                            break;
                        }
                        this.resetFIFO();
                        break;
                    }
                    if (this.dataLength <= 7) break;
                    this.fifo[0] = (byte)(0x80 | floppyDrive.head << 2 | this.currentDrive);
                    this.setFIFO(1, true);
                    break;
                }
                case -113: {
                    this.currentDrive = (byte)(this.fifo[1] & 1);
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.start();
                    floppyDrive.direction = 0;
                    floppyDrive.track = this.fifo[2] + floppyDrive.track >= floppyDrive.maxTrack ? (byte)(floppyDrive.maxTrack - 1) : (byte)(floppyDrive.track + this.fifo[2]);
                    this.resetFIFO();
                    this.raiseIRQ((byte)32);
                    break;
                }
                case -51: {
                    System.err.println("fdc >> treat FORMAT_AND_WRITE command");
                    this.unimplemented();
                    break;
                }
                case -49: {
                    this.currentDrive = (byte)(this.fifo[1] & 1);
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.start();
                    floppyDrive.direction = 1;
                    floppyDrive.track = this.fifo[2] > floppyDrive.track ? (byte)0 : (byte)(floppyDrive.track - this.fifo[2]);
                    this.resetFIFO();
                    this.raiseIRQ((byte)32);
                }
            }
        }
    }

    private void setFIFO(int n, boolean bl) {
        this.dataDirection = 1;
        this.dataLength = n;
        this.dataOffset = 0;
        this.dataState = (byte)(this.dataState & 0xFFFFFFFC | 1);
        if (bl) {
            this.raiseIRQ((byte)0);
        }
    }

    private FloppyDrive getCurrentDrive() {
        return this.getDrive(this.currentDrive);
    }

    private FloppyDrive getDrive(int n) {
        return this.drives[n - this.bootSelect];
    }

    private void unimplemented() {
        this.fifo[0] = -128;
        this.setFIFO(1, false);
    }

    private void startTransfer(int n) {
        int n2;
        this.currentDrive = (byte)(this.fifo[1] & 1);
        FloppyDrive floppyDrive = this.getCurrentDrive();
        byte by = this.fifo[2];
        byte by2 = this.fifo[3];
        byte by3 = this.fifo[4];
        boolean bl = false;
        switch (floppyDrive.seek(by2, by, by3, floppyDrive.lastSector)) {
            case 2: {
                this.stopTransfer((byte)64, (byte)0, (byte)0);
                this.fifo[3] = by;
                this.fifo[4] = by2;
                this.fifo[5] = by3;
                return;
            }
            case 3: {
                this.stopTransfer((byte)64, (byte)-128, (byte)0);
                this.fifo[3] = by;
                this.fifo[4] = by2;
                this.fifo[5] = by3;
                return;
            }
            case 4: {
                this.stopTransfer((byte)64, (byte)0, (byte)0);
                this.fifo[3] = by;
                this.fifo[4] = by2;
                this.fifo[5] = by3;
                return;
            }
            case 1: {
                bl = true;
                break;
            }
        }
        this.dataDirection = (byte)n;
        this.dataOffset = 0;
        this.dataState = (byte)(this.dataState & 0xFFFFFFFC | 2);
        this.dataState = (this.fifo[0] & 0x80) != 0 ? (byte)(this.dataState | 0x10) : (byte)(this.dataState & 0xFFFFFFEF);
        this.dataState = bl ? (byte)(this.dataState | 0x20) : (byte)(this.dataState & 0xFFFFFFDF);
        if (this.fifo[5] == 0) {
            this.dataLength = this.fifo[8];
        } else {
            this.dataLength = 128 << this.fifo[5];
            n2 = floppyDrive.lastSector - by3 + 1;
            if ((this.fifo[0] & 0x80) != 0) {
                n2 += floppyDrive.lastSector;
            }
            this.dataLength *= n2;
        }
        this.eot = this.fifo[6];
        if (this.dmaEnabled) {
            n2 = 0;
            n2 = this.dma.getChannelMode(this.dmaChannel & 3);
            n2 = n2 >>> 2 & 3;
            if ((n == 2 || n == 3 || n == 4) && n2 == 0 || n == 0 && n2 == 2 || n == 1 && n2 == 1) {
                this.state = (byte)(this.state | 8);
                this.dma.holdDREQ(this.dmaChannel & 3);
                return;
            }
            System.err.println("fdc >> dma_mode=" + n2 + " direction=" + n);
        }
        this.raiseIRQ((byte)0);
    }

    private void stopTransfer(byte by, byte by2, byte by3) {
        FloppyDrive floppyDrive = this.getCurrentDrive();
        this.fifo[0] = (byte)(by | floppyDrive.head << 2 | this.currentDrive);
        this.fifo[1] = by2;
        this.fifo[2] = by3;
        this.fifo[3] = floppyDrive.track;
        this.fifo[4] = floppyDrive.head;
        this.fifo[5] = floppyDrive.sector;
        this.fifo[6] = 2;
        this.dataDirection = 1;
        if ((this.state & 8) != 0) {
            this.dma.releaseDREQ(this.dmaChannel & 3);
            this.state = (byte)(this.state & 0xFFFFFFF7);
        }
        this.setFIFO(7, true);
    }

    private void startTransferDelete(int n) {
        this.stopTransfer((byte)96, (byte)0, (byte)0);
    }

    private void formatSector() {
        System.err.println("Cannot Format Sector");
    }

    private int memcmp(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] - byArray2[i + n] == 0) continue;
            return byArray[i] - byArray2[i + n];
        }
        return 0;
    }

    public int transferHandler(int n, int n2, int n3) {
        int n4;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        if ((this.state & 8) == 0) {
            return 0;
        }
        FloppyDrive floppyDrive = this.getCurrentDrive();
        if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
            by3 = 4;
        }
        if (n3 > this.dataLength) {
            n3 = this.dataLength;
        }
        if (floppyDrive.device == null) {
            if (this.dataDirection == 0) {
                this.stopTransfer((byte)96, (byte)0, (byte)0);
            } else {
                this.stopTransfer((byte)64, (byte)0, (byte)0);
            }
            return 0;
        }
        int n5 = this.dataOffset % 512;
        int n6 = this.dataOffset;
        while (this.dataOffset < n3) {
            n4 = n3 - this.dataOffset;
            if (n4 + n5 > 512) {
                n4 = 512 - n5;
            }
            if ((this.dataDirection != 0 || n4 < 512 || n5 != 0) && floppyDrive.read(floppyDrive.currentSector(), this.fifo, 1) < 0) {
                for (int i = 0; i < Math.min(this.fifo.length, 512); ++i) {
                    this.fifo[i] = 0;
                }
            }
            switch (this.dataDirection) {
                case 1: {
                    this.dma.writeMemory(n, this.fifo, n5, this.dataOffset, n4);
                    break;
                }
                case 0: {
                    this.dma.readMemory(n, this.fifo, n5, this.dataOffset, n4);
                    if (floppyDrive.write(floppyDrive.currentSector(), this.fifo, 1) >= 0) break;
                    this.stopTransfer((byte)96, (byte)0, (byte)0);
                    return n4;
                }
                default: {
                    byte[] byArray = new byte[512];
                    this.dma.readMemory(n, byArray, 0, this.dataOffset, n4);
                    int n7 = this.memcmp(byArray, this.fifo, n5, n4);
                    if (n7 == 0) {
                        by3 = 8;
                        n4 = this.dataOffset - n6;
                        if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
                            by3 = 8;
                        }
                        if ((this.dataState & 0x20) != 0) {
                            by = (byte)(by | 0x20);
                        }
                        this.dataLength -= n4;
                        this.stopTransfer(by, by2, by3);
                        return n4;
                    }
                    if ((n7 >= 0 || this.dataDirection != 3) && (n7 <= 0 || this.dataDirection != 4)) break;
                    by3 = 0;
                    n4 = this.dataOffset - n6;
                    if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
                        by3 = 8;
                    }
                    if ((this.dataState & 0x20) != 0) {
                        by = (byte)(by | 0x20);
                    }
                    this.dataLength -= n4;
                    this.stopTransfer(by, by2, by3);
                    return n4;
                }
            }
            this.dataOffset += n4;
            n5 = this.dataOffset % 512;
            if (n5 != 0) continue;
            if (floppyDrive.sector >= floppyDrive.lastSector || floppyDrive.sector == this.eot) {
                floppyDrive.sector = 1;
                if ((this.dataState & 0x10) != 0) {
                    if (floppyDrive.head == 0 && (floppyDrive.flags & 1) != 0) {
                        floppyDrive.head = 1;
                        continue;
                    }
                    floppyDrive.head = 0;
                    floppyDrive.track = (byte)(floppyDrive.track + 1);
                    if ((floppyDrive.flags & 1) != 0) continue;
                    break;
                }
                floppyDrive.track = (byte)(floppyDrive.track + 1);
                break;
            }
            floppyDrive.sector = (byte)(floppyDrive.sector + 1);
        }
        n4 = this.dataOffset - n6;
        if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
            by3 = 8;
        }
        if ((this.dataState & 0x20) != 0) {
            by = (byte)(by | 0x20);
        }
        this.dataLength -= n4;
        this.stopTransfer(by, by2, by3);
        return n4;
    }

    public void reset() {
        this.irqDevice = null;
        this.clock = null;
        this.resultTimer = null;
        this.dma = null;
        this.ioportRegistered = false;
        this.fifo = new byte[512];
        this.config = (byte)96;
        this.drives = new FloppyDrive[2];
        this.state = 1;
    }

    public boolean initialised() {
        return this.irqDevice != null && this.clock != null && this.dma != null && this.drives[0] != null && this.ioportRegistered;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        int n;
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
            this.resultTimer = this.clock.newTimer(this);
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof DMAController && hardwareComponent.initialised() && ((DMAController)hardwareComponent).isFirst() && this.dmaChannel != -1) {
            this.dma = (DMAController)hardwareComponent;
            this.dmaEnabled = true;
            this.dma.registerChannel(this.dmaChannel & 3, this);
        }
        if (hardwareComponent instanceof DriveSet && hardwareComponent.initialised()) {
            for (n = 0; n < 2; ++n) {
                this.drives[n] = new FloppyDrive(((DriveSet)hardwareComponent).getFloppyDrive(n));
            }
        }
        if (this.initialised()) {
            this.reset(false);
            for (n = 0; n < 2; ++n) {
                if (this.drives[n] == null) continue;
                this.drives[n].revalidate();
            }
        }
    }

    public String toString() {
        return "Intel 82078 Floppy Controller [" + this.drives[0].toString() + ", " + this.drives[1].toString() + "]";
    }

    class FloppyDrive {
        BlockDevice device;
        int drive;
        int driveFlags;
        byte perpendicular;
        byte head;
        byte track;
        byte sector;
        byte direction;
        byte readWrite;
        int flags;
        byte lastSector;
        byte maxTrack;
        short bps;
        byte readOnly;
        FloppyFormat format;

        public FloppyDrive(BlockDevice blockDevice) {
            this.device = blockDevice;
            this.drive = 3;
            this.driveFlags = 0;
            this.perpendicular = 0;
            this.lastSector = 0;
            this.maxTrack = 0;
        }

        public void start() {
            this.driveFlags |= 1;
        }

        public void stop() {
            this.driveFlags &= 0xFFFFFFFE;
        }

        public int seek(byte by, byte by2, byte by3, int n) {
            if (by2 > this.maxTrack || by != 0 && (this.flags & 1) == 0) {
                return 2;
            }
            if (by3 > this.lastSector) {
                return 3;
            }
            int n2 = this.calculateSector(by, by2, by3, this.lastSector);
            int n3 = 0;
            if (n2 != this.currentSector()) {
                if (n == 0) {
                    return 4;
                }
                this.head = by;
                if (this.track != by2) {
                    n3 = 1;
                }
                this.track = by2;
                this.sector = by3;
            }
            return n3;
        }

        public int currentSector() {
            return this.calculateSector(this.head, this.track, this.sector, this.lastSector);
        }

        private int calculateSector(byte by, byte by2, byte by3, byte by4) {
            return ((0xFF & by2) * 2 + (0xFF & by)) * (0xFF & by4) + (0xFF & by3) - 1;
        }

        public void recalibrate() {
            this.head = 0;
            this.track = 0;
            this.sector = 1;
            this.direction = 1;
            this.readWrite = 0;
        }

        public int read(int n, byte[] byArray, int n2) {
            return this.device.read(0xFFFFFFFFL & (long)n, byArray, n2);
        }

        public int write(int n, byte[] byArray, int n2) {
            return this.device.write(0xFFFFFFFFL & (long)n, byArray, n2);
        }

        public void reset() {
            this.stop();
            this.recalibrate();
        }

        public void revalidate() {
            this.driveFlags &= 0xFFFFFFFD;
            if (this.device != null && this.device.inserted()) {
                this.format = FloppyFormat.findFormat(this.device.getTotalSectors(), this.drive);
                this.flags = this.format.heads() == 1 ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
                this.maxTrack = (byte)this.format.tracks();
                this.lastSector = (byte)this.format.sectors();
                this.readOnly = this.device.readOnly() ? (byte)1 : 0;
                this.drive = this.format.drive();
            } else {
                this.lastSector = 0;
                this.maxTrack = 0;
                this.flags &= 0xFFFFFFFE;
            }
            this.driveFlags |= 2;
        }

        public String toString() {
            return this.device == null ? "<none>" : this.format.toString();
        }
    }
}

