/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor.fpu64;

import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.fpu64.FpuState;

public class FpuState64
extends FpuState {
    public static final int FPU_SPECIAL_TAG_NONE = 0;
    public static final int FPU_SPECIAL_TAG_NAN = 1;
    public static final int FPU_SPECIAL_TAG_UNSUPPORTED = 2;
    public static final int FPU_SPECIAL_TAG_INFINITY = 3;
    public static final int FPU_SPECIAL_TAG_DENORMAL = 4;
    public static final int FPU_SPECIAL_TAG_SNAN = 5;
    public static final double UNDERFLOW_THRESHOLD;
    private final Processor cpu;
    double[] data;
    int[] tag;
    int[] specialTag;
    private int statusWord;
    private boolean invalidOperation;
    private boolean denormalizedOperand;
    private boolean zeroDivide;
    private boolean overflow;
    private boolean underflow;
    private boolean precision;
    private boolean stackFault;
    private int maskWord;
    private int precisionControl;
    private int roundingControl;

    public boolean getInvalidOperation() {
        return (this.statusWord & 1) != 0;
    }

    public boolean getDenormalizedOperand() {
        return (this.statusWord & 2) != 0;
    }

    public boolean getZeroDivide() {
        return (this.statusWord & 4) != 0;
    }

    public boolean getOverflow() {
        return (this.statusWord & 8) != 0;
    }

    public boolean getUnderflow() {
        return (this.statusWord & 0x10) != 0;
    }

    public boolean getPrecision() {
        return (this.statusWord & 0x20) != 0;
    }

    public boolean getStackFault() {
        return (this.statusWord & 0x40) != 0;
    }

    public void setInvalidOperation() {
        this.statusWord |= 1;
    }

    public void setDenormalizedOperand() {
        this.statusWord |= 2;
    }

    public void setZeroDivide() {
        this.statusWord |= 4;
    }

    public void setOverflow() {
        this.statusWord |= 8;
    }

    public void setUnderflow() {
        this.statusWord |= 0x10;
    }

    public void setPrecision() {
        this.statusWord |= 0x20;
    }

    public void setStackFault() {
        this.statusWord |= 0x40;
    }

    public boolean getBusy() {
        return this.getErrorSummaryStatus();
    }

    public boolean getErrorSummaryStatus() {
        return (this.statusWord & 0x3F & ~this.maskWord) != 0;
    }

    public void checkExceptions() throws ProcessorException {
        if (this.getErrorSummaryStatus()) {
            this.cpu.reportFPUException();
        }
    }

    public void clearExceptions() {
        this.statusWord = 0;
    }

    public boolean getInvalidOperationMask() {
        return (this.maskWord & 1) != 0;
    }

    public boolean getDenormalizedOperandMask() {
        return (this.maskWord & 2) != 0;
    }

    public boolean getZeroDivideMask() {
        return (this.maskWord & 4) != 0;
    }

    public boolean getOverflowMask() {
        return (this.maskWord & 8) != 0;
    }

    public boolean getUnderflowMask() {
        return (this.maskWord & 0x10) != 0;
    }

    public boolean getPrecisionMask() {
        return (this.maskWord & 0x20) != 0;
    }

    public int getPrecisionControl() {
        return this.precisionControl;
    }

    public int getRoundingControl() {
        return this.roundingControl;
    }

    public void setInvalidOperationMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 1) : (this.maskWord &= 0xFFFFFFFE);
    }

    public void setDenormalizedOperandMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 2) : (this.maskWord &= 0xFFFFFFFD);
    }

    public void setZeroDivideMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 4) : (this.maskWord &= 0xFFFFFFFB);
    }

    public void setOverflowMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 8) : (this.maskWord &= 0xFFFFFFF7);
    }

    public void setUnderflowMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x10) : (this.maskWord &= 0xFFFFFFEF);
    }

    public void setPrecisionMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x20) : (this.maskWord &= 0xFFFFFFDF);
    }

    public void setAllMasks(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x3F) : 0;
    }

    public void setPrecisionControl(int n) {
        if (n != 2) {
            System.err.println("WARNING:  attempt to set non-double FP precision in Fpu64 mode");
        }
        this.precisionControl = 2;
    }

    public void setRoundingControl(int n) {
        if (n != 0) {
            System.err.println("WARNING:  attempt to set non-nearest rounding in Fpu64 mode");
        }
        this.roundingControl = 0;
    }

    public FpuState64(Processor processor) {
        this.cpu = processor;
        this.data = new double[8];
        this.tag = new int[8];
        this.specialTag = new int[8];
        this.init();
    }

    public void init() {
        int n;
        for (n = 0; n < 8; ++n) {
            this.tag[n] = 3;
        }
        for (n = 0; n < 8; ++n) {
            this.specialTag[n] = 0;
        }
        this.clearExceptions();
        this.conditionCode = 0;
        this.top = 0;
        this.setAllMasks(true);
        this.infinityControl = false;
        this.setPrecisionControl(2);
        this.setRoundingControl(0);
        this.lastOpcode = 0;
        this.lastIP = this.lastData = (long)0;
    }

    public int tagCode(double d) {
        if (d == 0.0) {
            return 1;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return 2;
        }
        return 0;
    }

    public static boolean isDenormal(double d) {
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 52 & 0x7FFL);
        if (n != 0) {
            return false;
        }
        long l2 = l & 0xFFFFFFFFFFFFFL;
        return l2 != 0L;
    }

    public static boolean isSNaN(long l) {
        int n = (int)(l >> 52 & 0x7FFL);
        if (n != 2047) {
            return false;
        }
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if ((l2 & 0x8000000000000L) != 0L) {
            return false;
        }
        return l2 != 0L;
    }

    public static int specialTagCode(double d) {
        if (Double.isNaN(d)) {
            return 1;
        }
        if (Double.isInfinite(d)) {
            return 3;
        }
        if (FpuState64.isDenormal(d)) {
            return 4;
        }
        return 0;
    }

    public void push(double d) throws ProcessorException {
        if (--this.top < 0) {
            this.top = 7;
        }
        if (this.tag[this.top] != 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode |= 2;
            this.checkExceptions();
        }
        this.data[this.top] = d;
        this.tag[this.top] = this.tagCode(d);
        this.specialTag[this.top] = FpuState64.specialTagCode(d);
    }

    public double pop() throws ProcessorException {
        if (this.tag[this.top] == 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode &= 0xFFFFFFFD;
            this.checkExceptions();
        } else if (this.specialTag[this.top] == 5) {
            this.setInvalidOperation();
            this.checkExceptions();
            return Double.NaN;
        }
        double d = this.data[this.top];
        this.tag[this.top] = 3;
        if (++this.top >= 8) {
            this.top = 0;
        }
        return d;
    }

    public double ST(int n) throws ProcessorException {
        int n2 = this.top + n & 7;
        if (this.tag[n2] == 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode &= 0xFFFFFFFD;
            this.checkExceptions();
        } else if (this.specialTag[n2] == 5) {
            this.setInvalidOperation();
            this.checkExceptions();
            return Double.NaN;
        }
        return this.data[n2];
    }

    public int getTag(int n) {
        int n2 = this.top + n & 7;
        return this.tag[n2];
    }

    public int getSpecialTag(int n) {
        int n2 = this.top + n & 7;
        return this.specialTag[n2];
    }

    public void setST(int n, double d) {
        int n2 = this.top + n & 7;
        this.data[n2] = d;
        this.tag[n2] = this.tagCode(d);
        this.specialTag[n2] = FpuState64.specialTagCode(d);
    }

    public int getStatus() {
        int n = this.statusWord;
        if (this.getErrorSummaryStatus()) {
            n |= 0x80;
        }
        if (this.getBusy()) {
            n |= 0x8000;
        }
        n |= this.top << 11;
        n |= (this.conditionCode & 7) << 8;
        return n |= (this.conditionCode & 8) << 11;
    }

    public void setStatus(int n) {
        this.statusWord &= 0xFFFFFF80;
        this.statusWord |= n & 0x7F;
        this.top = n >> 11 & 7;
        this.conditionCode = n >> 8 & 7;
        this.conditionCode |= n >>> 14 & 1;
    }

    public int getControl() {
        int n = this.maskWord;
        n |= (this.precisionControl & 3) << 8;
        n |= (this.roundingControl & 3) << 10;
        if (this.infinityControl) {
            n |= 0x1000;
        }
        return n;
    }

    public void setControl(int n) {
        this.maskWord &= 0xFFFFFFC0;
        this.maskWord |= n & 0x3F;
        this.infinityControl = (n & 0x1000) != 0;
        this.setPrecisionControl(n >> 8 & 3);
        this.setRoundingControl(n >> 10 & 3);
    }

    public int getTagWord() {
        int n = 0;
        for (int i = 7; i >= 0; --i) {
            n = n << 2 | this.tag[i] & 3;
        }
        return n;
    }

    public void setTagWord(int n) {
        for (int i = 0; i < 8; ++i) {
            int n2 = n & 3;
            if (n2 == 3) {
                this.tag[i] = 3;
            } else {
                this.tag[i] = this.tagCode(this.data[i]);
                if (this.specialTag[i] != 5) {
                    this.specialTag[i] = FpuState64.specialTagCode(this.data[i]);
                }
            }
            n >>= 2;
        }
    }

    public static byte[] doubleToExtended(double d, boolean bl) {
        byte[] byArray = new byte[10];
        long l = 0L;
        int n = 0;
        if (bl) {
            l = -4611686018427387904L;
        } else {
            long l2 = Double.doubleToLongBits(d);
            l = l2 & 0xFFFFFL;
            n = (int)(l2 >> 52) & 0x7FF;
            boolean bl2 = (l2 & Integer.MIN_VALUE) != 0L;
            l |= 0x100000L;
            l <<= 11;
            n += 15360;
            if (bl2) {
                n |= 0x8000;
            }
        }
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        byArray[8] = (byte)n;
        byArray[9] = (byte)(n >>> 8);
        return byArray;
    }

    public static int specialTagCode(byte[] byArray) {
        boolean bl;
        int n;
        long l = 0L;
        for (n = 7; n >= 0; --n) {
            long l2 = (long)byArray[n] & 0xFFL;
            l |= l2;
            l <<= 8;
        }
        n = byArray[8] & 0xFF | (byArray[9] & 0x7F) << 8;
        boolean bl2 = (byArray[9] & 0x80) != 0;
        boolean bl3 = bl = (byArray[7] & 0x80) != 0;
        if (n == 0) {
            if (bl) {
                return 4;
            }
            return 4;
        }
        if (n == Short.MAX_VALUE) {
            if (l == 0L) {
                return 2;
            }
            if (bl) {
                if (l << 1 == 0L) {
                    return 3;
                }
                if (l >>> 62 == 0L) {
                    return 5;
                }
                return 1;
            }
            return 2;
        }
        if (bl) {
            return 0;
        }
        return 2;
    }

    public static double extendedToDouble(byte[] byArray) {
        boolean bl;
        int n;
        long l = 0L;
        for (n = 7; n >= 0; --n) {
            long l2 = (long)byArray[n] & 0xFFL;
            l |= l2;
            l <<= 8;
        }
        n = byArray[8] & 0xFF | (byArray[9] & 0x7F) << 8;
        boolean bl2 = (byArray[9] & 0x80) != 0;
        boolean bl3 = bl = (byArray[7] & 0x80) != 0;
        if (n == 0) {
            if (bl) {
                n = 1;
            }
            return 0.0;
        }
        if (n == Short.MAX_VALUE) {
            if (l == 0L) {
                return Double.NaN;
            }
            if (bl) {
                if (l << 1 == 0L) {
                    return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                return Double.NaN;
            }
            return Double.NaN;
        }
        if (bl) {
            l >>>= 11;
            if ((n -= 15360) > 2047) {
                return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (n < 0) {
                l >>>= -n;
                n = 0;
            }
            l &= 0xFFFFFFFFFFFFFL;
            l |= ((long)n & 0x7FFL) << 52;
            if (bl2) {
                l |= Integer.MIN_VALUE;
            }
            return Double.longBitsToDouble(l);
        }
        return Double.NaN;
    }

    static {
        double d = 1.0;
        for (int i = 0; i < 1022; ++i) {
            d /= 2.0;
        }
        UNDERFLOW_THRESHOLD = d;
    }
}

