/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.j2se;

import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.j2se.PriorityVector;
import org.jpc.support.Clock;

public class VirtualClock
extends AbstractHardwareComponent
implements Clock {
    private PriorityVector timers = new PriorityVector(20);
    private Timer[] timerArray;
    private boolean ticksEnabled = false;
    private long ticksOffset = 0L;
    private long ticksStatic = 0L;
    private long tickRate = 0L;

    public Timer newTimer(TimerResponsive timerResponsive) {
        Timer timer = new Timer(timerResponsive, this);
        this.timers.addComparableObject(timer);
        return timer;
    }

    public void process() {
        Timer timer;
        while ((timer = (Timer)this.timers.firstElement()) != null && timer.check(this.getTime())) {
            this.timers.removeFirstElement();
            timer.setStatus(false);
            timer.runCallback();
        }
    }

    public void update(Timer timer) {
        this.timers.removeElement(timer);
        this.timers.addComparableObject(timer);
    }

    public long getTime() {
        if (this.ticksEnabled) {
            return this.getRealTime() + this.ticksOffset;
        }
        return this.ticksStatic;
    }

    private long getRealTime() {
        return System.currentTimeMillis() * 1000000L;
    }

    public long getTickRate() {
        if (this.tickRate != 0L) {
            return this.tickRate;
        }
        long l = System.currentTimeMillis();
        long l2 = this.getRealTime();
        do {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        } while ((l = System.currentTimeMillis() - l) < 450L);
        l2 = this.getRealTime() - l2;
        this.tickRate = 1000L * ((l2 + (l >>> 1)) / l);
        return this.tickRate;
    }

    public void pause() {
        if (this.ticksEnabled) {
            this.ticksStatic = this.getTime();
            this.ticksEnabled = false;
        }
    }

    public void resume() {
        if (!this.ticksEnabled) {
            this.ticksOffset = this.ticksStatic - this.getRealTime();
            this.ticksEnabled = true;
        }
    }

    public void reset() {
        this.pause();
        this.tickRate = 0L;
        this.ticksOffset = 0L;
        this.ticksStatic = 0L;
    }

    public String toString() {
        return "Virtual Clock";
    }
}

