/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import org.jpc.support.RawBlockDevice;
import org.jpc.support.SeekableIODevice;

public class CDROMBlockDevice
extends RawBlockDevice {
    private static final String formatName = "cdrom";
    private boolean locked;

    public CDROMBlockDevice(SeekableIODevice seekableIODevice) {
        this.data = seekableIODevice;
        this.cylinders = 2;
        this.heads = 16;
        this.sectors = 63;
        this.totalSectors = seekableIODevice.length() / 512;
    }

    public CDROMBlockDevice() {
        this.data = null;
        this.cylinders = 2;
        this.heads = 16;
        this.sectors = 63;
    }

    public void close() {
        System.out.println("Trying To Close CDROM");
        this.eject();
    }

    public boolean locked() {
        return this.locked;
    }

    public boolean readOnly() {
        return true;
    }

    public void setLock(boolean bl) {
        this.locked = bl;
    }

    public boolean insert(SeekableIODevice seekableIODevice) {
        if (this.locked) {
            return false;
        }
        if (this.inserted()) {
            this.eject();
        }
        this.totalSectors = seekableIODevice.length() / 512;
        return true;
    }

    public boolean eject() {
        if (this.locked) {
            return false;
        }
        this.data = null;
        return true;
    }

    public int type() {
        return 1;
    }

    public String getImageFileName() {
        return this.data.toString();
    }
}

