/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.jpc.support.GraphicsDisplay;

public class PCScreen
extends Canvas
implements GraphicsDisplay {
    private int[] buffer;
    private int[] screenBuffer;
    private int width;
    private int height;
    private int xOffset;
    private int yOffset;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private long instructions = 0L;
    private String diagnostic;
    private int dispWidth;
    private int dispHeight;
    private Image[] spinner = new Image[36];
    private Image progressImage;
    private int spinnerIndex;
    private boolean fitToScreen = true;
    private PCThread pcThread;

    public PCScreen() {
        this.setFullScreenMode(true);
        for (int i = 0; i < this.spinner.length; ++i) {
            try {
                this.spinner[i] = Image.createImage((String)("/spinner/frame" + (i + 1) + ".png"));
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error loading spinner image " + (i + 1));
            }
        }
        this.dispWidth = this.getWidth();
        this.dispHeight = this.getHeight();
        this.spinnerIndex = 0;
        this.progressImage = this.spinner[this.spinnerIndex];
        this.screenBuffer = new int[this.dispWidth * this.dispHeight];
        this.showSplashScreen();
    }

    public void start() {
        this.pcThread = new PCThread(this);
        this.pcThread.start();
    }

    public void stop() {
        this.pcThread.stopPC();
    }

    private void showSplashScreen() {
        try {
            Image image = Image.createImage((int)this.dispWidth, (int)this.dispHeight);
            Graphics graphics = image.getGraphics();
            Image image2 = Image.createImage((InputStream)this.getClass().getResourceAsStream("JPCSmall.png"));
            graphics.drawImage(image2, this.dispWidth / 2, this.dispHeight / 2, 3);
            graphics.drawString("Loading JPC...", this.dispWidth / 2, this.dispHeight / 2 + image2.getHeight(), 17);
            image.getRGB(this.screenBuffer, 0, this.dispWidth, 0, 0, this.dispWidth, this.dispHeight);
        }
        catch (Throwable throwable) {
            this.setDiagnostic("Splash screen failed: " + throwable);
            System.out.println("Warning: Splash Image construction failed");
            throwable.printStackTrace();
        }
        this.resizeDisplay(this.dispWidth, this.dispHeight);
        this.repaint();
    }

    public void setDiagnostic(String string) {
        System.err.println(string);
        if (string == null) {
            string = "";
        }
        this.diagnostic = string;
        this.repaint();
    }

    public void setInstructionCount(long l) {
        if (++this.spinnerIndex == this.spinner.length) {
            this.spinnerIndex = 0;
        }
        this.progressImage = this.spinner[this.spinnerIndex];
        this.repaint();
    }

    public void resizeDisplay(int n, int n2) {
        this.yOffset = 0;
        this.xOffset = 0;
        this.width = n;
        this.height = n2;
        this.buffer = new int[n * n2];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = -16777216;
        }
    }

    public int[] getDisplayBuffer() {
        return this.buffer;
    }

    public void prepareUpdate() {
        this.xmin = this.width;
        this.xmax = 0;
        this.ymin = this.height;
        this.ymax = 0;
    }

    public int rgbToPixel(int n, int n2, int n3) {
        return 0xFF000000 | (0xFF & n) << 16 | (0xFF & n2) << 8 | 0xFF & n3;
    }

    public void dirtyDisplayRegion(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n5 = Math.max(this.xOffset, n);
        int n6 = Math.max(this.yOffset, n2);
        int n7 = Math.min(n + n3, this.xOffset + this.width);
        int n8 = Math.min(n2 + n4, this.yOffset + this.height);
        if (n7 <= n5 || n8 <= n6) {
            return;
        }
        this.xmin = Math.min(n5, this.xmin);
        this.xmax = Math.max(n7, this.xmax);
        this.ymin = Math.min(n6, this.ymin);
        this.ymax = Math.max(n8, this.ymax);
    }

    public void blitUpdatesToScreen() {
        if (this.xmax == 0 && this.xmin == this.width) {
            return;
        }
        if (this.fitToScreen) {
            this.scaleRegion(this.xmin, this.ymin, this.xmax + 1, this.ymax + 1);
        } else {
            int n = Math.max(0, this.xmin - this.xOffset);
            int n2 = Math.max(0, this.ymin - this.yOffset);
            int n3 = Math.max(this.dispWidth, this.xmax - this.xOffset + 1);
            int n4 = Math.max(this.dispHeight, this.ymax - this.yOffset + 1);
            this.repaint(n, n2, n3 - n, n4 - n2);
            this.serviceRepaints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scaleRegion(int n, int n2, int n3, int n4) {
        float f = (float)this.height / (float)this.dispHeight;
        float f2 = (float)this.width / (float)this.dispWidth;
        int n5 = (int)((float)n / f2);
        int n6 = (int)((float)n2 / f);
        int n7 = Math.min(this.dispWidth, (int)((float)n3 / f2));
        int n8 = Math.min(this.dispHeight, (int)((float)n4 / f));
        int[] nArray = this.screenBuffer;
        synchronized (this.screenBuffer) {
            for (int i = n6; i < n8; ++i) {
                for (int j = n5; j < n7; ++j) {
                    this.screenBuffer[i * this.dispWidth + j] = this.buffer[(int)((float)i * f) * this.width + (int)((float)j * f2)];
                }
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.dispWidth != this.getWidth() || this.dispHeight != this.getHeight()) {
            this.dispWidth = this.getWidth();
            this.dispHeight = this.getHeight();
            if (this.fitToScreen) {
                int[] nArray = this.screenBuffer;
                // MONITORENTER : this.screenBuffer
                this.screenBuffer = new int[this.width * this.height];
                // MONITOREXIT : nArray
                this.scaleRegion(0, 0, this.width, this.height);
            }
            this.xOffset = 0;
            this.yOffset = 0;
        }
        int n = this.yOffset * this.width + this.xOffset;
        if (this.fitToScreen) {
            int[] nArray = this.screenBuffer;
            // MONITORENTER : this.screenBuffer
            graphics.drawRGB(this.screenBuffer, 0, this.dispWidth, 0, 0, this.dispWidth, this.dispHeight, false);
            // MONITOREXIT : nArray
        } else {
            graphics.drawRGB(this.buffer, n, this.width, 0, 0, this.dispWidth, this.dispHeight, false);
        }
        graphics.drawImage(this.progressImage, this.dispWidth - 4, 4, 24);
        if (this.diagnostic == null) return;
        graphics.setColor(0xFF0000);
        graphics.drawString(this.diagnostic, this.dispWidth / 2, this.dispHeight, 33);
    }

    public void flipZoom() {
        this.fitToScreen ^= true;
        if (this.fitToScreen) {
            this.scaleRegion(0, 0, this.width, this.height);
        } else {
            this.repaint();
        }
    }

    public void fireString(String string) {
        this.pcThread.fireString(string);
    }

    public void keyPressed(int n) {
        int n2 = this.xOffset;
        int n3 = this.yOffset;
        int n4 = 50;
        int n5 = 50;
        if (this.fitToScreen) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.pcThread.fireArrowKeyUp();
                    break;
                }
                case 6: {
                    this.pcThread.fireArrowKeyDown();
                    break;
                }
                case 2: {
                    this.pcThread.fireArrowKeyLeft();
                    break;
                }
                case 5: {
                    this.pcThread.fireArrowKeyRight();
                    break;
                }
                case 8: {
                    this.pcThread.fireChar('\r');
                    break;
                }
                default: {
                    this.pcThread.fireChar((char)n);
                    break;
                }
            }
        } else {
            switch (this.getGameAction(n)) {
                case 1: {
                    n3 = Math.max(n3 - n5, 0);
                    break;
                }
                case 6: {
                    n3 = Math.min(n3 + n5, this.height - this.dispHeight);
                    break;
                }
                case 2: {
                    n2 = Math.max(n2 - n4, 0);
                    break;
                }
                case 5: {
                    n2 = Math.min(n2 + n4, this.width - this.dispWidth);
                    break;
                }
                default: {
                    this.pcThread.fireChar((char)n);
                }
            }
            if (n2 != this.xOffset || n3 != this.yOffset) {
                this.xOffset = n2;
                this.yOffset = n3;
                this.repaint();
            }
        }
    }

    public void keyRepeated(int n) {
    }
}

