/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.CodeBlockMemory;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.processor.ProcessorException;

public class AlignmentCheckedAddressSpace
extends AddressSpace {
    private static final ProcessorException ALIGNMENT_CHECK_EXCEPTION = new ProcessorException(17, 0, true);
    private static final ProcessorException ALIGNMENT_CHECK_EXCEPTION_GP = new ProcessorException(13, 0, true);
    private AddressSpace addressSpace;

    public AlignmentCheckedAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
    }

    public Memory getReadMemoryBlockAt(int n) {
        return this.addressSpace.getReadMemoryBlockAt(n);
    }

    public Memory getWriteMemoryBlockAt(int n) {
        return this.addressSpace.getWriteMemoryBlockAt(n);
    }

    public CodeBlockMemory getCodeBlockMemoryAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    void replaceBlocks(Memory memory, Memory memory2) {
        throw new IllegalStateException("Invalid Operation");
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    public void clear() {
        this.addressSpace.clear();
    }

    public byte getByte(int n) {
        return this.addressSpace.getByte(n);
    }

    public void setByte(int n, byte by) {
        this.addressSpace.setByte(n, by);
    }

    public short getWord(int n) {
        if ((n & 1) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getWord(n);
    }

    public int getDoubleWord(int n) {
        if ((n & 3) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getDoubleWord(n);
    }

    public long getQuadWord(int n) {
        if ((n & 7) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getQuadWord(n);
    }

    public long getLowerDoubleQuadWord(int n) {
        if ((n & 0xF) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getLowerDoubleQuadWord(n);
    }

    public long getUpperDoubleQuadWord(int n) {
        return this.addressSpace.getUpperDoubleQuadWord(n);
    }

    public void setWord(int n, short s) {
        if ((n & 1) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        this.addressSpace.setWord(n, s);
    }

    public void setDoubleWord(int n, int n2) {
        if ((n & 3) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        this.addressSpace.setDoubleWord(n, n2);
    }

    public void setQuadWord(int n, long l) {
        if ((n & 7) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        this.addressSpace.setQuadWord(n, l);
    }

    public void setLowerDoubleQuadWord(int n, long l) {
        if ((n & 0xF) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION_GP;
        }
        this.addressSpace.setLowerDoubleQuadWord(n, l);
    }

    public void setUpperDoubleQuadWord(int n, long l) {
        this.addressSpace.setUpperDoubleQuadWord(n, l);
    }

    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        this.addressSpace.copyContentsFrom(n, byArray, n2, n3);
    }

    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        this.addressSpace.copyContentsInto(n, byArray, n2, n3);
    }
}

