/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.support.Clock;

public class IntervalTimer
implements IOPortCapable,
HardwareComponent {
    private static final int RW_STATE_LSB = 1;
    private static final int RW_STATE_MSB = 2;
    private static final int RW_STATE_WORD0 = 3;
    private static final int RW_STATE_WORD1 = 4;
    private static final int MODE_INTERRUPT_ON_TERMINAL_COUNT = 0;
    private static final int MODE_HARDWARE_RETRIGGERABLE_ONE_SHOT = 1;
    private static final int MODE_RATE_GENERATOR = 2;
    private static final int MODE_SQUARE_WAVE = 3;
    private static final int MODE_SOFTWARE_TRIGGERED_STROBE = 4;
    private static final int MODE_HARDWARE_TRIGGERED_STROBE = 5;
    private static final int PIT_FREQ = 1193182;
    private TimerChannel[] channels;
    private InterruptController irqDevice;
    private Clock timingSource;
    private boolean ioportRegistered;
    private int ioPortBase;
    private int irq;

    static final long scale64(long l, int n, int n2) {
        long l2 = (0xFFFFFFFFL & l) * (long)n;
        long l3 = (l >>> 32) * (long)n;
        long l4 = 0xFFFFFFFFL & (l3 += l2 >> 32) / (long)n2;
        long l5 = 0xFFFFFFFFL & ((l3 % (long)n2 << 32) + (l2 & 0xFFFFFFFFL)) / (long)n2;
        return l4 << 32 | l5;
    }

    public IntervalTimer(int n, int n2) {
        this.irq = n2;
        this.ioPortBase = n;
    }

    public int[] ioPortsRequested() {
        int n = this.ioPortBase;
        return new int[]{n, n + 1, n + 2, n + 3};
    }

    public int ioPortReadLong(int n) {
        return this.ioPortReadWord(n) & 0xFFFF | this.ioPortReadWord(n + 2) << 16 & 0xFFFF0000;
    }

    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) & 0xFF | this.ioPortReadByte(n + 1) << 8 & 0xFF00;
    }

    public int ioPortReadByte(int n) {
        return this.channels[n & 3].read();
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, 0xFFFF & n2);
        this.ioPortWriteWord(n + 2, 0xFFFF & n2 >> 16);
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, 0xFF & n2);
        this.ioPortWriteByte(n + 1, 0xFF & n2 >> 8);
    }

    public void ioPortWriteByte(int n, int n2) {
        n2 &= 0xFF;
        if ((n &= 3) == 3) {
            int n3 = n2 >> 6;
            if (n3 == 3) {
                for (n3 = 0; n3 < 3; ++n3) {
                    if (0 == (n2 & 2 << n3)) continue;
                    this.channels[n3].readBack(n2);
                }
            } else {
                this.channels[n3].writeControlWord(n2);
            }
        } else {
            this.channels[n].write(n2);
        }
    }

    public void reset() {
        this.irqDevice = null;
        this.timingSource = null;
        this.ioportRegistered = false;
    }

    public int getOut(int n, long l) {
        return this.channels[n].getOut(l);
    }

    public boolean getGate(int n) {
        return this.channels[n].getGate();
    }

    public void setGate(int n, boolean bl) {
        this.channels[n].setGate(bl);
    }

    private InterruptController getInterruptController() {
        return this.irqDevice;
    }

    private Clock getTimingSource() {
        return this.timingSource;
    }

    public boolean initialised() {
        return this.irqDevice != null && this.timingSource != null && this.ioportRegistered;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.timingSource = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (this.initialised() && this.channels == null) {
            this.channels = new TimerChannel[3];
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i] = new TimerChannel(i);
            }
            this.channels[0].setIRQTimer(this.timingSource.newTimer(this.channels[0]));
            this.channels[0].setIRQ(this.irq);
        }
    }

    public String toString() {
        return "Intel i8254 Interval Timer";
    }

    class TimerChannel
    implements TimerResponsive {
        private int countValue;
        private int outputLatch;
        private int inputLatch;
        private int countLatched;
        private boolean statusLatched;
        private boolean gate;
        private int status;
        private int readState;
        private int writeState;
        private int rwMode;
        private int mode;
        private int bcd;
        private long countStartTime;
        private long nextTransitionTimeValue;
        private Timer irqTimer;
        private int irq;

        public TimerChannel(int n) {
            this.reset(n);
        }

        public int read() {
            if (this.statusLatched) {
                this.statusLatched = false;
                return this.status;
            }
            switch (this.countLatched) {
                case 1: {
                    this.countLatched = 0;
                    return this.outputLatch & 0xFF;
                }
                case 2: {
                    this.countLatched = 0;
                    return this.outputLatch >> 8 & 0xFF;
                }
                case 3: {
                    this.countLatched = 2;
                    return this.outputLatch & 0xFF;
                }
            }
            switch (this.readState) {
                default: {
                    return this.getCount() & 0xFF;
                }
                case 2: {
                    return this.getCount() >> 8 & 0xFF;
                }
                case 3: {
                    this.readState = 4;
                    return this.getCount() & 0xFF;
                }
                case 4: 
            }
            this.readState = 3;
            return this.getCount() >> 8 & 0xFF;
        }

        public void readBack(int n) {
            if (0 == (n & 0x20)) {
                this.latchCount();
            }
            if (0 == (n & 0x10) && !this.statusLatched) {
                this.status = 0xFF & (this.getOut(IntervalTimer.this.getTimingSource().getTime()) << 7 | this.rwMode << 4 | this.mode << 1 | this.bcd);
                this.statusLatched = true;
            }
        }

        public void write(int n) {
            switch (this.writeState) {
                default: {
                    this.loadCount(0xFF & n);
                    break;
                }
                case 2: {
                    this.loadCount((0xFF & n) << 8);
                    break;
                }
                case 3: {
                    this.inputLatch = n;
                    this.writeState = 4;
                    break;
                }
                case 4: {
                    this.loadCount(0xFF & this.inputLatch | (0xFF & n) << 8);
                    this.writeState = 3;
                }
            }
        }

        public void writeControlWord(int n) {
            int n2 = n >> 4 & 3;
            if (n2 == 0) {
                this.latchCount();
            } else {
                this.rwMode = n2;
                this.readState = n2;
                this.writeState = n2;
                this.mode = n >> 1 & 7;
                this.bcd = n & 1;
            }
        }

        public void setGate(boolean bl) {
            switch (this.mode) {
                default: {
                    break;
                }
                case 1: 
                case 5: {
                    if (this.gate || !bl) break;
                    this.countStartTime = IntervalTimer.this.getTimingSource().getTime();
                    this.irqTimerUpdate(this.countStartTime);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.gate || !bl) break;
                    this.countStartTime = IntervalTimer.this.getTimingSource().getTime();
                    this.irqTimerUpdate(this.countStartTime);
                }
            }
            this.gate = bl;
        }

        private int getCount() {
            long l = IntervalTimer.scale64(IntervalTimer.this.getTimingSource().getTime() - this.countStartTime, 1193182, (int)IntervalTimer.this.getTimingSource().getTickRate());
            switch (this.mode) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    return (int)((long)this.countValue - l & 0xFFFFL);
                }
                case 3: {
                    return (int)((long)this.countValue - 2L * l % (long)this.countValue);
                }
            }
            return (int)((long)this.countValue - l % (long)this.countValue);
        }

        private int getOut(long l) {
            long l2 = IntervalTimer.scale64(l - this.countStartTime, 1193182, (int)IntervalTimer.this.getTimingSource().getTickRate());
            switch (this.mode) {
                default: {
                    if (l2 >= (long)this.countValue) {
                        return 1;
                    }
                    return 0;
                }
                case 1: {
                    if (l2 < (long)this.countValue) {
                        return 1;
                    }
                    return 0;
                }
                case 2: {
                    if (l2 % (long)this.countValue == 0L && l2 != 0L) {
                        return 1;
                    }
                    return 0;
                }
                case 3: {
                    if (l2 % (long)this.countValue < (long)(this.countValue + 1 >> 1)) {
                        return 1;
                    }
                    return 0;
                }
                case 4: 
                case 5: 
            }
            if (l2 == (long)this.countValue) {
                return 1;
            }
            return 0;
        }

        private long getNextTransitionTime(long l) {
            long l2;
            long l3 = IntervalTimer.scale64(l - this.countStartTime, 1193182, (int)IntervalTimer.this.getTimingSource().getTickRate());
            switch (this.mode) {
                default: {
                    if (l3 < (long)this.countValue) {
                        l2 = this.countValue;
                        break;
                    }
                    return -1L;
                }
                case 2: {
                    long l4 = l3 / (long)this.countValue * (long)this.countValue;
                    if (l3 - l4 == 0L && l3 != 0L) {
                        l2 = l4 + (long)this.countValue;
                        break;
                    }
                    l2 = l4 + (long)this.countValue + 1L;
                    break;
                }
                case 3: {
                    long l5 = l3 / (long)this.countValue * (long)this.countValue;
                    long l6 = this.countValue + 1 >>> 1;
                    if (l3 - l5 < l6) {
                        l2 = l5 + l6;
                        break;
                    }
                    l2 = l5 + (long)this.countValue;
                    break;
                }
                case 4: 
                case 5: {
                    if (l3 < (long)this.countValue) {
                        l2 = this.countValue;
                        break;
                    }
                    if (l3 == (long)this.countValue) {
                        l2 = this.countValue + 1;
                        break;
                    }
                    return -1L;
                }
            }
            l2 = this.countStartTime + IntervalTimer.scale64(l2, (int)IntervalTimer.this.getTimingSource().getTickRate(), 1193182);
            if (l2 <= l) {
                l2 = l + 1L;
            }
            return l2;
        }

        private void loadCount(int n) {
            if (n == 0) {
                n = 65536;
            }
            this.countStartTime = IntervalTimer.this.getTimingSource().getTime();
            this.countValue = n;
            this.irqTimerUpdate(this.countStartTime);
        }

        private void latchCount() {
            if (0 != this.countLatched) {
                this.outputLatch = this.getCount();
                this.countLatched = this.rwMode;
            }
        }

        private void irqTimerUpdate(long l) {
            if (this.irqTimer == null) {
                return;
            }
            long l2 = this.getNextTransitionTime(l);
            int n = this.getOut(l);
            IntervalTimer.this.getInterruptController().setIRQ(this.irq, n);
            this.nextTransitionTimeValue = l2;
            if (l2 != -1L) {
                this.irqTimer.setExpiry(l2);
            } else {
                this.irqTimer.setStatus(false);
            }
        }

        public void timerCallback() {
            this.irqTimerUpdate(this.nextTransitionTimeValue);
        }

        public void reset(int n) {
            this.mode = 3;
            this.gate = n != 2;
            this.loadCount(0);
        }

        public boolean getGate() {
            return this.gate;
        }

        private void setIRQTimer(Timer timer) {
            this.irqTimer = timer;
        }

        public void setIRQ(int n) {
            this.irq = n;
        }
    }
}

